/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.general;

import es.eucm.eadventure.common.data.Named;
import es.eucm.eadventure.common.data.chapter.Action;
import es.eucm.eadventure.common.data.chapter.CustomAction;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.general.ActionDataControl;
import es.eucm.eadventure.editor.control.controllers.general.ResourcesDataControl;
import es.eucm.eadventure.editor.control.tools.general.assets.AddResourcesBlockTool;
import es.eucm.eadventure.editor.control.tools.general.assets.DeleteResourcesBlockTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeNameTool;
import java.util.ArrayList;
import java.util.List;

public class CustomActionDataControl
extends ActionDataControl {
    private CustomAction customAction;

    public CustomActionDataControl(CustomAction customAction) {
        super((Action)customAction);
        this.customAction = customAction;
        this.resourcesList = this.customAction.getResources();
        if (this.resourcesList.size() == 0) {
            this.resourcesList.add(new Resources());
        }
        this.selectedResources = 0;
        this.resourcesDataControlList = new ArrayList();
        for (Resources resources : this.resourcesList) {
            this.resourcesDataControlList.add(new ResourcesDataControl(resources, 230));
        }
    }

    public void setName(String string) {
        this.controller.addTool(new ChangeNameTool((Named)this.customAction, string));
    }

    @Override
    public int countAssetReferences(String string) {
        int n = super.countAssetReferences(string);
        for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
            n += resourcesDataControl.countAssetReferences(string);
        }
        return n;
    }

    public String getName() {
        return this.customAction.getName();
    }

    @Override
    public void recursiveSearch() {
        super.recursiveSearch();
        this.check(this.getName(), TC.get((String)"Search.Name"));
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return this.getPathFromChild(searchable, this.resourcesDataControlList);
    }

    @Override
    public boolean addElement(int n, String string) {
        boolean bl = false;
        if (n == 34) {
            bl = Controller.getInstance().addTool(new AddResourcesBlockTool(this.resourcesList, this.resourcesDataControlList, 230, this));
        }
        return bl;
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        return this.controller.addTool(new DeleteResourcesBlockTool(this.resourcesList, this.resourcesDataControlList, dataControl, this));
    }
}

