/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.general;

import es.eucm.eadventure.common.data.chapter.Chapter;
import es.eucm.eadventure.editor.control.controllers.AdventureDataControl;
import es.eucm.eadventure.editor.control.controllers.ChapterToolManager;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.adaptation.AdaptationProfileDataControl;
import es.eucm.eadventure.editor.control.controllers.assessment.AssessmentProfileDataControl;
import es.eucm.eadventure.editor.control.controllers.general.ChapterDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;
import es.eucm.eadventure.editor.data.support.IdentifierSummary;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.util.ArrayList;
import java.util.List;

public class ChapterListDataControl {
    private List<ChapterDataControl> chapterDataControlList;
    private List<ChapterToolManager> chapterToolManagers;
    private int selectedChapter;
    private IdentifierSummary identifierSummary;
    private VarFlagSummary varFlagSummary = new VarFlagSummary();
    private List<Chapter> chapters;

    public ChapterListDataControl() {
        this.chapterDataControlList = new ArrayList<ChapterDataControl>();
        this.chapterToolManagers = new ArrayList<ChapterToolManager>();
        this.setSelectedChapterInternal(-1);
        this.chapters = new ArrayList<Chapter>();
    }

    public ChapterListDataControl(List<Chapter> list) {
        this();
        for (Chapter chapter : list) {
            this.chapterDataControlList.add(new ChapterDataControl(chapter));
            this.chapterToolManagers.add(new ChapterToolManager());
        }
        if (list.size() > 0) {
            this.setSelectedChapterInternal(0);
        }
        this.chapters = list;
    }

    public List<ChapterDataControl> getChapters() {
        return this.chapterDataControlList;
    }

    public void setSelectedChapterInternal(int n) {
        this.selectedChapter = n;
        if (this.selectedChapter == -1) {
            if (this.chapterDataControlList.size() > 0) {
                this.selectedChapter = 0;
                if (this.identifierSummary == null) {
                    this.identifierSummary = new IdentifierSummary(this.getSelectedChapterData());
                } else {
                    this.identifierSummary.loadIdentifiers(this.getSelectedChapterData());
                }
                if (this.varFlagSummary == null) {
                    this.varFlagSummary = new VarFlagSummary();
                }
                this.getSelectedChapterDataControl().updateVarFlagSummary(this.varFlagSummary);
            } else {
                this.identifierSummary = null;
                this.varFlagSummary = new VarFlagSummary();
            }
        } else {
            this.identifierSummary = new IdentifierSummary(this.getSelectedChapterData());
            if (this.varFlagSummary == null) {
                this.varFlagSummary = new VarFlagSummary();
            }
            this.getSelectedChapterDataControl().updateVarFlagSummary(this.varFlagSummary);
        }
    }

    public Chapter getSelectedChapterData() {
        return (Chapter)this.chapterDataControlList.get(this.selectedChapter).getContent();
    }

    public void addChapterDataControl(Chapter chapter) {
        this.chapters.add(chapter);
        this.chapterDataControlList.add(new ChapterDataControl(chapter));
        this.chapterToolManagers.add(new ChapterToolManager());
        this.setSelectedChapterInternal(this.chapterDataControlList.size() - 1);
    }

    public void addChapterDataControl(int n, Chapter chapter) {
        this.chapters.add(n, chapter);
        this.chapterDataControlList.add(n, new ChapterDataControl(chapter));
        this.chapterToolManagers.add(n, new ChapterToolManager());
        this.setSelectedChapterInternal(n);
    }

    public ChapterDataControl removeChapterDataControl() {
        return this.removeChapterDataControl(this.selectedChapter);
    }

    public ChapterDataControl removeChapterDataControl(int n) {
        this.chapters.remove(n);
        ChapterDataControl chapterDataControl = this.chapterDataControlList.remove(n);
        this.chapterToolManagers.remove(n);
        this.setSelectedChapterInternal(this.selectedChapter - 1);
        return chapterDataControl;
    }

    public int getSelectedChapter() {
        return this.selectedChapter;
    }

    public ChapterDataControl getSelectedChapterDataControl() {
        if (this.chapterDataControlList.size() != 0) {
            return this.chapterDataControlList.get(this.selectedChapter);
        }
        return null;
    }

    public void addPlayerToAllScenesChapters() {
        for (ChapterDataControl chapterDataControl : this.chapterDataControlList) {
            chapterDataControl.getScenesList().addPlayerToAllScenes();
        }
    }

    public void addPlayerToAllScenesSelectedChapter() {
    }

    public void deletePlayerToAllScenesChapters() {
        for (ChapterDataControl chapterDataControl : this.chapterDataControlList) {
            chapterDataControl.getScenesList().deletePlayerToAllScenes();
        }
    }

    public void deletePlayerToAllScenesSelectedChapter() {
    }

    public boolean isValid(String string, List<String> list) {
        boolean bl = true;
        for (ChapterDataControl chapterDataControl : this.chapterDataControlList) {
            bl &= chapterDataControl.isValid(string, list);
        }
        return bl;
    }

    public boolean isAnyChapterSelected() {
        return this.selectedChapter != -1;
    }

    public IdentifierSummary getIdentifierSummary() {
        return this.identifierSummary;
    }

    public VarFlagSummary getVarFlagSummary() {
        return this.varFlagSummary;
    }

    public boolean replaceSelectedChapter(Chapter chapter) {
        int n = this.getSelectedChapter();
        this.chapters.set(this.getSelectedChapter(), chapter);
        this.chapterDataControlList.set(n, new ChapterDataControl(chapter));
        this.identifierSummary = new IdentifierSummary(chapter);
        this.identifierSummary.loadIdentifiers(this.getSelectedChapterData());
        return true;
    }

    public boolean hasScorm12Profiles(AdventureDataControl adventureDataControl) {
        boolean bl = true;
        for (ChapterDataControl chapterDataControl : this.chapterDataControlList) {
            DataControl dataControl;
            if (chapterDataControl.hasAdaptationProfile()) {
                dataControl = chapterDataControl.getSelectedAdaptationProfile();
                bl &= ((AdaptationProfileDataControl)dataControl).isScorm12();
            }
            if (!chapterDataControl.hasAssessmentProfile()) continue;
            dataControl = chapterDataControl.getSelectedAssessmentProfile();
            bl &= ((AssessmentProfileDataControl)dataControl).isScorm12();
        }
        return bl;
    }

    public boolean hasScorm2004Profiles(AdventureDataControl adventureDataControl) {
        boolean bl = true;
        for (ChapterDataControl chapterDataControl : this.chapterDataControlList) {
            DataControl dataControl;
            if (chapterDataControl.hasAdaptationProfile()) {
                dataControl = chapterDataControl.getSelectedAdaptationProfile();
                bl &= ((AdaptationProfileDataControl)dataControl).isScorm2004();
            }
            if (!chapterDataControl.hasAssessmentProfile()) continue;
            dataControl = chapterDataControl.getSelectedAssessmentProfile();
            bl &= ((AssessmentProfileDataControl)dataControl).isScorm2004();
        }
        return bl;
    }

    public void updateVarFlagSummary() {
        this.getSelectedChapterDataControl().updateVarFlagSummary(this.varFlagSummary);
    }

    public boolean moveChapterUp() {
        return this.moveChapterUp(this.selectedChapter);
    }

    public boolean moveChapterUp(int n) {
        if (n > 0) {
            this.chapters.add(n - 1, this.chapters.remove(n));
            this.chapterDataControlList.add(n - 1, this.chapterDataControlList.remove(n));
            this.chapterToolManagers.add(n - 1, this.chapterToolManagers.remove(n));
            this.setSelectedChapterInternal(n - 1);
            return true;
        }
        return false;
    }

    public boolean moveChapterDown() {
        return this.moveChapterDown(this.selectedChapter);
    }

    public boolean moveChapterDown(int n) {
        if (n < this.chapterDataControlList.size() - 1) {
            this.chapters.add(n + 1, this.chapters.remove(n));
            this.chapterDataControlList.add(n + 1, this.chapterDataControlList.remove(n));
            this.setSelectedChapterInternal(n + 1);
            return true;
        }
        return false;
    }

    public int countAssetReferences(String string) {
        int n = 0;
        for (ChapterDataControl chapterDataControl : this.chapterDataControlList) {
            n += chapterDataControl.countAssetReferences(string);
        }
        return n;
    }

    public void getAssetReferences(List<String> list, List<Integer> list2) {
        for (ChapterDataControl chapterDataControl : this.chapterDataControlList) {
            chapterDataControl.getAssetReferences(list, list2);
        }
    }

    public void deleteAssetReferences(String string) {
        for (ChapterDataControl chapterDataControl : this.chapterDataControlList) {
            chapterDataControl.deleteAssetReferences(string);
        }
    }

    public void deleteIdentifierReferences(String string) {
        if (this.getSelectedChapterDataControl() != null) {
            this.getSelectedChapterDataControl().deleteIdentifierReferences(string);
        }
    }

    public boolean addTool(Tool tool) {
        boolean bl = true;
        if (!tool.doesClone()) {
            bl = this.chapterToolManagers.get(this.getSelectedChapter()).addTool(tool);
        } else {
            bl = tool.doTool();
            if (bl) {
                this.chapterToolManagers.get(this.getSelectedChapter()).clear();
                this.chapterToolManagers.get(this.getSelectedChapter()).addTool(false, tool);
            } else {
                this.chapterToolManagers.get(this.getSelectedChapter()).addTool(false, tool);
            }
        }
        return bl;
    }

    public void undoTool() {
        this.chapterToolManagers.get(this.getSelectedChapter()).undoTool();
    }

    public void redoTool() {
        this.chapterToolManagers.get(this.getSelectedChapter()).redoTool();
    }

    public void pushLocalToolManager() {
        this.chapterToolManagers.get(this.getSelectedChapter()).pushLocalToolManager();
    }

    public void popLocalToolManager() {
        this.chapterToolManagers.get(this.getSelectedChapter()).popLocalToolManager();
    }

    public String[] getChapterTitles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ChapterDataControl chapterDataControl : this.chapterDataControlList) {
            Chapter chapter = (Chapter)chapterDataControl.getContent();
            arrayList.add(chapter.getTitle());
        }
        return arrayList.toArray(new String[0]);
    }

    public int getChaptersCount() {
        return this.chapters.size();
    }

    public boolean exitsChapter(String string) {
        for (ChapterDataControl chapterDataControl : this.chapterDataControlList) {
            Chapter chapter = (Chapter)chapterDataControl.getContent();
            if (!chapter.getTitle().equals(string)) continue;
            return true;
        }
        return false;
    }

    public void updateVarsFlagsForRunning() {
        for (ChapterDataControl chapterDataControl : this.chapterDataControlList) {
            VarFlagSummary varFlagSummary = new VarFlagSummary();
            chapterDataControl.updateVarFlagSummary(varFlagSummary);
            varFlagSummary.clean();
            Chapter chapter = (Chapter)chapterDataControl.getContent();
            for (String string : varFlagSummary.getFlags()) {
                chapter.addFlag(string);
            }
            for (String string : varFlagSummary.getVars()) {
                chapter.addVar(string);
            }
        }
    }

    public List<ChapterToolManager> getChapterToolManagers() {
        return this.chapterToolManagers;
    }
}

