/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.general;

import es.eucm.eadventure.common.data.Described;
import es.eucm.eadventure.common.data.HasTargetId;
import es.eucm.eadventure.common.data.Titled;
import es.eucm.eadventure.common.data.chapter.Chapter;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.adaptation.AdaptationProfileDataControl;
import es.eucm.eadventure.editor.control.controllers.adaptation.AdaptationProfilesDataControl;
import es.eucm.eadventure.editor.control.controllers.assessment.AssessmentProfileDataControl;
import es.eucm.eadventure.editor.control.controllers.assessment.AssessmentProfilesDataControl;
import es.eucm.eadventure.editor.control.controllers.atrezzo.AtrezzoListDataControl;
import es.eucm.eadventure.editor.control.controllers.book.BooksListDataControl;
import es.eucm.eadventure.editor.control.controllers.character.NPCsListDataControl;
import es.eucm.eadventure.editor.control.controllers.character.PlayerDataControl;
import es.eucm.eadventure.editor.control.controllers.conversation.ConversationsListDataControl;
import es.eucm.eadventure.editor.control.controllers.cutscene.CutscenesListDataControl;
import es.eucm.eadventure.editor.control.controllers.general.AdvancedFeaturesDataControl;
import es.eucm.eadventure.editor.control.controllers.globalstate.GlobalStateListDataControl;
import es.eucm.eadventure.editor.control.controllers.item.ItemsListDataControl;
import es.eucm.eadventure.editor.control.controllers.macro.MacroListDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ScenesListDataControl;
import es.eucm.eadventure.editor.control.controllers.timer.TimersListDataControl;
import es.eucm.eadventure.editor.control.tools.general.chapters.ChangeSelectedProfileTool;
import es.eucm.eadventure.editor.control.tools.general.chapters.SetNoSelectedProfileTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeDescriptionTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeTargetIdTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeTitleTool;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.util.List;

public class ChapterDataControl
extends DataControl {
    private Chapter chapter;
    private ScenesListDataControl scenesListDataControl;
    private CutscenesListDataControl cutscenesListDataControl;
    private BooksListDataControl booksListDataControl;
    private ItemsListDataControl itemsListDataControl;
    private AtrezzoListDataControl atrezzoListDataControl;
    private PlayerDataControl playerDataControl;
    private NPCsListDataControl npcsListDataControl;
    private ConversationsListDataControl conversationsListDataControl;
    private AssessmentProfilesDataControl assessmentProfilesDataControl;
    private AdaptationProfilesDataControl adaptationProfilesDataControl;
    private AdvancedFeaturesDataControl advancedFeaturesDataControl;

    public ChapterDataControl(Chapter chapter) {
        this.update(chapter);
    }

    public void update(Chapter chapter) {
        this.chapter = chapter;
        this.playerDataControl = new PlayerDataControl(chapter.getPlayer());
        this.scenesListDataControl = new ScenesListDataControl(chapter.getScenes(), this.getPlayer().getPreviewImage());
        this.cutscenesListDataControl = new CutscenesListDataControl(chapter.getCutscenes());
        this.booksListDataControl = new BooksListDataControl(chapter.getBooks());
        this.itemsListDataControl = new ItemsListDataControl(chapter.getItems());
        this.atrezzoListDataControl = new AtrezzoListDataControl(chapter.getAtrezzo());
        this.npcsListDataControl = new NPCsListDataControl(chapter.getCharacters());
        this.conversationsListDataControl = new ConversationsListDataControl(chapter.getConversations());
        TimersListDataControl timersListDataControl = new TimersListDataControl(chapter.getTimers());
        GlobalStateListDataControl globalStateListDataControl = new GlobalStateListDataControl(chapter.getGlobalStates());
        MacroListDataControl macroListDataControl = new MacroListDataControl(chapter.getMacros());
        this.advancedFeaturesDataControl = new AdvancedFeaturesDataControl();
        this.advancedFeaturesDataControl.setTimerListDataControl(timersListDataControl);
        this.advancedFeaturesDataControl.setGlobalStatesListDataContorl(globalStateListDataControl);
        this.advancedFeaturesDataControl.setMacrosListDataControl(macroListDataControl);
        this.assessmentProfilesDataControl = new AssessmentProfilesDataControl(chapter.getAssessmentProfiles());
        this.adaptationProfilesDataControl = new AdaptationProfilesDataControl(chapter.getAdaptationProfiles());
    }

    public String getTitle() {
        return this.chapter.getTitle();
    }

    public String getDescription() {
        return this.chapter.getDescription();
    }

    public String getAssessmentName() {
        return this.chapter.getAssessmentName();
    }

    public String getAdaptationName() {
        return this.chapter.getAdaptationName();
    }

    public String getInitialScene() {
        return this.chapter.getTargetId();
    }

    public ScenesListDataControl getScenesList() {
        return this.scenesListDataControl;
    }

    public CutscenesListDataControl getCutscenesList() {
        return this.cutscenesListDataControl;
    }

    public BooksListDataControl getBooksList() {
        return this.booksListDataControl;
    }

    public ItemsListDataControl getItemsList() {
        return this.itemsListDataControl;
    }

    public AtrezzoListDataControl getAtrezzoList() {
        return this.atrezzoListDataControl;
    }

    public PlayerDataControl getPlayer() {
        return this.playerDataControl;
    }

    public NPCsListDataControl getNPCsList() {
        return this.npcsListDataControl;
    }

    public ConversationsListDataControl getConversationsList() {
        return this.conversationsListDataControl;
    }

    public TimersListDataControl getTimersList() {
        return this.advancedFeaturesDataControl.getTimersList();
    }

    public void setTitle(String string) {
        ChangeTitleTool changeTitleTool = new ChangeTitleTool((Titled)this.chapter, string);
        this.controller.addTool(changeTitleTool);
    }

    public void setDescription(String string) {
        ChangeDescriptionTool changeDescriptionTool = new ChangeDescriptionTool((Described)this.chapter, string);
        this.controller.addTool(changeDescriptionTool);
    }

    public void setAssessmentPath(String string) {
        Controller.getInstance().addTool(new ChangeSelectedProfileTool(this.chapter, 40, string));
    }

    public void setAdaptationPath(String string) {
        Controller.getInstance().addTool(new ChangeSelectedProfileTool(this.chapter, 41, string));
    }

    public void setInitialScene(String string) {
        Controller.getInstance().addTool(new ChangeTargetIdTool((HasTargetId)this.chapter, string));
    }

    public void deleteAssessmentPath() {
        Controller.getInstance().addTool(new SetNoSelectedProfileTool(this.chapter, 40));
    }

    public void deleteAdaptationPath() {
        Controller.getInstance().addTool(new SetNoSelectedProfileTool(this.chapter, 41));
    }

    @Override
    public Object getContent() {
        return this.chapter;
    }

    @Override
    public int[] getAddableElements() {
        return new int[0];
    }

    @Override
    public boolean canAddElement(int n) {
        return false;
    }

    @Override
    public boolean canBeDeleted() {
        return false;
    }

    @Override
    public boolean canBeMoved() {
        return false;
    }

    @Override
    public boolean canBeRenamed() {
        return false;
    }

    @Override
    public boolean addElement(int n, String string) {
        return false;
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        return false;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        return false;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        return false;
    }

    @Override
    public String renameElement(String string) {
        return null;
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        varFlagSummary.clearReferences();
        this.scenesListDataControl.updateVarFlagSummary(varFlagSummary);
        this.cutscenesListDataControl.updateVarFlagSummary(varFlagSummary);
        this.itemsListDataControl.updateVarFlagSummary(varFlagSummary);
        this.atrezzoListDataControl.updateVarFlagSummary(varFlagSummary);
        this.npcsListDataControl.updateVarFlagSummary(varFlagSummary);
        this.playerDataControl.updateVarFlagSummary(varFlagSummary);
        this.conversationsListDataControl.updateVarFlagSummary(varFlagSummary);
        this.advancedFeaturesDataControl.updateVarFlagSummary(varFlagSummary);
        this.adaptationProfilesDataControl.updateVarFlagSummary(varFlagSummary);
        this.assessmentProfilesDataControl.updateVarFlagSummary(varFlagSummary);
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        boolean bl = true;
        string = this.getTitle();
        String string2 = string + " >> " + TC.getElement((int)26);
        bl &= this.scenesListDataControl.isValid(string, list);
        bl &= this.cutscenesListDataControl.isValid(string, list);
        bl &= this.booksListDataControl.isValid(string, list);
        bl &= this.itemsListDataControl.isValid(string, list);
        bl &= this.atrezzoListDataControl.isValid(string, list);
        bl &= this.playerDataControl.isValid(string2, list);
        bl &= this.npcsListDataControl.isValid(string, list);
        bl &= this.conversationsListDataControl.isValid(string, list);
        bl &= this.advancedFeaturesDataControl.isValid(string, list);
        bl &= this.adaptationProfilesDataControl.isValid(string, list);
        return bl &= this.assessmentProfilesDataControl.isValid(string, list);
    }

    @Override
    public int countAssetReferences(String string) {
        int n = 0;
        if (this.getAssessmentName().equals(string)) {
            ++n;
        }
        if (this.getAdaptationName().equals(string)) {
            ++n;
        }
        n += this.scenesListDataControl.countAssetReferences(string);
        n += this.cutscenesListDataControl.countAssetReferences(string);
        n += this.booksListDataControl.countAssetReferences(string);
        n += this.itemsListDataControl.countAssetReferences(string);
        n += this.atrezzoListDataControl.countAssetReferences(string);
        n += this.playerDataControl.countAssetReferences(string);
        n += this.npcsListDataControl.countAssetReferences(string);
        n += this.conversationsListDataControl.countAssetReferences(string);
        return n += this.advancedFeaturesDataControl.countAssetReferences(string);
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
        this.scenesListDataControl.getAssetReferences(list, list2);
        this.cutscenesListDataControl.getAssetReferences(list, list2);
        this.booksListDataControl.getAssetReferences(list, list2);
        this.itemsListDataControl.getAssetReferences(list, list2);
        this.atrezzoListDataControl.getAssetReferences(list, list2);
        this.playerDataControl.getAssetReferences(list, list2);
        this.npcsListDataControl.getAssetReferences(list, list2);
        this.conversationsListDataControl.getAssetReferences(list, list2);
        this.advancedFeaturesDataControl.getAssetReferences(list, list2);
    }

    @Override
    public void deleteAssetReferences(String string) {
        if (this.getAssessmentName().equals(string)) {
            this.chapter.setAssessmentName("");
        }
        if (this.getAdaptationName().equals(string)) {
            this.chapter.setAdaptationName("");
        }
        this.scenesListDataControl.deleteAssetReferences(string);
        this.cutscenesListDataControl.deleteAssetReferences(string);
        this.booksListDataControl.deleteAssetReferences(string);
        this.itemsListDataControl.deleteAssetReferences(string);
        this.atrezzoListDataControl.deleteAssetReferences(string);
        this.playerDataControl.deleteAssetReferences(string);
        this.npcsListDataControl.deleteAssetReferences(string);
        this.conversationsListDataControl.deleteAssetReferences(string);
        this.advancedFeaturesDataControl.deleteAssetReferences(string);
    }

    @Override
    public int countIdentifierReferences(String string) {
        int n = 0;
        if (this.chapter.getTargetId().equals(string)) {
            ++n;
        }
        n += this.scenesListDataControl.countIdentifierReferences(string);
        n += this.cutscenesListDataControl.countIdentifierReferences(string);
        n += this.itemsListDataControl.countIdentifierReferences(string);
        n += this.atrezzoListDataControl.countIdentifierReferences(string);
        n += this.npcsListDataControl.countIdentifierReferences(string);
        n += this.conversationsListDataControl.countIdentifierReferences(string);
        n += this.advancedFeaturesDataControl.countIdentifierReferences(string);
        n += this.adaptationProfilesDataControl.countIdentifierReferences(string);
        return n += this.assessmentProfilesDataControl.countIdentifierReferences(string);
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        if (this.chapter.getTargetId().equals(string)) {
            this.chapter.setTargetId(string2);
        }
        this.scenesListDataControl.replaceIdentifierReferences(string, string2);
        this.cutscenesListDataControl.replaceIdentifierReferences(string, string2);
        this.itemsListDataControl.replaceIdentifierReferences(string, string2);
        this.atrezzoListDataControl.replaceIdentifierReferences(string, string2);
        this.npcsListDataControl.replaceIdentifierReferences(string, string2);
        this.conversationsListDataControl.replaceIdentifierReferences(string, string2);
        this.advancedFeaturesDataControl.replaceIdentifierReferences(string, string2);
        this.assessmentProfilesDataControl.replaceIdentifierReferences(string, string2);
        this.adaptationProfilesDataControl.replaceIdentifierReferences(string, string2);
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        if (this.chapter.getTargetId().equals(string)) {
            this.chapter.setTargetId(this.controller.getIdentifierSummary().getGeneralSceneIds()[0]);
        }
        this.scenesListDataControl.deleteIdentifierReferences(string);
        this.cutscenesListDataControl.deleteIdentifierReferences(string);
        this.itemsListDataControl.deleteIdentifierReferences(string);
        this.atrezzoListDataControl.deleteIdentifierReferences(string);
        this.npcsListDataControl.deleteIdentifierReferences(string);
        this.conversationsListDataControl.deleteIdentifierReferences(string);
        this.advancedFeaturesDataControl.deleteIdentifierReferences(string);
        this.assessmentProfilesDataControl.deleteIdentifierReferences(string);
        this.adaptationProfilesDataControl.deleteIdentifierReferences(string);
    }

    @Override
    public boolean canBeDuplicated() {
        return true;
    }

    public GlobalStateListDataControl getGlobalStatesListDataControl() {
        return this.advancedFeaturesDataControl.getGlobalStatesListDataControl();
    }

    public MacroListDataControl getMacrosListDataControl() {
        return this.advancedFeaturesDataControl.getMacrosListDataControl();
    }

    @Override
    public void recursiveSearch() {
        this.check(this.getAdaptationName(), TC.get((String)"Search.AdaptationPath"));
        this.check(this.getAssessmentName(), TC.get((String)"Search.AssessmentPath"));
        this.check(this.getDescription(), TC.get((String)"Search.Description"));
        this.check(this.getInitialScene(), TC.get((String)"Search.InitialScene"));
        this.check(this.getTitle(), TC.get((String)"Search.Title"));
        this.getAtrezzoList().recursiveSearch();
        this.getBooksList().recursiveSearch();
        this.getConversationsList().recursiveSearch();
        this.getCutscenesList().recursiveSearch();
        this.getItemsList().recursiveSearch();
        this.getNPCsList().recursiveSearch();
        this.getPlayer().recursiveSearch();
        this.getScenesList().recursiveSearch();
        this.getAdvancedFeaturesController().recursiveSearch();
        this.getAdaptationProfilesDataControl().recursiveSearch();
        this.getAssessmentProfilesDataControl().recursiveSearch();
    }

    public AssessmentProfileDataControl getSelectedAssessmentProfile() {
        return this.assessmentProfilesDataControl.getProfileByPath(this.chapter.getAssessmentName());
    }

    public AdaptationProfileDataControl getSelectedAdaptationProfile() {
        return this.adaptationProfilesDataControl.getProfileByPath(this.chapter.getAdaptationName());
    }

    public AssessmentProfilesDataControl getAssessmentProfilesDataControl() {
        return this.assessmentProfilesDataControl;
    }

    public AdaptationProfilesDataControl getAdaptationProfilesDataControl() {
        return this.adaptationProfilesDataControl;
    }

    public boolean hasAdaptationProfile() {
        return this.chapter.hasAdaptationProfile();
    }

    public boolean hasAssessmentProfile() {
        return this.chapter.hasAssessmentProfile();
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        List<Searchable> list = this.getPathFromChild(searchable, this.scenesListDataControl);
        if (list != null) {
            return list;
        }
        list = this.getPathFromChild(searchable, this.cutscenesListDataControl);
        if (list != null) {
            return list;
        }
        list = this.getPathFromChild(searchable, this.booksListDataControl);
        if (list != null) {
            return list;
        }
        list = this.getPathFromChild(searchable, this.itemsListDataControl);
        if (list != null) {
            return list;
        }
        list = this.getPathFromChild(searchable, this.atrezzoListDataControl);
        if (list != null) {
            return list;
        }
        list = this.getPathFromChild(searchable, this.npcsListDataControl);
        if (list != null) {
            return list;
        }
        list = this.getPathFromChild(searchable, this.playerDataControl);
        if (list != null) {
            return list;
        }
        list = this.getPathFromChild(searchable, this.conversationsListDataControl);
        if (list != null) {
            return list;
        }
        list = this.getPathFromChild(searchable, this.advancedFeaturesDataControl);
        if (list != null) {
            return list;
        }
        list = this.getPathFromChild(searchable, this.assessmentProfilesDataControl);
        if (list != null) {
            return list;
        }
        list = this.getPathFromChild(searchable, this.adaptationProfilesDataControl);
        if (list != null) {
            return list;
        }
        return null;
    }

    public AdvancedFeaturesDataControl getAdvancedFeaturesController() {
        return this.advancedFeaturesDataControl;
    }
}

