/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.general;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.chapter.Action;
import es.eucm.eadventure.common.data.chapter.CustomAction;
import es.eucm.eadventure.common.data.chapter.effects.AbstractEffect;
import es.eucm.eadventure.common.data.chapter.effects.TriggerConversationEffect;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.character.NPCDataControl;
import es.eucm.eadventure.editor.control.controllers.general.ActionDataControl;
import es.eucm.eadventure.editor.control.controllers.general.CustomActionDataControl;
import es.eucm.eadventure.editor.control.controllers.item.ItemDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ActiveAreaDataControl;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.swing.JOptionPane;

public class ActionsListDataControl
extends DataControl {
    private List<Action> actionsList;
    private List<ActionDataControl> actionsDataControlList;
    private DataControl parent;

    public ActionsListDataControl(List<Action> list, DataControl dataControl) {
        this.actionsList = list;
        this.parent = dataControl;
        this.actionsDataControlList = new ArrayList<ActionDataControl>();
        for (Action action : list) {
            if (action.getType() == 5 || action.getType() == 6) {
                this.actionsDataControlList.add(new CustomActionDataControl((CustomAction)action));
                continue;
            }
            if (action.getType() == 7) {
                this.actionsDataControlList.add(new ActionDataControl(action, ((NPCDataControl)dataControl).getId()));
                continue;
            }
            this.actionsDataControlList.add(new ActionDataControl(action));
        }
    }

    public List<ActionDataControl> getActions() {
        return this.actionsDataControlList;
    }

    public ActionDataControl getLastAction() {
        return this.actionsDataControlList.get(this.actionsDataControlList.size() - 1);
    }

    public String[][] getActionsInfo() {
        String[][] stringArray = null;
        stringArray = new String[this.actionsList.size()][3];
        for (int i = 0; i < this.actionsList.size(); ++i) {
            Action action = this.actionsList.get(i);
            if (action.getType() == 0) {
                stringArray[i][0] = TC.get((String)"ActionsList.ExamineAction");
            } else if (action.getType() == 1) {
                stringArray[i][0] = TC.get((String)"ActionsList.GrabAction");
            } else if (action.getType() == 5) {
                stringArray[i][0] = TC.get((String)"ActionsList.CustomAction", (String)((CustomAction)action).getName());
            } else if (action.getType() == 2) {
                stringArray[i][0] = TC.get((String)"ActionsList.GiveToAction", (String)action.getTargetId());
            } else if (action.getType() == 3) {
                stringArray[i][0] = TC.get((String)"ActionsList.UseWithAction", (String)action.getTargetId());
            } else if (action.getType() == 6) {
                stringArray[i][0] = TC.get((String)"ActionsList.CustomInteractAction", (String)action.getTargetId());
            } else if (action.getType() == 4) {
                stringArray[i][0] = TC.get((String)"ActionsList.UseAction");
            } else if (action.getType() == 7) {
                stringArray[i][0] = TC.get((String)"ActionsList.TalkToAction");
            } else if (action.getType() == 8) {
                stringArray[i][0] = TC.get((String)"ActionsList.DragToAction");
            }
            stringArray[i][1] = action.getConditions().isEmpty() ? TC.get((String)"GeneralText.No") : TC.get((String)"GeneralText.Yes");
            stringArray[i][2] = action.getEffects().isEmpty() ? TC.get((String)"GeneralText.No") : TC.get((String)"GeneralText.Yes");
        }
        return stringArray;
    }

    @Override
    public Object getContent() {
        return this.actionsList;
    }

    @Override
    public int[] getAddableElements() {
        if (this.parent instanceof ItemDataControl) {
            return new int[]{21, 22, 23, 250, 24, 25, 251};
        }
        if (this.parent instanceof NPCDataControl) {
            return new int[]{21, 23, 230, 231, 251};
        }
        if (this.parent instanceof ActiveAreaDataControl) {
            return new int[]{21, 22, 23, 250};
        }
        return new int[]{21, 22, 23, 230, 24, 25, 231};
    }

    @Override
    public boolean canAddElement(int n) {
        return n == 21 || n == 22 || n == 23 || n == 230 || n == 24 || n == 25 || n == 250 || n == 231 || n == 251;
    }

    @Override
    public boolean canBeDeleted() {
        return false;
    }

    @Override
    public boolean canBeMoved() {
        return false;
    }

    @Override
    public boolean canBeRenamed() {
        return false;
    }

    @Override
    public boolean addElement(int n, String string) {
        Action action = null;
        if (n == 21) {
            action = new Action(0);
        } else if (n == 22) {
            action = new Action(1);
        } else if (n == 23) {
            action = new Action(4);
        } else if (n == 231) {
            Object[] objectArray = this.controller.getIdentifierSummary().getConversationsIds();
            if (objectArray.length > 0) {
                String string2 = this.controller.showInputDialog(TC.get((String)"Action.OperationAddAction"), TC.get((String)"TalkToAction.MessageSelectConversation"), objectArray);
                if (string2 != null) {
                    action = new Action(7);
                    action.getEffects().add((AbstractEffect)new TriggerConversationEffect(string2));
                }
            } else {
                this.controller.showErrorDialog(TC.get((String)"Action.OperationAddAction"), TC.get((String)"Action.ErrorNoItems"));
            }
        } else if (n == 250) {
            String string3 = this.controller.showInputDialog(TC.get((String)"CustomAction.GetNameTitle"), TC.get((String)"CustomAction.GetNameMessage"));
            if (string3 == null || string3.equals("")) {
                string3 = "NONAME_" + new Random().nextInt(1000);
            }
            Object[] objectArray = new String[]{TC.get((String)"Element.Action"), TC.get((String)"Element.Interaction")};
            int n2 = JOptionPane.showOptionDialog(null, TC.get((String)"CustomAction.SelectTypeMessage"), TC.get((String)"CustomAction.SelectTypeTitle"), -1, 3, null, objectArray, 0);
            if (n2 == 0) {
                action = new CustomAction(5);
                ((CustomAction)action).setName(string3);
            } else {
                String[] stringArray = this.controller.getIdentifierSummary().getItemAndActiveAreaIds();
                String[] stringArray2 = this.controller.getIdentifierSummary().getNPCIds();
                Object[] objectArray2 = new String[stringArray.length + stringArray2.length];
                for (int i = 0; i < objectArray2.length; ++i) {
                    objectArray2[i] = i < stringArray.length ? stringArray[i] : stringArray2[i - stringArray.length];
                }
                if (objectArray2.length > 0) {
                    String string4 = this.controller.showInputDialog(TC.get((String)"Action.OperationAddAction"), TC.get((String)"CustomAction.MessageSelectInteraction"), objectArray2);
                    if (string4 != null) {
                        action = new CustomAction(6, string4);
                        ((CustomAction)action).setName(string3);
                    }
                } else {
                    this.controller.showErrorDialog(TC.get((String)"Action.OperationAddAction"), TC.get((String)"Action.ErrorNoItems"));
                }
            }
        } else if (n == 230) {
            String string5 = this.controller.showInputDialog(TC.get((String)"CustomAction.GetNameMessage"), TC.get((String)"CustomAction.GetNameTitle"));
            if (string5.equals("")) {
                string5 = "NONAME_" + new Random().nextInt(1000);
            }
            action = new CustomAction(5);
            ((CustomAction)action).setName(string5);
        } else if (n == 24) {
            Object[] objectArray = this.controller.getIdentifierSummary().getItemAndActiveAreaIds();
            if (objectArray.length > 0) {
                String string6 = this.controller.showInputDialog(TC.get((String)"Action.OperationAddAction"), TC.get((String)"Action.MessageSelectItem"), objectArray);
                if (string6 != null) {
                    action = new Action(3, string6);
                }
            } else {
                this.controller.showErrorDialog(TC.get((String)"Action.OperationAddAction"), TC.get((String)"Action.ErrorNoItems"));
            }
        } else if (n == 251) {
            Object[] objectArray = this.controller.getIdentifierSummary().getItemActiveAreaNPCIds();
            if (objectArray.length > 0) {
                String string7 = this.controller.showInputDialog(TC.get((String)"Action.OperationAddAction"), TC.get((String)"Action.MessageSelectItem"), objectArray);
                if (string7 != null) {
                    action = new Action(8, string7);
                }
            } else {
                this.controller.showErrorDialog(TC.get((String)"Action.OperationAddAction"), TC.get((String)"Action.ErrorNoItems"));
            }
        } else if (n == 25) {
            Object[] objectArray = this.controller.getIdentifierSummary().getNPCIds();
            if (objectArray.length > 0) {
                String string8 = this.controller.showInputDialog(TC.get((String)"Action.OperationAddAction"), TC.get((String)"Action.MessageSelectNPC"), objectArray);
                if (string8 != null) {
                    action = new Action(2, string8);
                }
            } else {
                this.controller.showErrorDialog(TC.get((String)"Action.OperationAddAction"), TC.get((String)"Action.ErrorNoNPCs"));
            }
        }
        if (action != null) {
            this.actionsList.add(action);
            if (action.getType() == 5 || action.getType() == 6) {
                this.actionsDataControlList.add(new CustomActionDataControl((CustomAction)action));
            } else {
                this.actionsDataControlList.add(new ActionDataControl(action));
            }
        }
        return action != null;
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        boolean bl2 = false;
        if (this.actionsList.remove(dataControl.getContent())) {
            this.actionsDataControlList.remove(dataControl);
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public boolean duplicateElement(DataControl dataControl) {
        if (!(dataControl instanceof ActionDataControl)) {
            return false;
        }
        try {
            Action action = (Action)((Action)dataControl.getContent()).clone();
            this.actionsList.add(action);
            this.actionsDataControlList.add(new ActionDataControl(action));
            return true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ReportDialog.GenerateErrorReport((Exception)cloneNotSupportedException, (boolean)true, (String)"Could not clone action");
            return false;
        }
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        boolean bl = false;
        int n = this.actionsList.indexOf(dataControl.getContent());
        if (n > 0) {
            this.actionsList.add(n - 1, this.actionsList.remove(n));
            this.actionsDataControlList.add(n - 1, this.actionsDataControlList.remove(n));
            this.controller.dataModified();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        boolean bl = false;
        int n = this.actionsList.indexOf(dataControl.getContent());
        if (n < this.actionsList.size() - 1) {
            this.actionsList.add(n + 1, this.actionsList.remove(n));
            this.actionsDataControlList.add(n + 1, this.actionsDataControlList.remove(n));
            this.controller.dataModified();
            bl = true;
        }
        return bl;
    }

    @Override
    public String renameElement(String string) {
        return null;
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        for (ActionDataControl actionDataControl : this.actionsDataControlList) {
            actionDataControl.updateVarFlagSummary(varFlagSummary);
        }
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        boolean bl = true;
        for (int i = 0; i < this.actionsDataControlList.size(); ++i) {
            String string2 = string + " >> " + TC.get((String)"Element.Action") + " #" + (i + 1) + " (" + TC.getElement((int)this.actionsDataControlList.get(i).getType()) + ")";
            bl &= this.actionsDataControlList.get(i).isValid(string2, list);
        }
        return bl;
    }

    @Override
    public int countAssetReferences(String string) {
        int n = 0;
        for (ActionDataControl actionDataControl : this.actionsDataControlList) {
            n += actionDataControl.countAssetReferences(string);
        }
        return n;
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
        for (ActionDataControl actionDataControl : this.actionsDataControlList) {
            actionDataControl.getAssetReferences(list, list2);
        }
    }

    @Override
    public void deleteAssetReferences(String string) {
        for (ActionDataControl actionDataControl : this.actionsDataControlList) {
            actionDataControl.deleteAssetReferences(string);
        }
    }

    @Override
    public int countIdentifierReferences(String string) {
        int n = 0;
        for (ActionDataControl actionDataControl : this.actionsDataControlList) {
            n += actionDataControl.countIdentifierReferences(string);
        }
        return n;
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        for (ActionDataControl actionDataControl : this.actionsDataControlList) {
            actionDataControl.replaceIdentifierReferences(string, string2);
        }
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        int n = 0;
        while (n < this.actionsList.size()) {
            Action action = this.actionsList.get(n);
            if ((action.getType() == 2 || action.getType() == 3 || action.getType() == 8) && action.getTargetId().equals(string)) {
                this.actionsList.remove(n);
                this.actionsDataControlList.remove(n);
                continue;
            }
            if (action.getType() == 6 && action.getTargetId().equals(string)) {
                this.actionsList.remove(n);
                this.actionsDataControlList.remove(n);
                continue;
            }
            this.actionsDataControlList.get(n).deleteIdentifierReferences(string);
            ++n;
        }
    }

    @Override
    public boolean canBeDuplicated() {
        return false;
    }

    @Override
    public void recursiveSearch() {
        for (ActionDataControl actionDataControl : this.actionsDataControlList) {
            ((Searchable)actionDataControl).recursiveSearch();
        }
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return this.getPathFromChild(searchable, this.actionsDataControlList);
    }

    public List<Action> getActionsList() {
        return this.actionsList;
    }
}

