/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.general;

import es.eucm.eadventure.common.data.Documented;
import es.eucm.eadventure.common.data.HasTargetId;
import es.eucm.eadventure.common.data.chapter.Action;
import es.eucm.eadventure.common.data.chapter.CustomAction;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.ConditionsController;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.DataControlWithResources;
import es.eucm.eadventure.editor.control.controllers.EffectsController;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.general.ResourcesDataControl;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeDocumentationTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeTargetIdTool;
import es.eucm.eadventure.editor.control.tools.generic.ChangeBooleanValueTool;
import es.eucm.eadventure.editor.control.tools.generic.ChangeIntegerValueTool;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.util.ArrayList;
import java.util.List;

public class ActionDataControl
extends DataControlWithResources {
    private Action action;
    private int actionType;
    private ConditionsController conditionsController;
    private EffectsController effectsController;
    private EffectsController notEffectsController;

    public ActionDataControl(Action action, String string) {
        this.action = action;
        this.resourcesList = new ArrayList();
        this.resourcesDataControlList = new ArrayList();
        this.actionType = 231;
        this.conditionsController = new ConditionsController(action.getConditions(), this.actionType, string);
        this.effectsController = new EffectsController(action.getEffects());
        this.notEffectsController = new EffectsController(action.getNotEffects());
    }

    public ActionDataControl(Action action) {
        this.action = action;
        this.resourcesList = new ArrayList();
        this.resourcesDataControlList = new ArrayList();
        String string = null;
        switch (action.getType()) {
            case 0: {
                this.actionType = 21;
                string = "";
                break;
            }
            case 1: {
                this.actionType = 22;
                string = "";
                break;
            }
            case 4: {
                this.actionType = 23;
                string = "";
                break;
            }
            case 5: {
                this.actionType = 230;
                CustomAction customAction = (CustomAction)action;
                string = customAction.getName();
                break;
            }
            case 3: {
                this.actionType = 24;
                string = action.getTargetId();
                break;
            }
            case 2: {
                this.actionType = 25;
                string = action.getTargetId();
                break;
            }
            case 6: {
                this.actionType = 250;
                CustomAction customAction = (CustomAction)action;
                string = customAction.getName() + " " + action.getTargetId();
                break;
            }
            case 7: {
                this.actionType = 231;
                string = action.getTargetId();
                break;
            }
            case 8: {
                this.actionType = 251;
                string = action.getTargetId();
            }
        }
        this.conditionsController = new ConditionsController(action.getConditions(), this.actionType, string);
        this.effectsController = new EffectsController(action.getEffects());
        this.notEffectsController = new EffectsController(action.getNotEffects());
    }

    public ConditionsController getConditions() {
        return this.conditionsController;
    }

    public EffectsController getEffects() {
        return this.effectsController;
    }

    public int getType() {
        return this.actionType;
    }

    public boolean hasIdTarget() {
        return this.action.getType() == 3 || this.action.getType() == 2 || this.action.getType() == 6 || this.action.getType() == 8;
    }

    public String[] getElementsList() {
        String[] stringArray = null;
        if (this.action.getType() == 3) {
            stringArray = this.controller.getIdentifierSummary().getItemAndActiveAreaIds();
        } else if (this.action.getType() == 2) {
            stringArray = this.controller.getIdentifierSummary().getNPCIds();
        } else if (this.action.getType() == 8) {
            stringArray = this.controller.getIdentifierSummary().getItemActiveAreaNPCIds();
        } else if (this.action.getType() == 6) {
            String[] stringArray2 = this.controller.getIdentifierSummary().getNPCIds();
            String[] stringArray3 = this.controller.getIdentifierSummary().getItemAndActiveAreaIds();
            stringArray = new String[stringArray2.length + stringArray3.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = i < stringArray2.length ? stringArray2[i] : stringArray3[i - stringArray2.length];
            }
        }
        return stringArray;
    }

    public String getIdTarget() {
        return this.action.getTargetId();
    }

    public String getDocumentation() {
        return this.action.getDocumentation();
    }

    public void setDocumentation(String string) {
        this.controller.addTool(new ChangeDocumentationTool((Documented)this.action, string));
    }

    public void setIdTarget(String string) {
        this.controller.addTool(new ChangeTargetIdTool((HasTargetId)this.action, string, true, false));
    }

    @Override
    public Object getContent() {
        return this.action;
    }

    @Override
    public int[] getAddableElements() {
        return new int[0];
    }

    @Override
    public boolean canAddElement(int n) {
        return false;
    }

    @Override
    public boolean canBeDeleted() {
        return true;
    }

    @Override
    public boolean canBeMoved() {
        return true;
    }

    @Override
    public boolean canBeRenamed() {
        return false;
    }

    @Override
    public boolean addElement(int n, String string) {
        return false;
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        return false;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        return false;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        return false;
    }

    @Override
    public String renameElement(String string) {
        return null;
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        EffectsController.updateVarFlagSummary(varFlagSummary, this.action.getEffects());
        if (this.action.getNotEffects() != null) {
            EffectsController.updateVarFlagSummary(varFlagSummary, this.action.getNotEffects());
        }
        ConditionsController.updateVarFlagSummary(varFlagSummary, this.action.getConditions());
        if (this.action.getType() == 6 || this.action.getType() == 5) {
            for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
                resourcesDataControl.updateVarFlagSummary(varFlagSummary);
            }
        }
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        boolean bl = true;
        if (this.action.getType() == 6 || this.action.getType() == 5) {
            for (int i = 0; i < this.resourcesDataControlList.size(); ++i) {
                String string2 = string + " >> " + TC.getElement((int)34) + " #" + (i + 1);
                bl &= ((ResourcesDataControl)this.resourcesDataControlList.get(i)).isValid(string2, list);
            }
        }
        return bl &= EffectsController.isValid(string + " >> " + TC.get((String)"Element.Effects"), list, this.action.getEffects());
    }

    @Override
    public int countAssetReferences(String string) {
        int n = 0;
        if (this.action.getType() == 6 || this.action.getType() == 5) {
            for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
                n += resourcesDataControl.countAssetReferences(string);
            }
        }
        return n += EffectsController.countAssetReferences(string, this.action.getEffects());
    }

    @Override
    public void deleteAssetReferences(String string) {
        if (this.action.getType() == 6 || this.action.getType() == 5) {
            for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
                resourcesDataControl.deleteAssetReferences(string);
            }
        }
        EffectsController.deleteAssetReferences(string, this.action.getEffects());
    }

    @Override
    public int countIdentifierReferences(String string) {
        int n = 0;
        if ((this.action.getType() == 2 || this.action.getType() == 3 || this.action.getType() == 8 || this.action.getType() == 6) && this.action.getTargetId().equals(string)) {
            ++n;
        }
        if (this.action.getType() == 6 || this.action.getType() == 5) {
            for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
                resourcesDataControl.countIdentifierReferences(string);
            }
        }
        n += EffectsController.countIdentifierReferences(string, this.action.getEffects());
        return n += this.conditionsController.countIdentifierReferences(string);
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        if (this.action.getType() == 6 || this.action.getType() == 5) {
            for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
                resourcesDataControl.replaceIdentifierReferences(string, string2);
            }
        }
        if ((this.action.getType() == 2 || this.action.getType() == 3 || this.action.getType() == 8 || this.action.getType() == 6) && this.action.getTargetId().equals(string)) {
            this.action.setTargetId(string2);
        }
        EffectsController.replaceIdentifierReferences(string, string2, this.action.getEffects());
        this.conditionsController.replaceIdentifierReferences(string, string2);
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        if (this.action.getType() == 6 || this.action.getType() == 5) {
            for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
                resourcesDataControl.deleteIdentifierReferences(string);
            }
        }
        EffectsController.deleteIdentifierReferences(string, this.action.getEffects());
        this.conditionsController.deleteIdentifierReferences(string);
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
        for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
            resourcesDataControl.getAssetReferences(list, list2);
        }
        EffectsController.getAssetReferences(list, list2, this.action.getEffects());
    }

    @Override
    public boolean canBeDuplicated() {
        return true;
    }

    public boolean getNeedsGoTo() {
        return this.action.isNeedsGoTo();
    }

    public void setNeedsGoTo(boolean bl) {
        this.controller.addTool(new ChangeBooleanValueTool(this.action, bl, "isNeedsGoTo", "setNeedsGoTo"));
    }

    public int getKeepDistance() {
        return this.action.getKeepDistance();
    }

    public void setKeepDistance(int n) {
        this.controller.addTool(new ChangeIntegerValueTool(this.action, n, "getKeepDistance", "setKeepDistance"));
    }

    public void setActivatedNotEffects(Boolean bl) {
        this.action.setActivatedNotEffects(bl.booleanValue());
    }

    public Boolean isActivatedNotEffects() {
        return this.action.isActivatedNotEffects();
    }

    public EffectsController getNotEffectsController() {
        return this.notEffectsController;
    }

    @Override
    public void recursiveSearch() {
        this.check(this.getConditions(), TC.get((String)"Search.Conditions"));
        this.check(this.getIdTarget(), TC.get((String)"Search.IDTarget"));
        for (int i = 0; i < this.getEffects().getEffectCount(); ++i) {
            this.check(this.getEffects().getEffectInfo(i), TC.get((String)"Search.Effect"));
        }
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return null;
    }
}

