/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.cutscene;

import es.eucm.eadventure.common.data.chapter.scenes.Cutscene;
import es.eucm.eadventure.common.data.chapter.scenes.Slidescene;
import es.eucm.eadventure.common.data.chapter.scenes.Videoscene;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.cutscene.CutsceneDataControl;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import es.eucm.eadventure.editor.gui.editdialogs.CutsceneTypesDialog;
import java.util.ArrayList;
import java.util.List;

public class CutscenesListDataControl
extends DataControl {
    private List<Cutscene> cutscenesList;
    private List<CutsceneDataControl> cutscenesDataControlList;

    public CutscenesListDataControl(List<Cutscene> list) {
        this.cutscenesList = list;
        this.cutscenesDataControlList = new ArrayList<CutsceneDataControl>();
        for (Cutscene cutscene : list) {
            this.cutscenesDataControlList.add(new CutsceneDataControl(cutscene));
        }
    }

    public List<CutsceneDataControl> getCutscenes() {
        return this.cutscenesDataControlList;
    }

    public CutsceneDataControl getLastCutscene() {
        return this.cutscenesDataControlList.get(this.cutscenesDataControlList.size() - 1);
    }

    public String[][] getCutscenesInfo() {
        String[][] stringArray = null;
        stringArray = new String[this.cutscenesList.size()][2];
        for (int i = 0; i < this.cutscenesList.size(); ++i) {
            Cutscene cutscene = this.cutscenesList.get(i);
            stringArray[i][0] = cutscene.getId();
            if (cutscene.getType() == 1) {
                stringArray[i][1] = TC.get((String)"CutscenesList.Slidescene");
                continue;
            }
            if (cutscene.getType() != 2) continue;
            stringArray[i][1] = TC.get((String)"CutscenesList.Videoscene");
        }
        return stringArray;
    }

    @Override
    public Object getContent() {
        return this.cutscenesList;
    }

    @Override
    public int[] getAddableElements() {
        return new int[]{910};
    }

    @Override
    public boolean canAddElement(int n) {
        return n == 910;
    }

    @Override
    public boolean canBeDeleted() {
        return false;
    }

    @Override
    public boolean canBeMoved() {
        return false;
    }

    @Override
    public boolean canBeRenamed() {
        return false;
    }

    @Override
    public boolean addElement(int n, String string) {
        boolean bl = false;
        if (n == 910) {
            CutsceneTypesDialog cutsceneTypesDialog = new CutsceneTypesDialog();
            n = cutsceneTypesDialog.getOptionSelected();
            if (n == 10) {
                if (string == null) {
                    string = this.controller.showInputDialog(TC.get((String)"Operation.AddCutsceneTitle"), TC.get((String)"Operation.AddCutsceneMessage"), TC.get((String)"Operation.AddCutsceneDefaultValue"));
                }
                if (string != null && this.controller.isElementIdValid(string)) {
                    Slidescene slidescene = null;
                    if (n == 10) {
                        slidescene = new Slidescene(string);
                    }
                    this.cutscenesList.add((Cutscene)slidescene);
                    this.cutscenesDataControlList.add(new CutsceneDataControl((Cutscene)slidescene));
                    this.controller.getIdentifierSummary().addCutsceneId(string);
                    bl = true;
                }
            } else if (n == 37) {
                if (string == null) {
                    string = this.controller.showInputDialog(TC.get((String)"Operation.AddCutsceneTitle"), TC.get((String)"Operation.AddCutsceneMessage"), TC.get((String)"Operation.AddCutsceneDefaultValue"));
                }
                if (string != null && this.controller.isElementIdValid(string)) {
                    Videoscene videoscene = null;
                    if (n == 37) {
                        videoscene = new Videoscene(string);
                    }
                    this.cutscenesList.add((Cutscene)videoscene);
                    this.cutscenesDataControlList.add(new CutsceneDataControl((Cutscene)videoscene));
                    this.controller.getIdentifierSummary().addCutsceneId(string);
                    bl = true;
                }
            }
        }
        return bl;
    }

    @Override
    public String getDefaultId(int n) {
        return TC.get((String)"Operation.AddCutsceneDefaultValue");
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        boolean bl2 = false;
        int n = this.controller.getIdentifierSummary().getGeneralSceneIds().length;
        if (n > 1) {
            String string = ((CutsceneDataControl)dataControl).getId();
            String string2 = String.valueOf(this.controller.countIdentifierReferences(string));
            if ((!bl || this.controller.showStrictConfirmDialog(TC.get((String)"Operation.DeleteElementTitle"), TC.get((String)"Operation.DeleteElementWarning", (String[])new String[]{string, string2}))) && this.cutscenesList.remove(dataControl.getContent())) {
                this.cutscenesDataControlList.remove(dataControl);
                this.controller.deleteIdentifierReferences(string);
                this.controller.getIdentifierSummary().deleteCutsceneId(string);
                bl2 = true;
            }
        } else {
            this.controller.showErrorDialog(TC.get((String)"Operation.DeleteElementTitle"), TC.get((String)"Operation.ErrorLastScene"));
        }
        return bl2;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        boolean bl = false;
        int n = this.cutscenesList.indexOf(dataControl.getContent());
        if (n > 0) {
            this.cutscenesList.add(n - 1, this.cutscenesList.remove(n));
            this.cutscenesDataControlList.add(n - 1, this.cutscenesDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        boolean bl = false;
        int n = this.cutscenesList.indexOf(dataControl.getContent());
        if (n < this.cutscenesList.size() - 1) {
            this.cutscenesList.add(n + 1, this.cutscenesList.remove(n));
            this.cutscenesDataControlList.add(n + 1, this.cutscenesDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public String renameElement(String string) {
        return null;
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        for (CutsceneDataControl cutsceneDataControl : this.cutscenesDataControlList) {
            cutsceneDataControl.updateVarFlagSummary(varFlagSummary);
        }
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        boolean bl = true;
        string = string + " >> " + TC.getElement((int)9);
        for (CutsceneDataControl cutsceneDataControl : this.cutscenesDataControlList) {
            String string2 = string + " >> " + cutsceneDataControl.getId();
            bl &= cutsceneDataControl.isValid(string2, list);
        }
        return bl;
    }

    @Override
    public int countAssetReferences(String string) {
        int n = 0;
        for (CutsceneDataControl cutsceneDataControl : this.cutscenesDataControlList) {
            n += cutsceneDataControl.countAssetReferences(string);
        }
        return n;
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
        for (CutsceneDataControl cutsceneDataControl : this.cutscenesDataControlList) {
            cutsceneDataControl.getAssetReferences(list, list2);
        }
    }

    @Override
    public void deleteAssetReferences(String string) {
        for (CutsceneDataControl cutsceneDataControl : this.cutscenesDataControlList) {
            cutsceneDataControl.deleteAssetReferences(string);
        }
    }

    @Override
    public int countIdentifierReferences(String string) {
        int n = 0;
        for (CutsceneDataControl cutsceneDataControl : this.cutscenesDataControlList) {
            n += cutsceneDataControl.countIdentifierReferences(string);
        }
        return n;
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        for (CutsceneDataControl cutsceneDataControl : this.cutscenesDataControlList) {
            cutsceneDataControl.replaceIdentifierReferences(string, string2);
        }
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        for (CutsceneDataControl cutsceneDataControl : this.cutscenesDataControlList) {
            cutsceneDataControl.deleteIdentifierReferences(string);
        }
    }

    @Override
    public boolean canBeDuplicated() {
        return false;
    }

    @Override
    public void recursiveSearch() {
        for (CutsceneDataControl cutsceneDataControl : this.cutscenesDataControlList) {
            ((Searchable)cutsceneDataControl).recursiveSearch();
        }
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return this.getPathFromChild(searchable, this.cutscenesDataControlList);
    }

    public List<CutsceneDataControl> getAllCutsceneDataControls() {
        return this.cutscenesDataControlList;
    }
}

