/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.cutscene;

import es.eucm.eadventure.common.data.Documented;
import es.eucm.eadventure.common.data.Named;
import es.eucm.eadventure.common.data.Positioned;
import es.eucm.eadventure.common.data.animation.ImageLoaderFactory;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.common.data.chapter.scenes.Cutscene;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.common.loader.InputStreamCreator;
import es.eucm.eadventure.common.loader.Loader;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.DataControlWithResources;
import es.eucm.eadventure.editor.control.controllers.EditorImageLoader;
import es.eucm.eadventure.editor.control.controllers.EffectsController;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.general.ResourcesDataControl;
import es.eucm.eadventure.editor.control.tools.general.ChangeNSDestinyPositionTool;
import es.eucm.eadventure.editor.control.tools.general.assets.AddResourcesBlockTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeDocumentationTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeNameTool;
import es.eucm.eadventure.editor.control.tools.generic.ChangeIntegerValueTool;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.util.ArrayList;
import java.util.List;

public class CutsceneDataControl
extends DataControlWithResources {
    private Cutscene cutscene;
    private int cutsceneType;

    public CutsceneDataControl(Cutscene cutscene) {
        this.cutscene = cutscene;
        this.resourcesList = cutscene.getResources();
        switch (cutscene.getType()) {
            case 1: {
                this.cutsceneType = 10;
                break;
            }
            case 2: {
                this.cutsceneType = 37;
            }
        }
        this.selectedResources = 0;
        if (this.resourcesList.size() == 0) {
            this.resourcesList.add(new Resources());
        }
        this.resourcesDataControlList = new ArrayList();
        for (Resources resources : this.resourcesList) {
            this.resourcesDataControlList.add(new ResourcesDataControl(resources, this.cutsceneType));
        }
    }

    public int getType() {
        return this.cutsceneType;
    }

    public String getId() {
        return this.cutscene.getId();
    }

    public String getDocumentation() {
        return this.cutscene.getDocumentation();
    }

    public String getName() {
        return this.cutscene.getName();
    }

    public void setDocumentation(String string) {
        this.controller.addTool(new ChangeDocumentationTool((Documented)this.cutscene, string));
    }

    public void setName(String string) {
        this.controller.addTool(new ChangeNameTool((Named)this.cutscene, string));
    }

    public String getTargetId() {
        return this.cutscene.getTargetId();
    }

    public void setTargetId(String string) {
        this.cutscene.setTargetId(string);
    }

    @Override
    public Object getContent() {
        return this.cutscene;
    }

    @Override
    public int[] getAddableElements() {
        return new int[]{35, 36};
    }

    @Override
    public boolean canAddElement(int n) {
        boolean bl = false;
        return bl;
    }

    @Override
    public boolean canBeDeleted() {
        return true;
    }

    @Override
    public boolean canBeMoved() {
        return true;
    }

    @Override
    public boolean canBeRenamed() {
        return true;
    }

    @Override
    public boolean addElement(int n, String string) {
        boolean bl = false;
        if (n == 34) {
            bl = Controller.getInstance().addTool(new AddResourcesBlockTool(this.resourcesList, this.resourcesDataControlList, this.cutsceneType, this));
        }
        return bl;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        int n;
        boolean bl = false;
        if (this.resourcesList.contains(dataControl.getContent()) && (n = this.resourcesList.indexOf(dataControl.getContent())) > 0) {
            this.resourcesList.add(n - 1, this.resourcesList.remove(n));
            this.resourcesDataControlList.add(n - 1, this.resourcesDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        int n;
        boolean bl = false;
        if (this.resourcesList.contains(dataControl.getContent()) && (n = this.resourcesList.indexOf(dataControl.getContent())) < this.resourcesList.size() - 1) {
            this.resourcesList.add(n + 1, this.resourcesList.remove(n));
            this.resourcesDataControlList.add(n + 1, this.resourcesDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public String renameElement(String string) {
        boolean bl = false;
        String string2 = this.cutscene.getId();
        String string3 = String.valueOf(this.controller.countIdentifierReferences(string2));
        if (string != null || this.controller.showStrictConfirmDialog(TC.get((String)"Operation.RenameCutsceneTitle"), TC.get((String)"Operation.RenameElementWarning", (String[])new String[]{string2, string3}))) {
            String string4 = string;
            if (string == null) {
                string4 = this.controller.showInputDialog(TC.get((String)"Operation.RenameCutsceneTitle"), TC.get((String)"Operation.RenameCutsceneMessage"), string2);
            }
            if (string4 != null && !string4.equals(string2) && this.controller.isElementIdValid(string4)) {
                this.cutscene.setId(string4);
                this.controller.replaceIdentifierReferences(string2, string4);
                this.controller.getIdentifierSummary().deleteCutsceneId(string2);
                this.controller.getIdentifierSummary().addCutsceneId(string4);
                bl = true;
            }
        }
        if (bl) {
            return string2;
        }
        return null;
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        EffectsController.updateVarFlagSummary(varFlagSummary, this.cutscene.getEffects());
        for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
            resourcesDataControl.updateVarFlagSummary(varFlagSummary);
        }
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        boolean bl = true;
        for (int i = 0; i < this.resourcesDataControlList.size(); ++i) {
            String string2 = string + " >> " + TC.getElement((int)34) + " #" + (i + 1);
            bl &= ((ResourcesDataControl)this.resourcesDataControlList.get(i)).isValid(string2, list);
        }
        return bl &= EffectsController.isValid(string + " >> " + TC.get((String)"Element.Effects"), list, this.cutscene.getEffects());
    }

    @Override
    public int countAssetReferences(String string) {
        int n = 0;
        for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
            n += resourcesDataControl.countAssetReferences(string);
        }
        return n += EffectsController.countAssetReferences(string, this.cutscene.getEffects());
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
        for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
            resourcesDataControl.getAssetReferences(list, list2);
        }
        EffectsController.getAssetReferences(list, list2, this.cutscene.getEffects());
    }

    @Override
    public void deleteAssetReferences(String string) {
        for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
            resourcesDataControl.deleteAssetReferences(string);
        }
        EffectsController.deleteAssetReferences(string, this.cutscene.getEffects());
    }

    @Override
    public int countIdentifierReferences(String string) {
        int n = 0;
        if (this.cutscene.getTargetId() != null && this.cutscene.getTargetId().equals(string)) {
            ++n;
        }
        return n += EffectsController.countIdentifierReferences(string, this.cutscene.getEffects());
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        if (this.cutscene.getNext() == 2 && this.cutscene.getTargetId().equals(string)) {
            this.cutscene.setTargetId(string2);
        }
        EffectsController.replaceIdentifierReferences(string, string2, this.cutscene.getEffects());
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        EffectsController.deleteIdentifierReferences(string, this.cutscene.getEffects());
        if (this.cutscene.getNext() == 2 && this.cutscene.getTargetId().equals(string)) {
            this.cutscene.setNext(Integer.valueOf(0));
        }
    }

    @Override
    public boolean canBeDuplicated() {
        return false;
    }

    @Override
    public void recursiveSearch() {
        this.check(this.getId(), "ID");
        this.check(this.getDocumentation(), TC.get((String)"Search.Documentation"));
        this.check(this.getName(), TC.get((String)"Search.Name"));
        this.check(this.getTargetId(), TC.get((String)"Search.NextScene"));
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return this.getPathFromChild(searchable, this.resourcesDataControlList);
    }

    public String getPreviewImage() {
        if (this.cutsceneType == 10) {
            String string = ((ResourcesDataControl)this.resourcesDataControlList.get(this.selectedResources)).getAssetPath("slides");
            if (string != null && !string.toLowerCase().endsWith(".eaa")) {
                string = string + "_01.jpg";
            } else if (string != null) {
                return Loader.loadAnimation((InputStreamCreator)AssetsController.getInputStreamCreator(), (String)string, (ImageLoaderFactory)new EditorImageLoader()).getFrame(0).getUri();
            }
            return string;
        }
        return "img/icons/video.png";
    }

    public Integer getNext() {
        return this.cutscene.getNext();
    }

    public void setNext(Integer n) {
        Controller.getInstance().addTool(new ChangeIntegerValueTool(this.cutscene, n, "getNext", "setNext"));
        if (this.cutscene.getTargetId() == null || this.cutscene.getTargetId().equals("")) {
            this.cutscene.setTargetId(Controller.getInstance().getIdentifierSummary().getGeneralSceneIds()[0]);
        } else {
            boolean bl = false;
            for (int i = 0; i < Controller.getInstance().getIdentifierSummary().getGeneralSceneIds().length; ++i) {
                if (!Controller.getInstance().getIdentifierSummary().getGeneralSceneIds()[i].equals(this.cutscene.getTargetId())) continue;
                bl = true;
            }
            if (!bl) {
                this.cutscene.setTargetId(Controller.getInstance().getIdentifierSummary().getGeneralSceneIds()[0]);
            }
        }
    }

    public String getNextSceneId() {
        return this.cutscene.getTargetId();
    }

    public void setNextSceneId(String string) {
        this.cutscene.setTargetId(string);
    }

    public boolean hasDestinyPosition() {
        return this.cutscene.hasPlayerPosition();
    }

    public Integer getTransitionType() {
        return this.cutscene.getTransitionType();
    }

    public Integer getTransitionTime() {
        return this.cutscene.getTransitionTime();
    }

    public void setTransitionTime(int n) {
        Controller.getInstance().addTool(new ChangeIntegerValueTool(this.cutscene, n, "getTransitionTime", "setTransitionTime"));
    }

    public void setTransitionType(int n) {
        Controller.getInstance().addTool(new ChangeIntegerValueTool(this.cutscene, n, "getTransitionType", "setTransitionType"));
    }

    public void toggleDestinyPosition() {
        if (this.cutscene.hasPlayerPosition()) {
            this.controller.addTool(new ChangeNSDestinyPositionTool((Positioned)this.cutscene, Integer.MIN_VALUE, Integer.MIN_VALUE));
        } else {
            this.controller.addTool(new ChangeNSDestinyPositionTool((Positioned)this.cutscene, 400, 300));
        }
    }

    public int getDestinyPositionX() {
        return this.cutscene.getPositionX();
    }

    public int getDestinyPositionY() {
        return this.cutscene.getPositionY();
    }

    public void setDestinyPosition(int n, int n2) {
        this.controller.addTool(new ChangeNSDestinyPositionTool((Positioned)this.cutscene, n, n2));
    }

    public EffectsController getEffects() {
        return new EffectsController(this.cutscene.getEffects());
    }
}

