/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.conversation;

import es.eucm.eadventure.common.data.chapter.conversation.Conversation;
import es.eucm.eadventure.common.data.chapter.conversation.GraphConversation;
import es.eucm.eadventure.common.data.chapter.conversation.line.ConversationLine;
import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNode;
import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNodeView;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.ConditionsController;
import es.eucm.eadventure.editor.control.controllers.EffectsController;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.conversation.ConversationDataControl;
import es.eucm.eadventure.editor.control.controllers.conversation.SearchableNode;
import es.eucm.eadventure.editor.control.tools.conversation.DeleteConversationNodeTool;
import es.eucm.eadventure.editor.control.tools.conversation.LinkConversationNodeTool;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GraphConversationDataControl
extends ConversationDataControl {
    private GraphConversation graphConversation;
    private Map<ConversationNodeView, List<ConditionsController>> allConditions;

    public GraphConversationDataControl(GraphConversation graphConversation) {
        this.graphConversation = graphConversation;
        this.storeAllConditions();
    }

    @Override
    public int getType() {
        return 33;
    }

    @Override
    public String getId() {
        return this.graphConversation.getId();
    }

    @Override
    public ConversationNodeView getRootNode() {
        return this.graphConversation.getRootNode();
    }

    @Override
    public void updateAllConditions() {
        this.allConditions.clear();
        List<ConversationNodeView> list = this.getAllNodesViews();
        for (ConversationNodeView conversationNodeView : list) {
            ArrayList<ConditionsController> arrayList = new ArrayList<ConditionsController>();
            for (int i = 0; i < conversationNodeView.getLineCount(); ++i) {
                arrayList.add(new ConditionsController(conversationNodeView.getLineConditions(i), conversationNodeView.getType() == 0 ? 330 : 331, Integer.toString(i)));
            }
            this.allConditions.put(conversationNodeView, arrayList);
        }
    }

    private void storeAllConditions() {
        this.allConditions = new HashMap<ConversationNodeView, List<ConditionsController>>();
        this.updateAllConditions();
    }

    public ConditionsController getLineConditionController(ConversationNodeView conversationNodeView, int n) {
        return this.allConditions.get(conversationNodeView).get(n);
    }

    @Override
    public int getConversationLineCount() {
        int n = 0;
        List<ConversationNodeView> list = this.getAllNodesViews();
        for (ConversationNodeView conversationNodeView : list) {
            n += conversationNodeView.getLineCount();
        }
        return n;
    }

    @Override
    public int[] getAddableNodes(ConversationNodeView conversationNodeView) {
        int[] nArray = null;
        if (conversationNodeView.getType() == 0) {
            nArray = new int[]{0, 1};
        } else if (conversationNodeView.getType() == 1) {
            nArray = new int[]{0};
        }
        return nArray;
    }

    @Override
    public boolean canAddChild(ConversationNodeView conversationNodeView, int n) {
        boolean bl = false;
        if (conversationNodeView.getType() == 0 && conversationNodeView.isTerminal()) {
            bl = true;
        }
        if (conversationNodeView.getType() == 1 && n == 0) {
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean canLinkNode(ConversationNodeView conversationNodeView) {
        boolean bl = false;
        if (conversationNodeView != this.graphConversation.getRootNode()) {
            if (conversationNodeView.getType() == 0 && conversationNodeView.isTerminal()) {
                bl = true;
            }
            if (conversationNodeView.getType() == 1) {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean canDeleteLink(ConversationNodeView conversationNodeView) {
        boolean bl = false;
        if (conversationNodeView != this.graphConversation.getRootNode()) {
            if (conversationNodeView.getType() == 0 && conversationNodeView.isTerminal()) {
                bl = true;
            }
            if (conversationNodeView.getType() == 1) {
                bl = true;
            }
        }
        return !bl && this.getAllNodesViews().size() > 1;
    }

    @Override
    public boolean canLinkNodeTo(ConversationNodeView conversationNodeView, ConversationNodeView conversationNodeView2) {
        boolean bl = false;
        if (conversationNodeView != conversationNodeView2) {
            if (conversationNodeView.getType() == 0 && conversationNodeView.isTerminal() && !this.isDirectFather(conversationNodeView2, conversationNodeView)) {
                bl = true;
            }
            if (conversationNodeView.getType() == 1 && conversationNodeView2.getType() == 0) {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean canDeleteNode(ConversationNodeView conversationNodeView) {
        return conversationNodeView != this.graphConversation.getRootNode();
    }

    @Override
    public boolean canMoveNode(ConversationNodeView conversationNodeView) {
        return false;
    }

    @Override
    public boolean canMoveNodeTo(ConversationNodeView conversationNodeView, ConversationNodeView conversationNodeView2) {
        return false;
    }

    @Override
    public boolean linkNode(ConversationNodeView conversationNodeView, ConversationNodeView conversationNodeView2) {
        return this.controller.addTool(new LinkConversationNodeTool(this, conversationNodeView, conversationNodeView2));
    }

    @Override
    public boolean deleteNode(ConversationNodeView conversationNodeView) {
        return this.controller.addTool(new DeleteConversationNodeTool(conversationNodeView, (GraphConversation)this.getConversation(), this.allConditions));
    }

    @Override
    public boolean moveNode(ConversationNodeView conversationNodeView, ConversationNodeView conversationNodeView2) {
        return false;
    }

    public List<ConversationNodeView> getAllNodesViews() {
        List list = this.graphConversation.getAllNodes();
        ArrayList<ConversationNodeView> arrayList = new ArrayList<ConversationNodeView>();
        for (ConversationNode conversationNode : list) {
            arrayList.add((ConversationNodeView)conversationNode);
        }
        return arrayList;
    }

    public List<SearchableNode> getAllSearchableNodes() {
        List list = this.graphConversation.getAllNodes();
        ArrayList<SearchableNode> arrayList = new ArrayList<SearchableNode>();
        for (ConversationNode conversationNode : list) {
            arrayList.add(new SearchableNode((ConversationNodeView)conversationNode));
        }
        return arrayList;
    }

    private boolean isDirectFather(ConversationNodeView conversationNodeView, ConversationNodeView conversationNodeView2) {
        boolean bl = false;
        if (conversationNodeView.getType() == 0 && conversationNodeView2.getType() == 0 && !conversationNodeView.isTerminal()) {
            bl = conversationNodeView.getChildView(0) == conversationNodeView2 ? true : this.isDirectFather(conversationNodeView.getChildView(0), conversationNodeView2);
        }
        return bl;
    }

    @Override
    public Object getContent() {
        return this.graphConversation;
    }

    @Override
    public String renameElement(String string) {
        boolean bl = false;
        String string2 = this.graphConversation.getId();
        String string3 = String.valueOf(this.controller.countIdentifierReferences(string2));
        if (string != null || this.controller.showStrictConfirmDialog(TC.get((String)"Operation.RenameConversationTitle"), TC.get((String)"Operation.RenameElementWarning", (String[])new String[]{string2, string3}))) {
            String string4 = string;
            if (string == null) {
                string4 = this.controller.showInputDialog(TC.get((String)"Operation.RenameConversationTitle"), TC.get((String)"Operation.RenameConversationMessage"), string2);
            }
            if (string4 != null && !string4.equals(string2) && this.controller.isElementIdValid(string4)) {
                this.graphConversation.setId(string4);
                this.controller.replaceIdentifierReferences(string2, string4);
                this.controller.getIdentifierSummary().deleteConversationId(string2);
                this.controller.getIdentifierSummary().addConversationId(string4);
                bl = true;
            }
        }
        if (bl) {
            return string2;
        }
        return null;
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        List list = this.graphConversation.getAllNodes();
        for (ConversationNode conversationNode : list) {
            if (conversationNode.hasEffects()) {
                EffectsController.updateVarFlagSummary(varFlagSummary, conversationNode.getEffects());
            }
            for (int i = 0; i < conversationNode.getLineCount(); ++i) {
                ConditionsController.updateVarFlagSummary(varFlagSummary, conversationNode.getLineConditions(i));
            }
        }
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        return GraphConversationDataControl.isValidNode(this.graphConversation.getRootNode(), string, list, new ArrayList<ConversationNode>());
    }

    @Override
    public int countAssetReferences(String string) {
        int n = 0;
        List list = this.graphConversation.getAllNodes();
        for (ConversationNode conversationNode : list) {
            if (conversationNode.hasEffects()) {
                n += EffectsController.countAssetReferences(string, conversationNode.getEffects());
            }
            for (int i = 0; i < conversationNode.getLineCount(); ++i) {
                String string2;
                if (!conversationNode.hasAudioPath(i) || !(string2 = conversationNode.getAudioPath(i)).equals(string)) continue;
                ++n;
            }
        }
        return n;
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
        List list3 = this.graphConversation.getAllNodes();
        for (ConversationNode conversationNode : list3) {
            if (conversationNode.hasEffects()) {
                EffectsController.getAssetReferences(list, list2, conversationNode.getEffects());
            }
            for (int i = 0; i < conversationNode.getLineCount(); ++i) {
                if (!conversationNode.hasAudioPath(i)) continue;
                String string = conversationNode.getAudioPath(i);
                boolean bl = true;
                for (String string2 : list) {
                    if (!string2.equals(string)) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                int n = list.size();
                list.add(n, string);
                list2.add(n, 4);
            }
        }
    }

    @Override
    public void deleteAssetReferences(String string) {
        List list = this.graphConversation.getAllNodes();
        for (ConversationNode conversationNode : list) {
            if (conversationNode.hasEffects()) {
                EffectsController.deleteAssetReferences(string, conversationNode.getEffects());
            }
            for (int i = 0; i < conversationNode.getLineCount(); ++i) {
                String string2;
                if (!conversationNode.hasAudioPath(i) || !(string2 = conversationNode.getAudioPath(i)).equals(string)) continue;
                conversationNode.getLine(i).setAudioPath(null);
            }
        }
    }

    @Override
    public int countIdentifierReferences(String string) {
        int n = 0;
        List list = this.graphConversation.getAllNodes();
        for (ConversationNode object2 : list) {
            if (object2.getType() != 0) continue;
            for (int iterator = 0; iterator < object2.getLineCount(); ++iterator) {
                Object object = object2.getLine(iterator);
                if (!object.getName().equals(string)) continue;
                ++n;
            }
            if (!object2.hasEffects()) continue;
            n += EffectsController.countIdentifierReferences(string, object2.getEffects());
        }
        for (List list2 : this.allConditions.values()) {
            for (Object object : list2) {
                n += ((ConditionsController)object).countIdentifierReferences(string);
            }
        }
        return n;
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        List list = this.graphConversation.getAllNodes();
        for (ConversationNode conversationNode : list) {
            if (conversationNode.getType() == 0) {
                for (int i = 0; i < conversationNode.getLineCount(); ++i) {
                    ConversationLine conversationLine = conversationNode.getLine(i);
                    if (!conversationLine.getName().equals(string)) continue;
                    conversationLine.setName(string2);
                }
                if (conversationNode.hasEffects()) {
                    EffectsController.replaceIdentifierReferences(string, string2, conversationNode.getEffects());
                }
            }
            for (List<ConditionsController> list2 : this.allConditions.values()) {
                for (ConditionsController conditionsController : list2) {
                    conditionsController.replaceIdentifierReferences(string, string2);
                }
            }
        }
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        List list = this.graphConversation.getAllNodes();
        for (ConversationNode conversationNode : list) {
            if (conversationNode.getType() == 0) {
                int n = 0;
                while (n < conversationNode.getLineCount()) {
                    if (conversationNode.getLine(n).getName().equals(string)) {
                        conversationNode.removeLine(n);
                        continue;
                    }
                    ++n;
                }
                if (conversationNode.hasEffects()) {
                    EffectsController.deleteIdentifierReferences(string, conversationNode.getEffects());
                }
            }
            for (List<ConditionsController> list2 : this.allConditions.values()) {
                for (ConditionsController conditionsController : list2) {
                    conditionsController.deleteIdentifierReferences(string);
                }
            }
        }
    }

    @Override
    public boolean canBeDuplicated() {
        return true;
    }

    @Override
    public void recursiveSearch() {
        this.check(this.getId(), "ID");
        for (SearchableNode searchableNode : this.getAllSearchableNodes()) {
            searchableNode.recursiveSearch();
        }
    }

    @Override
    public Conversation getConversation() {
        return this.graphConversation;
    }

    @Override
    public void setConversation(Conversation conversation) {
        if (conversation instanceof GraphConversation) {
            this.graphConversation = (GraphConversation)conversation;
        }
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        List<Searchable> list = this.getPathFromChild(searchable, this.getAllSearchableNodes());
        if (list != null) {
            return list;
        }
        if (searchable == this) {
            list = new ArrayList<Searchable>();
            list.add(this);
            return list;
        }
        return null;
    }

    public Map<ConversationNodeView, List<ConditionsController>> getAllConditions() {
        return this.allConditions;
    }

    @Override
    public List<ConversationNodeView> getAllNodes() {
        return this.getAllNodesViews();
    }
}

