/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.conversation;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.chapter.conversation.Conversation;
import es.eucm.eadventure.common.data.chapter.conversation.GraphConversation;
import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNode;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.config.ConversationConfigData;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.conversation.ConversationDataControl;
import es.eucm.eadventure.editor.control.controllers.conversation.GraphConversationDataControl;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.util.ArrayList;
import java.util.List;

public class ConversationsListDataControl
extends DataControl {
    private List<Conversation> conversationsList;
    private List<ConversationDataControl> conversationsDataControlList;

    public ConversationsListDataControl(List<Conversation> list) {
        this.conversationsList = list;
        this.conversationsDataControlList = new ArrayList<ConversationDataControl>();
        for (Conversation conversation : list) {
            if (conversation.getType() != 1) continue;
            this.conversationsDataControlList.add(new GraphConversationDataControl((GraphConversation)conversation));
        }
    }

    public List<ConversationDataControl> getConversations() {
        return this.conversationsDataControlList;
    }

    public ConversationDataControl getLastConversation() {
        return this.conversationsDataControlList.get(this.conversationsDataControlList.size() - 1);
    }

    @Override
    public Object getContent() {
        return this.conversationsList;
    }

    @Override
    public int[] getAddableElements() {
        return new int[]{33};
    }

    @Override
    public boolean canAddElement(int n) {
        return n == 33;
    }

    @Override
    public boolean canBeDeleted() {
        return false;
    }

    @Override
    public boolean canBeMoved() {
        return false;
    }

    @Override
    public boolean canBeRenamed() {
        return false;
    }

    @Override
    public boolean addElement(int n, String string) {
        boolean bl = false;
        if (n == 33) {
            if (string == null) {
                string = this.controller.showInputDialog(TC.get((String)"Operation.AddConversationTitle"), TC.get((String)"Operation.AddConversationMessage"), TC.get((String)"Operation.AddConversationDefaultValue"));
            }
            if (string != null && this.controller.isElementIdValid(string)) {
                GraphConversation graphConversation = new GraphConversation(string);
                GraphConversationDataControl graphConversationDataControl = new GraphConversationDataControl(graphConversation);
                this.conversationsList.add((Conversation)graphConversation);
                this.conversationsDataControlList.add(graphConversationDataControl);
                this.controller.getIdentifierSummary().addConversationId(string);
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean duplicateElement(DataControl dataControl) {
        if (!(dataControl instanceof GraphConversationDataControl)) {
            return false;
        }
        try {
            GraphConversation graphConversation = (GraphConversation)((GraphConversation)dataControl.getContent()).clone();
            String string = graphConversation.getId();
            int n = 1;
            do {
                string = graphConversation.getId() + n;
                ++n;
            } while (!this.controller.isElementIdValid(string, false));
            graphConversation.setId(string);
            this.conversationsList.add((Conversation)graphConversation);
            this.conversationsDataControlList.add(new GraphConversationDataControl(graphConversation));
            this.controller.getIdentifierSummary().addConversationId(string);
            String string2 = ((GraphConversation)dataControl.getContent()).getId();
            boolean bl = ConversationConfigData.isConversationConfig(string2);
            if (bl) {
                for (int i = 0; i < graphConversation.getAllNodes().size(); ++i) {
                    int n2 = ConversationConfigData.getNodeX(string2, i);
                    int n3 = ConversationConfigData.getNodeY(string2, i);
                    ConversationConfigData.setNodeX(string, i, n2);
                    ConversationConfigData.setNodeY(string, i, n3);
                }
            }
            return true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ReportDialog.GenerateErrorReport((Exception)cloneNotSupportedException, (boolean)true, (String)"Could not clone conversation");
            return false;
        }
    }

    @Override
    public String getDefaultId(int n) {
        return TC.get((String)"Operation.AddConversationDefaultValue");
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        boolean bl2 = false;
        String string = ((ConversationDataControl)dataControl).getId();
        String string2 = String.valueOf(this.controller.countIdentifierReferences(string));
        if ((!bl || this.controller.showStrictConfirmDialog(TC.get((String)"Operation.DeleteElementTitle"), TC.get((String)"Operation.DeleteElementWarning", (String[])new String[]{string, string2}))) && this.conversationsList.remove(dataControl.getContent())) {
            this.conversationsDataControlList.remove(dataControl);
            this.controller.deleteIdentifierReferences(string);
            this.controller.getIdentifierSummary().deleteConversationId(string);
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        boolean bl = false;
        int n = this.conversationsList.indexOf(dataControl.getContent());
        if (n > 0) {
            this.conversationsList.add(n - 1, this.conversationsList.remove(n));
            this.conversationsDataControlList.add(n - 1, this.conversationsDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        boolean bl = false;
        int n = this.conversationsList.indexOf(dataControl.getContent());
        if (n < this.conversationsList.size() - 1) {
            this.conversationsList.add(n + 1, this.conversationsList.remove(n));
            this.conversationsDataControlList.add(n + 1, this.conversationsDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public String renameElement(String string) {
        return null;
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        for (ConversationDataControl conversationDataControl : this.conversationsDataControlList) {
            conversationDataControl.updateVarFlagSummary(varFlagSummary);
        }
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        boolean bl = true;
        string = string + " >> " + TC.getElement((int)31);
        for (ConversationDataControl conversationDataControl : this.conversationsDataControlList) {
            String string2 = string + " >> " + conversationDataControl.getId();
            bl &= conversationDataControl.isValid(string2, list);
        }
        return bl;
    }

    @Override
    public int countAssetReferences(String string) {
        int n = 0;
        for (ConversationDataControl conversationDataControl : this.conversationsDataControlList) {
            n += conversationDataControl.countAssetReferences(string);
        }
        return n;
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
        for (ConversationDataControl conversationDataControl : this.conversationsDataControlList) {
            conversationDataControl.getAssetReferences(list, list2);
        }
    }

    @Override
    public void deleteAssetReferences(String string) {
        for (ConversationDataControl conversationDataControl : this.conversationsDataControlList) {
            conversationDataControl.deleteAssetReferences(string);
        }
    }

    @Override
    public int countIdentifierReferences(String string) {
        int n = 0;
        for (ConversationDataControl conversationDataControl : this.conversationsDataControlList) {
            n += conversationDataControl.countIdentifierReferences(string);
        }
        return n;
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        for (ConversationDataControl conversationDataControl : this.conversationsDataControlList) {
            conversationDataControl.replaceIdentifierReferences(string, string2);
        }
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        for (ConversationDataControl conversationDataControl : this.conversationsDataControlList) {
            conversationDataControl.deleteIdentifierReferences(string);
        }
    }

    @Override
    public boolean canBeDuplicated() {
        return false;
    }

    public void resetAllConversationNodes() {
        for (Conversation conversation : this.conversationsList) {
            for (ConversationNode conversationNode : conversation.getAllNodes()) {
                conversationNode.resetEffect();
            }
        }
    }

    @Override
    public void recursiveSearch() {
        for (ConversationDataControl conversationDataControl : this.conversationsDataControlList) {
            conversationDataControl.recursiveSearch();
        }
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return this.getPathFromChild(searchable, this.conversationsDataControlList);
    }
}

