/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.conversation;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.Named;
import es.eucm.eadventure.common.data.chapter.conversation.Conversation;
import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNode;
import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNodeView;
import es.eucm.eadventure.common.data.chapter.conversation.node.DialogueConversationNode;
import es.eucm.eadventure.common.data.chapter.conversation.node.OptionConversationNode;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.ConditionsController;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.EffectsController;
import es.eucm.eadventure.editor.control.tools.conversation.AddConversationNodeTool;
import es.eucm.eadventure.editor.control.tools.conversation.AddNodeLineTool;
import es.eucm.eadventure.editor.control.tools.conversation.DeleteNodeLineTool;
import es.eucm.eadventure.editor.control.tools.conversation.DeleteNodeLinkTool;
import es.eucm.eadventure.editor.control.tools.conversation.DeleteNodeOptionTool;
import es.eucm.eadventure.editor.control.tools.conversation.MoveNodeLineTool;
import es.eucm.eadventure.editor.control.tools.conversation.SelectLineAudioPathTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeNameTool;
import es.eucm.eadventure.editor.control.tools.generic.ChangeBooleanValueTool;
import es.eucm.eadventure.editor.control.tools.generic.ChangeStringValueTool;
import es.eucm.eadventure.editor.gui.editdialogs.EffectsDialog;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class ConversationDataControl
extends DataControl {
    public abstract int getType();

    public abstract String getId();

    public abstract ConversationNodeView getRootNode();

    public abstract int getConversationLineCount();

    public abstract int[] getAddableNodes(ConversationNodeView var1);

    public abstract boolean canAddChild(ConversationNodeView var1, int var2);

    public abstract boolean canLinkNode(ConversationNodeView var1);

    public abstract boolean canDeleteLink(ConversationNodeView var1);

    public abstract boolean canLinkNodeTo(ConversationNodeView var1, ConversationNodeView var2);

    public abstract boolean canDeleteNode(ConversationNodeView var1);

    public abstract boolean canMoveNode(ConversationNodeView var1);

    public abstract boolean canMoveNodeTo(ConversationNodeView var1, ConversationNodeView var2);

    public boolean addChild(ConversationNodeView conversationNodeView, int n, Map<ConversationNodeView, List<ConditionsController>> map) {
        return this.controller.addTool(new AddConversationNodeTool(conversationNodeView, n, map));
    }

    public abstract boolean linkNode(ConversationNodeView var1, ConversationNodeView var2);

    public abstract boolean deleteNode(ConversationNodeView var1);

    public abstract boolean moveNode(ConversationNodeView var1, ConversationNodeView var2);

    public abstract Conversation getConversation();

    public abstract void setConversation(Conversation var1);

    public abstract void updateAllConditions();

    public void addNodeLine(ConversationNodeView conversationNodeView, int n, String string, List<ConditionsController> list) {
        this.controller.addTool(new AddNodeLineTool(conversationNodeView, n, string, list));
    }

    public void setNodeLineName(ConversationNodeView conversationNodeView, int n, String string) {
        ConversationNode conversationNode = (ConversationNode)conversationNodeView;
        this.controller.addTool(new ChangeNameTool((Named)conversationNode.getLine(n), string));
    }

    public void setNodeLineText(ConversationNodeView conversationNodeView, int n, String string) {
        ConversationNode conversationNode = (ConversationNode)conversationNodeView;
        this.controller.addTool(new ChangeStringValueTool(conversationNode.getLine(n), string, "getText", "setText"));
    }

    public void setNodeLineAudioPath(ConversationNodeView conversationNodeView, int n, String string) {
        ConversationNode conversationNode = (ConversationNode)conversationNodeView;
        if (!conversationNode.hasAudioPath(n) || !conversationNode.getAudioPath(n).equals(string)) {
            this.controller.addTool(new ChangeStringValueTool(conversationNode.getLine(n), string, "getAudioPath", "setAudioPath"));
        }
    }

    public boolean moveNodeLineUp(ConversationNodeView conversationNodeView, int n) {
        return this.controller.addTool(new MoveNodeLineTool(conversationNodeView, n, 1));
    }

    public boolean moveNodeLineDown(ConversationNodeView conversationNodeView, int n) {
        return this.controller.addTool(new MoveNodeLineTool(conversationNodeView, n, 2));
    }

    public void deleteNodeLine(ConversationNodeView conversationNodeView, int n, List<ConditionsController> list) {
        this.controller.addTool(new DeleteNodeLineTool(conversationNodeView, n, list));
    }

    public boolean deleteNodeLink(ConversationNodeView conversationNodeView) {
        return this.controller.addTool(new DeleteNodeLinkTool(conversationNodeView));
    }

    public boolean deleteNodeOption(ConversationNodeView conversationNodeView, int n) {
        return this.controller.addTool(new DeleteNodeOptionTool(conversationNodeView, n));
    }

    public void editNodeEffects(ConversationNodeView conversationNodeView) {
        ConversationNode conversationNode = (ConversationNode)conversationNodeView;
        new EffectsDialog(new EffectsController(conversationNode.getEffects()));
    }

    @Override
    public int[] getAddableElements() {
        return new int[0];
    }

    @Override
    public boolean canAddElement(int n) {
        return false;
    }

    @Override
    public boolean canBeDeleted() {
        return true;
    }

    @Override
    public boolean canBeMoved() {
        return true;
    }

    @Override
    public boolean canBeRenamed() {
        return true;
    }

    @Override
    public boolean addElement(int n, String string) {
        return false;
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        return false;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        return false;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        return false;
    }

    public boolean editLineAudioPath(ConversationNodeView conversationNodeView, int n) {
        try {
            return this.controller.addTool(new SelectLineAudioPathTool(((ConversationNode)conversationNodeView).getLine(n)));
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ReportDialog.GenerateErrorReport((Exception)new Exception("Could not clone resources"), (boolean)false, (String)TC.get((String)"Error.Title"));
            return false;
        }
    }

    public void setRandomlyOptions(ConversationNodeView conversationNodeView) {
        ConversationNode conversationNode;
        this.controller.addTool(new ChangeBooleanValueTool(conversationNode, ((OptionConversationNode)(conversationNode = (ConversationNode)conversationNodeView)).isRandom() == false, "isRandom", "setRandom"));
    }

    public void setKeepShowingOptionNodeOptions(ConversationNodeView conversationNodeView) {
        ConversationNode conversationNode;
        this.controller.addTool(new ChangeBooleanValueTool(conversationNode, ((OptionConversationNode)(conversationNode = (ConversationNode)conversationNodeView)).isKeepShowing() == false, "isKeepShowing", "setKeepShowing"));
    }

    public void setShowUserOptionOptions(ConversationNodeView conversationNodeView) {
        ConversationNode conversationNode;
        this.controller.addTool(new ChangeBooleanValueTool(conversationNode, ((OptionConversationNode)(conversationNode = (ConversationNode)conversationNodeView)).isShowUserOption() == false, "isShowUserOption", "setShowUserOption"));
    }

    public void setKeepShowingDialogueOptions(ConversationNodeView conversationNodeView) {
        ConversationNode conversationNode;
        this.controller.addTool(new ChangeBooleanValueTool(conversationNode, ((DialogueConversationNode)(conversationNode = (ConversationNode)conversationNodeView)).isKeepShowing() == false, "isKeepShowing", "setKeepShowing"));
    }

    public void setPreListeningOptions(ConversationNodeView conversationNodeView) {
        ConversationNode conversationNode;
        this.controller.addTool(new ChangeBooleanValueTool(conversationNode, ((OptionConversationNode)(conversationNode = (ConversationNode)conversationNodeView)).isPreListening() == false, "isPreListening", "setPreListening"));
    }

    public boolean isRandomActivate(ConversationNodeView conversationNodeView) {
        ConversationNode conversationNode = (ConversationNode)conversationNodeView;
        return ((OptionConversationNode)conversationNode).isRandom();
    }

    public boolean isKeepShowingOptionsNodeActivate(ConversationNodeView conversationNodeView) {
        ConversationNode conversationNode = (ConversationNode)conversationNodeView;
        return ((OptionConversationNode)conversationNode).isKeepShowing();
    }

    public boolean isShowUserOptionActivate(ConversationNodeView conversationNodeView) {
        ConversationNode conversationNode = (ConversationNode)conversationNodeView;
        return ((OptionConversationNode)conversationNode).isShowUserOption();
    }

    public boolean isPreListeningActivate(ConversationNodeView conversationNodeView) {
        ConversationNode conversationNode = (ConversationNode)conversationNodeView;
        return ((OptionConversationNode)conversationNode).isPreListening();
    }

    public boolean isKeepShowingDialogueActivate(ConversationNodeView conversationNodeView) {
        ConversationNode conversationNode = (ConversationNode)conversationNodeView;
        return ((DialogueConversationNode)conversationNode).isKeepShowing();
    }

    protected static boolean isValidNode(ConversationNode conversationNode, String string, List<String> list, List<ConversationNode> list2) {
        boolean bl = true;
        if (list2 == null) {
            list2 = new ArrayList<ConversationNode>();
        }
        if (!list2.contains(conversationNode)) {
            list2.add(conversationNode);
            if (conversationNode.getType() == 1 && conversationNode.getLineCount() == 0) {
                if (list != null && string != null) {
                    list.add(string + " >> " + TC.get((String)"Operation.AdventureConsistencyErrorEmptyOptionsNode"));
                }
                bl = false;
            } else {
                for (int i = 0; i < conversationNode.getChildCount() && (bl &= ConversationDataControl.isValidNode(conversationNode.getChild(i), string, list, list2)); ++i) {
                }
            }
        }
        return bl;
    }

    public abstract List<ConversationNodeView> getAllNodes();
}

