/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.character;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.chapter.elements.NPC;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.character.NPCDataControl;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.util.ArrayList;
import java.util.List;

public class NPCsListDataControl
extends DataControl {
    private List<NPC> npcsList;
    private List<NPCDataControl> npcsDataControlList;

    public NPCsListDataControl(List<NPC> list) {
        this.npcsList = list;
        this.npcsDataControlList = new ArrayList<NPCDataControl>();
        for (NPC nPC : list) {
            this.npcsDataControlList.add(new NPCDataControl(nPC));
        }
    }

    public List<NPCDataControl> getNPCs() {
        return this.npcsDataControlList;
    }

    public NPCDataControl getLastNPC() {
        return this.npcsDataControlList.get(this.npcsDataControlList.size() - 1);
    }

    public String[][] getNPCsInfo() {
        String[][] stringArray = null;
        stringArray = new String[this.npcsList.size()][2];
        for (int i = 0; i < this.npcsList.size(); ++i) {
            NPC nPC = this.npcsList.get(i);
            stringArray[i][0] = nPC.getId();
            stringArray[i][1] = TC.get((String)"NPCsList.ActionsNumber", (String)String.valueOf(nPC.getActions().size()));
        }
        return stringArray;
    }

    @Override
    public Object getContent() {
        return this.npcsList;
    }

    @Override
    public int[] getAddableElements() {
        return new int[]{28};
    }

    @Override
    public boolean canAddElement(int n) {
        return n == 28;
    }

    @Override
    public boolean canBeDeleted() {
        return false;
    }

    @Override
    public boolean canBeMoved() {
        return false;
    }

    @Override
    public boolean canBeRenamed() {
        return false;
    }

    @Override
    public boolean addElement(int n, String string) {
        boolean bl = false;
        if (n == 28) {
            if (string == null) {
                string = this.controller.showInputDialog(TC.get((String)"Operation.AddNPCTitle"), TC.get((String)"Operation.AddNPCMessage"), TC.get((String)"Operation.AddNPCDefaultValue"));
            }
            if (string != null && this.controller.isElementIdValid(string)) {
                NPC nPC = new NPC(string);
                this.npcsList.add(nPC);
                this.npcsDataControlList.add(new NPCDataControl(nPC));
                this.controller.getIdentifierSummary().addNPCId(string);
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean duplicateElement(DataControl dataControl) {
        if (!(dataControl instanceof NPCDataControl)) {
            return false;
        }
        try {
            NPC nPC = (NPC)((NPC)dataControl.getContent()).clone();
            String string = nPC.getId();
            int n = 1;
            do {
                string = nPC.getId() + n;
                ++n;
            } while (!this.controller.isElementIdValid(string, false));
            nPC.setId(string);
            this.npcsList.add(nPC);
            this.npcsDataControlList.add(new NPCDataControl(nPC));
            this.controller.getIdentifierSummary().addNPCId(string);
            return true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ReportDialog.GenerateErrorReport((Exception)cloneNotSupportedException, (boolean)true, (String)"Could not clone npc");
            return false;
        }
    }

    @Override
    public String getDefaultId(int n) {
        return TC.get((String)"Operation.AddNPCDefaultValue");
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        boolean bl2 = false;
        String string = ((NPCDataControl)dataControl).getId();
        String string2 = String.valueOf(this.controller.countIdentifierReferences(string));
        if ((!bl || this.controller.showStrictConfirmDialog(TC.get((String)"Operation.DeleteElementTitle"), TC.get((String)"Operation.DeleteElementWarning", (String[])new String[]{string, string2}))) && this.npcsList.remove(dataControl.getContent())) {
            this.npcsDataControlList.remove(dataControl);
            this.controller.deleteIdentifierReferences(string);
            this.controller.getIdentifierSummary().deleteNPCId(string);
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        boolean bl = false;
        int n = this.npcsList.indexOf(dataControl.getContent());
        if (n > 0) {
            this.npcsList.add(n - 1, this.npcsList.remove(n));
            this.npcsDataControlList.add(n - 1, this.npcsDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        boolean bl = false;
        int n = this.npcsList.indexOf(dataControl.getContent());
        if (n < this.npcsList.size() - 1) {
            this.npcsList.add(n + 1, this.npcsList.remove(n));
            this.npcsDataControlList.add(n + 1, this.npcsDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public String renameElement(String string) {
        return null;
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        for (NPCDataControl nPCDataControl : this.npcsDataControlList) {
            nPCDataControl.updateVarFlagSummary(varFlagSummary);
        }
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        boolean bl = true;
        string = string + " >> " + TC.getElement((int)27);
        for (NPCDataControl nPCDataControl : this.npcsDataControlList) {
            String string2 = string + " >> " + nPCDataControl.getId();
            bl &= nPCDataControl.isValid(string2, list);
        }
        return bl;
    }

    @Override
    public int countAssetReferences(String string) {
        int n = 0;
        for (NPCDataControl nPCDataControl : this.npcsDataControlList) {
            n += nPCDataControl.countAssetReferences(string);
        }
        return n;
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
        for (NPCDataControl nPCDataControl : this.npcsDataControlList) {
            nPCDataControl.getAssetReferences(list, list2);
        }
    }

    @Override
    public void deleteAssetReferences(String string) {
        for (NPCDataControl nPCDataControl : this.npcsDataControlList) {
            nPCDataControl.deleteAssetReferences(string);
        }
    }

    @Override
    public int countIdentifierReferences(String string) {
        int n = 0;
        for (NPCDataControl nPCDataControl : this.npcsDataControlList) {
            n += nPCDataControl.countIdentifierReferences(string);
        }
        return n;
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        for (NPCDataControl nPCDataControl : this.npcsDataControlList) {
            nPCDataControl.replaceIdentifierReferences(string, string2);
        }
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        for (NPCDataControl nPCDataControl : this.npcsDataControlList) {
            nPCDataControl.deleteIdentifierReferences(string);
        }
    }

    @Override
    public boolean canBeDuplicated() {
        return false;
    }

    @Override
    public void recursiveSearch() {
        for (NPCDataControl nPCDataControl : this.npcsDataControlList) {
            ((Searchable)nPCDataControl).recursiveSearch();
        }
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return this.getPathFromChild(searchable, this.npcsDataControlList);
    }

    public NPC getNPC(String string) {
        for (NPC nPC : this.npcsList) {
            if (!nPC.getId().equals(string)) continue;
            return nPC;
        }
        return null;
    }

    public List<NPCDataControl> getAllNPCDataControls() {
        return this.npcsDataControlList;
    }
}

