/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.character;

import es.eucm.eadventure.common.data.animation.ImageLoaderFactory;
import es.eucm.eadventure.common.data.chapter.elements.NPC;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.common.loader.InputStreamCreator;
import es.eucm.eadventure.common.loader.Loader;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.DataControlWithResources;
import es.eucm.eadventure.editor.control.controllers.EditorImageLoader;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.general.ActionsListDataControl;
import es.eucm.eadventure.editor.control.controllers.general.ResourcesDataControl;
import es.eucm.eadventure.editor.control.tools.general.assets.AddResourcesBlockTool;
import es.eucm.eadventure.editor.control.tools.generic.ChangeBooleanValueTool;
import es.eucm.eadventure.editor.control.tools.generic.ChangeStringValueTool;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class NPCDataControl
extends DataControlWithResources {
    private static final String EMPTY_ANIMATION = "assets/special/EmptyAnimation";
    private NPC npc;
    private ActionsListDataControl actionsListDataControl;

    public NPCDataControl(NPC nPC) {
        this.npc = nPC;
        this.resourcesList = nPC.getResources();
        this.selectedResources = 0;
        if (this.resourcesList.size() == 0) {
            this.resourcesList.add(new Resources());
        }
        this.resourcesDataControlList = new ArrayList();
        for (Resources resources : this.resourcesList) {
            this.resourcesDataControlList.add(new ResourcesDataControl(resources, 28));
        }
        this.actionsListDataControl = new ActionsListDataControl(nPC.getActions(), this);
    }

    public ActionsListDataControl getActionsList() {
        return this.actionsListDataControl;
    }

    public String getPreviewImage() {
        String string = this.getExistingPreviewImagePath();
        if (string != null && !string.toLowerCase().endsWith(".eaa")) {
            string = string + "_01.png";
        } else if (string != null) {
            return Loader.loadAnimation((InputStreamCreator)AssetsController.getInputStreamCreator(), (String)string, (ImageLoaderFactory)new EditorImageLoader()).getFrame(0).getUri();
        }
        return string;
    }

    private String getExistingPreviewImagePath() {
        String string = null;
        for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
            string = resourcesDataControl != null && resourcesDataControl.getAssetPath("standright") != null && !resourcesDataControl.getAssetPath("standright").equals(EMPTY_ANIMATION) ? resourcesDataControl.getAssetPath("standright") : resourcesDataControl.getAssetPath("standleft");
            if (string != null) {
                return string;
            }
            for (int i = 0; i < resourcesDataControl.getAssetCount(); ++i) {
                string = resourcesDataControl.getAssetPath(resourcesDataControl.getAssetName(i));
                if (string == null) continue;
                return string;
            }
        }
        return EMPTY_ANIMATION;
    }

    public String getId() {
        return this.npc.getId();
    }

    public String getDocumentation() {
        return this.npc.getDocumentation();
    }

    public Color getTextFrontColor() {
        return new Color(Integer.valueOf(this.npc.getTextFrontColor().substring(1), 16));
    }

    public Color getTextBorderColor() {
        return new Color(Integer.valueOf(this.npc.getTextBorderColor().substring(1), 16));
    }

    public String getName() {
        return this.npc.getName();
    }

    public String getBriefDescription() {
        return this.npc.getDescription();
    }

    public String getDetailedDescription() {
        return this.npc.getDetailedDescription();
    }

    public boolean isAlwaysSynthesizer() {
        return this.npc.isAlwaysSynthesizer();
    }

    public void setTextFrontColor(Color color) {
        String string = Integer.toHexString(color.getRed());
        String string2 = Integer.toHexString(color.getGreen());
        String string3 = Integer.toHexString(color.getBlue());
        if (string.length() == 1) {
            string = "0" + string;
        }
        if (string2.length() == 1) {
            string2 = "0" + string2;
        }
        if (string3.length() == 1) {
            string3 = "0" + string3;
        }
        this.controller.addTool(new ChangeStringValueTool(this.npc, "#" + string + string2 + string3, "getTextFrontColor", "setTextFrontColor"));
    }

    public void setTextBorderColor(Color color) {
        String string = Integer.toHexString(color.getRed());
        String string2 = Integer.toHexString(color.getGreen());
        String string3 = Integer.toHexString(color.getBlue());
        if (string.length() == 1) {
            string = "0" + string;
        }
        if (string2.length() == 1) {
            string2 = "0" + string2;
        }
        if (string3.length() == 1) {
            string3 = "0" + string3;
        }
        this.controller.addTool(new ChangeStringValueTool(this.npc, "#" + string + string2 + string3, "getTextBorderColor", "setTextBorderColor"));
    }

    public void setBubbleBkgColor(Color color) {
        String string = Integer.toHexString(color.getRed());
        String string2 = Integer.toHexString(color.getGreen());
        String string3 = Integer.toHexString(color.getBlue());
        if (string.length() == 1) {
            string = "0" + string;
        }
        if (string2.length() == 1) {
            string2 = "0" + string2;
        }
        if (string3.length() == 1) {
            string3 = "0" + string3;
        }
        this.controller.addTool(new ChangeStringValueTool(this.npc, "#" + string + string2 + string3, "getBubbleBkgColor", "setBubbleBkgColor"));
    }

    public void setBubbleBorderColor(Color color) {
        String string = Integer.toHexString(color.getRed());
        String string2 = Integer.toHexString(color.getGreen());
        String string3 = Integer.toHexString(color.getBlue());
        if (string.length() == 1) {
            string = "0" + string;
        }
        if (string2.length() == 1) {
            string2 = "0" + string2;
        }
        if (string3.length() == 1) {
            string3 = "0" + string3;
        }
        this.controller.addTool(new ChangeStringValueTool(this.npc, "#" + string + string2 + string3, "getBubbleBorderColor", "setBubbleBorderColor"));
    }

    public void setAlwaysSynthesizer(boolean bl) {
        this.controller.addTool(new ChangeBooleanValueTool(this.npc, bl, "isAlwaysSynthesizer", "setAlwaysSynthesizer"));
    }

    public void setVoice(String string) {
        this.controller.addTool(new ChangeStringValueTool(this.npc, string, "getVoice", "setVoice"));
    }

    public String getVoice() {
        return this.npc.getVoice();
    }

    @Override
    public Object getContent() {
        return this.npc;
    }

    @Override
    public int[] getAddableElements() {
        return new int[0];
    }

    @Override
    public boolean canAddElement(int n) {
        return false;
    }

    @Override
    public boolean canBeDeleted() {
        return true;
    }

    @Override
    public boolean canBeMoved() {
        return true;
    }

    @Override
    public boolean canBeRenamed() {
        return true;
    }

    @Override
    public boolean addElement(int n, String string) {
        boolean bl = false;
        if (n == 34) {
            bl = Controller.getInstance().addTool(new AddResourcesBlockTool(this.resourcesList, this.resourcesDataControlList, 28, this));
        }
        return bl;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        boolean bl = false;
        int n = this.resourcesList.indexOf(dataControl.getContent());
        if (n > 0) {
            this.resourcesList.add(n - 1, this.resourcesList.remove(n));
            this.resourcesDataControlList.add(n - 1, this.resourcesDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        boolean bl = false;
        int n = this.resourcesList.indexOf(dataControl.getContent());
        if (n < this.resourcesList.size() - 1) {
            this.resourcesList.add(n + 1, this.resourcesList.remove(n));
            this.resourcesDataControlList.add(n + 1, this.resourcesDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public String renameElement(String string) {
        boolean bl = false;
        String string2 = this.npc.getId();
        String string3 = String.valueOf(this.controller.countIdentifierReferences(string2));
        if (string != null || this.controller.showStrictConfirmDialog(TC.get((String)"Operation.RenameNPCTitle"), TC.get((String)"Operation.RenameElementWarning", (String[])new String[]{string2, string3}))) {
            String string4 = string;
            if (string == null) {
                string4 = this.controller.showInputDialog(TC.get((String)"Operation.RenameNPCTitle"), TC.get((String)"Operation.RenameNPCMessage"), string2);
            }
            if (string4 != null && !string4.equals(string2) && this.controller.isElementIdValid(string4)) {
                this.npc.setId(string4);
                this.controller.replaceIdentifierReferences(string2, string4);
                this.controller.getIdentifierSummary().deleteNPCId(string2);
                this.controller.getIdentifierSummary().addNPCId(string4);
                bl = true;
            }
        }
        if (bl) {
            return string2;
        }
        return null;
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        this.actionsListDataControl.updateVarFlagSummary(varFlagSummary);
        for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
            resourcesDataControl.updateVarFlagSummary(varFlagSummary);
        }
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        boolean bl = true;
        for (int i = 0; i < this.resourcesDataControlList.size(); ++i) {
            String string2 = string + " >> " + TC.getElement((int)34) + " #" + (i + 1);
            bl &= ((ResourcesDataControl)this.resourcesDataControlList.get(i)).isValid(string2, list);
        }
        return bl &= this.actionsListDataControl.isValid(string, list);
    }

    @Override
    public int countAssetReferences(String string) {
        int n = 0;
        for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
            n += resourcesDataControl.countAssetReferences(string);
        }
        return n += this.actionsListDataControl.countAssetReferences(string);
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
        for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
            resourcesDataControl.getAssetReferences(list, list2);
        }
        this.actionsListDataControl.getAssetReferences(list, list2);
    }

    @Override
    public void deleteAssetReferences(String string) {
        for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
            resourcesDataControl.deleteAssetReferences(string);
        }
        this.actionsListDataControl.deleteAssetReferences(string);
    }

    @Override
    public int countIdentifierReferences(String string) {
        int n = 0;
        for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
            resourcesDataControl.countIdentifierReferences(string);
        }
        return n += this.actionsListDataControl.countIdentifierReferences(string);
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
            resourcesDataControl.replaceIdentifierReferences(string, string2);
        }
        this.actionsListDataControl.replaceIdentifierReferences(string, string2);
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
            resourcesDataControl.deleteIdentifierReferences(string);
        }
        this.actionsListDataControl.deleteIdentifierReferences(string);
    }

    public boolean buildResourcesTab() {
        return true;
    }

    @Override
    public boolean canBeDuplicated() {
        return true;
    }

    @Override
    public void recursiveSearch() {
        this.check(this.getBriefDescription(), TC.get((String)"Search.BriefDescription"));
        this.check(this.getDetailedDescription(), TC.get((String)"Search.DetailedDescription"));
        this.check(this.getDocumentation(), TC.get((String)"Search.Documentation"));
        this.check(this.getId(), "ID");
        this.check(this.getName(), TC.get((String)"Search.Name"));
        this.check(this.getVoice(), TC.get((String)"Search.NPCVoice"));
        this.check(this.getPreviewImage(), TC.get((String)"Search.PreviewImage"));
        this.getActionsList().recursiveSearch();
    }

    public String getAnimationPath(String string) {
        return ((ResourcesDataControl)this.resourcesDataControlList.get(this.selectedResources)).getAssetPath(string);
    }

    public Color getBubbleBorderColor() {
        return new Color(Integer.valueOf(this.npc.getBubbleBorderColor().substring(1), 16));
    }

    public Color getBubbleBkgColor() {
        return new Color(Integer.valueOf(this.npc.getBubbleBkgColor().substring(1), 16));
    }

    public Boolean getShowsSpeechBubbles() {
        return this.npc.getShowsSpeechBubbles();
    }

    public void setShowsSpeechBubbles(Boolean bl) {
        this.controller.addTool(new ChangeBooleanValueTool(this.npc, bl, "getShowsSpeechBubbles", "setShowsSpeechBubbles"));
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        List<Searchable> list = this.getPathFromChild(searchable, this.resourcesDataControlList);
        if (list != null) {
            return list;
        }
        return this.getPathFromChild(searchable, this.actionsListDataControl);
    }
}

