/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.book;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.chapter.book.Book;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.book.BookDataControl;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import es.eucm.eadventure.editor.gui.editdialogs.BookTypesDialog;
import java.util.ArrayList;
import java.util.List;

public class BooksListDataControl
extends DataControl {
    private List<Book> booksList;
    private List<BookDataControl> booksDataControlList;

    public BooksListDataControl(List<Book> list) {
        this.booksList = list;
        this.booksDataControlList = new ArrayList<BookDataControl>();
        for (Book book : list) {
            this.booksDataControlList.add(new BookDataControl(book));
        }
    }

    public List<BookDataControl> getBooks() {
        return this.booksDataControlList;
    }

    public BookDataControl getLastBook() {
        return this.booksDataControlList.get(this.booksDataControlList.size() - 1);
    }

    @Override
    public Object getContent() {
        return this.booksList;
    }

    @Override
    public int[] getAddableElements() {
        return new int[]{12};
    }

    @Override
    public boolean canAddElement(int n) {
        return n == 12;
    }

    @Override
    public boolean canBeDeleted() {
        return false;
    }

    @Override
    public boolean canBeMoved() {
        return false;
    }

    @Override
    public boolean canBeRenamed() {
        return false;
    }

    @Override
    public boolean addElement(int n, String string) {
        boolean bl = false;
        if (n == 12) {
            int n2 = -1;
            BookTypesDialog bookTypesDialog = new BookTypesDialog(0);
            n2 = bookTypesDialog.getOptionSelected();
            if (n2 != -1) {
                if (string == null) {
                    string = this.controller.showInputDialog(TC.get((String)"Operation.AddBookTitle"), TC.get((String)"Operation.AddBookMessage"), TC.get((String)"Operation.AddBookDefaultValue"));
                }
                if (string != null && this.controller.isElementIdValid(string)) {
                    Book book = new Book(string);
                    book.setType(n2);
                    Resources resources = new Resources();
                    resources.addAsset("background", "assets/special/DefaultBook.jpg");
                    resources.addAsset("arrowLeftNormal", "assets/special/DefaultLeftNormalArrow.png");
                    resources.addAsset("arrowLeftOver", "assets/special/DefaultLeftOverArrow.png");
                    book.addResources(resources);
                    BookDataControl bookDataControl = new BookDataControl(book);
                    this.booksList.add(book);
                    this.booksDataControlList.add(bookDataControl);
                    this.controller.getIdentifierSummary().addBookId(string);
                    bl = true;
                }
            }
        }
        return bl;
    }

    @Override
    public boolean duplicateElement(DataControl dataControl) {
        if (!(dataControl instanceof BookDataControl)) {
            return false;
        }
        try {
            Book book = (Book)((Book)dataControl.getContent()).clone();
            String string = book.getId();
            int n = 1;
            do {
                string = book.getId() + n;
                ++n;
            } while (!this.controller.isElementIdValid(string, false));
            book.setId(string);
            this.booksList.add(book);
            this.booksDataControlList.add(new BookDataControl(book));
            this.controller.getIdentifierSummary().addBookId(string);
            return true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ReportDialog.GenerateErrorReport((Exception)cloneNotSupportedException, (boolean)true, (String)"Could not clone book");
            return false;
        }
    }

    @Override
    public String getDefaultId(int n) {
        return TC.get((String)"Operation.AddBookDefaultValue");
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        boolean bl2 = false;
        String string = ((BookDataControl)dataControl).getId();
        String string2 = String.valueOf(this.controller.countIdentifierReferences(string));
        if ((!bl || this.controller.showStrictConfirmDialog(TC.get((String)"Operation.DeleteElementTitle"), TC.get((String)"Operation.DeleteElementWarning", (String[])new String[]{string, string2}))) && this.booksList.remove(dataControl.getContent())) {
            this.booksDataControlList.remove(dataControl);
            this.controller.deleteIdentifierReferences(string);
            this.controller.getIdentifierSummary().deleteBookId(string);
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        boolean bl = false;
        int n = this.booksList.indexOf(dataControl.getContent());
        if (n > 0) {
            this.booksList.add(n - 1, this.booksList.remove(n));
            this.booksDataControlList.add(n - 1, this.booksDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        boolean bl = false;
        int n = this.booksList.indexOf(dataControl.getContent());
        if (n < this.booksList.size() - 1) {
            this.booksList.add(n + 1, this.booksList.remove(n));
            this.booksDataControlList.add(n + 1, this.booksDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public String renameElement(String string) {
        return null;
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        boolean bl = true;
        string = string + " >> " + TC.getElement((int)11);
        for (BookDataControl bookDataControl : this.booksDataControlList) {
            String string2 = string + " >> " + bookDataControl.getId();
            bl &= bookDataControl.isValid(string2, list);
        }
        return bl;
    }

    @Override
    public int countAssetReferences(String string) {
        int n = 0;
        for (BookDataControl bookDataControl : this.booksDataControlList) {
            n += bookDataControl.countAssetReferences(string);
        }
        return n;
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
        for (BookDataControl bookDataControl : this.booksDataControlList) {
            bookDataControl.getAssetReferences(list, list2);
        }
    }

    @Override
    public void deleteAssetReferences(String string) {
        for (BookDataControl bookDataControl : this.booksDataControlList) {
            bookDataControl.deleteAssetReferences(string);
        }
    }

    @Override
    public int countIdentifierReferences(String string) {
        return 0;
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
    }

    @Override
    public void deleteIdentifierReferences(String string) {
    }

    @Override
    public boolean canBeDuplicated() {
        return false;
    }

    @Override
    public void recursiveSearch() {
        for (BookDataControl bookDataControl : this.booksDataControlList) {
            ((Searchable)bookDataControl).recursiveSearch();
        }
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return this.getPathFromChild(searchable, this.booksDataControlList);
    }
}

