/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.book;

import es.eucm.eadventure.common.data.chapter.book.BookParagraph;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.book.BookParagraphDataControl;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.util.ArrayList;
import java.util.List;

public class BookParagraphsListDataControl
extends DataControl {
    private List<BookParagraph> bookParagraphsList;
    private List<BookParagraphDataControl> bookParagraphsDataControlList;

    public BookParagraphsListDataControl(List<BookParagraph> list) {
        this.bookParagraphsList = list;
        this.bookParagraphsDataControlList = new ArrayList<BookParagraphDataControl>();
        for (BookParagraph bookParagraph : list) {
            this.bookParagraphsDataControlList.add(new BookParagraphDataControl(bookParagraph));
        }
    }

    public List<BookParagraphDataControl> getBookParagraphs() {
        return this.bookParagraphsDataControlList;
    }

    public BookParagraphDataControl getLastBookParagraph() {
        return this.bookParagraphsDataControlList.get(this.bookParagraphsDataControlList.size() - 1);
    }

    public String[][] getBookParagraphsInfo() {
        String[][] stringArray = null;
        stringArray = new String[this.bookParagraphsList.size()][3];
        for (int i = 0; i < this.bookParagraphsList.size(); ++i) {
            BookParagraph bookParagraph = this.bookParagraphsList.get(i);
            if (bookParagraph.getType() == 2) {
                stringArray[i][0] = TC.get((String)"BookParagraphsList.TextParagraph", (String)String.valueOf(i + 1));
            } else if (bookParagraph.getType() == 3) {
                stringArray[i][0] = TC.get((String)"BookParagraphsList.TitleParagraph", (String)String.valueOf(i + 1));
            } else if (bookParagraph.getType() == 0) {
                stringArray[i][0] = TC.get((String)"BookParagraphsList.BulletParagraph", (String)String.valueOf(i + 1));
            } else if (bookParagraph.getType() == 1) {
                stringArray[i][0] = TC.get((String)"BookParagraphsList.ImageParagraph", (String)String.valueOf(i + 1));
            }
            stringArray[i][1] = bookParagraph.getType() != 1 ? TC.get((String)"BookParagraphsList.WordCount", (String)String.valueOf(bookParagraph.getContent().split(" ").length)) : TC.get((String)"BookParagraphsList.NotApplicable");
        }
        return stringArray;
    }

    @Override
    public Object getContent() {
        return this.bookParagraphsList;
    }

    @Override
    public int[] getAddableElements() {
        return new int[]{14, 15, 16, 17};
    }

    @Override
    public boolean canAddElement(int n) {
        return n == 14 || n == 15 || n == 16 || n == 17;
    }

    @Override
    public boolean canBeDeleted() {
        return false;
    }

    @Override
    public boolean canBeMoved() {
        return false;
    }

    @Override
    public boolean canBeRenamed() {
        return false;
    }

    @Override
    public boolean addElement(int n, String string) {
        BookParagraph bookParagraph = null;
        if (n == 14) {
            bookParagraph = new BookParagraph(3);
        } else if (n == 15) {
            bookParagraph = new BookParagraph(2);
        } else if (n == 16) {
            bookParagraph = new BookParagraph(0);
        } else if (n == 17) {
            bookParagraph = new BookParagraph(1);
        }
        if (bookParagraph != null) {
            this.bookParagraphsList.add(bookParagraph);
            this.bookParagraphsDataControlList.add(new BookParagraphDataControl(bookParagraph));
        }
        return bookParagraph != null;
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        boolean bl2 = false;
        if (this.bookParagraphsList.remove(dataControl.getContent())) {
            this.bookParagraphsDataControlList.remove(dataControl);
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        boolean bl = false;
        int n = this.bookParagraphsList.indexOf(dataControl.getContent());
        if (n > 0) {
            this.bookParagraphsList.add(n - 1, this.bookParagraphsList.remove(n));
            this.bookParagraphsDataControlList.add(n - 1, this.bookParagraphsDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        boolean bl = false;
        int n = this.bookParagraphsList.indexOf(dataControl.getContent());
        if (n < this.bookParagraphsList.size() - 1) {
            this.bookParagraphsList.add(n + 1, this.bookParagraphsList.remove(n));
            this.bookParagraphsDataControlList.add(n + 1, this.bookParagraphsDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public String renameElement(String string) {
        return null;
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        boolean bl = true;
        for (int i = 0; i < this.bookParagraphsDataControlList.size(); ++i) {
            String string2 = string + " >> " + TC.get((String)"Element.BookParagraph") + " #" + (i + 1) + " (" + TC.getElement((int)this.bookParagraphsDataControlList.get(i).getType()) + ")";
            bl &= this.bookParagraphsDataControlList.get(i).isValid(string2, list);
        }
        return bl;
    }

    @Override
    public int countAssetReferences(String string) {
        int n = 0;
        for (BookParagraphDataControl bookParagraphDataControl : this.bookParagraphsDataControlList) {
            n += bookParagraphDataControl.countAssetReferences(string);
        }
        return n;
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
        for (BookParagraphDataControl bookParagraphDataControl : this.bookParagraphsDataControlList) {
            bookParagraphDataControl.getAssetReferences(list, list2);
        }
    }

    @Override
    public void deleteAssetReferences(String string) {
        for (BookParagraphDataControl bookParagraphDataControl : this.bookParagraphsDataControlList) {
            bookParagraphDataControl.deleteAssetReferences(string);
        }
    }

    @Override
    public int countIdentifierReferences(String string) {
        return 0;
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
    }

    @Override
    public void deleteIdentifierReferences(String string) {
    }

    @Override
    public boolean canBeDuplicated() {
        return false;
    }

    @Override
    public void recursiveSearch() {
        for (BookParagraphDataControl bookParagraphDataControl : this.bookParagraphsDataControlList) {
            ((Searchable)bookParagraphDataControl).recursiveSearch();
        }
    }

    public List<BookParagraph> getBookParagraphsList() {
        return this.bookParagraphsList;
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return this.getPathFromChild(searchable, this.bookParagraphsDataControlList);
    }
}

