/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.book;

import es.eucm.eadventure.common.data.chapter.book.BookParagraph;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.tools.books.ChangeParagraphContentTool;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import es.eucm.eadventure.editor.gui.assetchooser.AssetChooser;
import java.util.List;

public class BookParagraphDataControl
extends DataControl {
    private BookParagraph bookParagraph;
    private int bookParagraphType;

    public BookParagraphDataControl(BookParagraph bookParagraph) {
        this.bookParagraph = bookParagraph;
        switch (bookParagraph.getType()) {
            case 3: {
                this.bookParagraphType = 14;
                break;
            }
            case 2: {
                this.bookParagraphType = 15;
                break;
            }
            case 1: {
                this.bookParagraphType = 17;
                break;
            }
            case 0: {
                this.bookParagraphType = 16;
            }
        }
    }

    public int getType() {
        return this.bookParagraphType;
    }

    public String getParagraphContent() {
        return this.bookParagraph.getContent();
    }

    public void setParagraphTextContent(String string) {
        Controller.getInstance().addTool(new ChangeParagraphContentTool(this.bookParagraph, string));
    }

    public void editImagePath() {
        boolean bl;
        String string = null;
        AssetChooser assetChooser = AssetsController.getAssetChooser(2, 0);
        int n = assetChooser.showAssetChooser(this.controller.peekWindow());
        if (n == 4) {
            string = assetChooser.getSelectedAsset();
        } else if (n == 5 && (bl = AssetsController.addSingleAsset(2, assetChooser.getSelectedFile().getAbsolutePath()))) {
            string = assetChooser.getSelectedFile().getName();
        }
        if (string != null) {
            String[] stringArray = AssetsController.getAssetFilenames(2);
            String[] stringArray2 = AssetsController.getAssetsList(2);
            int n2 = -1;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                n2 = i;
            }
            Controller.getInstance().addTool(new ChangeParagraphContentTool(this.bookParagraph, stringArray2[n2]));
        }
    }

    public void setImageParagraphContent() {
        Object[] objectArray = AssetsController.getAssetFilenames(2);
        String[] stringArray = AssetsController.getAssetsList(2);
        if (objectArray.length == 0) {
            this.controller.showErrorDialog(TC.get((String)"Resources.EditAsset"), TC.get((String)"Resources.ErrorNoAssets"));
        } else {
            String string = this.controller.showInputDialog(TC.get((String)"Resources.EditAsset"), TC.get((String)"Resources.EditAssetMessage"), objectArray);
            if (string != null) {
                int n = -1;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!((String)objectArray[i]).equals(string)) continue;
                    n = i;
                }
                Controller.getInstance().addTool(new ChangeParagraphContentTool(this.bookParagraph, stringArray[n]));
            }
        }
    }

    public void deleteImageParagraphContent() {
        Controller.getInstance().addTool(new ChangeParagraphContentTool(this.bookParagraph, ""));
    }

    @Override
    public Object getContent() {
        return this.bookParagraph;
    }

    @Override
    public int[] getAddableElements() {
        return new int[0];
    }

    @Override
    public boolean canAddElement(int n) {
        return false;
    }

    @Override
    public boolean canBeDeleted() {
        return true;
    }

    @Override
    public boolean canBeMoved() {
        return true;
    }

    @Override
    public boolean canBeRenamed() {
        return false;
    }

    @Override
    public boolean addElement(int n, String string) {
        return false;
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        return false;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        return false;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        return false;
    }

    @Override
    public String renameElement(String string) {
        return null;
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        boolean bl = true;
        if (this.bookParagraph.getType() == 1 && this.bookParagraph.getContent().length() == 0) {
            bl = false;
            if (list != null) {
                list.add(string + " >> " + TC.get((String)"Operation.AdventureConsistencyErrorBookParagraph"));
            }
        }
        return bl;
    }

    @Override
    public int countAssetReferences(String string) {
        return this.bookParagraph.getType() == 1 && this.bookParagraph.getContent().equals(string) ? 1 : 0;
    }

    @Override
    public void deleteAssetReferences(String string) {
        if (this.bookParagraph.getType() == 1 && this.bookParagraph.getContent().equals(string)) {
            this.bookParagraph.setContent("");
        }
    }

    @Override
    public int countIdentifierReferences(String string) {
        return 0;
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
    }

    @Override
    public void deleteIdentifierReferences(String string) {
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
        if (this.bookParagraph.getType() == 1) {
            String string = this.bookParagraph.getContent();
            boolean bl = true;
            for (String string2 : list) {
                if (!string2.equals(string)) continue;
                bl = false;
                break;
            }
            if (bl) {
                int n = list.size();
                list.add(n, string);
                list2.add(n, 2);
            }
        }
    }

    @Override
    public boolean canBeDuplicated() {
        return true;
    }

    @Override
    public void recursiveSearch() {
        this.check(this.getParagraphContent(), TC.get((String)"Search.ParagraphContent"));
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return null;
    }
}

