/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.book;

import es.eucm.eadventure.common.auxiliar.File;
import es.eucm.eadventure.common.data.chapter.book.BookPage;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.book.BookDataControl;
import es.eucm.eadventure.editor.control.tools.books.AddBookPageTool;
import es.eucm.eadventure.editor.control.tools.books.ChangeBookPageMarginsTool;
import es.eucm.eadventure.editor.control.tools.books.ChangeBookPageScrollableTool;
import es.eucm.eadventure.editor.control.tools.books.ChangeBookPageTypeTool;
import es.eucm.eadventure.editor.control.tools.books.ChangeBookPageUriTool;
import es.eucm.eadventure.editor.control.tools.books.DeleteBookPageTool;
import es.eucm.eadventure.editor.control.tools.books.MoveBookPageDownTool;
import es.eucm.eadventure.editor.control.tools.books.MoveBookPageUpTool;
import es.eucm.eadventure.editor.gui.assetchooser.AssetChooser;
import es.eucm.eadventure.editor.gui.otherpanels.bookpanels.BookPagePreviewPanel;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;

public class BookPagesListDataControl
extends Searchable {
    private List<BookPage> bookPagesList;
    private int selectedPage;
    private boolean defaultScrollable;
    private int defaultMargin;
    private int defaultType;
    private BookDataControl dControl;

    public BookPagesListDataControl(List<BookPage> list, BookDataControl bookDataControl) {
        this.bookPagesList = list;
        this.dControl = bookDataControl;
        this.selectedPage = -1;
        this.defaultType = 1;
        this.defaultMargin = 0;
        this.defaultScrollable = false;
    }

    public List<BookPage> getBookPages() {
        return this.bookPagesList;
    }

    public BookPage addPage() {
        BookPage bookPage = new BookPage("", this.defaultType, this.defaultMargin, this.defaultScrollable);
        Controller.getInstance().addTool(new AddBookPageTool(this.bookPagesList, bookPage, this.selectedPage));
        this.selectedPage = this.bookPagesList.indexOf(bookPage);
        return bookPage;
    }

    public boolean deletePage(BookPage bookPage) {
        Controller.getInstance().addTool(new DeleteBookPageTool(this.bookPagesList, bookPage));
        return true;
    }

    public boolean movePageUp(BookPage bookPage) {
        Controller.getInstance().addTool(new MoveBookPageUpTool(this.bookPagesList, bookPage));
        return true;
    }

    public boolean movePageDown(BookPage bookPage) {
        Controller.getInstance().addTool(new MoveBookPageDownTool(this.bookPagesList, bookPage));
        return true;
    }

    public int countAssetReferences(String string) {
        int n = 0;
        for (BookPage bookPage : this.bookPagesList) {
            if (!bookPage.getUri().equals(string) || bookPage.getType() != 1 && bookPage.getType() != 2) continue;
            ++n;
        }
        return n;
    }

    public void getAssetReferences(List<String> list, List<Integer> list2) {
        for (BookPage bookPage : this.bookPagesList) {
            String string = bookPage.getUri();
            if (string == null || string.equals("") || bookPage.getType() != 1 && bookPage.getType() != 2) continue;
            boolean bl = true;
            for (String string2 : list) {
                if (!string2.equals(string)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            int n = list.size();
            list.add(n, string);
            if (bookPage.getType() == 1) {
                list2.add(n, 7);
                continue;
            }
            if (bookPage.getType() != 2) continue;
            list2.add(n, 2);
        }
    }

    public void deleteAssetReferences(String string) {
        ArrayList<BookPage> arrayList = new ArrayList<BookPage>();
        for (BookPage bookPage : this.bookPagesList) {
            if (!bookPage.getUri().equals(string) || bookPage.getType() != 1 && bookPage.getType() != 2) continue;
            arrayList.add(bookPage);
        }
        for (BookPage bookPage : arrayList) {
            this.bookPagesList.remove(bookPage);
        }
    }

    public BookPage changeCurrentPage(int n) {
        BookPage bookPage = null;
        if (n >= 0 && n < this.bookPagesList.size()) {
            bookPage = this.bookPagesList.get(n);
            this.selectedPage = n;
        }
        return bookPage;
    }

    public boolean editStyledTextAssetPath() {
        Object object;
        String string = null;
        if (this.selectedPage < 0 || this.selectedPage >= this.bookPagesList.size()) {
            return false;
        }
        AssetChooser assetChooser = AssetsController.getAssetChooser(7, 0);
        int n = assetChooser.showAssetChooser(Controller.getInstance().peekWindow());
        if (n == 4) {
            string = assetChooser.getSelectedAsset();
        } else if (n == 5) {
            boolean bl = AssetsController.addSingleAsset(7, assetChooser.getSelectedFile().getAbsolutePath());
            object = assetChooser.getSelectedFile().getAbsolutePath();
            String string2 = ((String)object).substring(0, ((String)object).lastIndexOf(".")) + "_files";
            File file = new File(string2);
            if (file.exists() && file.isDirectory()) {
                bl &= AssetsController.addSingleAsset(7, string2);
            }
            if (bl) {
                string = assetChooser.getSelectedFile().getName();
            }
        }
        if (string != null) {
            String[] stringArray = AssetsController.getAssetFilenames(7);
            object = AssetsController.getAssetsList(7);
            int n2 = -1;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                n2 = i;
            }
            Controller.getInstance().addTool(new ChangeBookPageUriTool(this.bookPagesList.get(this.selectedPage), (String)object[n2]));
            return true;
        }
        return false;
    }

    public boolean editImageAssetPath() {
        Object object;
        String string = null;
        if (this.selectedPage < 0 || this.selectedPage >= this.bookPagesList.size()) {
            return false;
        }
        AssetChooser assetChooser = AssetsController.getAssetChooser(2, 0);
        int n = assetChooser.showAssetChooser(Controller.getInstance().peekWindow());
        if (n == 4) {
            string = assetChooser.getSelectedAsset();
        } else if (n == 5) {
            boolean bl = AssetsController.addSingleAsset(2, assetChooser.getSelectedFile().getAbsolutePath());
            object = assetChooser.getSelectedFile().getAbsolutePath();
            String string2 = ((String)object).substring(0, ((String)object).lastIndexOf(".")) + "_files";
            File file = new File(string2);
            if (file.exists() && file.isDirectory()) {
                bl &= AssetsController.addSingleAsset(2, string2);
            }
            if (bl) {
                string = assetChooser.getSelectedFile().getName();
            }
        }
        if (string != null) {
            String[] stringArray = AssetsController.getAssetFilenames(2);
            object = AssetsController.getAssetsList(2);
            int n2 = -1;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                n2 = i;
            }
            Controller.getInstance().addTool(new ChangeBookPageUriTool(this.bookPagesList.get(this.selectedPage), (String)object[n2]));
            return true;
        }
        return false;
    }

    public boolean editURL(String string) {
        if (this.selectedPage >= 0 && this.selectedPage < this.bookPagesList.size() && this.bookPagesList.get(this.selectedPage).getType() == 0) {
            Controller.getInstance().addTool(new ChangeBookPageUriTool(this.bookPagesList.get(this.selectedPage), string));
            return true;
        }
        return false;
    }

    public boolean setType(int n) {
        boolean bl = false;
        if (this.selectedPage >= 0 && this.selectedPage < this.bookPagesList.size() && n != this.bookPagesList.get(this.selectedPage).getType()) {
            Controller.getInstance().addTool(new ChangeBookPageTypeTool(this.bookPagesList.get(this.selectedPage), n));
            bl = true;
        }
        return bl;
    }

    public void setMargins(int n, int n2, int n3, int n4) {
        if (this.selectedPage >= 0 && this.selectedPage < this.bookPagesList.size()) {
            Controller.getInstance().addTool(new ChangeBookPageMarginsTool(this.bookPagesList.get(this.selectedPage), n, n2, n3, n4));
        }
    }

    public void setScrollable(boolean bl) {
        if (this.selectedPage >= 0 && this.selectedPage < this.bookPagesList.size()) {
            Controller.getInstance().addTool(new ChangeBookPageScrollableTool(this.bookPagesList.get(this.selectedPage), bl));
        }
    }

    public boolean isValidPage(BookPage bookPage) {
        boolean bl = false;
        try {
            if (bookPage.getType() == 1) {
                BookPagePreviewPanel bookPagePreviewPanel = new BookPagePreviewPanel(this.dControl, true);
                bookPagePreviewPanel.setCurrentBookPage(bookPage);
                bl = !bookPage.getUri().equals("") && bookPagePreviewPanel.isValid();
            } else if (bookPage.getType() == 0) {
                URL uRL = new URL(bookPage.getUri());
                uRL.openStream().close();
                bl = true;
            } else if (bookPage.getType() == 2 && bookPage.getUri().length() > 0) {
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public boolean isValidPage(int n) {
        return this.isValidPage(this.bookPagesList.get(n));
    }

    public boolean isValid(String string, List<String> list) {
        boolean bl = true;
        for (int i = 0; i < this.bookPagesList.size(); ++i) {
            String string2 = string + " >> " + TC.get((String)"Element.BookPage") + " #" + (i + 1);
            boolean bl2 = true;
            if (this.bookPagesList.get(i).getType() == 1 && this.bookPagesList.get(i).getUri().length() == 0) {
                bl2 = false;
                if (list != null) {
                    list.add(string2 + " >> " + TC.get((String)"Operation.AdventureConsistencyErrorBookPage"));
                }
            }
            bl &= bl2;
        }
        return bl;
    }

    public BookPage getSelectedPage() {
        if (this.selectedPage >= 0 && this.selectedPage < this.bookPagesList.size()) {
            return this.bookPagesList.get(this.selectedPage);
        }
        return null;
    }

    public int getIndexSelectedPage() {
        return this.selectedPage;
    }

    public BookPage getLastPage() {
        return this.bookPagesList.get(this.bookPagesList.size() - 1);
    }

    @Override
    public void recursiveSearch() {
        for (int i = 0; i < this.bookPagesList.size(); ++i) {
            if (this.bookPagesList.get(i).getType() == 0) continue;
            JEditorPane jEditorPane = new JEditorPane();
            try {
                jEditorPane.setPage(AssetsController.getResourceAsURLFromZip(this.bookPagesList.get(i).getUri()));
                this.check(jEditorPane.getDocument().getText(0, jEditorPane.getDocument().getLength()), TC.get((String)"Search.HTMLBookPage"));
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                continue;
            }
            catch (IOException iOException) {
                continue;
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    @Override
    protected List<Searchable> getPath(Searchable searchable) {
        if (searchable == this) {
            ArrayList<Searchable> arrayList = new ArrayList<Searchable>();
            arrayList.add(this);
            return arrayList;
        }
        return null;
    }
}

