/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.book;

import es.eucm.eadventure.common.data.Documented;
import es.eucm.eadventure.common.data.chapter.book.Book;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.DataControlWithResources;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.book.BookPagesListDataControl;
import es.eucm.eadventure.editor.control.controllers.book.BookParagraphsListDataControl;
import es.eucm.eadventure.editor.control.controllers.general.ResourcesDataControl;
import es.eucm.eadventure.editor.control.tools.general.assets.AddResourcesBlockTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeDocumentationTool;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

public class BookDataControl
extends DataControlWithResources {
    private Book book;
    private BookParagraphsListDataControl bookParagraphsListDataControl;
    private BookPagesListDataControl bookPagesListDataControl;
    public static final int ARROW_LEFT = 0;
    public static final int ARROW_RIGHT = 1;
    public static final int ARROW_NORMAL = 0;
    public static final int ARROW_OVER = 1;

    public BookDataControl(Book book) {
        this.book = book;
        this.resourcesList = book.getResources();
        this.selectedResources = 0;
        if (this.resourcesList.size() == 0) {
            this.resourcesList.add(new Resources());
        }
        this.resourcesDataControlList = new ArrayList();
        for (Resources resources : this.resourcesList) {
            this.resourcesDataControlList.add(new ResourcesDataControl(resources, 12));
        }
        if (book.getType() == 0) {
            this.bookParagraphsListDataControl = new BookParagraphsListDataControl(book.getParagraphs());
        } else if (book.getType() == 1) {
            this.bookPagesListDataControl = new BookPagesListDataControl(book.getPageURLs(), this);
        }
    }

    public BookParagraphsListDataControl getBookParagraphsList() {
        return this.bookParagraphsListDataControl;
    }

    public BookPagesListDataControl getBookPagesList() {
        return this.bookPagesListDataControl;
    }

    public String getId() {
        return this.book.getId();
    }

    public String getDocumentation() {
        return this.book.getDocumentation();
    }

    public String getPreviewImage() {
        return ((ResourcesDataControl)this.resourcesDataControlList.get(this.selectedResources)).getAssetPath("background");
    }

    public String getArrowImagePath(int n, int n2) {
        String string = "";
        switch (n) {
            case 0: {
                string = string + "arrowLeft";
                break;
            }
            case 1: {
                string = string + "arrowRight";
            }
        }
        switch (n2) {
            case 0: {
                string = string + "Normal";
                break;
            }
            case 1: {
                string = string + "Over";
            }
        }
        return ((ResourcesDataControl)this.resourcesDataControlList.get(this.selectedResources)).getAssetPath(string);
    }

    public void setDocumentation(String string) {
        this.controller.addTool(new ChangeDocumentationTool((Documented)this.book, string));
    }

    @Override
    public Object getContent() {
        return this.book;
    }

    @Override
    public int[] getAddableElements() {
        return new int[0];
    }

    @Override
    public boolean canAddElement(int n) {
        return false;
    }

    @Override
    public boolean canBeDeleted() {
        return true;
    }

    @Override
    public boolean canBeMoved() {
        return true;
    }

    @Override
    public boolean canBeRenamed() {
        return true;
    }

    @Override
    public boolean addElement(int n, String string) {
        boolean bl = false;
        if (n == 34) {
            bl = Controller.getInstance().addTool(new AddResourcesBlockTool(this.resourcesList, this.resourcesDataControlList, 12, this));
        }
        return bl;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        boolean bl = false;
        int n = this.resourcesList.indexOf(dataControl.getContent());
        if (n > 0) {
            this.resourcesList.add(n - 1, this.resourcesList.remove(n));
            this.resourcesDataControlList.add(n - 1, this.resourcesDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        boolean bl = false;
        int n = this.resourcesList.indexOf(dataControl.getContent());
        if (n < this.resourcesList.size() - 1) {
            this.resourcesList.add(n + 1, this.resourcesList.remove(n));
            this.resourcesDataControlList.add(n + 1, this.resourcesDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public String renameElement(String string) {
        boolean bl = false;
        String string2 = this.book.getId();
        String string3 = String.valueOf(this.controller.countIdentifierReferences(string2));
        if (string != null || this.controller.showStrictConfirmDialog(TC.get((String)"Operation.RenameBookTitle"), TC.get((String)"Operation.RenameElementWarning", (String[])new String[]{string2, string3}))) {
            String string4 = string;
            if (string == null) {
                string4 = this.controller.showInputDialog(TC.get((String)"Operation.RenameBookTitle"), TC.get((String)"Operation.RenameBookMessage"), string2);
            }
            if (string4 != null && !string4.equals(string2) && this.controller.isElementIdValid(string4)) {
                this.book.setId(string4);
                this.controller.replaceIdentifierReferences(string2, string4);
                this.controller.getIdentifierSummary().deleteBookId(string2);
                this.controller.getIdentifierSummary().addBookId(string4);
                bl = true;
            }
        }
        if (bl) {
            return string2;
        }
        return null;
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        boolean bl = true;
        for (int i = 0; i < this.resourcesDataControlList.size(); ++i) {
            String string2 = string + " >> " + TC.getElement((int)34) + " #" + (i + 1);
            bl &= ((ResourcesDataControl)this.resourcesDataControlList.get(i)).isValid(string2, list);
        }
        if (this.book.getType() == 0) {
            bl &= this.bookParagraphsListDataControl.isValid(string, list);
        } else if (this.book.getType() == 1) {
            bl &= this.bookPagesListDataControl.isValid(string, list);
        }
        return bl;
    }

    @Override
    public int countAssetReferences(String string) {
        int n = 0;
        for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
            n += resourcesDataControl.countAssetReferences(string);
        }
        if (this.book.getType() == 0) {
            n += this.bookParagraphsListDataControl.countAssetReferences(string);
        } else if (this.book.getType() == 1) {
            n += this.bookPagesListDataControl.countAssetReferences(string);
        }
        return n;
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
        for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
            resourcesDataControl.getAssetReferences(list, list2);
        }
        if (this.book.getType() == 0) {
            this.bookParagraphsListDataControl.getAssetReferences(list, list2);
        } else if (this.book.getType() == 1) {
            this.bookPagesListDataControl.getAssetReferences(list, list2);
        }
    }

    @Override
    public void deleteAssetReferences(String string) {
        for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
            resourcesDataControl.deleteAssetReferences(string);
        }
        if (this.book.getType() == 0) {
            this.bookParagraphsListDataControl.deleteAssetReferences(string);
        } else if (this.book.getType() == 1) {
            this.bookPagesListDataControl.deleteAssetReferences(string);
        }
    }

    @Override
    public int countIdentifierReferences(String string) {
        return 0;
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
    }

    @Override
    public void deleteIdentifierReferences(String string) {
    }

    public int getType() {
        return this.book.getType();
    }

    @Override
    public boolean canBeDuplicated() {
        return true;
    }

    @Override
    public void recursiveSearch() {
        this.check(this.getDocumentation(), TC.get((String)"Search.Documentation"));
        this.check(this.getId(), "ID");
        if (this.getBookParagraphsList() != null) {
            this.getBookParagraphsList().recursiveSearch();
        }
        if (this.getBookPagesList() != null) {
            this.getBookPagesList().recursiveSearch();
        }
        this.check(this.getPreviewImage(), TC.get((String)"Search.PreviewImage"));
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        List<Searchable> list = this.getPathFromChild(searchable, this.resourcesDataControlList);
        if (list != null) {
            return list;
        }
        list = this.getPathFromChild(searchable, this.bookParagraphsListDataControl);
        if (list != null) {
            return list;
        }
        return this.getPathFromSearchableChild(searchable, this.bookPagesListDataControl);
    }

    public Point getNextPagePosition() {
        return this.book.getNextPagePoint();
    }

    public Point getPreviousPagePosition() {
        return this.book.getPreviousPagePoint();
    }

    public void setNextPagePosition(Point point) {
        this.book.setNextPagePoint(point);
    }

    public void setPreviousPagePosition(Point point) {
        this.book.setPreviousPagePoint(point);
    }
}

