/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.atrezzo;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.chapter.elements.Atrezzo;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.atrezzo.AtrezzoDataControl;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.util.ArrayList;
import java.util.List;

public class AtrezzoListDataControl
extends DataControl {
    private List<Atrezzo> atrezzoList;
    private List<AtrezzoDataControl> atrezzoDataControlList;

    public AtrezzoListDataControl(List<Atrezzo> list) {
        this.atrezzoList = list;
        this.atrezzoDataControlList = new ArrayList<AtrezzoDataControl>();
        for (Atrezzo atrezzo : list) {
            this.atrezzoDataControlList.add(new AtrezzoDataControl(atrezzo));
        }
    }

    public List<AtrezzoDataControl> getAtrezzoList() {
        return this.atrezzoDataControlList;
    }

    public AtrezzoDataControl getLastAtrezzo() {
        return this.atrezzoDataControlList.get(this.atrezzoDataControlList.size() - 1);
    }

    public String[][] getItemsInfo() {
        String[][] stringArray = null;
        stringArray = new String[this.atrezzoList.size()][1];
        for (int i = 0; i < this.atrezzoList.size(); ++i) {
            stringArray[i][0] = this.atrezzoList.get(i).getId();
        }
        return stringArray;
    }

    @Override
    public boolean addElement(int n, String string) {
        boolean bl = false;
        if (n == 58) {
            if (string == null) {
                string = this.controller.showInputDialog(TC.get((String)"Operation.AddAtrezzoTitle"), TC.get((String)"Operation.AddAtrezzoMessage"), TC.get((String)"Operation.AddAtrezzoDefaultValue"));
            }
            if (string != null && this.controller.isElementIdValid(string)) {
                Atrezzo atrezzo = new Atrezzo(string);
                this.atrezzoList.add(atrezzo);
                this.atrezzoDataControlList.add(new AtrezzoDataControl(atrezzo));
                this.controller.getIdentifierSummary().addAtrezzoId(string);
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean duplicateElement(DataControl dataControl) {
        if (!(dataControl instanceof AtrezzoDataControl)) {
            return false;
        }
        try {
            Atrezzo atrezzo = (Atrezzo)((Atrezzo)dataControl.getContent()).clone();
            String string = atrezzo.getId();
            int n = 1;
            do {
                string = atrezzo.getId() + n;
                ++n;
            } while (!this.controller.isElementIdValid(string, false));
            atrezzo.setId(string);
            this.atrezzoList.add(atrezzo);
            this.atrezzoDataControlList.add(new AtrezzoDataControl(atrezzo));
            this.controller.getIdentifierSummary().addAtrezzoId(string);
            return true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ReportDialog.GenerateErrorReport((Exception)cloneNotSupportedException, (boolean)true, (String)"Could not clone atrezzo");
            return false;
        }
    }

    @Override
    public String getDefaultId(int n) {
        return TC.get((String)"Operation.AddAtrezzoDefaultValue");
    }

    @Override
    public boolean canAddElement(int n) {
        return n == 58;
    }

    @Override
    public boolean canBeDeleted() {
        return false;
    }

    @Override
    public boolean canBeDuplicated() {
        return false;
    }

    @Override
    public boolean canBeMoved() {
        return false;
    }

    @Override
    public boolean canBeRenamed() {
        return false;
    }

    @Override
    public int countAssetReferences(String string) {
        int n = 0;
        for (AtrezzoDataControl atrezzoDataControl : this.atrezzoDataControlList) {
            n += atrezzoDataControl.countAssetReferences(string);
        }
        return n;
    }

    @Override
    public int countIdentifierReferences(String string) {
        int n = 0;
        for (AtrezzoDataControl atrezzoDataControl : this.atrezzoDataControlList) {
            n += atrezzoDataControl.countIdentifierReferences(string);
        }
        return n;
    }

    @Override
    public void deleteAssetReferences(String string) {
        for (AtrezzoDataControl atrezzoDataControl : this.atrezzoDataControlList) {
            atrezzoDataControl.deleteIdentifierReferences(string);
        }
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        boolean bl2 = false;
        String string = ((AtrezzoDataControl)dataControl).getId();
        String string2 = String.valueOf(this.controller.countIdentifierReferences(string));
        if ((!bl || this.controller.showStrictConfirmDialog(TC.get((String)"Operation.DeleteElementTitle"), TC.get((String)"Operation.DeleteElementWarning", (String[])new String[]{string, string2}))) && this.atrezzoList.remove(dataControl.getContent())) {
            this.atrezzoDataControlList.remove(dataControl);
            this.controller.deleteIdentifierReferences(string);
            this.controller.getIdentifierSummary().deleteItemId(string);
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public void deleteIdentifierReferences(String string) {
    }

    @Override
    public int[] getAddableElements() {
        return new int[]{58};
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
        for (AtrezzoDataControl atrezzoDataControl : this.atrezzoDataControlList) {
            atrezzoDataControl.getAssetReferences(list, list2);
        }
    }

    @Override
    public Object getContent() {
        return this.atrezzoList;
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        boolean bl = true;
        string = string + " >> " + TC.getElement((int)59);
        for (AtrezzoDataControl atrezzoDataControl : this.atrezzoDataControlList) {
            String string2 = string + " >> " + atrezzoDataControl.getId();
            bl &= atrezzoDataControl.isValid(string2, list);
        }
        return bl;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        boolean bl = false;
        int n = this.atrezzoList.indexOf(dataControl.getContent());
        if (n < this.atrezzoList.size() - 1) {
            this.atrezzoList.add(n + 1, this.atrezzoList.remove(n));
            this.atrezzoDataControlList.add(n + 1, this.atrezzoDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        boolean bl = false;
        int n = this.atrezzoList.indexOf(dataControl.getContent());
        if (n > 0) {
            this.atrezzoList.add(n - 1, this.atrezzoList.remove(n));
            this.atrezzoDataControlList.add(n - 1, this.atrezzoDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public String renameElement(String string) {
        return null;
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        for (AtrezzoDataControl atrezzoDataControl : this.atrezzoDataControlList) {
            atrezzoDataControl.replaceIdentifierReferences(string, string2);
        }
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        for (AtrezzoDataControl atrezzoDataControl : this.atrezzoDataControlList) {
            atrezzoDataControl.updateVarFlagSummary(varFlagSummary);
        }
    }

    @Override
    public void recursiveSearch() {
        for (AtrezzoDataControl atrezzoDataControl : this.atrezzoDataControlList) {
            ((Searchable)atrezzoDataControl).recursiveSearch();
        }
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return this.getPathFromChild(searchable, this.atrezzoDataControlList);
    }
}

