/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.atrezzo;

import es.eucm.eadventure.common.data.Described;
import es.eucm.eadventure.common.data.Detailed;
import es.eucm.eadventure.common.data.Documented;
import es.eucm.eadventure.common.data.Named;
import es.eucm.eadventure.common.data.chapter.elements.Atrezzo;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.DataControlWithResources;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.general.ResourcesDataControl;
import es.eucm.eadventure.editor.control.tools.general.assets.AddResourcesBlockTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeDescriptionTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeDetailedDescriptionTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeDocumentationTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeNameTool;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.util.ArrayList;
import java.util.List;

public class AtrezzoDataControl
extends DataControlWithResources {
    private Atrezzo atrezzo;

    public AtrezzoDataControl(Atrezzo atrezzo) {
        this.atrezzo = atrezzo;
        this.resourcesList = atrezzo.getResources();
        this.selectedResources = 0;
        if (this.resourcesList.size() == 0) {
            this.resourcesList.add(new Resources());
        }
        this.resourcesDataControlList = new ArrayList();
        for (Resources resources : this.resourcesList) {
            this.resourcesDataControlList.add(new ResourcesDataControl(resources, 58));
        }
    }

    public String getPreviewImage() {
        return ((ResourcesDataControl)this.resourcesDataControlList.get(this.selectedResources)).getAssetPath("image");
    }

    public String getId() {
        return this.atrezzo.getId();
    }

    public String getDocumentation() {
        return this.atrezzo.getDocumentation();
    }

    public String getName() {
        return this.atrezzo.getName();
    }

    public String getBriefDescription() {
        return this.atrezzo.getDescription();
    }

    public String getDetailedDescription() {
        return this.atrezzo.getDetailedDescription();
    }

    public void setDocumentation(String string) {
        this.controller.addTool(new ChangeDocumentationTool((Documented)this.atrezzo, string));
    }

    public void setName(String string) {
        this.controller.addTool(new ChangeNameTool((Named)this.atrezzo, string));
    }

    public void setBriefDescription(String string) {
        this.controller.addTool(new ChangeDescriptionTool((Described)this.atrezzo, string));
    }

    public void setDetailedDescription(String string) {
        this.controller.addTool(new ChangeDetailedDescriptionTool((Detailed)this.atrezzo, string));
    }

    @Override
    public Object getContent() {
        return this.atrezzo;
    }

    @Override
    public int[] getAddableElements() {
        return new int[0];
    }

    @Override
    public boolean canAddElement(int n) {
        return false;
    }

    @Override
    public boolean canBeDeleted() {
        return true;
    }

    @Override
    public boolean canBeMoved() {
        return true;
    }

    @Override
    public boolean canBeRenamed() {
        return true;
    }

    @Override
    public boolean addElement(int n, String string) {
        boolean bl = false;
        if (n == 34) {
            bl = Controller.getInstance().addTool(new AddResourcesBlockTool(this.resourcesList, this.resourcesDataControlList, 58, this));
        }
        return bl;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        boolean bl = false;
        int n = this.resourcesList.indexOf(dataControl.getContent());
        if (n > 0) {
            this.resourcesList.add(n - 1, this.resourcesList.remove(n));
            this.resourcesDataControlList.add(n - 1, this.resourcesDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        boolean bl = false;
        int n = this.resourcesList.indexOf(dataControl.getContent());
        if (n < this.resourcesList.size() - 1) {
            this.resourcesList.add(n + 1, this.resourcesList.remove(n));
            this.resourcesDataControlList.add(n + 1, this.resourcesDataControlList.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public String renameElement(String string) {
        boolean bl = false;
        String string2 = this.atrezzo.getId();
        String string3 = String.valueOf(this.controller.countIdentifierReferences(string2));
        if (string != null || this.controller.showStrictConfirmDialog(TC.get((String)"Operation.RenameAtrezzoTitle"), TC.get((String)"Operation.RenameElementWarning", (String[])new String[]{string2, string3}))) {
            String string4 = string;
            if (string == null) {
                string4 = this.controller.showInputDialog(TC.get((String)"Operation.RenameAtrezzoTitle"), TC.get((String)"Operation.RenameAtrezzoMessage"), string2);
            }
            if (string4 != null && !string4.equals(string2) && this.controller.isElementIdValid(string4)) {
                this.atrezzo.setId(string4);
                this.controller.replaceIdentifierReferences(string2, string4);
                this.controller.getIdentifierSummary().deleteAtrezzoId(string2);
                this.controller.getIdentifierSummary().addAtrezzoId(string4);
                bl = true;
            }
        }
        if (bl) {
            return string2;
        }
        return null;
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
            resourcesDataControl.updateVarFlagSummary(varFlagSummary);
        }
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        boolean bl = true;
        for (int i = 0; i < this.resourcesDataControlList.size(); ++i) {
            String string2 = string + " >> " + TC.getElement((int)34) + " #" + (i + 1);
            bl &= ((ResourcesDataControl)this.resourcesDataControlList.get(i)).isValid(string2, list);
        }
        return bl;
    }

    @Override
    public int countAssetReferences(String string) {
        int n = 0;
        for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
            n += resourcesDataControl.countAssetReferences(string);
        }
        return n;
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
        for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
            resourcesDataControl.getAssetReferences(list, list2);
        }
    }

    @Override
    public void deleteAssetReferences(String string) {
        for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
            resourcesDataControl.deleteAssetReferences(string);
        }
    }

    @Override
    public int countIdentifierReferences(String string) {
        int n = 0;
        for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
            n += resourcesDataControl.countIdentifierReferences(string);
        }
        return n;
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
            resourcesDataControl.replaceIdentifierReferences(string, string2);
        }
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        for (ResourcesDataControl resourcesDataControl : this.resourcesDataControlList) {
            resourcesDataControl.deleteIdentifierReferences(string);
        }
    }

    @Override
    public boolean canBeDuplicated() {
        return true;
    }

    @Override
    public void recursiveSearch() {
        this.check(this.getBriefDescription(), TC.get((String)"Search.BriefDescription"));
        this.check(this.getDetailedDescription(), TC.get((String)"Search.DetailedDescription"));
        this.check(this.getDocumentation(), TC.get((String)"Search.Documentation"));
        this.check(this.getId(), "ID");
        this.check(this.getName(), TC.get((String)"Search.Name"));
        this.check(this.getPreviewImage(), TC.get((String)"Search.PreviewImage"));
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return this.getPathFromChild(searchable, this.resourcesDataControlList);
    }
}

