/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.assessment;

import es.eucm.eadventure.common.data.HasId;
import es.eucm.eadventure.common.data.assessment.AssessmentProfile;
import es.eucm.eadventure.common.data.assessment.AssessmentProperty;
import es.eucm.eadventure.common.data.assessment.AssessmentRule;
import es.eucm.eadventure.common.data.assessment.TimedAssessmentEffect;
import es.eucm.eadventure.common.data.assessment.TimedAssessmentRule;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.config.SCORMConfigData;
import es.eucm.eadventure.editor.control.controllers.ConditionsController;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.tools.assessment.AddAssessmentPropertyTool;
import es.eucm.eadventure.editor.control.tools.assessment.AddEffectTool;
import es.eucm.eadventure.editor.control.tools.assessment.ChangeAssessmentPropertyTool;
import es.eucm.eadventure.editor.control.tools.assessment.ChangeMinTimeValueTool;
import es.eucm.eadventure.editor.control.tools.assessment.ChangeUsesEndCondition;
import es.eucm.eadventure.editor.control.tools.assessment.DeleteAssessmentPropertyTool;
import es.eucm.eadventure.editor.control.tools.assessment.DeleteEffectTool;
import es.eucm.eadventure.editor.control.tools.assessment.RenameRuleTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeIdTool;
import es.eucm.eadventure.editor.control.tools.generic.ChangeBooleanValueTool;
import es.eucm.eadventure.editor.control.tools.generic.ChangeIntegerValueTool;
import es.eucm.eadventure.editor.control.tools.generic.ChangeStringValueTool;
import es.eucm.eadventure.editor.control.tools.generic.MoveObjectTool;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import es.eucm.eadventure.editor.gui.editdialogs.SCORMAttributeDialog;
import java.util.HashMap;
import java.util.List;

public class AssessmentRuleDataControl
extends DataControl {
    private AssessmentRule assessmentRule;
    private ConditionsController conditionsController;
    private ConditionsController initConditionsController;
    private ConditionsController endConditionsController;
    private AssessmentProfile profile;

    public AssessmentRuleDataControl(AssessmentRule assessmentRule, AssessmentProfile assessmentProfile) {
        this.assessmentRule = assessmentRule;
        this.profile = assessmentProfile;
        if (this.isTimedRule()) {
            TimedAssessmentRule timedAssessmentRule = (TimedAssessmentRule)assessmentRule;
            HashMap<String, ConditionsController.ConditionContextProperty> hashMap = new HashMap<String, ConditionsController.ConditionContextProperty>();
            ConditionsController.ConditionOwner conditionOwner = new ConditionsController.ConditionOwner(49, assessmentRule.getId());
            hashMap.put(ConditionsController.CONDITION_OWNER, conditionOwner);
            ConditionsController.ConditionCustomMessage conditionCustomMessage = new ConditionsController.ConditionCustomMessage(TC.get((String)"Conditions.Context.TimedAssessmentRuleA1"), TC.get((String)"Conditions.Context.TimedAssessmentRuleA2"));
            hashMap.put(ConditionsController.CONDITION_CUSTOM_MESSAGE, conditionCustomMessage);
            HashMap<String, ConditionsController.ConditionContextProperty> hashMap2 = new HashMap<String, ConditionsController.ConditionContextProperty>();
            hashMap2.put(ConditionsController.CONDITION_OWNER, conditionOwner);
            ConditionsController.ConditionCustomMessage conditionCustomMessage2 = new ConditionsController.ConditionCustomMessage(TC.get((String)"Conditions.Context.TimedAssessmentRuleB1"), TC.get((String)"Conditions.Context.TimedAssessmentRuleB2"));
            hashMap2.put(ConditionsController.CONDITION_CUSTOM_MESSAGE, conditionCustomMessage2);
            this.initConditionsController = new ConditionsController(timedAssessmentRule.getInitConditions(), hashMap);
            this.endConditionsController = new ConditionsController(timedAssessmentRule.getEndConditions(), hashMap2);
        } else {
            this.conditionsController = new ConditionsController(assessmentRule.getConditions(), 38, assessmentRule.getId());
        }
    }

    @Override
    public boolean addElement(int n, String string) {
        return false;
    }

    @Override
    public boolean canAddElement(int n) {
        return false;
    }

    @Override
    public boolean canBeDeleted() {
        return true;
    }

    @Override
    public boolean canBeMoved() {
        return true;
    }

    @Override
    public boolean canBeRenamed() {
        return true;
    }

    @Override
    public int countAssetReferences(String string) {
        return 0;
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
    }

    @Override
    public int countIdentifierReferences(String string) {
        int n = 0;
        if (string.equals(this.profile.getName() + "." + this.assessmentRule.getId())) {
            ++n;
        }
        if (this.isTimedRule()) {
            n += this.initConditionsController.countIdentifierReferences(string);
            n += this.endConditionsController.countIdentifierReferences(string);
        } else {
            n += this.conditionsController.countIdentifierReferences(string);
        }
        return n;
    }

    @Override
    public void deleteAssetReferences(String string) {
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        return false;
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        if (this.isTimedRule()) {
            this.initConditionsController.deleteIdentifierReferences(string);
            this.endConditionsController.deleteIdentifierReferences(string);
        } else {
            this.conditionsController.deleteIdentifierReferences(string);
        }
    }

    @Override
    public int[] getAddableElements() {
        return new int[0];
    }

    @Override
    public Object getContent() {
        return this.assessmentRule;
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        return true;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        return false;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        return false;
    }

    @Override
    public String renameElement(String string) {
        String string2 = this.assessmentRule.getId();
        String string3 = string;
        if (string == null) {
            string3 = this.controller.showInputDialog(TC.get((String)"Operation.RenameAssessmentRuleTitle"), TC.get((String)"Operation.RenameAssessmentRuleMessage"), TC.get((String)"Operation.AddAssessmentRuleDefaultValue"));
        }
        if (string3 != null && this.controller.isElementIdValid(this.profile.getName() + "." + string3)) {
            this.controller.getIdentifierSummary().deleteAssessmentRuleId(string2, this.profile.getName());
            this.controller.getIdentifierSummary().addAssessmentRuleId(string3, this.profile.getName());
            this.assessmentRule.setId(string3);
            return string2;
        }
        return null;
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        if (this.isTimedRule()) {
            this.initConditionsController.replaceIdentifierReferences(string, string2);
            this.endConditionsController.replaceIdentifierReferences(string, string2);
        } else {
            this.conditionsController.replaceIdentifierReferences(string, string2);
        }
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        if (this.isTimedRule()) {
            TimedAssessmentRule timedAssessmentRule = (TimedAssessmentRule)this.assessmentRule;
            ConditionsController.updateVarFlagSummary(varFlagSummary, timedAssessmentRule.getInitConditions());
            ConditionsController.updateVarFlagSummary(varFlagSummary, timedAssessmentRule.getEndConditions());
        } else {
            ConditionsController.updateVarFlagSummary(varFlagSummary, this.assessmentRule.getConditions());
        }
    }

    public String getConcept() {
        return this.assessmentRule.getConcept();
    }

    public String getEffectText(int n) {
        if (this.assessmentRule instanceof TimedAssessmentRule) {
            TimedAssessmentRule timedAssessmentRule = (TimedAssessmentRule)this.assessmentRule;
            return ((TimedAssessmentEffect)timedAssessmentRule.getEffects().get(n)).getText();
        }
        return this.assessmentRule.getText();
    }

    public void setConcept(String string) {
        this.controller.addTool(new ChangeStringValueTool(this.assessmentRule, string, "getConcept", "setConcept"));
    }

    public void setEffectText(String string) {
        this.controller.addTool(new ChangeStringValueTool(this.assessmentRule, string, "getText", "setText"));
    }

    public void setEffectText(int n, String string) {
        if (this.assessmentRule instanceof TimedAssessmentRule) {
            TimedAssessmentRule timedAssessmentRule = (TimedAssessmentRule)this.assessmentRule;
            if (n >= 0 && n < timedAssessmentRule.getEffectsCount()) {
                this.controller.addTool(new ChangeStringValueTool(timedAssessmentRule.getEffects().get(n), string, "getText", "setText"));
            }
        } else {
            this.setEffectText(string);
        }
    }

    public void setImportance(int n) {
        this.controller.addTool(new ChangeIntegerValueTool(this.assessmentRule, n, "getImportance", "setImportance"));
    }

    public int getImportance() {
        return this.assessmentRule.getImportance();
    }

    public ConditionsController getConditions() {
        return this.conditionsController;
    }

    public ConditionsController getInitConditions() {
        if (this.assessmentRule instanceof TimedAssessmentRule) {
            return this.initConditionsController;
        }
        return this.conditionsController;
    }

    public ConditionsController getEndConditions() {
        if (this.assessmentRule instanceof TimedAssessmentRule) {
            return this.endConditionsController;
        }
        return this.conditionsController;
    }

    public boolean movePropertyUp(int n) {
        return this.controller.addTool(new MoveObjectTool(this.assessmentRule.getAssessmentProperties(), n, 0));
    }

    public boolean movePropertyUp(int n, int n2) {
        if (this.assessmentRule instanceof TimedAssessmentRule) {
            TimedAssessmentRule timedAssessmentRule = (TimedAssessmentRule)this.assessmentRule;
            if (n2 >= 0 && n2 < timedAssessmentRule.getEffectsCount() && n > 0) {
                return this.controller.addTool(new MoveObjectTool(((TimedAssessmentEffect)timedAssessmentRule.getEffects().get(n2)).getAssessmentProperties(), n, 0));
            }
        } else {
            return this.movePropertyUp(n);
        }
        return false;
    }

    public boolean movePropertyDown(int n) {
        return this.controller.addTool(new MoveObjectTool(this.assessmentRule.getAssessmentProperties(), n, 1));
    }

    public boolean movePropertyDown(int n, int n2) {
        if (this.assessmentRule instanceof TimedAssessmentRule) {
            TimedAssessmentRule timedAssessmentRule = (TimedAssessmentRule)this.assessmentRule;
            if (n2 >= 0 && n2 < timedAssessmentRule.getEffectsCount() && n < ((TimedAssessmentEffect)timedAssessmentRule.getEffects().get(n2)).getAssessmentProperties().size() - 1) {
                return this.controller.addTool(new MoveObjectTool(((TimedAssessmentEffect)timedAssessmentRule.getEffects().get(n2)).getAssessmentProperties(), n, 0));
            }
        } else {
            return this.movePropertyDown(n);
        }
        return false;
    }

    public boolean addBlankProperty(int n, int n2) {
        return this.addBlankProperty(n, n2, null);
    }

    public boolean addBlankProperty(int n, int n2, String string) {
        boolean bl = false;
        if (this.assessmentRule instanceof TimedAssessmentRule) {
            TimedAssessmentRule timedAssessmentRule = (TimedAssessmentRule)this.assessmentRule;
            if (n2 >= 0 && n2 < timedAssessmentRule.getEffectsCount()) {
                TimedAssessmentEffect timedAssessmentEffect = (TimedAssessmentEffect)timedAssessmentRule.getEffects().get(n2);
                bl = this.controller.addTool(new AddAssessmentPropertyTool(timedAssessmentEffect.getAssessmentProperties(), n, string));
            }
        } else {
            bl = this.controller.addTool(new AddAssessmentPropertyTool(this.assessmentRule.getAssessmentProperties(), n, string));
        }
        return bl;
    }

    public boolean deleteProperty(int n) {
        return this.controller.addTool(new DeleteAssessmentPropertyTool(this.assessmentRule.getAssessmentProperties(), n));
    }

    public boolean deleteProperty(int n, int n2) {
        if (this.assessmentRule instanceof TimedAssessmentRule) {
            TimedAssessmentRule timedAssessmentRule = (TimedAssessmentRule)this.assessmentRule;
            if (n2 >= 0 && n2 < timedAssessmentRule.getEffectsCount()) {
                return this.controller.addTool(new DeleteAssessmentPropertyTool(((TimedAssessmentEffect)timedAssessmentRule.getEffects().get(n2)).getAssessmentProperties(), n));
            }
        } else {
            return this.deleteProperty(n);
        }
        return false;
    }

    public int getPropertyCount(int n) {
        if (this.assessmentRule instanceof TimedAssessmentRule) {
            TimedAssessmentRule timedAssessmentRule = (TimedAssessmentRule)this.assessmentRule;
            if (n >= 0 && n < timedAssessmentRule.getEffectsCount()) {
                return ((TimedAssessmentEffect)timedAssessmentRule.getEffects().get(n)).getAssessmentProperties().size();
            }
            return 0;
        }
        return this.assessmentRule.getAssessmentProperties().size();
    }

    public void setPropertyValue(int n, String string) {
        if (n >= 0 && n < this.assessmentRule.getAssessmentProperties().size()) {
            try {
                if (((AssessmentProperty)this.assessmentRule.getAssessmentProperties().get(n)).getVarName() == null) {
                    this.controller.addTool(new ChangeAssessmentPropertyTool(this.assessmentRule.getAssessmentProperties(), string, n, 3));
                } else {
                    this.controller.addTool(new ChangeAssessmentPropertyTool(this.assessmentRule.getAssessmentProperties(), string, n, 4));
                }
            }
            catch (Exception exception) {
                this.controller.showErrorDialog(TC.get((String)"AssessmentRule.InvalidPropertyID"), TC.get((String)"AssessmentRule.InvalidPropertyID.Message"));
            }
        }
    }

    public boolean isRegular(int n, int n2) {
        boolean bl = false;
        if (this.assessmentRule instanceof TimedAssessmentRule) {
            TimedAssessmentRule timedAssessmentRule = (TimedAssessmentRule)this.assessmentRule;
            AssessmentProperty assessmentProperty = timedAssessmentRule.getProperty(n, n2);
            if (assessmentProperty != null) {
                bl = assessmentProperty.getVarName() == null;
            }
        } else {
            bl = ((AssessmentProperty)this.assessmentRule.getAssessmentProperties().get(n)).getVarName() == null;
        }
        return bl;
    }

    public void setPropertyValue(int n, int n2, String string) {
        block6: {
            if (this.assessmentRule instanceof TimedAssessmentRule) {
                TimedAssessmentRule timedAssessmentRule = (TimedAssessmentRule)this.assessmentRule;
                AssessmentProperty assessmentProperty = timedAssessmentRule.getProperty(n, n2);
                if (assessmentProperty != null) {
                    try {
                        if (assessmentProperty.getVarName() == null) {
                            this.controller.addTool(new ChangeAssessmentPropertyTool(((TimedAssessmentEffect)timedAssessmentRule.getEffects().get(n2)).getAssessmentProperties(), string, n, 3));
                            break block6;
                        }
                        this.controller.addTool(new ChangeAssessmentPropertyTool(((TimedAssessmentEffect)timedAssessmentRule.getEffects().get(n2)).getAssessmentProperties(), string, n, 4));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        this.controller.showErrorDialog(TC.get((String)"AssessmentRule.InvalidPropertyID"), TC.get((String)"AssessmentRule.InvalidPropertyID.Message"));
                    }
                }
            } else {
                this.setPropertyValue(n, string);
            }
        }
    }

    public void setPropertyId(int n, String string) {
        if (n >= 0 && n < this.assessmentRule.getAssessmentProperties().size() && this.controller.isElementIdValid(string)) {
            this.controller.addTool(new ChangeIdTool((HasId)this.assessmentRule.getAssessmentProperties().get(n), string));
        }
    }

    public void setPropertyId(int n, int n2, String string) {
        if (this.assessmentRule instanceof TimedAssessmentRule) {
            TimedAssessmentRule timedAssessmentRule = (TimedAssessmentRule)this.assessmentRule;
            AssessmentProperty assessmentProperty = timedAssessmentRule.getProperty(n, n2);
            if (assessmentProperty != null) {
                if (SCORMConfigData.isArrayAttribute(string)) {
                    if (((AssessmentProperty)this.assessmentRule.getAssessmentProperties().get(n)).getId().startsWith(string)) {
                        string = ((AssessmentProperty)this.assessmentRule.getAssessmentProperties().get(n)).getId();
                    }
                    string = SCORMAttributeDialog.showAttributeDialogForWrite(this.getProfileType(), string);
                }
                if (!SCORMConfigData.isArrayAttribute(string)) {
                    this.controller.addTool(new ChangeAssessmentPropertyTool(((TimedAssessmentEffect)((TimedAssessmentRule)this.assessmentRule).getEffects().get(n2)).getAssessmentProperties(), string, n, 2));
                }
            }
        } else if (n >= 0 && n < this.assessmentRule.getAssessmentProperties().size() && this.controller.isElementIdValid(string)) {
            if (SCORMConfigData.isArrayAttribute(string)) {
                if (((AssessmentProperty)this.assessmentRule.getAssessmentProperties().get(n)).getId().startsWith(string)) {
                    string = ((AssessmentProperty)this.assessmentRule.getAssessmentProperties().get(n)).getId();
                }
                string = SCORMAttributeDialog.showAttributeDialogForWrite(this.getProfileType(), string);
            }
            if (!SCORMConfigData.isArrayAttribute(string)) {
                this.controller.addTool(new ChangeAssessmentPropertyTool(this.assessmentRule.getAssessmentProperties(), string, n, 2));
            }
        }
    }

    public int getProfileType() {
        if (this.profile.isScorm12()) {
            return 0;
        }
        if (this.profile.isScorm2004()) {
            return 1;
        }
        return -1;
    }

    public boolean checkRulesDataModel(String string, List<String> list, boolean bl, boolean bl2) {
        boolean bl3 = true;
        for (AssessmentProperty assessmentProperty : this.assessmentRule.getAssessmentProperties()) {
            if (bl && !SCORMConfigData.isPartOfTheModel12(assessmentProperty.getId())) {
                list.add(TC.get((String)"AssessmentRule.CheckRule.Rule") + ": " + string + " " + TC.get((String)"AssessmentRule.CheckRule.Property") + " " + assessmentProperty.getId() + " " + TC.get((String)"AssessmentRule.CheckRule.Datav12"));
                bl3 &= false;
            }
            if (!bl2 || SCORMConfigData.isPartOfTheModel2004(assessmentProperty.getId())) continue;
            list.add(TC.get((String)"AssessmentRule.CheckRule.Rule") + ": " + string + " " + TC.get((String)"AssessmentRule.CheckRule.Property") + " " + assessmentProperty.getId() + " " + TC.get((String)"AssessmentRule.CheckRule.Data2004"));
            bl3 &= false;
        }
        return bl3;
    }

    public String getPropertyId(int n, int n2) {
        if (this.assessmentRule instanceof TimedAssessmentRule) {
            TimedAssessmentRule timedAssessmentRule = (TimedAssessmentRule)this.assessmentRule;
            AssessmentProperty assessmentProperty = timedAssessmentRule.getProperty(n, n2);
            if (assessmentProperty != null) {
                return assessmentProperty.getId();
            }
            return null;
        }
        return ((AssessmentProperty)this.assessmentRule.getAssessmentProperties().get(n)).getId();
    }

    public String getPropertyValue(int n, int n2) {
        if (this.assessmentRule instanceof TimedAssessmentRule) {
            TimedAssessmentRule timedAssessmentRule = (TimedAssessmentRule)this.assessmentRule;
            AssessmentProperty assessmentProperty = timedAssessmentRule.getProperty(n, n2);
            if (assessmentProperty != null) {
                if (assessmentProperty.getVarName() == null) {
                    return assessmentProperty.getValue();
                }
                return assessmentProperty.getVarName();
            }
            return "";
        }
        if (((AssessmentProperty)this.assessmentRule.getAssessmentProperties().get(n)).getVarName() == null) {
            return ((AssessmentProperty)this.assessmentRule.getAssessmentProperties().get(n)).getValue();
        }
        return ((AssessmentProperty)this.assessmentRule.getAssessmentProperties().get(n)).getVarName();
    }

    public String getId() {
        return this.assessmentRule.getId();
    }

    public boolean isRepeatRule() {
        return this.assessmentRule.isRepeatRule();
    }

    public boolean isTimedRule() {
        return this.assessmentRule != null && this.assessmentRule instanceof TimedAssessmentRule;
    }

    public int getMinTime(int n) {
        TimedAssessmentRule timedAssessmentRule = (TimedAssessmentRule)this.assessmentRule;
        return timedAssessmentRule.getMinTime(n);
    }

    public int getMaxTime(int n) {
        TimedAssessmentRule timedAssessmentRule = (TimedAssessmentRule)this.assessmentRule;
        return timedAssessmentRule.getMaxTime(n);
    }

    public void setMinTime(int n, int n2) {
        TimedAssessmentRule timedAssessmentRule = (TimedAssessmentRule)this.assessmentRule;
        if (n2 >= 0 && n2 < timedAssessmentRule.getEffectsCount()) {
            this.controller.addTool(new ChangeMinTimeValueTool((TimedAssessmentEffect)timedAssessmentRule.getEffects().get(n2), n));
        }
    }

    public void setMaxTime(int n, int n2) {
        TimedAssessmentRule timedAssessmentRule = (TimedAssessmentRule)this.assessmentRule;
        if (n2 >= 0 && n2 < timedAssessmentRule.getEffectsCount()) {
            this.controller.addTool(new ChangeIntegerValueTool(timedAssessmentRule.getEffects().get(n2), n, "getMaxTime", "setMaxTime"));
        }
    }

    public int getEffectsCount() {
        TimedAssessmentRule timedAssessmentRule = (TimedAssessmentRule)this.assessmentRule;
        return timedAssessmentRule.getEffectsCount();
    }

    public String[] getEffectNames() {
        TimedAssessmentRule timedAssessmentRule = (TimedAssessmentRule)this.assessmentRule;
        String[] stringArray = new String[timedAssessmentRule.getEffectsCount()];
        for (int i = 1; i <= stringArray.length; ++i) {
            stringArray[i - 1] = Integer.toString(i);
        }
        return stringArray;
    }

    public void addEffectBlock(int n) {
        TimedAssessmentRule timedAssessmentRule = (TimedAssessmentRule)this.assessmentRule;
        this.controller.addTool(new AddEffectTool(timedAssessmentRule, n));
    }

    public void removeEffectBlock(int n) {
        TimedAssessmentRule timedAssessmentRule = (TimedAssessmentRule)this.assessmentRule;
        this.controller.addTool(new DeleteEffectTool(timedAssessmentRule, n));
    }

    @Override
    public boolean canBeDuplicated() {
        return true;
    }

    @Override
    public void recursiveSearch() {
        this.check(this.getConcept(), TC.get((String)"Search.Concept"));
        this.check(this.getId(), "ID");
        this.check(this.getEndConditions(), TC.get((String)"Search.EndConditions"));
        if (this.assessmentRule instanceof TimedAssessmentRule) {
            for (int i = 0; i < this.getEffectsCount(); ++i) {
                this.check(this.getEffectNames()[i], TC.get((String)"Search.EffectName"));
                this.check(this.getEffectText(i), TC.get((String)"Search.EffectText"));
                for (int j = 0; j < this.getPropertyCount(i); ++j) {
                    this.check(this.getPropertyId(j, i), TC.get((String)"Search.PropertyID"));
                    this.check(this.getPropertyValue(j, i), TC.get((String)"Search.PropertyValue"));
                }
                this.check(this.getInitConditions(), TC.get((String)"Search.Conditions"));
            }
        } else if (this.assessmentRule instanceof AssessmentRule) {
            for (int i = 0; i < this.getPropertyCount(-1); ++i) {
                this.check(this.getPropertyId(i, -1), TC.get((String)"Search.PropertyID"));
                this.check(this.getPropertyValue(i, -1), TC.get((String)"Search.PropertyValue"));
            }
            this.check(this.getEffectText(-1), TC.get((String)"Search.EffectText"));
            this.check(this.getConditions(), TC.get((String)"Search.Conditions"));
        }
    }

    public boolean isUsesEndConditions() {
        if (this.assessmentRule instanceof TimedAssessmentRule) {
            return ((TimedAssessmentRule)this.assessmentRule).isUsesEndConditions();
        }
        return false;
    }

    public void setUsesEndConditions(boolean bl) {
        Controller.getInstance().addTool(new ChangeUsesEndCondition((TimedAssessmentRule)this.assessmentRule, bl));
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return null;
    }

    public void setId(String string) {
        Controller.getInstance().addTool(new RenameRuleTool(this, string));
    }

    public void setRepeatRule(Boolean bl) {
        Controller.getInstance().addTool(new ChangeBooleanValueTool(this.assessmentRule, bl, "isRepeatRule", "setRepeatRule"));
    }
}

