/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.assessment;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.assessment.AssessmentProfile;
import es.eucm.eadventure.common.data.assessment.AssessmentRule;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.assessment.AssessmentProfileDataControl;
import es.eucm.eadventure.editor.control.controllers.assessment.AssessmentRuleDataControl;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AssessmentProfilesDataControl
extends DataControl {
    private List<AssessmentProfileDataControl> profiles = new ArrayList<AssessmentProfileDataControl>();
    private List<AssessmentProfile> data;

    public AssessmentProfilesDataControl(List<AssessmentProfile> list) {
        this.data = list;
        for (AssessmentProfile assessmentProfile : list) {
            this.profiles.add(new AssessmentProfileDataControl(assessmentProfile));
        }
    }

    @Override
    public boolean addElement(int n, String string) {
        boolean bl = false;
        if (n == 40) {
            if (string == null) {
                string = this.controller.showInputDialog(TC.get((String)"Operation.CreateAssessmentFile.FileName"), TC.get((String)"Operation.CreateAssessmentFile.FileName.Message"), TC.get((String)"Operation.CreateAssessmentFile.FileName.DefaultValue"));
            }
            if (string != null && this.controller.isElementIdValid(string)) {
                Object object;
                int n2 = 1;
                while (this.controller.getIdentifierSummary().isAssessmentProfileId(string)) {
                    object = string.substring(string.length() - 1, string.length());
                    try {
                        Integer.parseInt((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                        string = string + n2;
                    }
                    string = string.substring(0, string.length() - 1);
                    string = string + n2;
                }
                object = new ArrayList();
                this.profiles.add(new AssessmentProfileDataControl((List<AssessmentRule>)object, string));
                this.data.add((AssessmentProfile)this.profiles.get(this.profiles.size() - 1).getContent());
                this.controller.getIdentifierSummary().addAssessmentProfileId(string);
                if (this.controller.getSelectedChapterDataControl().getAssessmentName() == null || this.controller.getSelectedChapterDataControl().getAssessmentName().equals("")) {
                    this.controller.getSelectedChapterDataControl().setAssessmentPath(string);
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean duplicateElement(DataControl dataControl) {
        if (!(dataControl instanceof AssessmentProfileDataControl)) {
            return false;
        }
        try {
            AssessmentProfile assessmentProfile = (AssessmentProfile)((AssessmentProfile)dataControl.getContent()).clone();
            String string = assessmentProfile.getName();
            int n = 1;
            do {
                string = assessmentProfile.getName() + n;
                ++n;
            } while (this.controller.getIdentifierSummary().isAssessmentProfileId(string));
            assessmentProfile.setName(string);
            this.profiles.add(new AssessmentProfileDataControl(assessmentProfile));
            this.data.add((AssessmentProfile)this.profiles.get(this.profiles.size() - 1).getContent());
            this.controller.getIdentifierSummary().addAssessmentProfileId(string);
            for (AssessmentRule assessmentRule : assessmentProfile.getRules()) {
                this.controller.getIdentifierSummary().addAssessmentRuleId(assessmentRule.getId(), string);
            }
            return true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ReportDialog.GenerateErrorReport((Exception)cloneNotSupportedException, (boolean)true, (String)"Could not clone assessment profile");
            return false;
        }
    }

    @Override
    public String getDefaultId(int n) {
        return TC.get((String)"Operation.CreateAssessmentFile.FileName.DefaultValue");
    }

    @Override
    public boolean canAddElement(int n) {
        return n == 40;
    }

    @Override
    public boolean canBeDeleted() {
        return false;
    }

    @Override
    public boolean canBeMoved() {
        return false;
    }

    @Override
    public boolean canBeRenamed() {
        return false;
    }

    @Override
    public int countAssetReferences(String string) {
        return 0;
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
    }

    @Override
    public int countIdentifierReferences(String string) {
        int n = 0;
        for (AssessmentProfileDataControl assessmentProfileDataControl : this.profiles) {
            if (assessmentProfileDataControl.getName().equals(string)) {
                ++n;
            }
            n += assessmentProfileDataControl.countIdentifierReferences(string);
        }
        return n;
    }

    @Override
    public void deleteAssetReferences(String string) {
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        boolean bl2 = false;
        for (AssessmentProfileDataControl assessmentProfileDataControl : this.profiles) {
            if (dataControl != assessmentProfileDataControl) continue;
            String string = assessmentProfileDataControl.getName();
            int n = Controller.getInstance().countAssetReferences(string);
            if (bl && !this.controller.showStrictConfirmDialog(TC.get((String)"Operation.DeleteElementTitle"), TC.get((String)"Operation.DeleteElementWarning", (String[])new String[]{TC.getElement((int)40), Integer.toString(n)}))) continue;
            this.data.remove(this.profiles.indexOf(dataControl));
            bl2 = this.profiles.remove(dataControl);
            if (!bl2) continue;
            for (AssessmentRuleDataControl assessmentRuleDataControl : ((AssessmentProfileDataControl)dataControl).getAssessmentRules()) {
                this.controller.getIdentifierSummary().deleteAssessmentRuleId(assessmentRuleDataControl.getId(), assessmentProfileDataControl.getName());
            }
            this.controller.getIdentifierSummary().deleteAssessmentProfileId(assessmentProfileDataControl.getName());
            break;
        }
        return bl2;
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        Object var2_2 = null;
        AssessmentProfileDataControl assessmentProfileDataControl = null;
        Iterator<AssessmentProfileDataControl> iterator = this.profiles.iterator();
        while (iterator.hasNext()) {
            assessmentProfileDataControl = iterator.next();
            if (string.equals(assessmentProfileDataControl.getName())) {
                this.data.remove(this.profiles.indexOf(assessmentProfileDataControl));
                iterator.remove();
                continue;
            }
            assessmentProfileDataControl.deleteIdentifierReferences(string);
        }
    }

    @Override
    public int[] getAddableElements() {
        return new int[]{40};
    }

    @Override
    public Object getContent() {
        return this.profiles;
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        boolean bl = true;
        for (int i = 0; i < this.profiles.size(); ++i) {
            string = string + ">>" + i;
            AssessmentProfileDataControl assessmentProfileDataControl = this.profiles.get(i);
            bl &= assessmentProfileDataControl.isValid(string, list);
        }
        return bl;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        boolean bl = false;
        int n = this.profiles.indexOf(dataControl);
        if (n < this.profiles.size() - 1) {
            this.profiles.add(n + 1, this.profiles.remove(n));
            this.data.add(n + 1, this.data.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        boolean bl = false;
        int n = this.profiles.indexOf(dataControl);
        if (n > 0) {
            this.profiles.add(n - 1, this.profiles.remove(n));
            this.data.add(n - 1, this.data.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public String renameElement(String string) {
        return null;
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        for (AssessmentProfileDataControl assessmentProfileDataControl : this.profiles) {
            if (assessmentProfileDataControl.getName().equals(string)) {
                assessmentProfileDataControl.renameElement(string2);
            }
            assessmentProfileDataControl.replaceIdentifierReferences(string, string2);
        }
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        for (AssessmentProfileDataControl assessmentProfileDataControl : this.profiles) {
            assessmentProfileDataControl.updateVarFlagSummary(varFlagSummary);
        }
    }

    public List<AssessmentProfileDataControl> getProfiles() {
        return this.profiles;
    }

    public boolean isScorm12Profile() {
        boolean bl = true;
        for (AssessmentProfileDataControl assessmentProfileDataControl : this.profiles) {
            bl &= assessmentProfileDataControl.isScorm12();
        }
        return false;
    }

    public boolean isScorm2004Profile() {
        boolean bl = true;
        for (AssessmentProfileDataControl assessmentProfileDataControl : this.profiles) {
            bl &= assessmentProfileDataControl.isScorm2004();
        }
        return false;
    }

    public AssessmentProfileDataControl getLastProfile() {
        return this.profiles.get(this.profiles.size() - 1);
    }

    @Override
    public boolean canBeDuplicated() {
        return false;
    }

    @Override
    public void recursiveSearch() {
        for (AssessmentProfileDataControl assessmentProfileDataControl : this.profiles) {
            ((Searchable)assessmentProfileDataControl).recursiveSearch();
        }
    }

    public AssessmentProfileDataControl getProfileByPath(String string) {
        for (AssessmentProfileDataControl assessmentProfileDataControl : this.profiles) {
            if (!assessmentProfileDataControl.getName().equals(string)) continue;
            return assessmentProfileDataControl;
        }
        return null;
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return this.getPathFromChild(searchable, this.profiles);
    }
}

