/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.assessment;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.assessment.AssessmentProfile;
import es.eucm.eadventure.common.data.assessment.AssessmentRule;
import es.eucm.eadventure.common.data.assessment.TimedAssessmentRule;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.assessment.AssessmentRuleDataControl;
import es.eucm.eadventure.editor.control.tools.animation.ChangeAssessmentProfileTypeTool;
import es.eucm.eadventure.editor.control.tools.assessment.ChangeReportSettingsTool;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import es.eucm.eadventure.editor.gui.displaydialogs.InvalidReportDialog;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AssessmentProfileDataControl
extends DataControl {
    private List<AssessmentRuleDataControl> dataControls = new ArrayList<AssessmentRuleDataControl>();
    private AssessmentProfile profile;
    public static final String[] IMPORTANCE_VALUES_PRINT = new String[]{"Very low", "Low", "Normal", "High", "Very high"};

    public AssessmentProfileDataControl(AssessmentProfile assessmentProfile) {
        this.profile = assessmentProfile;
        for (AssessmentRule assessmentRule : assessmentProfile.getRules()) {
            this.dataControls.add(new AssessmentRuleDataControl(assessmentRule, this.profile));
        }
    }

    public AssessmentProfileDataControl(List<AssessmentRule> list, String string) {
        this(new AssessmentProfile(list, string));
    }

    public String getFileName() {
        return this.profile.getName().substring(Math.max(this.profile.getName().lastIndexOf("/"), this.profile.getName().lastIndexOf("\\")) + 1);
    }

    @Override
    public boolean addElement(int n, String string) {
        boolean bl = false;
        if (n == 38 || n == 49) {
            if (string == null) {
                string = this.controller.showInputDialog(TC.get((String)"Operation.AddAssessmentRuleTitle"), TC.get((String)"Operation.AddAssessmentRuleMessage"), TC.get((String)"Operation.AddAssessmentRuleDefaultValue"));
            }
            if (string != null && this.controller.isElementIdValid(string)) {
                Object object = null;
                object = n == 49 ? new TimedAssessmentRule(string, 2, false) : new AssessmentRule(string, 2, false);
                this.profile.getRules().add(object);
                this.dataControls.add(new AssessmentRuleDataControl((AssessmentRule)object, this.profile));
                this.controller.getIdentifierSummary().addAssessmentRuleId(string, this.profile.getName());
                bl = true;
            }
        }
        return bl;
    }

    public DataControl getLastDatacontrol() {
        return this.dataControls.get(this.dataControls.size() - 1);
    }

    public boolean addElement(int n, String string, AssessmentRule assessmentRule) {
        boolean bl = false;
        if ((n == 38 || n == 49) && string != null && this.controller.isElementIdValid(string)) {
            this.profile.getRules().add(assessmentRule);
            this.dataControls.add(new AssessmentRuleDataControl(assessmentRule, this.profile));
            this.controller.getIdentifierSummary().addAssessmentRuleId(string, this.profile.getName());
            bl = true;
        }
        return bl;
    }

    public AssessmentRuleDataControl getLastAssessmentRule() {
        return this.dataControls.get(this.dataControls.size() - 1);
    }

    @Override
    public boolean canAddElement(int n) {
        return n == 38 || n == 49;
    }

    @Override
    public boolean canBeDeleted() {
        return true;
    }

    @Override
    public boolean canBeMoved() {
        return true;
    }

    @Override
    public boolean canBeRenamed() {
        return true;
    }

    @Override
    public int countAssetReferences(String string) {
        return 0;
    }

    @Override
    public int countIdentifierReferences(String string) {
        int n = 0;
        if (string.equals(this.profile.getName())) {
            ++n;
        }
        for (AssessmentRuleDataControl assessmentRuleDataControl : this.dataControls) {
            n += assessmentRuleDataControl.countIdentifierReferences(string);
        }
        return n;
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
    }

    @Override
    public void deleteAssetReferences(String string) {
    }

    @Override
    public boolean duplicateElement(DataControl dataControl) {
        if (!(dataControl instanceof AssessmentRuleDataControl)) {
            return false;
        }
        try {
            AssessmentRule assessmentRule = (AssessmentRule)((AssessmentRule)dataControl.getContent()).clone();
            String string = assessmentRule.getId();
            int n = 0;
            do {
                String string2 = n < 10 ? string.substring(string.length() - 1, string.length()) : string.substring(string.length() - 2, string.length());
                try {
                    Integer.parseInt(string2);
                    string = ++n < 10 ? string.substring(0, string.length() - 1) : string.substring(0, string.length() - 2);
                    string = string + n;
                }
                catch (NumberFormatException numberFormatException) {
                    string = string + 1;
                }
            } while (this.controller.getIdentifierSummary().isAssessmentRuleId(string, this.profile.getName()));
            assessmentRule.setId(string);
            this.dataControls.add(new AssessmentRuleDataControl(assessmentRule, this.profile));
            this.profile.addRule(assessmentRule);
            this.controller.getIdentifierSummary().addAssessmentRuleId(assessmentRule.getId(), this.profile.getName());
            return true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ReportDialog.GenerateErrorReport((Exception)cloneNotSupportedException, (boolean)true, (String)"Could not clone action");
            return false;
        }
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        boolean bl2 = false;
        String string = ((AssessmentRuleDataControl)dataControl).getId();
        String string2 = String.valueOf(this.controller.countIdentifierReferences(string));
        if ((!bl || this.controller.showStrictConfirmDialog(TC.get((String)"Operation.DeleteElementTitle"), TC.get((String)"Operation.DeleteElementWarning", (String[])new String[]{string, string2}))) && this.profile.getRules().remove(dataControl.getContent())) {
            this.dataControls.remove(dataControl);
            this.controller.deleteIdentifierReferences(string);
            this.controller.getIdentifierSummary().deleteAssessmentRuleId(string, this.profile.getName());
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        Iterator<AssessmentRuleDataControl> iterator = this.dataControls.iterator();
        while (iterator.hasNext()) {
            iterator.next().deleteIdentifierReferences(string);
        }
    }

    @Override
    public int[] getAddableElements() {
        return new int[]{38, 49};
    }

    @Override
    public Object getContent() {
        return this.profile;
    }

    public List<AssessmentRuleDataControl> getAssessmentRules() {
        return this.dataControls;
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        Iterator<AssessmentRuleDataControl> iterator = this.dataControls.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getId().equals(string)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        boolean bl = false;
        int n = this.profile.getRules().indexOf(dataControl.getContent());
        if (n < this.profile.getRules().size() - 1) {
            this.profile.getRules().add(n + 1, this.profile.getRules().remove(n));
            this.dataControls.add(n + 1, this.dataControls.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        boolean bl = false;
        int n = this.profile.getRules().indexOf(dataControl.getContent());
        if (n > 0) {
            this.profile.getRules().add(n - 1, this.profile.getRules().remove(n));
            this.dataControls.add(n - 1, this.dataControls.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public String renameElement(String string) {
        boolean bl = false;
        String string2 = null;
        if (this.profile.getName() != null) {
            string2 = this.profile.getName();
        }
        if (string != null || this.controller.showStrictConfirmDialog(TC.get((String)"Operation.RenameAssessmentFile"), TC.get((String)"Operation.RenameAssessmentFile.Message"))) {
            String string3 = string;
            if (string == null || string.equals("")) {
                string3 = this.controller.showInputDialog(TC.get((String)"Operation.RenameAssessmentFile.FileName"), TC.get((String)"Operation.RenameAssessmentFile.FileName.Message"), this.getFileName());
            }
            if (string3 != null && !string3.equals(string2) && this.controller.isElementIdValid(string3)) {
                if (!this.controller.getIdentifierSummary().isAssessmentProfileId(string)) {
                    this.profile.setName(string3);
                    this.controller.getIdentifierSummary().renameAssessmentProfile(string2, string3);
                    this.controller.replaceIdentifierReferences(string2, string3);
                    bl = true;
                } else {
                    this.controller.showErrorDialog(TC.get((String)"Operation.CreateAdaptationFile.FileName.ExistValue.Title"), TC.get((String)"Operation.CreateAdaptationFile.FileName.ExistValue.Message"));
                }
            }
        }
        if (bl) {
            return string2;
        }
        return null;
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        for (AssessmentRuleDataControl assessmentRuleDataControl : this.dataControls) {
            assessmentRuleDataControl.replaceIdentifierReferences(string, string2);
        }
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        for (AssessmentRuleDataControl assessmentRuleDataControl : this.dataControls) {
            assessmentRuleDataControl.updateVarFlagSummary(varFlagSummary);
        }
    }

    public String[][] getAssessmentRulesInfo() {
        String[][] stringArray = new String[this.profile.getRules().size()][3];
        for (int i = 0; i < this.profile.getRules().size(); ++i) {
            stringArray[i][0] = ((AssessmentRule)this.profile.getRules().get(i)).getId();
            stringArray[i][1] = IMPORTANCE_VALUES_PRINT[((AssessmentRule)this.profile.getRules().get(i)).getImportance()];
            stringArray[i][2] = ((AssessmentRule)this.profile.getRules().get(i)).getConditions().isEmpty() ? TC.get((String)"GeneralText.No") : TC.get((String)"GeneralText.Yes");
        }
        return stringArray;
    }

    public String getName() {
        return this.profile.getName();
    }

    @Override
    public boolean canBeDuplicated() {
        return true;
    }

    public boolean isShowReportAtEnd() {
        return this.profile.isShowReportAtEnd();
    }

    public void setShowReportAtEnd(boolean bl) {
        this.controller.addTool(new ChangeReportSettingsTool(this.profile, bl, 1));
    }

    public boolean isSendByEmail() {
        return this.profile.isSendByEmail();
    }

    public void setSendByEmail(boolean bl) {
        this.controller.addTool(new ChangeReportSettingsTool(this.profile, bl, 2));
    }

    public String getEmail() {
        return this.profile.getEmail();
    }

    public void setEmail(String string) {
        this.controller.addTool(new ChangeReportSettingsTool(this.profile, string, 3));
    }

    public String getSmtpServer() {
        return this.profile.getSmtpServer();
    }

    public boolean isSmtpSSL() {
        return this.profile.isSmtpSSL();
    }

    public String getSmtpPort() {
        return this.profile.getSmtpPort();
    }

    public String getSmtpUser() {
        return this.profile.getSmtpUser();
    }

    public String getSmtpPwd() {
        return this.profile.getSmtpPwd();
    }

    public void setSmtpServer(String string) {
        this.controller.addTool(new ChangeReportSettingsTool(this.profile, string, 4));
    }

    public void setSmtpSSL(boolean bl) {
        this.controller.addTool(new ChangeReportSettingsTool(this.profile, bl, 5));
    }

    public void setSmtpPort(String string) {
        this.controller.addTool(new ChangeReportSettingsTool(this.profile, string, 6));
    }

    public void setSmtpUser(String string) {
        this.controller.addTool(new ChangeReportSettingsTool(this.profile, string, 7));
    }

    public void setSmtpPwd(String string) {
        this.controller.addTool(new ChangeReportSettingsTool(this.profile, string, 8));
    }

    public boolean isScorm12() {
        return this.profile.isScorm12();
    }

    public boolean isScorm2004() {
        return this.profile.isScorm2004();
    }

    public void changeToScorm2004Profile() {
        this.controller.addTool(new ChangeAssessmentProfileTypeTool(this.profile, 2, this.profile.isScorm12(), this.profile.isScorm2004()));
        this.checkRulesDataModel();
    }

    public void changeToScorm12Profile() {
        this.controller.addTool(new ChangeAssessmentProfileTypeTool(this.profile, 1, this.profile.isScorm12(), this.profile.isScorm2004()));
        this.checkRulesDataModel();
    }

    public void changeToNormalProfile() {
        this.controller.addTool(new ChangeAssessmentProfileTypeTool(this.profile, 0, this.profile.isScorm12(), this.profile.isScorm2004()));
        this.checkRulesDataModel();
    }

    public void checkRulesDataModel() {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = true;
        for (AssessmentRuleDataControl assessmentRuleDataControl : this.dataControls) {
            bl &= assessmentRuleDataControl.checkRulesDataModel(assessmentRuleDataControl.getId(), arrayList, this.profile.isScorm12(), this.profile.isScorm2004());
        }
        if (!bl) {
            new InvalidReportDialog(arrayList, TC.get((String)"AssessmentRule.CheckRule.Title"));
        }
    }

    @Override
    public void recursiveSearch() {
        for (AssessmentRuleDataControl assessmentRuleDataControl : this.dataControls) {
            ((Searchable)assessmentRuleDataControl).recursiveSearch();
        }
        this.check(this.getEmail(), TC.get((String)"Search.EMail"));
        this.check(this.getName(), TC.get((String)"Search.Name"));
        this.check(this.getSmtpPort(), TC.get((String)"Search.SMTPPort"));
        this.check(this.getSmtpServer(), TC.get((String)"Search.SMTPServer"));
        this.check(this.getSmtpUser(), TC.get((String)"Search.SMTPUser"));
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return this.getPathFromChild(searchable, this.dataControls);
    }

    public List<AssessmentRuleDataControl> getDataControls() {
        return this.dataControls;
    }

    public void setDataControlsAndData(List<AssessmentRuleDataControl> list) {
        this.dataControls = list;
        ArrayList<AssessmentRule> arrayList = new ArrayList<AssessmentRule>();
        for (AssessmentRuleDataControl assessmentRuleDataControl : list) {
            arrayList.add((AssessmentRule)assessmentRuleDataControl.getContent());
        }
        this.profile.setRules(arrayList);
    }
}

