/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.animation;

import es.eucm.eadventure.common.data.animation.Frame;
import es.eucm.eadventure.common.data.animation.Timed;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.DataControlWithResources;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.general.ResourcesDataControl;
import es.eucm.eadventure.editor.control.tools.animation.ChangeImageURITool;
import es.eucm.eadventure.editor.control.tools.animation.ChangeSoundUriTool;
import es.eucm.eadventure.editor.control.tools.animation.ChangeTimeTool;
import es.eucm.eadventure.editor.control.tools.animation.ChangeWaitForClick;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.util.ArrayList;
import java.util.List;

public class FrameDataControl
extends DataControlWithResources {
    private Frame frame;

    public FrameDataControl(Frame frame) {
        this.frame = frame;
        this.resourcesDataControlList = new ArrayList();
        for (Resources resources : frame.getResources()) {
            this.resourcesDataControlList.add(new ResourcesDataControl(resources, 65));
        }
    }

    public long getTime() {
        return this.frame.getTime();
    }

    public void setTime(long l) {
        Controller.getInstance().addTool(new ChangeTimeTool((Timed)this.frame, l));
    }

    public void setImageURI(String string) {
        Controller.getInstance().addTool(new ChangeImageURITool(this.frame, string));
    }

    public String getImageURI() {
        return this.frame.getUri();
    }

    public boolean isWaitForClick() {
        return this.frame.isWaitforclick();
    }

    public void setWaitForClick(boolean bl) {
        Controller.getInstance().addTool(new ChangeWaitForClick(this.frame, bl));
    }

    public String getSoundUri() {
        return this.frame.getSoundUri();
    }

    public void setSoundURI(String string) {
        Controller.getInstance().addTool(new ChangeSoundUriTool(this.frame, string));
    }

    @Override
    public boolean addElement(int n, String string) {
        return false;
    }

    @Override
    public boolean canAddElement(int n) {
        return false;
    }

    @Override
    public boolean canBeDeleted() {
        return false;
    }

    @Override
    public boolean canBeDuplicated() {
        return false;
    }

    @Override
    public boolean canBeMoved() {
        return false;
    }

    @Override
    public boolean canBeRenamed() {
        return false;
    }

    @Override
    public int countAssetReferences(String string) {
        return 0;
    }

    @Override
    public int countIdentifierReferences(String string) {
        return 0;
    }

    @Override
    public void deleteAssetReferences(String string) {
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        return false;
    }

    @Override
    public void deleteIdentifierReferences(String string) {
    }

    @Override
    public int[] getAddableElements() {
        return null;
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
    }

    @Override
    public Object getContent() {
        return this.frame;
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        return false;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        return false;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        return false;
    }

    @Override
    public void recursiveSearch() {
    }

    @Override
    public String renameElement(String string) {
        return null;
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
    }

    @Override
    public ResourcesDataControl getLastResources() {
        if (this.resourcesDataControlList.size() == 0) {
            return null;
        }
        return (ResourcesDataControl)this.resourcesDataControlList.get(this.resourcesDataControlList.size() - 1);
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return this.getPathFromChild(searchable, this.resourcesDataControlList);
    }
}

