/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.animation;

import es.eucm.eadventure.common.data.Documented;
import es.eucm.eadventure.common.data.HasId;
import es.eucm.eadventure.common.data.animation.Animation;
import es.eucm.eadventure.common.data.animation.Frame;
import es.eucm.eadventure.common.data.animation.ImageLoaderFactory;
import es.eucm.eadventure.common.data.animation.Transition;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.animation.FrameDataControl;
import es.eucm.eadventure.editor.control.controllers.animation.TransitionDataControl;
import es.eucm.eadventure.editor.control.tools.animation.AddNewFrameTool;
import es.eucm.eadventure.editor.control.tools.animation.ChangeSlidesTool;
import es.eucm.eadventure.editor.control.tools.animation.ChangeUseTransitionsTool;
import es.eucm.eadventure.editor.control.tools.animation.DeleteFrameTool;
import es.eucm.eadventure.editor.control.tools.animation.DuplicateFrameTool;
import es.eucm.eadventure.editor.control.tools.animation.MoveFrameLeftTool;
import es.eucm.eadventure.editor.control.tools.animation.MoveFrameRightTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeDocumentationTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeIdTool;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import es.eucm.eadventure.editor.gui.assetchooser.AssetChooser;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class AnimationDataControl
extends DataControl {
    private Animation animation;
    private String filename;
    private List<FrameDataControl> frameDataControls;
    private List<TransitionDataControl> transitionDataControls;

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public AnimationDataControl(Animation animation) {
        this.animation = animation;
        this.createDataControls();
    }

    public void setAnimation(Animation animation) {
        this.animation = animation;
        this.createDataControls();
    }

    public String getDocumentation() {
        return this.animation.getDocumentation();
    }

    public void setDocumentation(String string) {
        Controller.getInstance().addTool(new ChangeDocumentationTool((Documented)this.animation, string));
    }

    public String getId() {
        return this.animation.getId();
    }

    public void setId(String string) {
        Controller.getInstance().addTool(new ChangeIdTool((HasId)this.animation, string));
    }

    public boolean isUseTransitions() {
        return this.animation.isUseTransitions();
    }

    public boolean isSlides() {
        return this.animation.isSlides();
    }

    public void setUseTransitions(boolean bl) {
        Controller.getInstance().addTool(new ChangeUseTransitionsTool(this.animation, bl));
    }

    public void setSlides(boolean bl) {
        Controller.getInstance().addTool(new ChangeSlidesTool(this.animation, bl));
    }

    public FrameDataControl getFrameDataControl(int n) {
        if (n >= 0 && n < this.frameDataControls.size()) {
            return this.frameDataControls.get(n);
        }
        return null;
    }

    public TransitionDataControl getTransitionDataControl(int n) {
        if (n >= 0 && n < this.transitionDataControls.size()) {
            return this.transitionDataControls.get(n);
        }
        return null;
    }

    public List<TransitionDataControl> getTransitionDataControls() {
        return this.transitionDataControls;
    }

    public List<FrameDataControl> getFrameDataControls() {
        return this.frameDataControls;
    }

    public int indexOfFrame(Frame frame) {
        return this.animation.getFrames().indexOf(frame);
    }

    public int getFrameCount() {
        return this.frameDataControls.size();
    }

    public void addFrame(int n, Frame frame) {
        Controller.getInstance().addTool(new AddNewFrameTool(this, n, frame));
    }

    public void duplicateFrame(int n, Frame frame) {
        Controller.getInstance().addTool(new DuplicateFrameTool(this, n, frame));
    }

    public void moveFrameLeft(FrameDataControl frameDataControl) {
        Controller.getInstance().addTool(new MoveFrameLeftTool(this, frameDataControl));
    }

    public void moveFrameRight(FrameDataControl frameDataControl) {
        Controller.getInstance().addTool(new MoveFrameRightTool(this, frameDataControl));
    }

    public void deleteFrame(FrameDataControl frameDataControl) {
        Controller.getInstance().addTool(new DeleteFrameTool(this, frameDataControl));
    }

    private void createDataControls() {
        this.frameDataControls = new ArrayList<FrameDataControl>();
        this.transitionDataControls = new ArrayList<TransitionDataControl>();
        for (Frame frame : this.animation.getFrames()) {
            this.frameDataControls.add(new FrameDataControl(frame));
        }
        for (Frame frame : this.animation.getTransitions()) {
            this.transitionDataControls.add(new TransitionDataControl((Transition)frame));
        }
    }

    public String getImagePath(Component component) {
        boolean bl;
        String string = null;
        AssetChooser assetChooser = AssetsController.getAssetChooser(2, 0);
        int n = assetChooser.showAssetChooser(component);
        if (n == 4) {
            string = assetChooser.getSelectedAsset();
            string = AssetsController.getCategoryFolder(2) + "/" + string;
        } else if (n == 5 && (bl = AssetsController.addSingleAsset(8, assetChooser.getSelectedFile().getAbsolutePath()))) {
            string = assetChooser.getSelectedFile().getName();
            string = AssetsController.getCategoryFolder(8) + "/" + string;
        }
        return string;
    }

    public String getSoundPath(Component component) {
        boolean bl;
        String string = null;
        AssetChooser assetChooser = AssetsController.getAssetChooser(4, 0);
        int n = assetChooser.showAssetChooser(component);
        if (n == 4) {
            string = assetChooser.getSelectedAsset();
            string = AssetsController.getCategoryFolder(4) + "/" + string;
        } else if (n == 5 && (bl = AssetsController.addSingleAsset(10, assetChooser.getSelectedFile().getAbsolutePath()))) {
            string = assetChooser.getSelectedFile().getName();
            string = AssetsController.getCategoryFolder(10) + "/" + string;
        }
        return string;
    }

    @Override
    public boolean addElement(int n, String string) {
        return false;
    }

    @Override
    public boolean canAddElement(int n) {
        return false;
    }

    @Override
    public boolean canBeDeleted() {
        return false;
    }

    @Override
    public boolean canBeDuplicated() {
        return false;
    }

    @Override
    public boolean canBeMoved() {
        return false;
    }

    @Override
    public boolean canBeRenamed() {
        return false;
    }

    @Override
    public int countAssetReferences(String string) {
        return 0;
    }

    @Override
    public int countIdentifierReferences(String string) {
        return 0;
    }

    @Override
    public void deleteAssetReferences(String string) {
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        return false;
    }

    @Override
    public void deleteIdentifierReferences(String string) {
    }

    @Override
    public int[] getAddableElements() {
        return null;
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
    }

    @Override
    public Object getContent() {
        return this.animation;
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        return false;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        return false;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        return false;
    }

    @Override
    public void recursiveSearch() {
    }

    @Override
    public String renameElement(String string) {
        return null;
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        List<Searchable> list = this.getPathFromChild(searchable, this.frameDataControls);
        if (list != null) {
            return list;
        }
        list = this.getPathFromChild(searchable, this.transitionDataControls);
        return list;
    }

    public ImageLoaderFactory getImageLoaderFactory() {
        return this.animation.getImageLoaderFactory();
    }
}

