/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.adaptation;

import es.eucm.eadventure.common.data.HasTargetId;
import es.eucm.eadventure.common.data.adaptation.AdaptationProfile;
import es.eucm.eadventure.common.data.adaptation.AdaptationRule;
import es.eucm.eadventure.common.data.adaptation.AdaptedState;
import es.eucm.eadventure.common.data.adaptation.ContainsAdaptedState;
import es.eucm.eadventure.common.data.adaptation.UOLProperty;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.config.SCORMConfigData;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.tools.adaptation.AddActionTool;
import es.eucm.eadventure.editor.control.tools.adaptation.AddUOLPropertyTool;
import es.eucm.eadventure.editor.control.tools.adaptation.ChangeActionTool;
import es.eucm.eadventure.editor.control.tools.adaptation.ChangeUOLPropertyTool;
import es.eucm.eadventure.editor.control.tools.adaptation.ChangeVarFlagTool;
import es.eucm.eadventure.editor.control.tools.adaptation.DeleteActionTool;
import es.eucm.eadventure.editor.control.tools.adaptation.DeleteUOLPropertyTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeTargetIdTool;
import es.eucm.eadventure.editor.control.tools.generic.MoveObjectTool;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import es.eucm.eadventure.editor.gui.editdialogs.SCORMAttributeDialog;
import java.util.List;

public class AdaptationRuleDataControl
extends DataControl {
    private AdaptationRule adaptationRule;
    private AdaptationProfile profile;

    public AdaptationRuleDataControl(AdaptationRule adaptationRule, AdaptationProfile adaptationProfile) {
        this.adaptationRule = adaptationRule;
        this.profile = adaptationProfile;
    }

    @Override
    public boolean addElement(int n, String string) {
        return false;
    }

    @Override
    public boolean canAddElement(int n) {
        return false;
    }

    @Override
    public boolean canBeDeleted() {
        return true;
    }

    @Override
    public boolean canBeMoved() {
        return true;
    }

    @Override
    public boolean canBeRenamed() {
        return false;
    }

    @Override
    public int countAssetReferences(String string) {
        return 0;
    }

    @Override
    public int countIdentifierReferences(String string) {
        if (this.adaptationRule.getId().equals(string)) {
            return 1;
        }
        return 0;
    }

    @Override
    public void deleteAssetReferences(String string) {
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        return false;
    }

    @Override
    public void deleteIdentifierReferences(String string) {
    }

    @Override
    public int[] getAddableElements() {
        return new int[0];
    }

    @Override
    public Object getContent() {
        return this.adaptationRule;
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        return true;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        return false;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        return false;
    }

    @Override
    public String renameElement(String string) {
        return null;
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        for (String string : this.adaptationRule.getAdaptedState().getFlagsVars()) {
            if (this.isFlag(string)) {
                varFlagSummary.addFlagReference(string);
                continue;
            }
            varFlagSummary.addVarReference(string);
        }
    }

    public String getDescription() {
        return this.adaptationRule.getDescription();
    }

    public void setInitialScene(String string) {
        this.controller.addTool(new ChangeTargetIdTool((HasTargetId)this.adaptationRule.getAdaptedState(), string));
    }

    public String getInitialScene() {
        return this.adaptationRule.getAdaptedState().getTargetId();
    }

    private AdaptedState getGameState() {
        return this.adaptationRule.getAdaptedState();
    }

    public boolean moveUOLPropertyUp(int n) {
        return this.controller.addTool(new MoveObjectTool(this.adaptationRule.getUOLProperties(), n, 0));
    }

    public boolean moveUOLPropertyDown(int n) {
        return this.controller.addTool(new MoveObjectTool(this.adaptationRule.getUOLProperties(), n, 1));
    }

    public boolean addFlagAction(int n) {
        return this.controller.addTool(new AddActionTool(this.adaptationRule.getAdaptedState(), n));
    }

    public void deleteFlagAction(int n) {
        this.controller.addTool(new DeleteActionTool((ContainsAdaptedState)this.adaptationRule, n));
    }

    public int getFlagActionCount() {
        return this.adaptationRule.getAdaptedState().getFlagsVars().size();
    }

    public void setFlag(int n, String string) {
        this.controller.addTool(new ChangeActionTool((ContainsAdaptedState)this.adaptationRule, n, string, 2));
    }

    public void change(int n, String string) {
        this.controller.addTool(new ChangeVarFlagTool(this.adaptationRule.getAdaptedState(), n, string));
    }

    public String getFlag(int n) {
        return this.adaptationRule.getAdaptedState().getFlagVar(n);
    }

    public String getAction(int n) {
        return this.adaptationRule.getAdaptedState().getAction(n);
    }

    public boolean isFlag(int n) {
        return this.adaptationRule.getAdaptedState().isFlag(n);
    }

    public boolean isFlag(String string) {
        return this.adaptationRule.getAdaptedState().isFlag(string);
    }

    public String getId() {
        return this.adaptationRule.getId();
    }

    public void addBlankUOLProperty(int n) {
        this.controller.addTool(new AddUOLPropertyTool(this.adaptationRule, n));
    }

    public void deleteUOLProperty(int n) {
        this.controller.addTool(new DeleteUOLPropertyTool(this.adaptationRule, n));
    }

    public int getUOLPropertyCount() {
        return this.adaptationRule.getUOLProperties().size();
    }

    public void setUOLPropertyValue(int n, String string) {
        this.controller.addTool(new ChangeUOLPropertyTool(this.adaptationRule, string, n, 3));
    }

    public void setUOLPropertyId(int n, String string) {
        if (SCORMConfigData.isArrayAttribute(string)) {
            if (((UOLProperty)this.adaptationRule.getUOLProperties().get(n)).getId().startsWith(string)) {
                string = ((UOLProperty)this.adaptationRule.getUOLProperties().get(n)).getId();
            }
            string = SCORMAttributeDialog.showAttributeDialogForRead(this.getProfileType(), string);
        }
        if (!SCORMConfigData.isArrayAttribute(string)) {
            this.controller.addTool(new ChangeUOLPropertyTool(this.adaptationRule, string, n, 2));
        }
    }

    public void setUOLPropertyOp(int n, String string) {
        this.controller.addTool(new ChangeUOLPropertyTool(this.adaptationRule, string, n, 4));
    }

    public String getUOLPropertyId(int n) {
        return ((UOLProperty)this.adaptationRule.getUOLProperties().get(n)).getId();
    }

    public String getUOLPropertyValue(int n) {
        return ((UOLProperty)this.adaptationRule.getUOLProperties().get(n)).getValue();
    }

    public String getUOLPropertyOp(int n) {
        return ((UOLProperty)this.adaptationRule.getUOLProperties().get(n)).getOperation();
    }

    public void setAction(int n, String string) {
        this.controller.addTool(new ChangeActionTool((ContainsAdaptedState)this.adaptationRule, n, string, 3));
    }

    public int getValueToSet(int n) {
        if (this.adaptationRule.getAdaptedState().getValueToSet(n) == Integer.MIN_VALUE) {
            return 0;
        }
        return this.adaptationRule.getAdaptedState().getValueToSet(n);
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
    }

    @Override
    public boolean canBeDuplicated() {
        return true;
    }

    @Override
    public void recursiveSearch() {
        int n;
        this.check(this.getDescription(), TC.get((String)"Search.Description"));
        this.check(this.getId(), "ID");
        this.check(this.getInitialScene(), TC.get((String)"Search.InitialScene"));
        for (n = 0; n < this.getFlagActionCount(); ++n) {
            if (this.isFlag(n)) {
                this.check(this.getFlag(n), TC.get((String)"Search.Flag"));
            } else {
                this.check(this.getFlag(n), TC.get((String)"Search.Var"));
            }
            this.check(this.getAction(n), TC.get((String)"Search.ActionOverGameState"));
        }
        for (n = 0; n < this.getUOLPropertyCount(); ++n) {
            this.check(this.getUOLPropertyId(n), TC.get((String)"Search.LMSPropertyID"));
            this.check(this.getUOLPropertyValue(n), TC.get((String)"Search.LMSPropertyValue"));
        }
    }

    public int getProfileType() {
        if (this.profile.isScorm12().booleanValue()) {
            return 0;
        }
        if (this.profile.isScorm2004().booleanValue()) {
            return 1;
        }
        return -1;
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return null;
    }
}

