/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.adaptation;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.adaptation.AdaptationProfile;
import es.eucm.eadventure.common.data.adaptation.AdaptationRule;
import es.eucm.eadventure.common.data.adaptation.AdaptedState;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.adaptation.AdaptationProfileDataControl;
import es.eucm.eadventure.editor.control.controllers.adaptation.AdaptationRuleDataControl;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AdaptationProfilesDataControl
extends DataControl {
    private List<AdaptationProfileDataControl> profiles = new ArrayList<AdaptationProfileDataControl>();
    private List<AdaptationProfile> data;

    public AdaptationProfilesDataControl(List<AdaptationProfile> list) {
        this.data = list;
        for (AdaptationProfile adaptationProfile : list) {
            this.profiles.add(new AdaptationProfileDataControl(adaptationProfile));
        }
    }

    @Override
    public boolean addElement(int n, String string) {
        boolean bl = false;
        if (n == 41) {
            if (string == null) {
                string = this.controller.showInputDialog(TC.get((String)"Operation.CreateAdaptationFile.FileName"), TC.get((String)"Operation.CreateAdaptationFile.FileName.Message"), TC.get((String)"Operation.CreateAdaptationFile.FileName.DefaultValue"));
            }
            if (string != null && this.controller.isElementIdValid(string)) {
                Object object;
                int n2 = 1;
                while (this.controller.getIdentifierSummary().isAdaptationProfileId(string)) {
                    object = string.substring(string.length() - 1, string.length());
                    try {
                        Integer.parseInt((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                        string = string + n2;
                    }
                    string = string.substring(0, string.length() - 1);
                    string = string + n2;
                }
                object = new ArrayList();
                AdaptedState adaptedState = new AdaptedState();
                this.profiles.add(new AdaptationProfileDataControl((List<AdaptationRule>)object, adaptedState, string));
                this.data.add((AdaptationProfile)this.profiles.get(this.profiles.size() - 1).getContent());
                this.controller.getIdentifierSummary().addAdaptationProfileId(string);
                if (this.controller.getSelectedChapterDataControl().getAdaptationName() == null || this.controller.getSelectedChapterDataControl().getAdaptationName().equals("")) {
                    this.controller.getSelectedChapterDataControl().setAdaptationPath(string);
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean duplicateElement(DataControl dataControl) {
        if (!(dataControl instanceof AdaptationProfileDataControl)) {
            return false;
        }
        try {
            AdaptationProfile adaptationProfile = (AdaptationProfile)((AdaptationProfile)dataControl.getContent()).clone();
            String string = adaptationProfile.getName();
            int n = 1;
            do {
                string = adaptationProfile.getName() + n;
                ++n;
            } while (this.controller.getIdentifierSummary().isAdaptationProfileId(string));
            adaptationProfile.setName(string);
            this.profiles.add(new AdaptationProfileDataControl(adaptationProfile));
            this.data.add((AdaptationProfile)this.profiles.get(this.profiles.size() - 1).getContent());
            this.controller.getIdentifierSummary().addAdaptationProfileId(string);
            for (AdaptationRule adaptationRule : adaptationProfile.getRules()) {
                this.controller.getIdentifierSummary().addAdaptationRuleId(adaptationRule.getId(), string);
            }
            return true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ReportDialog.GenerateErrorReport((Exception)cloneNotSupportedException, (boolean)true, (String)"Could not clone adaptation profile");
            return false;
        }
    }

    @Override
    public String getDefaultId(int n) {
        return TC.get((String)"Operation.CreateAdaptationFile.FileName.DefaultValue");
    }

    @Override
    public boolean canAddElement(int n) {
        return n == 41;
    }

    @Override
    public boolean canBeDeleted() {
        return false;
    }

    @Override
    public boolean canBeMoved() {
        return false;
    }

    @Override
    public boolean canBeRenamed() {
        return false;
    }

    @Override
    public int countAssetReferences(String string) {
        return 0;
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
    }

    @Override
    public int countIdentifierReferences(String string) {
        int n = 0;
        for (AdaptationProfileDataControl adaptationProfileDataControl : this.profiles) {
            if (adaptationProfileDataControl.getName().equals(string)) {
                ++n;
            }
            n += adaptationProfileDataControl.countIdentifierReferences(string);
        }
        return n;
    }

    @Override
    public void deleteAssetReferences(String string) {
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        boolean bl2 = false;
        for (AdaptationProfileDataControl adaptationProfileDataControl : this.profiles) {
            if (dataControl != adaptationProfileDataControl) continue;
            String string = adaptationProfileDataControl.getName();
            int n = Controller.getInstance().countAssetReferences(string);
            if (bl && !this.controller.showStrictConfirmDialog(TC.get((String)"Operation.DeleteElementTitle"), TC.get((String)"Operation.DeleteElementWarning", (String[])new String[]{TC.getElement((int)41), Integer.toString(n)}))) continue;
            this.data.remove(this.profiles.indexOf(dataControl));
            bl2 = this.profiles.remove(dataControl);
            if (!bl2) continue;
            for (AdaptationRuleDataControl adaptationRuleDataControl : ((AdaptationProfileDataControl)dataControl).getAdaptationRules()) {
                this.controller.getIdentifierSummary().deleteAdaptationRuleId(adaptationRuleDataControl.getId(), adaptationProfileDataControl.getName());
            }
            this.controller.getIdentifierSummary().deleteAdaptationProfileId(adaptationProfileDataControl.getName());
            break;
        }
        return bl2;
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        Object var2_2 = null;
        AdaptationProfileDataControl adaptationProfileDataControl = null;
        Iterator<AdaptationProfileDataControl> iterator = this.profiles.iterator();
        while (iterator.hasNext()) {
            adaptationProfileDataControl = iterator.next();
            if (string.equals(adaptationProfileDataControl.getName())) {
                this.data.remove(this.profiles.indexOf(adaptationProfileDataControl));
                iterator.remove();
                continue;
            }
            adaptationProfileDataControl.deleteIdentifierReferences(string);
        }
    }

    @Override
    public int[] getAddableElements() {
        return new int[]{41};
    }

    @Override
    public Object getContent() {
        return this.profiles;
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        boolean bl = true;
        for (int i = 0; i < this.profiles.size(); ++i) {
            string = string + ">>" + i;
            AdaptationProfileDataControl adaptationProfileDataControl = this.profiles.get(i);
            bl &= adaptationProfileDataControl.isValid(string, list);
        }
        return bl;
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        boolean bl = false;
        int n = this.profiles.indexOf(dataControl);
        if (n < this.profiles.size() - 1) {
            this.profiles.add(n + 1, this.profiles.remove(n));
            this.data.add(n + 1, this.data.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        boolean bl = false;
        int n = this.profiles.indexOf(dataControl);
        if (n > 0) {
            this.profiles.add(n - 1, this.profiles.remove(n));
            this.data.add(n - 1, this.data.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public String renameElement(String string) {
        return null;
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        for (AdaptationProfileDataControl adaptationProfileDataControl : this.profiles) {
            if (adaptationProfileDataControl.getName().equals(string)) {
                adaptationProfileDataControl.renameElement(string2);
            }
            adaptationProfileDataControl.replaceIdentifierReferences(string, string2);
        }
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        for (AdaptationProfileDataControl adaptationProfileDataControl : this.profiles) {
            adaptationProfileDataControl.updateVarFlagSummary(varFlagSummary);
        }
    }

    public List<AdaptationProfileDataControl> getProfiles() {
        return this.profiles;
    }

    public AdaptationProfileDataControl getLastProfile() {
        return this.profiles.get(this.profiles.size() - 1);
    }

    @Override
    public boolean canBeDuplicated() {
        return false;
    }

    @Override
    public void recursiveSearch() {
        for (AdaptationProfileDataControl adaptationProfileDataControl : this.profiles) {
            ((Searchable)adaptationProfileDataControl).recursiveSearch();
        }
    }

    public boolean isScorm12Profile() {
        boolean bl = true;
        for (AdaptationProfileDataControl adaptationProfileDataControl : this.profiles) {
            bl &= adaptationProfileDataControl.isScorm12();
        }
        return bl;
    }

    public boolean isScorm2004Profile() {
        boolean bl = true;
        for (AdaptationProfileDataControl adaptationProfileDataControl : this.profiles) {
            bl &= adaptationProfileDataControl.isScorm2004();
        }
        return bl;
    }

    public AdaptationProfileDataControl getProfileByPath(String string) {
        for (AdaptationProfileDataControl adaptationProfileDataControl : this.profiles) {
            if (!adaptationProfileDataControl.getName().equals(string)) continue;
            return adaptationProfileDataControl;
        }
        return null;
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return this.getPathFromChild(searchable, this.profiles);
    }
}

