/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers.adaptation;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.HasTargetId;
import es.eucm.eadventure.common.data.adaptation.AdaptationProfile;
import es.eucm.eadventure.common.data.adaptation.AdaptationRule;
import es.eucm.eadventure.common.data.adaptation.AdaptedState;
import es.eucm.eadventure.common.data.adaptation.ContainsAdaptedState;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.adaptation.AdaptationRuleDataControl;
import es.eucm.eadventure.editor.control.tools.adaptation.AddActionTool;
import es.eucm.eadventure.editor.control.tools.adaptation.ChangeActionTool;
import es.eucm.eadventure.editor.control.tools.adaptation.ChangeAdaptationProfileTypeTool;
import es.eucm.eadventure.editor.control.tools.adaptation.ChangeVarFlagTool;
import es.eucm.eadventure.editor.control.tools.adaptation.DeleteActionTool;
import es.eucm.eadventure.editor.control.tools.adaptation.MoveRuleTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeTargetIdTool;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AdaptationProfileDataControl
extends DataControl {
    private List<AdaptationRuleDataControl> dataControls = new ArrayList<AdaptationRuleDataControl>();
    private AdaptationProfile profile;
    private int number = 0;

    public AdaptationProfileDataControl(List<AdaptationRule> list, AdaptedState adaptedState, String string) {
        this(new AdaptationProfile(list, adaptedState, string, false, false));
    }

    public AdaptationProfileDataControl(AdaptationProfile adaptationProfile) {
        if (adaptationProfile == null) {
            adaptationProfile = new AdaptationProfile();
        } else {
            this.profile = adaptationProfile;
        }
        if (adaptationProfile != null && adaptationProfile.getRules() != null) {
            for (AdaptationRule adaptationRule : adaptationProfile.getRules()) {
                adaptationRule.setId(this.generateId());
                this.dataControls.add(new AdaptationRuleDataControl(adaptationRule, this.profile));
            }
        }
    }

    private String generateId() {
        ++this.number;
        return "#" + this.number;
    }

    @Override
    public boolean addElement(int n, String string) {
        boolean bl = false;
        if (n == 39) {
            if (string == null) {
                string = this.controller.showInputDialog(TC.get((String)"Operation.AddAdaptationRuleTitle"), TC.get((String)"Operation.AddAdaptationRuleMessage"), TC.get((String)"Operation.AddAdaptationRuleDefaultValue"));
            }
            if (string != null && this.controller.isElementIdValid(string)) {
                AdaptationRule adaptationRule = new AdaptationRule();
                adaptationRule.setId(string);
                this.profile.addRule(adaptationRule);
                this.dataControls.add(new AdaptationRuleDataControl(adaptationRule, this.profile));
                this.controller.getIdentifierSummary().addAdaptationRuleId(string, this.profile.getName());
                bl = true;
            }
        }
        return bl;
    }

    public DataControl getLastDatacontrol() {
        return this.dataControls.get(this.dataControls.size() - 1);
    }

    public boolean addElement(int n, String string, AdaptationRule adaptationRule) {
        boolean bl = false;
        if (n == 39 && string != null && this.controller.isElementIdValid(string)) {
            this.profile.addRule(adaptationRule);
            this.dataControls.add(new AdaptationRuleDataControl(adaptationRule, this.profile));
            this.controller.getIdentifierSummary().addAdaptationRuleId(string, this.profile.getName());
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean canAddElement(int n) {
        return n == 39;
    }

    @Override
    public boolean canBeDeleted() {
        return true;
    }

    @Override
    public boolean canBeMoved() {
        return true;
    }

    @Override
    public boolean canBeRenamed() {
        return true;
    }

    @Override
    public int countAssetReferences(String string) {
        return 0;
    }

    @Override
    public void getAssetReferences(List<String> list, List<Integer> list2) {
    }

    @Override
    public int countIdentifierReferences(String string) {
        int n = 0;
        if (string.equals(this.profile.getName())) {
            ++n;
        }
        for (AdaptationRuleDataControl adaptationRuleDataControl : this.dataControls) {
            n += adaptationRuleDataControl.countIdentifierReferences(string);
        }
        return n;
    }

    @Override
    public void deleteAssetReferences(String string) {
    }

    @Override
    public boolean deleteElement(DataControl dataControl, boolean bl) {
        boolean bl2 = false;
        String string = ((AdaptationRuleDataControl)dataControl).getId();
        String string2 = String.valueOf(this.controller.countIdentifierReferences(string));
        if ((!bl || this.controller.showStrictConfirmDialog(TC.get((String)"Operation.DeleteElementTitle"), TC.get((String)"Operation.DeleteElementWarning", (String[])new String[]{string, string2}))) && this.profile.getRules().remove(dataControl.getContent())) {
            this.dataControls.remove(dataControl);
            this.controller.deleteIdentifierReferences(string);
            this.controller.getIdentifierSummary().deleteAdaptationRuleId(string, this.profile.getName());
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public void deleteIdentifierReferences(String string) {
        Iterator<AdaptationRuleDataControl> iterator = this.dataControls.iterator();
        while (iterator.hasNext()) {
            iterator.next().deleteIdentifierReferences(string);
        }
    }

    @Override
    public int[] getAddableElements() {
        return new int[]{39};
    }

    @Override
    public Object getContent() {
        return this.profile;
    }

    public List<AdaptationRuleDataControl> getAdaptationRules() {
        return this.dataControls;
    }

    @Override
    public boolean isValid(String string, List<String> list) {
        return true;
    }

    public boolean moveElementDown(AdaptationRuleDataControl adaptationRuleDataControl) {
        return this.controller.addTool(new MoveRuleTool(this, adaptationRuleDataControl, 1));
    }

    public boolean moveElementUp(AdaptationRuleDataControl adaptationRuleDataControl) {
        return this.controller.addTool(new MoveRuleTool(this, adaptationRuleDataControl, 0));
    }

    @Override
    public boolean moveElementDown(DataControl dataControl) {
        boolean bl = false;
        int n = this.profile.getRules().indexOf(dataControl.getContent());
        if (n < this.profile.getRules().size() - 1) {
            this.profile.getRules().add(n + 1, this.profile.getRules().remove(n));
            this.dataControls.add(n + 1, this.dataControls.remove(n));
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean moveElementUp(DataControl dataControl) {
        boolean bl = false;
        int n = this.profile.getRules().indexOf(dataControl.getContent());
        if (n > 0) {
            this.profile.getRules().add(n - 1, this.profile.getRules().remove(n));
            this.dataControls.add(n - 1, this.dataControls.remove(n));
            bl = true;
        }
        return bl;
    }

    public String getFileName() {
        return this.profile.getName().substring(Math.max(this.profile.getName().lastIndexOf("/"), this.profile.getName().lastIndexOf("\\")) + 1);
    }

    @Override
    public String renameElement(String string) {
        boolean bl = false;
        String string2 = null;
        if (this.profile.getName() != null) {
            string2 = this.profile.getName();
        }
        if (string != null || this.controller.showStrictConfirmDialog(TC.get((String)"Operation.RenameAssessmentFile"), TC.get((String)"Operation.RenameAssessmentFile.Message"))) {
            String string3 = string;
            if (string == null || string.equals("")) {
                string3 = this.controller.showInputDialog(TC.get((String)"Operation.RenameAssessmentFile.FileName"), TC.get((String)"Operation.RenameAssessmentFile.FileName.Message"), this.getFileName());
            }
            if (string3 != null && !string3.equals(string2) && this.controller.isElementIdValid(string3)) {
                if (!this.controller.getIdentifierSummary().isAdaptationProfileId(string)) {
                    this.profile.setName(string3);
                    this.controller.getIdentifierSummary().renameAdaptationProfile(string2, string3);
                    bl = true;
                } else {
                    this.controller.showErrorDialog(TC.get((String)"Operation.CreateAdaptationFile.FileName.ExistValue.Title"), TC.get((String)"Operation.CreateAdaptationFile.FileName.ExistValue.Message"));
                }
            }
        }
        if (bl) {
            return string2;
        }
        return null;
    }

    @Override
    public void replaceIdentifierReferences(String string, String string2) {
        for (AdaptationRuleDataControl adaptationRuleDataControl : this.dataControls) {
            if (!adaptationRuleDataControl.getId().equals(string)) continue;
            adaptationRuleDataControl.renameElement(string2);
        }
    }

    @Override
    public void updateVarFlagSummary(VarFlagSummary varFlagSummary) {
        for (AdaptationRuleDataControl object : this.dataControls) {
            object.updateVarFlagSummary(varFlagSummary);
        }
        if (this.profile != null && this.profile.getAdaptedState() != null) {
            for (String string : this.profile.getAdaptedState().getFlagsVars()) {
                if (this.profile.getAdaptedState().isFlag(string)) {
                    varFlagSummary.addFlagReference(string);
                    continue;
                }
                varFlagSummary.addVarReference(string);
            }
        }
    }

    @Override
    public boolean duplicateElement(DataControl dataControl) {
        if (!(dataControl instanceof AdaptationRuleDataControl)) {
            return false;
        }
        try {
            String string = this.generateId();
            AdaptationRule adaptationRule = (AdaptationRule)((AdaptationRule)dataControl.getContent()).clone();
            adaptationRule.setId(string);
            this.dataControls.add(new AdaptationRuleDataControl(adaptationRule, this.profile));
            this.profile.addRule(adaptationRule);
            this.controller.getIdentifierSummary().addAdaptationRuleId(adaptationRule.getId(), this.profile.getName());
            return true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ReportDialog.GenerateErrorReport((Exception)cloneNotSupportedException, (boolean)true, (String)"Could not clone adaptation rule");
            return false;
        }
    }

    public AdaptedState getInitialState() {
        return this.profile.getAdaptedState();
    }

    public void setInitialScene(String string) {
        if (this.profile.getAdaptedState() == null) {
            this.profile.setAdaptedState(new AdaptedState());
        }
        this.controller.addTool(new ChangeTargetIdTool((HasTargetId)this.profile.getAdaptedState(), string));
    }

    public String getInitialScene() {
        if (this.profile.getAdaptedState() == null) {
            return null;
        }
        return this.profile.getAdaptedState().getTargetId();
    }

    public boolean addFlagAction(int n) {
        return this.controller.addTool(new AddActionTool(this.profile.getAdaptedState(), n));
    }

    public void deleteFlagAction(int n) {
        this.controller.addTool(new DeleteActionTool((ContainsAdaptedState)this.profile, n));
    }

    public int getFlagActionCount() {
        return this.profile.getAdaptedState().getFlagsVars().size();
    }

    public void setFlag(int n, String string) {
        this.controller.addTool(new ChangeActionTool((ContainsAdaptedState)this.profile, n, string, 2));
    }

    public void setAction(int n, String string) {
        this.controller.addTool(new ChangeActionTool((ContainsAdaptedState)this.profile, n, string, 3));
    }

    public String getFlag(int n) {
        return this.profile.getAdaptedState().getFlagVar(n);
    }

    public String getAction(int n) {
        return this.profile.getAdaptedState().getAction(n);
    }

    public int getValueToSet(int n) {
        if (this.profile.getAdaptedState().getValueToSet(n) == Integer.MIN_VALUE) {
            return 0;
        }
        return this.profile.getAdaptedState().getValueToSet(n);
    }

    public String[][] getAdaptationRulesInfo() {
        String[][] stringArray = new String[this.profile.getRules().size()][4];
        for (int i = 0; i < this.profile.getRules().size(); ++i) {
            stringArray[i][0] = ((AdaptationRule)this.profile.getRules().get(i)).getId();
            stringArray[i][1] = String.valueOf(((AdaptationRule)this.profile.getRules().get(i)).getUOLProperties().size());
            stringArray[i][2] = ((AdaptationRule)this.profile.getRules().get(i)).getAdaptedState().getTargetId() == null ? "<Not selected>" : ((AdaptationRule)this.profile.getRules().get(i)).getAdaptedState().getTargetId();
            stringArray[i][3] = String.valueOf(((AdaptationRule)this.profile.getRules().get(i)).getAdaptedState().getFlagsVars().size());
        }
        return stringArray;
    }

    public String getName() {
        return this.profile.getName();
    }

    @Override
    public boolean canBeDuplicated() {
        return true;
    }

    @Override
    public void recursiveSearch() {
        for (AdaptationRuleDataControl adaptationRuleDataControl : this.dataControls) {
            ((Searchable)adaptationRuleDataControl).recursiveSearch();
        }
        this.check("" + this.number, TC.get((String)"Search.Number"));
        this.check(this.getFileName(), TC.get((String)"Search.Name"));
        this.check(this.getInitialScene(), TC.get((String)"Search.InitialScene"));
        for (int i = 0; i < this.getFlagActionCount(); ++i) {
            if (this.isFlag(i)) {
                this.check(this.getFlag(i), TC.get((String)"Search.Flag"));
            } else {
                this.check(this.getFlag(i), TC.get((String)"Search.Var"));
            }
            this.check(this.getAction(i), TC.get((String)"Search.ActionOverGameState"));
        }
    }

    public void change(int n, String string) {
        this.controller.addTool(new ChangeVarFlagTool(this.profile.getAdaptedState(), n, string));
    }

    public boolean isFlag(int n) {
        return this.profile.getAdaptedState().isFlag(n);
    }

    public boolean isScorm2004() {
        return this.profile.isScorm2004();
    }

    public boolean isScorm12() {
        return this.profile.isScorm12();
    }

    public void changeToScorm2004Profile() {
        this.controller.addTool(new ChangeAdaptationProfileTypeTool(this.profile, 2, this.profile.isScorm12(), this.profile.isScorm2004()));
    }

    public void changeToScorm12Profile() {
        this.controller.addTool(new ChangeAdaptationProfileTypeTool(this.profile, 1, this.profile.isScorm12(), this.profile.isScorm2004()));
    }

    public void changeToNormalProfile() {
        this.controller.addTool(new ChangeAdaptationProfileTypeTool(this.profile, 0, this.profile.isScorm12(), this.profile.isScorm2004()));
    }

    @Override
    public List<Searchable> getPathToDataControl(Searchable searchable) {
        return this.getPathFromChild(searchable, this.dataControls);
    }

    public List<AdaptationRuleDataControl> getDataControls() {
        return this.dataControls;
    }

    public void setDataControlsAndData(List<AdaptationRuleDataControl> list) {
        this.dataControls = list;
        ArrayList<AdaptationRule> arrayList = new ArrayList<AdaptationRule>();
        for (AdaptationRuleDataControl adaptationRuleDataControl : list) {
            arrayList.add((AdaptationRule)adaptationRuleDataControl.getContent());
        }
        this.profile.setRules(arrayList);
    }
}

