/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.util.ArrayList;

public class VarFlagsController {
    private Controller controller = Controller.getInstance();
    private VarFlagSummary varFlagSummary;

    public VarFlagsController(VarFlagSummary varFlagSummary) {
        this.varFlagSummary = varFlagSummary;
    }

    public int getFlagCount() {
        return this.varFlagSummary.getFlagCount();
    }

    public int getVarCount() {
        return this.varFlagSummary.getVarCount();
    }

    public String getFlag(int n) {
        return this.varFlagSummary.getFlag(n);
    }

    public String getVar(int n) {
        return this.varFlagSummary.getVar(n);
    }

    public boolean existsFlag(String string) {
        return this.varFlagSummary.existsFlag(string);
    }

    public boolean existsVar(String string) {
        return this.varFlagSummary.existsVar(string);
    }

    public boolean existsId(String string) {
        return this.varFlagSummary.existsId(string);
    }

    public int getFlagReferences(int n) {
        return this.varFlagSummary.getFlagReferences(n);
    }

    public int getVarReferences(int n) {
        return this.varFlagSummary.getVarReferences(n);
    }

    public String addShortCutFlagVar(boolean bl, String string) {
        String string2 = null;
        if (string == null || string.contains(" ") || string.equals("")) {
            if (bl) {
                this.controller.showErrorDialog(TC.get((String)"Flags.AddFlag"), TC.get((String)"Flags.ErrorFlagWhitespaces"));
            } else {
                this.controller.showErrorDialog(TC.get((String)"Vars.AddVar"), TC.get((String)"Vars.ErrorVarWhitespaces"));
            }
        } else {
            String[] stringArray = null;
            stringArray = bl ? this.getSimilarFlags(string) : this.getSimilarVars(string);
            if (stringArray.length == 0) {
                if (bl) {
                    Controller.getInstance().getVarFlagSummary().addFlag(string);
                } else {
                    Controller.getInstance().getVarFlagSummary().addVar(string);
                }
                string2 = string;
            } else {
                Object[] objectArray = new String[stringArray.length + 1];
                objectArray[0] = string + " (" + TC.get((String)"GeneralText.New") + ")";
                for (int i = 1; i < objectArray.length; ++i) {
                    objectArray[i] = stringArray[i - 1];
                }
                String string3 = null;
                string3 = bl ? Controller.getInstance().showInputDialog(TC.get((String)"Flags.ConfirmNewFlag.Title"), TC.get((String)"Flags.ConfirmNewFlag.Text"), objectArray) : Controller.getInstance().showInputDialog(TC.get((String)"Vars.ConfirmNewVar.Title"), TC.get((String)"Vars.ConfirmNewVar.Text"), objectArray);
                if (string3 != null) {
                    if (string3.equals(string + " (" + TC.get((String)"GeneralText.New") + ")")) {
                        string2 = string;
                        if (bl) {
                            Controller.getInstance().getVarFlagSummary().addFlag(string);
                        } else {
                            Controller.getInstance().getVarFlagSummary().addVar(string);
                        }
                    } else {
                        string2 = string3;
                        if (bl) {
                            Controller.getInstance().getVarFlagSummary().addFlag(string3);
                        } else {
                            Controller.getInstance().getVarFlagSummary().addVar(string3);
                        }
                    }
                }
            }
        }
        return string2;
    }

    public boolean addVarFlag(boolean bl) {
        boolean bl2 = false;
        String string = null;
        string = bl ? this.controller.showInputDialog(TC.get((String)"Flags.AddFlag"), TC.get((String)"Flags.AddFlagMessage"), TC.get((String)"Flags.DefaultFlagId")) : this.controller.showInputDialog(TC.get((String)"Vars.AddVar"), TC.get((String)"Vars.AddVarMessage"), TC.get((String)"Vars.DefaultVarId"));
        if (string != null) {
            if (!string.contains(" ")) {
                if (!this.varFlagSummary.existsId(string)) {
                    bl2 = bl ? this.varFlagSummary.addFlag(string) : this.varFlagSummary.addVar(string);
                } else {
                    this.controller.showErrorDialog(TC.get((String)"Ids.AddId"), TC.get((String)"Ids.ErrorIdAlreadyExists"));
                }
            } else {
                this.controller.showErrorDialog(TC.get((String)"Ids.AddId"), TC.get((String)"Ids.ErrorIdWhitespaces"));
            }
        }
        return bl2;
    }

    public boolean deleteFlag(int n) {
        boolean bl = false;
        if (this.varFlagSummary.getFlagReferences(n) == 0) {
            bl = this.varFlagSummary.deleteFlag(this.varFlagSummary.getFlag(n));
        } else {
            this.controller.showErrorDialog(TC.get((String)"Flags.DeleteFlag"), TC.get((String)"Flags.ErrorFlagWithReferences"));
        }
        return bl;
    }

    public boolean deleteVar(int n) {
        boolean bl = false;
        if (this.varFlagSummary.getVarReferences(n) == 0) {
            bl = this.varFlagSummary.deleteVar(this.varFlagSummary.getVar(n));
        } else {
            this.controller.showErrorDialog(TC.get((String)"Vars.DeleteVar"), TC.get((String)"Vars.ErrorVarWithReferences"));
        }
        return bl;
    }

    public String[] getSimilarFlags(String string) {
        return this.getSimilarIds(string, this.varFlagSummary.getFlags());
    }

    public String[] getSimilarVars(String string) {
        return this.getSimilarIds(string, this.varFlagSummary.getVars());
    }

    private String[] getSimilarIds(String string, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        block0: for (String string2 : stringArray) {
            for (SimilarityCriterium similarityCriterium : SCSummary.getCriteriums()) {
                if (!similarityCriterium.areSimilar(string, string2)) continue;
                arrayList.add(string2);
                continue block0;
            }
        }
        return arrayList.toArray(new String[0]);
    }

    private static class Criterium3
    implements SimilarityCriterium {
        private Criterium3() {
        }

        @Override
        public boolean areSimilar(String string, String string2) {
            return string.startsWith(string2) || string2.startsWith(string) || string.endsWith(string2) || string2.endsWith(string) || string.contains(string2) || string2.contains(string);
        }
    }

    private static class Criterium2
    implements SimilarityCriterium {
        private Criterium2() {
        }

        @Override
        public boolean areSimilar(String string, String string2) {
            char[] cArray = string.toCharArray();
            char[] cArray2 = string2.toCharArray();
            int n = 0;
            for (int i = 0; i < Math.max(cArray.length, cArray2.length); ++i) {
                if (i < cArray.length && i < cArray2.length && cArray[i] == cArray2[i]) continue;
                ++n;
            }
            return n <= 2;
        }
    }

    private static class Criterium1
    implements SimilarityCriterium {
        private Criterium1() {
        }

        @Override
        public boolean areSimilar(String string, String string2) {
            char[] cArray = string.toCharArray();
            char[] cArray2 = string2.toCharArray();
            int n = 0;
            for (int i = 0; i < Math.min(cArray.length, cArray2.length); ++i) {
                if (cArray[i] != cArray2[i]) continue;
                ++n;
            }
            return (float)n / (float)Math.max(cArray.length, cArray2.length) > 0.8f;
        }
    }

    private static interface SimilarityCriterium {
        public boolean areSimilar(String var1, String var2);
    }

    private static class SCSummary {
        private SCSummary() {
        }

        public static SimilarityCriterium[] getCriteriums() {
            return new SimilarityCriterium[]{new Criterium1(), new Criterium2(), new Criterium3()};
        }
    }
}

