/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers;

import es.eucm.eadventure.common.data.chapter.Trajectory;
import es.eucm.eadventure.editor.control.controllers.NormalScenePreviewEditionController;
import es.eucm.eadventure.editor.control.controllers.scene.NodeDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.SideDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.TrajectoryDataControl;
import es.eucm.eadventure.editor.gui.otherpanels.ScenePreviewEditionPanel;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElement;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElementNode;
import java.awt.event.MouseEvent;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TrajectoryScenePreviewEditionController
extends NormalScenePreviewEditionController {
    public static final int NODE_EDIT = 0;
    public static final int SIDE_EDIT = 1;
    public static final int DELETE_TOOL = 2;
    public static final int EDIT_BARRIERS = 3;
    public static final int SELECT_INITIAL = 4;
    private TrajectoryDataControl tdc;
    private int selectedTool = 0;
    private JSpinner spinner;

    public TrajectoryScenePreviewEditionController(ScenePreviewEditionPanel scenePreviewEditionPanel, TrajectoryDataControl trajectoryDataControl) {
        super(scenePreviewEditionPanel);
        this.spep = scenePreviewEditionPanel;
        this.tdc = trajectoryDataControl;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.spep.getRealX(mouseEvent.getX());
        int n2 = this.spep.getRealY(mouseEvent.getY());
        this.setMouseUnder(mouseEvent.getX(), mouseEvent.getY());
        if (this.spinner != null) {
            this.spep.removeComponent(this.spinner);
            this.spep.repaint();
            this.spinner = null;
            return;
        }
        if (this.selectedTool == 0) {
            if (this.underMouse == null) {
                this.tdc.addNode(n, n2);
                this.spep.addNode(this.tdc.getLastNode());
                this.spep.setTrajectory((Trajectory)this.tdc.getContent());
                this.spep.repaint();
            } else {
                this.spep.setSelectedElement(this.underMouse);
                this.spep.repaint();
            }
        } else if (this.selectedTool == 2) {
            if (this.underMouse != null) {
                NodeDataControl nodeDataControl = ((ImageElementNode)this.underMouse).getNodeDataControl();
                if (this.tdc.deleteElement(nodeDataControl, true)) {
                    this.spep.removeElement(8, this.underMouse);
                    this.underMouse = null;
                    this.spep.setSelectedElement((ImageElement)null);
                    this.spep.setTrajectory((Trajectory)this.tdc.getContent());
                    this.spep.repaint();
                }
            } else {
                this.findAndDeleteSide(n, n2);
            }
        } else if (this.selectedTool == 1) {
            for (final SideDataControl sideDataControl : this.tdc.getSides()) {
                NodeDataControl nodeDataControl = sideDataControl.getStart();
                NodeDataControl nodeDataControl2 = sideDataControl.getEnd();
                int n3 = nodeDataControl.getX() + (nodeDataControl2.getX() - nodeDataControl.getX()) / 2;
                int n4 = nodeDataControl.getY() + (nodeDataControl2.getY() - nodeDataControl.getY()) / 2;
                if (n3 + 30 <= n || n3 - 30 >= n || n4 + 20 <= n2 || n4 - 20 >= n2) continue;
                this.spinner = new JSpinner(new SpinnerNumberModel(sideDataControl.getLength(), 1, 2000, 1));
                this.spinner.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        sideDataControl.setLength((Integer)((JSpinner)changeEvent.getSource()).getValue());
                        TrajectoryScenePreviewEditionController.this.spep.repaint();
                    }
                });
                this.spep.addComponent(this.spinner, n3, n4);
                this.spep.repaint();
                return;
            }
            if (this.underMouse != null) {
                if (this.spep.getFirstElement() == null) {
                    this.spep.setFirstElement(this.underMouse);
                } else {
                    this.tdc.addSide(((ImageElementNode)this.spep.getFirstElement()).getNodeDataControl(), ((ImageElementNode)this.underMouse).getNodeDataControl());
                    this.spep.setFirstElement(null);
                    this.spep.repaint();
                }
            }
        } else if (this.selectedTool == 3) {
            super.mouseClicked(mouseEvent);
        } else if (this.selectedTool == 4 && this.underMouse != null) {
            this.tdc.setInitialNode(((ImageElementNode)this.underMouse).getNodeDataControl());
            this.spep.recreateElements(8);
            this.spep.repaint();
        }
    }

    private void findAndDeleteSide(int n, int n2) {
        SideDataControl sideDataControl = null;
        SideDataControl sideDataControl2 = null;
        for (int i = 0; i < this.tdc.getSides().size() && sideDataControl == null; ++i) {
            sideDataControl2 = this.tdc.getSides().get(i);
            NodeDataControl nodeDataControl = sideDataControl2.getStart();
            NodeDataControl nodeDataControl2 = sideDataControl2.getEnd();
            int n3 = nodeDataControl.getX();
            int n4 = nodeDataControl.getY();
            int n5 = nodeDataControl2.getX();
            int n6 = nodeDataControl2.getY();
            if (n3 > n5) {
                n5 = nodeDataControl.getX();
                n6 = nodeDataControl.getY();
                n3 = nodeDataControl2.getX();
                n4 = nodeDataControl2.getY();
            }
            int n7 = n5 - n3;
            for (int j = 0; j < n7 && sideDataControl == null; ++j) {
                int n8 = (int)((float)n3 + (float)(n5 - n3) * ((float)j / (float)n7));
                int n9 = (int)((float)n4 + (float)(n6 - n4) * ((float)j / (float)n7));
                if (Math.abs(n8 - n) >= 8 || Math.abs(n9 - n2) >= 8) continue;
                sideDataControl = sideDataControl2;
            }
        }
        if (sideDataControl != null) {
            this.tdc.deleteElement(sideDataControl, true);
            this.spep.setTrajectory((Trajectory)this.tdc.getContent());
            this.spep.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.selectedTool == 0) {
            this.setMouseUnder(mouseEvent.getX(), mouseEvent.getY());
            if (this.underMouse != null) {
                this.startDragX = mouseEvent.getX();
                this.startDragY = mouseEvent.getY();
                this.originalX = this.underMouse.getX();
                this.originalY = this.underMouse.getY();
                this.originalWidth = this.underMouse.getImage().getWidth(null);
                this.originalHeight = this.underMouse.getImage().getHeight(null);
                this.originalScale = this.underMouse.getScale();
            } else if (this.underMouse != null) {
                this.spep.setSelectedElement(this.underMouse);
                this.spep.repaint();
            }
        } else if (this.selectedTool == 3) {
            super.mousePressed(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.selectedTool == 0) {
            if (this.underMouse != null && !this.spep.isRescale()) {
                int n = this.spep.getRealWidth(mouseEvent.getX() - this.startDragX);
                int n2 = this.spep.getRealHeight(mouseEvent.getY() - this.startDragY);
                int n3 = this.originalX + n;
                int n4 = this.originalY + n2;
                this.underMouse.changePosition(n3, n4);
                this.spep.repaint();
            } else if (this.underMouse != null && this.spep.isRescale()) {
                double d = mouseEvent.getX() - this.startDragX;
                double d2 = -(mouseEvent.getY() - this.startDragY);
                double d3 = (float)this.originalWidth / this.originalScale;
                double d4 = (float)(this.originalHeight - 10) / this.originalScale;
                double d5 = d / d3;
                double d6 = d2 / d4;
                float f = this.originalScale;
                f = d5 * d5 > d6 * d6 ? (float)((d3 * (double)this.originalScale + (double)this.spep.getRealWidth((int)d)) / d3) : (float)((d4 * (double)this.originalScale + (double)this.spep.getRealHeight((int)d2)) / d4);
                if (f <= 0.0f) {
                    f = 0.01f;
                }
                this.underMouse.setScale(f);
                this.underMouse.recreateImage();
                this.spep.repaint();
            }
        } else if (this.selectedTool == 3) {
            super.mouseDragged(mouseEvent);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.setMouseUnder(mouseEvent.getX(), mouseEvent.getY());
        if (this.spep.getFirstElement() != null) {
            this.spep.repaint();
        }
    }

    @Override
    public ImageElement getUnderMouse() {
        return this.underMouse;
    }

    public void setSelectedTool(int n) {
        this.selectedTool = n;
        this.spep.setFirstElement(null);
        if (this.selectedTool == 3) {
            this.spep.setMovableCategory(4, true);
        } else {
            this.spep.setMovableCategory(4, false);
        }
    }
}

