/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers;

import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;
import java.util.ArrayList;
import java.util.List;

public class ToolManager {
    private List<Tool> undoList = new ArrayList<Tool>();
    private List<Tool> redoList = new ArrayList<Tool>();
    private boolean notifyController;

    public ToolManager(boolean bl) {
        this.notifyController = bl;
    }

    public boolean addTool(Tool tool) {
        return this.addTool(true, tool);
    }

    public boolean addTool(boolean bl, Tool tool) {
        boolean bl2;
        boolean bl3 = bl2 = bl ? tool.doTool() : true;
        if (bl2) {
            if (this.undoList.size() == 0) {
                this.undoList.add(tool);
            } else {
                Tool tool2 = this.undoList.get(this.undoList.size() - 1);
                if (tool2.getTimeStamp() < tool.getTimeStamp() - 1500L || !tool2.combine(tool)) {
                    this.undoList.add(tool);
                }
            }
            this.redoList.clear();
            if (this.notifyController) {
                Controller.getInstance().dataModified();
            }
            if (!tool.canUndo()) {
                this.undoList.clear();
            }
        }
        return bl2;
    }

    public boolean undoTool() {
        Tool tool;
        boolean bl;
        if (this.undoList.size() > 0 && (bl = (tool = this.undoList.remove(this.undoList.size() - 1)).undoTool())) {
            if (tool.canRedo()) {
                this.redoList.add(tool);
            } else {
                this.redoList.clear();
            }
            return true;
        }
        return false;
    }

    public boolean redoTool() {
        if (this.redoList.size() > 0) {
            Tool tool = this.redoList.remove(this.redoList.size() - 1);
            boolean bl = tool.redoTool();
            if (bl) {
                this.undoList.add(tool);
                if (!tool.canUndo()) {
                    this.undoList.clear();
                }
            }
            return bl;
        }
        return false;
    }

    public void clear() {
        this.undoList.clear();
        this.redoList.clear();
    }

    public List<Tool> getUndoList() {
        return this.undoList;
    }

    public List<Tool> getRedoList() {
        return this.redoList;
    }
}

