/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.config.ProjectConfigData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class SelectedEffectsController {
    private static final int NUMBER_OF_EFFECTS = 25;
    private static final String ACTIVATE = "ACTIVATE";
    private static final String DEACTIVATE = "DEACTIVATE";
    private static final String INCREMENT = "INCREMENT";
    private static final String DECREMENT = "DECREMENT";
    private static final String SETVALUE = "SETVALUE";
    private static final String MACRO = "MACRO";
    private static final String CONSUME = "CONSUME";
    private static final String GENERATE = "GENERATE";
    private static final String CANCEL = "CANCEL";
    private static final String SPPLAYER = "SPPLAYER";
    private static final String SPNPC = "SPNPC";
    private static final String BOOK = "BOOK";
    private static final String SOUND = "SOUND";
    private static final String ANIMATION = "ANIMATION";
    private static final String MVPLAYER = "MVPLAYER";
    private static final String MVNPC = "MVNPC";
    private static final String CONVERSATION = "CONVERSATION";
    private static final String CUTSCENE = "CUTSCENE";
    private static final String SCENE = "SCENE";
    private static final String LASTSCENE = "LASTSCENE";
    private static final String RANDOM = "RANDOM";
    private static final String SHOWTEXT = "SHOWTEXT";
    private static final String WAITTIME = "WAITTIME";
    private static final String HIGHLIGHT = "HIGHLIGHT";
    private static final String MOVE_OBJECT = "MOVEOBJECT";
    private HashMap<String, ListElement> selectedEffects;

    public SelectedEffectsController() {
        this.init();
    }

    public ListElement[] getMostVisiteEffects(int n) {
        ArrayList<ListElement> arrayList = new ArrayList<ListElement>(this.selectedEffects.values());
        Collections.sort(arrayList);
        ListElement[] listElementArray = n >= 1 && n <= 25 ? new ListElement[n] : new ListElement[25];
        for (int i = 0; i < listElementArray.length; ++i) {
            listElementArray[i] = arrayList.get(25 - i - 1);
        }
        return listElementArray;
    }

    public static String[] getAllEffectTypes() {
        return new String[]{ACTIVATE, DEACTIVATE, INCREMENT, DECREMENT, SETVALUE, MACRO, CONSUME, GENERATE, CANCEL, SPPLAYER, SPNPC, BOOK, SOUND, ANIMATION, MVPLAYER, MVNPC, CONVERSATION, CUTSCENE, SCENE, LASTSCENE, RANDOM, SHOWTEXT, WAITTIME, HIGHLIGHT, MOVE_OBJECT};
    }

    private void init() {
        String[] stringArray = new String[]{ACTIVATE, DEACTIVATE, INCREMENT, DECREMENT, SETVALUE, MACRO, CONSUME, GENERATE, CANCEL, SPPLAYER, SPNPC, BOOK, SOUND, ANIMATION, MVPLAYER, MVNPC, CONVERSATION, CUTSCENE, SCENE, LASTSCENE, RANDOM, SHOWTEXT, WAITTIME, HIGHLIGHT, MOVE_OBJECT};
        this.selectedEffects = new HashMap();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = ProjectConfigData.getProperty(stringArray[i]);
            if (string != null) {
                this.selectedEffects.put(stringArray[i], new ListElement(stringArray[i], Integer.parseInt(string)));
                continue;
            }
            this.selectedEffects.put(stringArray[i], new ListElement(stringArray[i], new Integer(0)));
        }
    }

    public void addSelectedEffect(String string) {
        int n = this.selectedEffects.get(string).getValue();
        this.selectedEffects.put(string, new ListElement(string, n + 1));
    }

    public static String convertNames(String string) {
        if (string.equals(TC.get((String)"Effect.Activate"))) {
            return ACTIVATE;
        }
        if (string.equals(TC.get((String)"Effect.Deactivate"))) {
            return DEACTIVATE;
        }
        if (string.equals(TC.get((String)"Effect.SetValue"))) {
            return SETVALUE;
        }
        if (string.equals(TC.get((String)"Effect.IncrementVar"))) {
            return INCREMENT;
        }
        if (string.equals(TC.get((String)"Effect.DecrementVar"))) {
            return DECREMENT;
        }
        if (string.equals(TC.get((String)"Effect.MacroReference"))) {
            return MACRO;
        }
        if (string.equals(TC.get((String)"Effect.ConsumeObject"))) {
            return CONSUME;
        }
        if (string.equals(TC.get((String)"Effect.GenerateObject"))) {
            return GENERATE;
        }
        if (string.equals(TC.get((String)"Effect.CancelAction"))) {
            return CANCEL;
        }
        if (string.equals(TC.get((String)"Effect.SpeakPlayer"))) {
            return SPPLAYER;
        }
        if (string.equals(TC.get((String)"Effect.SpeakCharacter"))) {
            return SPNPC;
        }
        if (string.equals(TC.get((String)"Effect.TriggerBook"))) {
            return BOOK;
        }
        if (string.equals(TC.get((String)"Effect.PlaySound"))) {
            return SOUND;
        }
        if (string.equals(TC.get((String)"Effect.TriggerConversation"))) {
            return CONVERSATION;
        }
        if (string.equals(TC.get((String)"Effect.TriggerCutscene"))) {
            return CUTSCENE;
        }
        if (string.equals(TC.get((String)"Effect.TriggerScene"))) {
            return SCENE;
        }
        if (string.equals(TC.get((String)"Effect.PlayAnimation"))) {
            return ANIMATION;
        }
        if (string.equals(TC.get((String)"Effect.MovePlayer"))) {
            return MVPLAYER;
        }
        if (string.equals(TC.get((String)"Effect.MoveCharacter"))) {
            return MVNPC;
        }
        if (string.equals(TC.get((String)"Effect.TriggerLastScene"))) {
            return LASTSCENE;
        }
        if (string.equals(TC.get((String)"Effect.RandomEffect"))) {
            return RANDOM;
        }
        if (string.equals(TC.get((String)"Effect.ShowText"))) {
            return SHOWTEXT;
        }
        if (string.equals(TC.get((String)"Effect.WaitTime"))) {
            return WAITTIME;
        }
        if (string.equals(TC.get((String)"Effect.HighlightItem"))) {
            return HIGHLIGHT;
        }
        if (string.equals(TC.get((String)"Effect.MoveObject"))) {
            return MOVE_OBJECT;
        }
        return null;
    }

    public static String reconvertNames(String string) {
        if (string.equals(ACTIVATE)) {
            return TC.get((String)"Effect.Activate");
        }
        if (string.equals(DEACTIVATE)) {
            return TC.get((String)"Effect.Deactivate");
        }
        if (string.equals(SETVALUE)) {
            return TC.get((String)"Effect.SetValue");
        }
        if (string.equals(INCREMENT)) {
            return TC.get((String)"Effect.IncrementVar");
        }
        if (string.equals(DECREMENT)) {
            return TC.get((String)"Effect.DecrementVar");
        }
        if (string.equals(MACRO)) {
            return TC.get((String)"Effect.MacroReference");
        }
        if (string.equals(CONSUME)) {
            return TC.get((String)"Effect.ConsumeObject");
        }
        if (string.equals(GENERATE)) {
            return TC.get((String)"Effect.GenerateObject");
        }
        if (string.equals(CANCEL)) {
            return TC.get((String)"Effect.CancelAction");
        }
        if (string.equals(SPPLAYER)) {
            return TC.get((String)"Effect.SpeakPlayer");
        }
        if (string.equals(SPNPC)) {
            return TC.get((String)"Effect.SpeakCharacter");
        }
        if (string.equals(BOOK)) {
            return TC.get((String)"Effect.TriggerBook");
        }
        if (string.equals(SOUND)) {
            return TC.get((String)"Effect.PlaySound");
        }
        if (string.equals(CONVERSATION)) {
            return TC.get((String)"Effect.TriggerConversation");
        }
        if (string.equals(CUTSCENE)) {
            return TC.get((String)"Effect.TriggerCutscene");
        }
        if (string.equals(SCENE)) {
            return TC.get((String)"Effect.TriggerScene");
        }
        if (string.equals(ANIMATION)) {
            return TC.get((String)"Effect.PlayAnimation");
        }
        if (string.equals(MVPLAYER)) {
            return TC.get((String)"Effect.MovePlayer");
        }
        if (string.equals(MVNPC)) {
            return TC.get((String)"Effect.MoveCharacter");
        }
        if (string.equals(LASTSCENE)) {
            return TC.get((String)"Effect.TriggerLastScene");
        }
        if (string.equals(RANDOM)) {
            return TC.get((String)"Effect.RandomEffect");
        }
        if (string.equals(SHOWTEXT)) {
            return TC.get((String)"Effect.ShowText");
        }
        if (string.equals(WAITTIME)) {
            return TC.get((String)"Effect.WaitTime");
        }
        if (string.equals(HIGHLIGHT)) {
            return TC.get((String)"Effect.HighlightItem");
        }
        if (string.equals(MOVE_OBJECT)) {
            return TC.get((String)"Effect.MoveObject");
        }
        return null;
    }

    public class ListElement
    implements Comparable<ListElement> {
        private String name;
        private Integer value;

        public ListElement(String string, Integer n) {
            this.name = string;
            this.value = n;
        }

        public String getName() {
            return this.name;
        }

        public Integer getValue() {
            return this.value;
        }

        @Override
        public int compareTo(ListElement listElement) {
            ListElement listElement2 = listElement;
            return this.value.compareTo(listElement2.value);
        }
    }
}

