/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.ConditionsController;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class Searchable {
    protected static HashMap<Searchable, List<String>> resultSet = new HashMap();
    protected static String searchedText;
    private static boolean caseSensitive;
    private static boolean fullMatch;

    public HashMap<Searchable, List<String>> search(String string, boolean bl, boolean bl2) {
        resultSet.clear();
        searchedText = bl ? string : string.toLowerCase();
        caseSensitive = bl;
        fullMatch = bl2;
        this.recursiveSearch();
        return resultSet;
    }

    public abstract void recursiveSearch();

    protected void addResult(String string) {
        List<String> list = resultSet.get(this);
        if (list == null) {
            list = new ArrayList<String>();
            resultSet.put(this, list);
        }
        if (!list.contains(string)) {
            list.add(string);
        }
    }

    protected void check(String string, String string2) {
        if (string != null) {
            if (!fullMatch) {
                if (!caseSensitive && string.toLowerCase().contains(searchedText)) {
                    this.addResult(string2);
                } else if (caseSensitive && string.contains(searchedText)) {
                    this.addResult(string2);
                }
            } else if (!caseSensitive && string.toLowerCase().equals(searchedText)) {
                this.addResult(string2);
            } else if (!caseSensitive || string.equals(searchedText)) {
                // empty if block
            }
        }
    }

    protected void check(ConditionsController conditionsController, String string) {
        for (int i = 0; i < conditionsController.getBlocksCount(); ++i) {
            for (int j = 0; j < conditionsController.getConditionCount(i); ++j) {
                HashMap<String, String> hashMap = conditionsController.getCondition(i, j);
                if (hashMap.containsKey("condition-id")) {
                    this.check(hashMap.get("condition-id"), string + " (ID)");
                }
                if (hashMap.containsKey("condition-state")) {
                    this.check(hashMap.get("condition-state"), string + " (" + TC.get((String)"Search.State") + ")");
                }
                if (!hashMap.containsKey("condition-value")) continue;
                this.check(hashMap.get("condition-value"), string + " (" + TC.get((String)"Search.Value") + ")");
            }
        }
    }

    protected abstract List<Searchable> getPath(Searchable var1);

    protected List<Searchable> getPathFromChild(Searchable searchable, DataControl dataControl) {
        List<Searchable> list;
        if (dataControl != null && (list = dataControl.getPath(searchable)) != null) {
            list.add(this);
            return list;
        }
        return null;
    }

    protected List<Searchable> getPathFromChild(Searchable searchable, List list) {
        for (Object e : list) {
            List<Searchable> list2 = ((Searchable)e).getPath(searchable);
            if (list2 == null) continue;
            list2.add(this);
            return list2;
        }
        return null;
    }

    protected List<Searchable> getPathFromSearchableChild(Searchable searchable, Searchable searchable2) {
        List<Searchable> list;
        if (searchable2 != null && (list = searchable2.getPath(searchable)) != null) {
            list.add(this);
            return list;
        }
        return null;
    }
}

