/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers;

import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.gui.otherpanels.SceneLinksPanel;
import es.eucm.eadventure.editor.gui.otherpanels.scenelistelements.SceneElement;
import es.eucm.eadventure.editor.gui.structurepanel.StructureControl;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class SceneLinksController
implements MouseListener,
MouseMotionListener {
    private SceneLinksPanel slp;
    private SceneElement under;
    private int startDragX;
    private int startDragY;
    private int originalX;
    private int originalY;
    private SceneElement showName;

    public SceneLinksController(SceneLinksPanel sceneLinksPanel) {
        this.slp = sceneLinksPanel;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.setUnderMouse(mouseEvent.getX(), mouseEvent.getY());
        if (this.under != null && mouseEvent.getClickCount() == 2) {
            StructureControl.getInstance().changeDataControl(this.under.getDataControl());
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.setUnderMouse(mouseEvent.getX(), mouseEvent.getY());
        if (this.under != null) {
            this.startDragX = mouseEvent.getX();
            this.startDragY = mouseEvent.getY();
            this.originalX = this.under.getPosX();
            this.originalY = this.under.getPosY();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.under != null) {
            int n = this.slp.getRealWidth(mouseEvent.getX() - this.startDragX);
            int n2 = this.slp.getRealHeight(mouseEvent.getY() - this.startDragY);
            int n3 = this.originalX + n;
            int n4 = this.originalY + n2;
            this.under.changePosition(n3, n4);
            this.slp.repaint();
            Controller.getInstance().dataModified();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        SceneElement sceneElement = this.slp.getSceneElement(mouseEvent.getX(), mouseEvent.getY());
        if (sceneElement != this.showName) {
            if (this.showName != null) {
                this.showName.setShowName(false);
            }
            this.showName = sceneElement;
            if (this.showName != null) {
                this.showName.setShowName(true);
            }
            this.slp.repaint();
        }
    }

    private void setUnderMouse(int n, int n2) {
        this.under = this.slp.getSceneElement(n, n2);
    }
}

