/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers;

import es.eucm.eadventure.editor.control.controllers.ScenePreviewEditionController;
import es.eucm.eadventure.editor.gui.otherpanels.ScenePreviewEditionPanel;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElement;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElementInfluenceArea;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElementReference;
import es.eucm.eadventure.editor.gui.structurepanel.StructureControl;
import java.awt.event.MouseEvent;

public class NormalScenePreviewEditionController
implements ScenePreviewEditionController {
    protected ImageElement underMouse;
    protected ScenePreviewEditionPanel spep;
    protected int startDragX;
    protected int startDragY;
    protected int originalX;
    protected int originalY;
    protected int originalWidth;
    protected int originalHeight;
    protected float originalScale;

    public NormalScenePreviewEditionController(ScenePreviewEditionPanel scenePreviewEditionPanel) {
        this.spep = scenePreviewEditionPanel;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.setMouseUnder(mouseEvent.getX(), mouseEvent.getY());
        if (this.spep.getSelectedElement() != null && mouseEvent.getClickCount() == 2 && this.spep.getSelectedElement() instanceof ImageElementReference) {
            StructureControl.getInstance().changeDataControl(this.spep.getSelectedElement().getReferencedDataControl());
        } else if (this.underMouse != null && !this.spep.getFixedSelectedElement() && !(this.spep.getSelectedElement() instanceof ImageElementInfluenceArea)) {
            this.spep.setSelectedElement(this.underMouse);
            this.spep.notifySelectionListener();
            this.spep.repaint();
        } else if (this.underMouse == null && !this.spep.getFixedSelectedElement()) {
            this.spep.setSelectedElement((ImageElement)null);
            this.spep.notifySelectionListener();
            this.spep.repaint();
        } else if (this.spep.getFixedSelectedElement()) {
            int n = this.spep.getRealX(mouseEvent.getX());
            int n2 = this.spep.getRealY(mouseEvent.getY());
            this.spep.getSelectedElement().changePosition(n, n2);
            this.spep.updateTextEditionPanel();
            this.spep.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.setMouseUnder(mouseEvent.getX(), mouseEvent.getY());
        if (this.underMouse != null) {
            this.startDragX = mouseEvent.getX();
            this.startDragY = mouseEvent.getY();
            this.originalX = this.underMouse.getX();
            this.originalY = this.underMouse.getY();
            this.originalWidth = this.underMouse.getWidth();
            this.originalHeight = this.underMouse.getHeight();
            this.originalScale = this.underMouse.getScale();
        } else if (this.underMouse != null && !this.spep.getFixedSelectedElement()) {
            this.spep.setSelectedElement(this.underMouse);
            this.spep.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!(this.underMouse == null || this.spep.isRescale() || this.spep.isResize() || this.spep.isResizeInflueceArea())) {
            int n = this.spep.getRealWidth(mouseEvent.getX() - this.startDragX);
            int n2 = this.spep.getRealHeight(mouseEvent.getY() - this.startDragY);
            int n3 = this.originalX + n;
            int n4 = this.originalY + n2;
            this.underMouse.changePosition(n3, n4);
            this.spep.updateTextEditionPanel();
            this.spep.repaint();
        } else if (this.underMouse != null && this.spep.isRescale() && !this.spep.isResize() && !this.spep.isResizeInflueceArea()) {
            double d = mouseEvent.getX() - this.startDragX;
            double d2 = -(mouseEvent.getY() - this.startDragY);
            double d3 = this.underMouse.getImage().getWidth(null);
            double d4 = this.underMouse.getImage().getHeight(null);
            double d5 = d / d3;
            double d6 = d2 / d4;
            float f = this.originalScale;
            f = d5 * d5 > d6 * d6 ? (float)((d3 * (double)this.originalScale + (double)this.spep.getRealWidth((int)d)) / d3) : (float)((d4 * (double)this.originalScale + (double)this.spep.getRealHeight((int)d2)) / d4);
            if (f <= 0.0f) {
                f = 0.01f;
            }
            this.underMouse.setScale(f);
            this.spep.updateTextEditionPanel();
            this.spep.repaint();
        } else if (this.underMouse != null && !this.spep.isRescale() && (this.spep.isResize() || this.spep.isResizeInflueceArea())) {
            int n = this.spep.getRealWidth(mouseEvent.getX() - this.startDragX);
            int n5 = this.spep.getRealHeight(mouseEvent.getY() - this.startDragY);
            this.underMouse.changeSize(this.originalWidth + n, this.originalHeight + n5);
            this.underMouse.recreateImage();
            this.spep.updateTextEditionPanel();
            this.spep.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.setMouseUnder(mouseEvent.getX(), mouseEvent.getY());
    }

    protected void setMouseUnder(int n, int n2) {
        int n3 = this.spep.getRealX(n);
        int n4 = this.spep.getRealY(n2);
        ImageElement imageElement = this.spep.getMovableElement(n3, n4);
        ImageElement imageElement2 = this.spep.getRescaleElement(n3, n4);
        ImageElement imageElement3 = this.spep.getResizeElement(n3, n4);
        if (imageElement2 != null) {
            this.underMouse = imageElement2;
            this.spep.setRescale(true);
            this.spep.setResize(false);
            this.spep.setResizeInflueceArea(false);
            this.spep.repaint();
        } else if (imageElement3 != null) {
            this.underMouse = imageElement3;
            if (imageElement3 instanceof ImageElementInfluenceArea) {
                this.spep.setResizeInflueceArea(true);
                this.spep.setResize(false);
            } else {
                this.spep.setResizeInflueceArea(false);
                this.spep.setResize(true);
            }
            this.spep.setRescale(false);
            this.spep.repaint();
        } else if (imageElement != this.underMouse || imageElement != null && (this.spep.isRescale() || this.spep.isResize() || this.spep.isResizeInflueceArea())) {
            this.underMouse = imageElement;
            this.spep.setRescale(false);
            this.spep.setResize(false);
            this.spep.setResizeInflueceArea(false);
            this.spep.repaint();
        } else if (imageElement == null) {
            this.underMouse = null;
            this.spep.setRescale(false);
            this.spep.setResizeInflueceArea(false);
            this.spep.setResize(false);
        }
    }

    @Override
    public ImageElement getUnderMouse() {
        return this.underMouse;
    }
}

