/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers;

import es.eucm.eadventure.editor.control.controllers.NormalScenePreviewEditionController;
import es.eucm.eadventure.editor.control.controllers.scene.PointDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.RectangleArea;
import es.eucm.eadventure.editor.gui.otherpanels.ScenePreviewEditionPanel;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElement;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElementInfluenceArea;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElementPoint;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class IrregularAreaEditionController
extends NormalScenePreviewEditionController {
    public static final int POINT_EDIT = 0;
    public static final int DELETE_TOOL = 2;
    private RectangleArea aadc;
    private int selectedTool = 0;
    private Color color;
    private boolean hasInfluenceArea;

    public IrregularAreaEditionController(ScenePreviewEditionPanel scenePreviewEditionPanel, RectangleArea rectangleArea, Color color, boolean bl) {
        super(scenePreviewEditionPanel);
        this.spep = scenePreviewEditionPanel;
        this.aadc = rectangleArea;
        this.color = color;
        this.hasInfluenceArea = bl;
        scenePreviewEditionPanel.setIrregularRectangle(this.aadc.getRectangle(), color);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.spep.getRealX(mouseEvent.getX());
        int n2 = this.spep.getRealY(mouseEvent.getY());
        this.setMouseUnder(mouseEvent.getX(), mouseEvent.getY());
        if (this.selectedTool == 0) {
            if (this.underMouse == null || this.underMouse instanceof ImageElementInfluenceArea) {
                this.aadc.addPoint(n, n2);
                this.spep.addPoint(new PointDataControl(this.aadc.getLastPoint()));
                if (this.hasInfluenceArea) {
                    if (this.aadc.getPoints().size() >= 3) {
                        ((ImageElementInfluenceArea)this.spep.getInfluenceArea()).setVisible(true);
                    }
                    this.spep.getInfluenceArea().recreateImage();
                }
                this.spep.setIrregularRectangle(this.aadc.getRectangle(), this.color);
                this.spep.repaint();
            }
        } else if (this.selectedTool == 2 && this.underMouse != null && this.underMouse instanceof ImageElementPoint) {
            PointDataControl pointDataControl = (PointDataControl)((ImageElementPoint)this.underMouse).getDataControl();
            this.aadc.deletePoint((Point)pointDataControl.getContent());
            this.spep.removeElement(9, this.underMouse);
            this.underMouse = null;
            this.spep.setIrregularRectangle(this.aadc.getRectangle(), this.color);
            this.spep.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.selectedTool == 0) {
            this.setMouseUnder(mouseEvent.getX(), mouseEvent.getY());
            if (this.underMouse != null) {
                this.startDragX = mouseEvent.getX();
                this.startDragY = mouseEvent.getY();
                this.originalX = this.underMouse.getX();
                this.originalY = this.underMouse.getY();
                this.originalWidth = this.underMouse.getImage().getWidth(null);
                this.originalHeight = this.underMouse.getImage().getHeight(null);
                this.originalScale = this.underMouse.getScale();
                this.spep.setSelectedElement(this.underMouse);
                this.spep.repaint();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.selectedTool == 0) {
            if (!(this.underMouse == null || this.spep.isRescale() || this.spep.isResize() || this.spep.isResizeInflueceArea())) {
                int n = this.spep.getRealWidth(mouseEvent.getX() - this.startDragX);
                int n2 = this.spep.getRealHeight(mouseEvent.getY() - this.startDragY);
                int n3 = this.originalX + n;
                int n4 = this.originalY + n2;
                this.underMouse.changePosition(n3, n4);
                this.spep.repaint();
            } else if (this.underMouse != null && this.spep.isRescale() && !this.spep.isResize() && !this.spep.isResizeInflueceArea()) {
                double d = mouseEvent.getX() - this.startDragX;
                double d2 = -(mouseEvent.getY() - this.startDragY);
                double d3 = (float)this.originalWidth / this.originalScale;
                double d4 = (float)(this.originalHeight - 10) / this.originalScale;
                double d5 = d / d3;
                double d6 = d2 / d4;
                float f = this.originalScale;
                f = d5 * d5 > d6 * d6 ? (float)((d3 * (double)this.originalScale + (double)this.spep.getRealWidth((int)d)) / d3) : (float)((d4 * (double)this.originalScale + (double)this.spep.getRealHeight((int)d2)) / d4);
                if (f <= 0.0f) {
                    f = 0.01f;
                }
                this.underMouse.setScale(f);
                this.underMouse.recreateImage();
                this.spep.repaint();
            } else if (this.underMouse != null && !this.spep.isRescale() && (this.spep.isResize() || this.spep.isResizeInflueceArea())) {
                int n = this.spep.getRealWidth(mouseEvent.getX() - this.startDragX);
                int n5 = this.spep.getRealHeight(mouseEvent.getY() - this.startDragY);
                this.underMouse.changeSize(this.originalWidth + n, this.originalHeight + n5);
                this.underMouse.recreateImage();
                this.spep.updateTextEditionPanel();
                this.spep.repaint();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.setMouseUnder(mouseEvent.getX(), mouseEvent.getY());
        if (this.spep.getFirstElement() != null) {
            this.spep.repaint();
        }
    }

    @Override
    public ImageElement getUnderMouse() {
        return this.underMouse;
    }

    public void setSelectedTool(int n) {
        this.selectedTool = n;
        if (this.selectedTool == 0) {
            this.spep.setMovableCategory(9, true);
            this.spep.setMovableCategory(10, true);
        } else if (this.selectedTool == 2) {
            this.spep.setMovableCategory(9, true);
            this.spep.setMovableCategory(10, false);
        }
        this.spep.repaint();
    }

    public RectangleArea getEditionRectangle() {
        return this.aadc;
    }
}

