/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers;

import es.eucm.eadventure.common.data.HasTargetId;
import es.eucm.eadventure.common.data.chapter.effects.AbstractEffect;
import es.eucm.eadventure.common.data.chapter.effects.ActivateEffect;
import es.eucm.eadventure.common.data.chapter.effects.CancelActionEffect;
import es.eucm.eadventure.common.data.chapter.effects.ConsumeObjectEffect;
import es.eucm.eadventure.common.data.chapter.effects.DeactivateEffect;
import es.eucm.eadventure.common.data.chapter.effects.DecrementVarEffect;
import es.eucm.eadventure.common.data.chapter.effects.Effect;
import es.eucm.eadventure.common.data.chapter.effects.Effects;
import es.eucm.eadventure.common.data.chapter.effects.GenerateObjectEffect;
import es.eucm.eadventure.common.data.chapter.effects.HighlightItemEffect;
import es.eucm.eadventure.common.data.chapter.effects.IncrementVarEffect;
import es.eucm.eadventure.common.data.chapter.effects.MacroReferenceEffect;
import es.eucm.eadventure.common.data.chapter.effects.MoveNPCEffect;
import es.eucm.eadventure.common.data.chapter.effects.MoveObjectEffect;
import es.eucm.eadventure.common.data.chapter.effects.MovePlayerEffect;
import es.eucm.eadventure.common.data.chapter.effects.PlayAnimationEffect;
import es.eucm.eadventure.common.data.chapter.effects.PlaySoundEffect;
import es.eucm.eadventure.common.data.chapter.effects.RandomEffect;
import es.eucm.eadventure.common.data.chapter.effects.SetValueEffect;
import es.eucm.eadventure.common.data.chapter.effects.ShowTextEffect;
import es.eucm.eadventure.common.data.chapter.effects.SpeakCharEffect;
import es.eucm.eadventure.common.data.chapter.effects.SpeakPlayerEffect;
import es.eucm.eadventure.common.data.chapter.effects.TriggerBookEffect;
import es.eucm.eadventure.common.data.chapter.effects.TriggerConversationEffect;
import es.eucm.eadventure.common.data.chapter.effects.TriggerCutsceneEffect;
import es.eucm.eadventure.common.data.chapter.effects.TriggerLastSceneEffect;
import es.eucm.eadventure.common.data.chapter.effects.TriggerSceneEffect;
import es.eucm.eadventure.common.data.chapter.effects.WaitTimeEffect;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.ConditionsController;
import es.eucm.eadventure.editor.control.controllers.SingleEffectController;
import es.eucm.eadventure.editor.control.tools.general.assets.SelectResourceTool;
import es.eucm.eadventure.editor.control.tools.general.effects.AddEffectTool;
import es.eucm.eadventure.editor.control.tools.general.effects.DeleteEffectTool;
import es.eucm.eadventure.editor.control.tools.general.effects.MoveEffectInTableTool;
import es.eucm.eadventure.editor.control.tools.general.effects.ReplaceEffectTool;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import es.eucm.eadventure.editor.gui.editdialogs.SelectEffectsDialog;
import es.eucm.eadventure.editor.gui.editdialogs.effectdialogs.EffectDialog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class EffectsController {
    public static final int EFFECT_PROPERTY_TARGET = 0;
    public static final int EFFECT_PROPERTY_PATH = 1;
    public static final int EFFECT_PROPERTY_TEXT = 2;
    public static final int EFFECT_PROPERTY_X = 3;
    public static final int EFFECT_PROPERTY_Y = 4;
    public static final int EFFECT_PROPERTY_BACKGROUND = 5;
    public static final int EFFECT_PROPERTY_PROBABILITY = 6;
    public static final int EFFECT_PROPERTY_VALUE = 7;
    public static final int EFFECT_PROPERTY_TIME = 8;
    public static final int EFFECT_PROPERTY_FRONT_COLOR = 9;
    public static final int EFFECT_PROPERTY_BORDER_COLOR = 10;
    public static final int EFFECT_PROPERTY_TYPE = 11;
    public static final int EFFECT_PROPERTY_FIRST_EFFECT = 12;
    public static final int EFFECT_PROPERTY_SECOND_EFFECT = 13;
    public static final int EFFECT_PROPERTY_HIGHLIGHT_TYPE = 14;
    public static final int EFFECT_PROPERTY_ANIMATED = 15;
    public static final int EFFECT_PROPERTY_SCALE = 16;
    public static final int EFFECT_PROPERTY_TRANSLATION_SPEED = 17;
    public static final int EFFECT_PROPERTY_SCALE_SPEED = 18;
    public static final int ASSET_ANIMATION = 0;
    public static final int ASSET_SOUND = 1;
    protected Controller controller;
    protected Effects effects;
    protected List<ConditionsController> conditionsList;
    protected boolean waitingForEffectSelection = false;

    public EffectsController(Effects effects) {
        this.effects = effects;
        this.controller = Controller.getInstance();
        this.conditionsList = new ArrayList<ConditionsController>();
        for (AbstractEffect abstractEffect : effects.getEffects()) {
            this.conditionsList.add(new ConditionsController(abstractEffect.getConditions(), 66, EffectsController.getEffectInfo(abstractEffect)));
        }
    }

    public ConditionsController getConditionController(int n) {
        return this.conditionsList.get(n);
    }

    public int getEffectCount() {
        return this.effects.getEffects().size();
    }

    public String getEffectInfo(int n) {
        if (this.getEffectCount() > 0) {
            AbstractEffect abstractEffect = (AbstractEffect)this.effects.getEffects().get(n);
            return EffectsController.getEffectInfo(abstractEffect);
        }
        return null;
    }

    public Icon getEffectIcon(int n) {
        ImageIcon imageIcon = null;
        if (n >= 0 && n < this.effects.getEffects().size()) {
            AbstractEffect abstractEffect = (AbstractEffect)this.effects.getEffects().get(n);
            switch (abstractEffect.getType()) {
                case 0: {
                    imageIcon = new ImageIcon("img/icons/effects/16x16/activate.png");
                    break;
                }
                case 1: {
                    imageIcon = new ImageIcon("img/icons/effects/16x16/deactivate.png");
                    break;
                }
                case 17: {
                    imageIcon = new ImageIcon("img/icons/effects/16x16/set-value.png");
                    break;
                }
                case 18: {
                    imageIcon = new ImageIcon("img/icons/effects/16x16/increment.png");
                    break;
                }
                case 19: {
                    imageIcon = new ImageIcon("img/icons/effects/16x16/decrement.png");
                    break;
                }
                case 20: {
                    imageIcon = new ImageIcon("img/icons/effects/16x16/macro.png");
                    break;
                }
                case 2: {
                    imageIcon = new ImageIcon("img/icons/effects/16x16/consume-object.png");
                    break;
                }
                case 3: {
                    imageIcon = new ImageIcon("img/icons/effects/16x16/generate-object.png");
                    break;
                }
                case 4: {
                    imageIcon = new ImageIcon("img/icons/effects/16x16/cancel-action.png");
                    break;
                }
                case 5: {
                    imageIcon = new ImageIcon("img/icons/effects/16x16/speak-player.png");
                    break;
                }
                case 6: {
                    imageIcon = new ImageIcon("img/icons/effects/16x16/speak-npc.png");
                    break;
                }
                case 7: {
                    imageIcon = new ImageIcon("img/icons/effects/16x16/trigger-book.png");
                    break;
                }
                case 8: {
                    imageIcon = new ImageIcon("img/icons/effects/16x16/play-sound.png");
                    break;
                }
                case 9: {
                    imageIcon = new ImageIcon("img/icons/effects/16x16/play-animation.png");
                    break;
                }
                case 10: {
                    imageIcon = new ImageIcon("img/icons/effects/16x16/move-player.png");
                    break;
                }
                case 11: {
                    imageIcon = new ImageIcon("img/icons/effects/16x16/move-npc.png");
                    break;
                }
                case 12: {
                    imageIcon = new ImageIcon("img/icons/effects/16x16/trigger-conversation.png");
                    break;
                }
                case 13: {
                    imageIcon = new ImageIcon("img/icons/effects/16x16/trigger-cutscene.png");
                    break;
                }
                case 14: {
                    imageIcon = new ImageIcon("img/icons/effects/16x16/trigger-scene.png");
                    break;
                }
                case 15: {
                    imageIcon = new ImageIcon("img/icons/effects/16x16/trigger-last-scene.png");
                    break;
                }
                case 16: {
                    imageIcon = new ImageIcon("img/icons/effects/16x16/random-effect.png");
                    break;
                }
                case 21: {
                    imageIcon = new ImageIcon("img/icons/effects/16x16/wait.png");
                    break;
                }
                case 22: {
                    imageIcon = new ImageIcon("img/icons/effects/16x16/show-text.png");
                    break;
                }
                case 23: {
                    imageIcon = new ImageIcon("img/icons/effects/16x16/highlight-item.png");
                    break;
                }
                case 24: {
                    imageIcon = new ImageIcon("img/icons/effects/16x16/move-object.png");
                }
            }
        }
        return imageIcon;
    }

    public static String getEffectInfo(AbstractEffect abstractEffect) {
        String string = null;
        switch (abstractEffect.getType()) {
            case 0: {
                ActivateEffect activateEffect = (ActivateEffect)abstractEffect;
                string = TC.get((String)"Effect.ActivateInfo", (String)activateEffect.getTargetId());
                break;
            }
            case 1: {
                DeactivateEffect deactivateEffect = (DeactivateEffect)abstractEffect;
                string = TC.get((String)"Effect.DeactivateInfo", (String)deactivateEffect.getTargetId());
                break;
            }
            case 17: {
                SetValueEffect setValueEffect = (SetValueEffect)abstractEffect;
                string = TC.get((String)"Effect.SetValueInfo", (String[])new String[]{setValueEffect.getTargetId(), Integer.toString(setValueEffect.getValue())});
                break;
            }
            case 18: {
                IncrementVarEffect incrementVarEffect = (IncrementVarEffect)abstractEffect;
                string = TC.get((String)"Effect.IncrementVarInfo", (String[])new String[]{incrementVarEffect.getTargetId(), Integer.toString(incrementVarEffect.getIncrement())});
                break;
            }
            case 19: {
                DecrementVarEffect decrementVarEffect = (DecrementVarEffect)abstractEffect;
                string = TC.get((String)"Effect.DecrementVarInfo", (String[])new String[]{decrementVarEffect.getTargetId(), Integer.toString(decrementVarEffect.getDecrement())});
                break;
            }
            case 20: {
                MacroReferenceEffect macroReferenceEffect = (MacroReferenceEffect)abstractEffect;
                string = TC.get((String)"Effect.MacroRefInfo", (String)macroReferenceEffect.getTargetId());
                break;
            }
            case 2: {
                ConsumeObjectEffect consumeObjectEffect = (ConsumeObjectEffect)abstractEffect;
                string = TC.get((String)"Effect.ConsumeObjectInfo", (String)consumeObjectEffect.getTargetId());
                break;
            }
            case 3: {
                GenerateObjectEffect generateObjectEffect = (GenerateObjectEffect)abstractEffect;
                string = TC.get((String)"Effect.GenerateObjectInfo", (String)generateObjectEffect.getTargetId());
                break;
            }
            case 4: {
                string = TC.get((String)"Effect.CancelActionInfo");
                break;
            }
            case 5: {
                SpeakPlayerEffect speakPlayerEffect = (SpeakPlayerEffect)abstractEffect;
                string = TC.get((String)"Effect.SpeakPlayerInfo", (String)speakPlayerEffect.getLine());
                break;
            }
            case 6: {
                SpeakCharEffect speakCharEffect = (SpeakCharEffect)abstractEffect;
                string = TC.get((String)"Effect.SpeakCharacterInfo", (String[])new String[]{speakCharEffect.getTargetId(), speakCharEffect.getLine()});
                break;
            }
            case 7: {
                TriggerBookEffect triggerBookEffect = (TriggerBookEffect)abstractEffect;
                string = TC.get((String)"Effect.TriggerBookInfo", (String)triggerBookEffect.getTargetId());
                break;
            }
            case 8: {
                PlaySoundEffect playSoundEffect = (PlaySoundEffect)abstractEffect;
                string = TC.get((String)"Effect.PlaySoundInfo", (String)playSoundEffect.getPath());
                break;
            }
            case 9: {
                PlayAnimationEffect playAnimationEffect = (PlayAnimationEffect)abstractEffect;
                string = TC.get((String)"Effect.PlayAnimationInfo", (String)playAnimationEffect.getPath());
                break;
            }
            case 10: {
                MovePlayerEffect movePlayerEffect = (MovePlayerEffect)abstractEffect;
                string = TC.get((String)"Effect.MovePlayerInfo", (String[])new String[]{String.valueOf(movePlayerEffect.getX()), String.valueOf(movePlayerEffect.getY())});
                break;
            }
            case 11: {
                MoveNPCEffect moveNPCEffect = (MoveNPCEffect)abstractEffect;
                string = TC.get((String)"Effect.MoveCharacterInfo", (String[])new String[]{moveNPCEffect.getTargetId(), String.valueOf(moveNPCEffect.getX()), String.valueOf(moveNPCEffect.getY())});
                break;
            }
            case 12: {
                TriggerConversationEffect triggerConversationEffect = (TriggerConversationEffect)abstractEffect;
                string = TC.get((String)"Effect.TriggerConversationInfo", (String)triggerConversationEffect.getTargetId());
                break;
            }
            case 13: {
                TriggerCutsceneEffect triggerCutsceneEffect = (TriggerCutsceneEffect)abstractEffect;
                string = TC.get((String)"Effect.TriggerCutsceneInfo", (String)triggerCutsceneEffect.getTargetId());
                break;
            }
            case 14: {
                TriggerSceneEffect triggerSceneEffect = (TriggerSceneEffect)abstractEffect;
                string = TC.get((String)"Effect.TriggerSceneInfo", (String)triggerSceneEffect.getTargetId());
                break;
            }
            case 15: {
                string = TC.get((String)"Effect.TriggerLastSceneInfo");
                break;
            }
            case 16: {
                RandomEffect randomEffect = (RandomEffect)abstractEffect;
                String string2 = "";
                String string3 = "";
                if (randomEffect.getPositiveEffect() != null) {
                    string2 = EffectsController.getEffectInfo(randomEffect.getPositiveEffect());
                }
                if (randomEffect.getNegativeEffect() != null) {
                    string3 = EffectsController.getEffectInfo(randomEffect.getNegativeEffect());
                }
                string = TC.get((String)"Effect.RandomInfo", (String[])new String[]{Integer.toString(randomEffect.getProbability()), Integer.toString(100 - randomEffect.getProbability()), string2, string3});
                break;
            }
            case 21: {
                WaitTimeEffect waitTimeEffect = (WaitTimeEffect)abstractEffect;
                string = TC.get((String)"Effect.WaitTimeInfo", (String)Integer.toString(waitTimeEffect.getTime()));
                break;
            }
            case 22: {
                ShowTextEffect showTextEffect = (ShowTextEffect)abstractEffect;
                string = TC.get((String)"Effect.ShowTextInfo", (String[])new String[]{showTextEffect.getText(), Integer.toString(showTextEffect.getX()), Integer.toString(showTextEffect.getY())});
                break;
            }
            case 23: {
                HighlightItemEffect highlightItemEffect = (HighlightItemEffect)abstractEffect;
                if (highlightItemEffect.getHighlightType() == 0) {
                    string = TC.get((String)"Effect.NoHighlightItemInfo", (String[])new String[]{highlightItemEffect.getTargetId()});
                }
                if (highlightItemEffect.getHighlightType() == 1) {
                    string = TC.get((String)"Effect.BlueHighlightItemInfo", (String[])new String[]{highlightItemEffect.getTargetId()});
                }
                if (highlightItemEffect.getHighlightType() == 3) {
                    string = TC.get((String)"Effect.GreenHighlightItemInfo", (String[])new String[]{highlightItemEffect.getTargetId()});
                }
                if (highlightItemEffect.getHighlightType() == 2) {
                    string = TC.get((String)"Effect.RedHighlightItemInfo", (String[])new String[]{highlightItemEffect.getTargetId()});
                }
                if (highlightItemEffect.getHighlightType() != 4) break;
                string = TC.get((String)"Effect.BorderHighlightItemInfo", (String[])new String[]{highlightItemEffect.getTargetId()});
                break;
            }
            case 24: {
                MoveObjectEffect moveObjectEffect = (MoveObjectEffect)abstractEffect;
                string = TC.get((String)"Effect.MoveObjectInfo", (String)moveObjectEffect.getTargetId());
            }
        }
        return string;
    }

    public List<AbstractEffect> getEffects() {
        return this.effects.getEffects();
    }

    public boolean addEffect() {
        boolean bl = false;
        HashMap<Integer, Object> hashMap = SelectEffectsDialog.getNewEffectProperties(this);
        if (hashMap != null) {
            int n = 0;
            if (hashMap.containsKey(11)) {
                n = Integer.parseInt((String)hashMap.get(11));
            }
            AbstractEffect abstractEffect = this.createNewEffect(hashMap);
            if (n == 16) {
                AbstractEffect abstractEffect2 = null;
                AbstractEffect abstractEffect3 = null;
                if (hashMap.containsKey(12)) {
                    abstractEffect2 = (AbstractEffect)hashMap.get(12);
                }
                if (hashMap.containsKey(13)) {
                    abstractEffect3 = (AbstractEffect)hashMap.get(13);
                }
                RandomEffect randomEffect = new RandomEffect(50);
                if (hashMap.containsKey(6)) {
                    randomEffect.setProbability(Integer.parseInt((String)hashMap.get(6)));
                }
                if (abstractEffect2 != null) {
                    randomEffect.setPositiveEffect(abstractEffect2);
                }
                if (abstractEffect3 != null) {
                    randomEffect.setNegativeEffect(abstractEffect3);
                }
                abstractEffect = randomEffect;
            }
            bl = this.controller.addTool(new AddEffectTool(this.effects, abstractEffect, this.conditionsList));
        }
        return bl;
    }

    protected AbstractEffect createNewEffect(HashMap<Integer, Object> hashMap) {
        int n = 0;
        if (hashMap.containsKey(11)) {
            n = Integer.parseInt((String)hashMap.get(11));
        }
        TriggerLastSceneEffect triggerLastSceneEffect = null;
        String string = (String)hashMap.get(0);
        String string2 = (String)hashMap.get(1);
        String string3 = (String)hashMap.get(2);
        int n2 = 0;
        if (hashMap.containsKey(7)) {
            n2 = Integer.parseInt((String)hashMap.get(7));
        }
        int n3 = 0;
        if (hashMap.containsKey(3)) {
            n3 = Integer.parseInt((String)hashMap.get(3));
        }
        int n4 = 0;
        if (hashMap.containsKey(4)) {
            n4 = Integer.parseInt((String)hashMap.get(4));
        }
        boolean bl = false;
        if (hashMap.containsKey(5)) {
            bl = Boolean.parseBoolean((String)hashMap.get(5));
        }
        int n5 = 0;
        if (hashMap.containsKey(8)) {
            n5 = Integer.parseInt((String)hashMap.get(8));
        }
        int n6 = 0;
        if (hashMap.containsKey(9)) {
            n6 = Integer.parseInt((String)hashMap.get(9));
        }
        int n7 = 0;
        if (hashMap.containsKey(10)) {
            n7 = Integer.parseInt((String)hashMap.get(10));
        }
        int n8 = 0;
        if (hashMap.containsKey(14)) {
            n8 = (Integer)hashMap.get(14);
        }
        boolean bl2 = false;
        if (hashMap.containsKey(15)) {
            bl2 = (Boolean)hashMap.get(15);
        }
        float f = 1.0f;
        if (hashMap.containsKey(16)) {
            f = ((Float)hashMap.get(16)).floatValue();
        }
        int n9 = 20;
        if (hashMap.containsKey(17)) {
            n9 = (Integer)hashMap.get(17);
        }
        int n10 = 20;
        if (hashMap.containsKey(18)) {
            n10 = (Integer)hashMap.get(18);
        }
        switch (n) {
            case 0: {
                triggerLastSceneEffect = new ActivateEffect(string);
                this.controller.getVarFlagSummary().addFlagReference(string);
                break;
            }
            case 1: {
                triggerLastSceneEffect = new DeactivateEffect(string);
                this.controller.getVarFlagSummary().addFlagReference(string);
                break;
            }
            case 17: {
                triggerLastSceneEffect = new SetValueEffect(string, n2);
                this.controller.getVarFlagSummary().addVarReference(string);
                break;
            }
            case 18: {
                triggerLastSceneEffect = new IncrementVarEffect(string, n2);
                this.controller.getVarFlagSummary().addVarReference(string);
                break;
            }
            case 19: {
                triggerLastSceneEffect = new DecrementVarEffect(string, n2);
                this.controller.getVarFlagSummary().addVarReference(string);
                break;
            }
            case 20: {
                triggerLastSceneEffect = new MacroReferenceEffect(string);
                break;
            }
            case 2: {
                triggerLastSceneEffect = new ConsumeObjectEffect(string);
                break;
            }
            case 3: {
                triggerLastSceneEffect = new GenerateObjectEffect(string);
                break;
            }
            case 15: {
                triggerLastSceneEffect = new TriggerLastSceneEffect();
                break;
            }
            case 5: {
                triggerLastSceneEffect = new SpeakPlayerEffect(string3);
                break;
            }
            case 6: {
                triggerLastSceneEffect = new SpeakCharEffect(string, string3);
                break;
            }
            case 7: {
                triggerLastSceneEffect = new TriggerBookEffect(string);
                break;
            }
            case 8: {
                triggerLastSceneEffect = new PlaySoundEffect(bl, string2);
                break;
            }
            case 9: {
                triggerLastSceneEffect = new PlayAnimationEffect(string2, n3, n4);
                break;
            }
            case 10: {
                triggerLastSceneEffect = new MovePlayerEffect(n3, n4);
                break;
            }
            case 11: {
                triggerLastSceneEffect = new MoveNPCEffect(string, n3, n4);
                break;
            }
            case 12: {
                triggerLastSceneEffect = new TriggerConversationEffect(string);
                break;
            }
            case 13: {
                triggerLastSceneEffect = new TriggerCutsceneEffect(string);
                break;
            }
            case 14: {
                triggerLastSceneEffect = new TriggerSceneEffect(string, n3, n4);
                break;
            }
            case 21: {
                triggerLastSceneEffect = new WaitTimeEffect(n5);
                break;
            }
            case 22: {
                triggerLastSceneEffect = new ShowTextEffect(string3, n3, n4, n6, n7);
                break;
            }
            case 23: {
                triggerLastSceneEffect = new HighlightItemEffect(string, n8, bl2);
                break;
            }
            case 24: {
                triggerLastSceneEffect = new MoveObjectEffect(string, n3, n4, f, bl2, n9, n10);
                break;
            }
            case 4: {
                triggerLastSceneEffect = new CancelActionEffect();
            }
        }
        return triggerLastSceneEffect;
    }

    public void deleteEffect(int n) {
        this.controller.addTool(new DeleteEffectTool(this.effects, n, this.conditionsList));
    }

    public boolean moveUpEffect(int n) {
        return this.controller.addTool(new MoveEffectInTableTool(this.effects, n, 0, this.conditionsList));
    }

    public boolean moveDownEffect(int n) {
        return this.controller.addTool(new MoveEffectInTableTool(this.effects, n, 1, this.conditionsList));
    }

    public boolean editEffect(int n) {
        SpeakPlayerEffect speakPlayerEffect;
        Object object;
        Object object2;
        Object object3;
        boolean bl = false;
        AbstractEffect abstractEffect = (AbstractEffect)this.effects.getEffects().get(n);
        int n2 = abstractEffect.getType();
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        if (abstractEffect instanceof HasTargetId) {
            hashMap.put(0, ((HasTargetId)abstractEffect).getTargetId());
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 12: 
            case 13: 
            case 20: {
                break;
            }
            case 17: {
                object3 = (SetValueEffect)abstractEffect;
                hashMap.put(7, Integer.toString(object3.getValue()));
                break;
            }
            case 18: {
                object2 = (IncrementVarEffect)abstractEffect;
                hashMap.put(7, Integer.toString(object2.getIncrement()));
                break;
            }
            case 19: {
                object = (DecrementVarEffect)abstractEffect;
                hashMap.put(7, Integer.toString(object.getDecrement()));
                break;
            }
            case 5: {
                speakPlayerEffect = (SpeakPlayerEffect)abstractEffect;
                hashMap.put(2, speakPlayerEffect.getLine());
                break;
            }
            case 6: {
                SpeakCharEffect speakCharEffect = (SpeakCharEffect)abstractEffect;
                hashMap.put(2, speakCharEffect.getLine());
                break;
            }
            case 8: {
                PlaySoundEffect playSoundEffect = (PlaySoundEffect)abstractEffect;
                hashMap.put(1, playSoundEffect.getPath());
                hashMap.put(5, String.valueOf(playSoundEffect.isBackground()));
                break;
            }
            case 9: {
                PlayAnimationEffect playAnimationEffect = (PlayAnimationEffect)abstractEffect;
                hashMap.put(1, playAnimationEffect.getPath());
                hashMap.put(3, String.valueOf(playAnimationEffect.getX()));
                hashMap.put(4, String.valueOf(playAnimationEffect.getY()));
                break;
            }
            case 10: {
                MovePlayerEffect movePlayerEffect = (MovePlayerEffect)abstractEffect;
                hashMap.put(3, String.valueOf(movePlayerEffect.getX()));
                hashMap.put(4, String.valueOf(movePlayerEffect.getY()));
                break;
            }
            case 11: {
                MoveNPCEffect moveNPCEffect = (MoveNPCEffect)abstractEffect;
                hashMap.put(3, String.valueOf(moveNPCEffect.getX()));
                hashMap.put(4, String.valueOf(moveNPCEffect.getY()));
                break;
            }
            case 14: {
                TriggerSceneEffect triggerSceneEffect = (TriggerSceneEffect)abstractEffect;
                hashMap.put(3, String.valueOf(triggerSceneEffect.getX()));
                hashMap.put(4, String.valueOf(triggerSceneEffect.getY()));
                break;
            }
            case 21: {
                WaitTimeEffect waitTimeEffect = (WaitTimeEffect)abstractEffect;
                hashMap.put(8, Integer.toString(waitTimeEffect.getTime()));
                break;
            }
            case 22: {
                ShowTextEffect showTextEffect = (ShowTextEffect)abstractEffect;
                hashMap.put(2, showTextEffect.getText());
                hashMap.put(3, Integer.toString(showTextEffect.getX()));
                hashMap.put(4, Integer.toString(showTextEffect.getY()));
                hashMap.put(9, Integer.toString(showTextEffect.getRgbFrontColor()));
                hashMap.put(10, Integer.toString(showTextEffect.getRgbBorderColor()));
                break;
            }
            case 23: {
                HighlightItemEffect highlightItemEffect = (HighlightItemEffect)abstractEffect;
                hashMap.put(14, highlightItemEffect.getHighlightType());
                hashMap.put(15, highlightItemEffect.isHighlightAnimated());
                break;
            }
            case 24: {
                MoveObjectEffect moveObjectEffect = (MoveObjectEffect)abstractEffect;
                hashMap.put(3, String.valueOf(moveObjectEffect.getX()));
                hashMap.put(4, String.valueOf(moveObjectEffect.getY()));
                hashMap.put(16, Float.valueOf(moveObjectEffect.getScale()));
                hashMap.put(15, moveObjectEffect.isAnimated());
                hashMap.put(17, moveObjectEffect.getTranslateSpeed());
                hashMap.put(18, moveObjectEffect.getScaleSpeed());
            }
        }
        object3 = null;
        object2 = null;
        object = null;
        if (n2 != 16) {
            object3 = EffectDialog.showEditEffectDialog(this, n2, hashMap);
        } else {
            speakPlayerEffect = (RandomEffect)abstractEffect;
            object2 = new SingleEffectController(speakPlayerEffect.getPositiveEffect());
            object = new SingleEffectController(speakPlayerEffect.getNegativeEffect());
            object3 = EffectDialog.showEditRandomEffectDialog(speakPlayerEffect.getProbability(), (SingleEffectController)object2, (SingleEffectController)object);
        }
        if (object3 != null) {
            bl = n2 != 16 ? this.controller.addTool(new ReplaceEffectTool(this.effects, abstractEffect, (HashMap<Integer, Object>)object3)) : this.controller.addTool(new ReplaceEffectTool(this.effects, abstractEffect, (HashMap<Integer, Object>)object3, ((SingleEffectController)object2).getEffect(), ((SingleEffectController)object).getEffect()));
        }
        return bl;
    }

    public String selectAsset(int n) {
        int n2 = -1;
        int n3 = 0;
        if (n == 0) {
            n2 = 1;
            n3 = 2;
        } else if (n == 1) {
            n2 = 4;
        }
        String string = SelectResourceTool.selectAssetPathUsingChooser(n2, n3);
        return string;
    }

    public static void updateVarFlagSummary(VarFlagSummary varFlagSummary, Effects effects) {
        for (AbstractEffect abstractEffect : effects.getEffects()) {
            EffectsController.updateVarFlagSummary(varFlagSummary, (Effect)abstractEffect);
            if (abstractEffect.getType() != 16) continue;
            RandomEffect randomEffect = (RandomEffect)abstractEffect;
            if (randomEffect.getNegativeEffect() != null) {
                EffectsController.updateVarFlagSummary(varFlagSummary, (Effect)randomEffect.getNegativeEffect());
            }
            if (randomEffect.getPositiveEffect() == null) continue;
            EffectsController.updateVarFlagSummary(varFlagSummary, (Effect)randomEffect.getPositiveEffect());
        }
    }

    private static void updateVarFlagSummary(VarFlagSummary varFlagSummary, Effect effect) {
        if (effect.getType() == 0) {
            ActivateEffect activateEffect = (ActivateEffect)effect;
            varFlagSummary.addFlagReference(activateEffect.getTargetId());
        } else if (effect.getType() == 1) {
            DeactivateEffect deactivateEffect = (DeactivateEffect)effect;
            varFlagSummary.addFlagReference(deactivateEffect.getTargetId());
        } else if (effect.getType() == 17) {
            SetValueEffect setValueEffect = (SetValueEffect)effect;
            varFlagSummary.addVarReference(setValueEffect.getTargetId());
        } else if (effect.getType() == 18) {
            IncrementVarEffect incrementVarEffect = (IncrementVarEffect)effect;
            varFlagSummary.addVarReference(incrementVarEffect.getTargetId());
        } else if (effect.getType() == 19) {
            DecrementVarEffect decrementVarEffect = (DecrementVarEffect)effect;
            varFlagSummary.addVarReference(decrementVarEffect.getTargetId());
        }
        ConditionsController.updateVarFlagSummary(varFlagSummary, ((AbstractEffect)effect).getConditions());
    }

    public static boolean isValid(String string, List<String> list, Effects effects) {
        boolean bl = true;
        for (AbstractEffect abstractEffect : effects.getEffects()) {
            int n = abstractEffect.getType();
            if (n == 9 && ((PlayAnimationEffect)abstractEffect).getPath().length() == 0) {
                bl = false;
                if (list == null) continue;
                list.add(string + " >> " + TC.get((String)"Operation.AdventureConsistencyErrorPlayAnimation"));
                continue;
            }
            if (n == 8 && ((PlaySoundEffect)abstractEffect).getPath().length() == 0) {
                bl = false;
                if (list == null) continue;
                list.add(string + " >> " + TC.get((String)"Operation.AdventureConsistencyErrorPlaySound"));
                continue;
            }
            if (n != 16) continue;
            RandomEffect randomEffect = (RandomEffect)abstractEffect;
            Effects effects2 = new Effects();
            if (randomEffect.getPositiveEffect() != null) {
                effects2.add(randomEffect.getPositiveEffect());
            }
            if (randomEffect.getNegativeEffect() != null) {
                effects2.add(randomEffect.getNegativeEffect());
            }
            EffectsController.isValid(string + " >> " + TC.get((String)"Effect.RandomEffect"), list, effects2);
        }
        return bl;
    }

    public static int countAssetReferences(String string, Effects effects) {
        int n = 0;
        for (AbstractEffect abstractEffect : effects.getEffects()) {
            int n2 = abstractEffect.getType();
            if (n2 == 9 && ((PlayAnimationEffect)abstractEffect).getPath().equals(string) || n2 == 8 && ((PlaySoundEffect)abstractEffect).getPath().equals(string)) {
                ++n;
                continue;
            }
            if (n2 != 16) continue;
            RandomEffect randomEffect = (RandomEffect)abstractEffect;
            Effects effects2 = new Effects();
            if (randomEffect.getPositiveEffect() != null) {
                effects2.add(randomEffect.getPositiveEffect());
            }
            if (randomEffect.getNegativeEffect() != null) {
                effects2.add(randomEffect.getNegativeEffect());
            }
            n += EffectsController.countAssetReferences(string, effects2);
        }
        return n;
    }

    public static void getAssetReferences(List<String> list, List<Integer> list2, Effects effects) {
        for (AbstractEffect abstractEffect : effects.getEffects()) {
            int n = abstractEffect.getType();
            int n2 = -1;
            String string = null;
            if (n == 9) {
                PlayAnimationEffect playAnimationEffect = (PlayAnimationEffect)abstractEffect;
                string = playAnimationEffect.getPath();
                n2 = 1;
            } else if (n == 8) {
                PlaySoundEffect playSoundEffect = (PlaySoundEffect)abstractEffect;
                string = playSoundEffect.getPath();
                n2 = 4;
            } else if (n == 16) {
                RandomEffect randomEffect = (RandomEffect)abstractEffect;
                Effects effects2 = new Effects();
                if (randomEffect.getPositiveEffect() != null) {
                    effects2.add(randomEffect.getPositiveEffect());
                }
                if (randomEffect.getNegativeEffect() != null) {
                    effects2.add(randomEffect.getNegativeEffect());
                }
                EffectsController.getAssetReferences(list, list2, effects2);
            }
            if (string == null) continue;
            boolean bl = true;
            for (String string2 : list) {
                if (!string2.equals(string)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            int n3 = list.size();
            list.add(n3, string);
            list2.add(n3, n2);
        }
    }

    public static void deleteAssetReferences(String string, Effects effects) {
        for (AbstractEffect abstractEffect : effects.getEffects()) {
            PlayAnimationEffect playAnimationEffect;
            int n = abstractEffect.getType();
            if (n == 9) {
                playAnimationEffect = (PlayAnimationEffect)abstractEffect;
                if (!playAnimationEffect.getPath().equals(string)) continue;
                playAnimationEffect.setPath("");
                continue;
            }
            if (n == 8) {
                playAnimationEffect = (PlaySoundEffect)abstractEffect;
                if (!playAnimationEffect.getPath().equals(string)) continue;
                playAnimationEffect.setPath("");
                continue;
            }
            if (n != 16) continue;
            playAnimationEffect = (RandomEffect)abstractEffect;
            Effects effects2 = new Effects();
            if (playAnimationEffect.getPositiveEffect() != null) {
                effects2.add(playAnimationEffect.getPositiveEffect());
            }
            if (playAnimationEffect.getNegativeEffect() != null) {
                effects2.add(playAnimationEffect.getNegativeEffect());
            }
            EffectsController.deleteAssetReferences(string, effects2);
        }
    }

    public static int countIdentifierReferences(String string, Effects effects) {
        int n = 0;
        for (AbstractEffect abstractEffect : effects.getEffects()) {
            Object object;
            int n2 = abstractEffect.getType();
            if (n2 == 16) {
                object = (RandomEffect)abstractEffect;
                Effects effects2 = new Effects();
                if (object.getPositiveEffect() != null) {
                    effects2.add(object.getPositiveEffect());
                }
                if (object.getNegativeEffect() != null) {
                    effects2.add(object.getNegativeEffect());
                }
                EffectsController.countIdentifierReferences(string, effects2);
            } else if (abstractEffect instanceof HasTargetId && ((HasTargetId)abstractEffect).getTargetId().equals(string)) {
                ++n;
            }
            object = new ConditionsController(abstractEffect.getConditions());
            n += ((ConditionsController)object).countIdentifierReferences(string);
        }
        return n;
    }

    public static void replaceIdentifierReferences(String string, String string2, Effects effects) {
        for (AbstractEffect abstractEffect : effects.getEffects()) {
            Object object;
            if (abstractEffect instanceof HasTargetId) {
                if (((HasTargetId)abstractEffect).getTargetId().equals(string)) {
                    ((HasTargetId)abstractEffect).setTargetId(string2);
                }
            } else if (abstractEffect.getType() == 16) {
                object = (RandomEffect)abstractEffect;
                Effects effects2 = new Effects();
                if (object.getPositiveEffect() != null) {
                    effects2.add(object.getPositiveEffect());
                }
                if (object.getNegativeEffect() != null) {
                    effects2.add(object.getNegativeEffect());
                }
                EffectsController.replaceIdentifierReferences(string, string2, effects2);
            }
            object = new ConditionsController(abstractEffect.getConditions());
            ((ConditionsController)object).replaceIdentifierReferences(string, string2);
        }
    }

    public static void deleteIdentifierReferences(String string, Effects effects) {
        int n = 0;
        while (n < effects.getEffects().size()) {
            Effect effect = (Effect)effects.getEffects().get(n);
            int n2 = effect.getType();
            boolean bl = false;
            ConditionsController conditionsController = new ConditionsController(((AbstractEffect)effect).getConditions());
            conditionsController.deleteIdentifierReferences(string);
            if (n2 == 16) {
                RandomEffect randomEffect = (RandomEffect)effect;
                if (randomEffect.getPositiveEffect() != null && EffectsController.deleteSingleEffect(string, (Effect)randomEffect.getPositiveEffect())) {
                    randomEffect.setPositiveEffect(null);
                    bl = true;
                }
                if (randomEffect.getNegativeEffect() != null && EffectsController.deleteSingleEffect(string, (Effect)randomEffect.getNegativeEffect())) {
                    randomEffect.setNegativeEffect(null);
                }
            } else {
                bl = EffectsController.deleteSingleEffect(string, effect);
            }
            if (bl) {
                effects.getEffects().remove(n);
                continue;
            }
            ++n;
        }
    }

    private static boolean deleteSingleEffect(String string, Effect effect) {
        boolean bl = false;
        if (effect instanceof HasTargetId) {
            bl = ((HasTargetId)effect).getTargetId().equals(string);
        }
        return bl;
    }
}

