/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers;

import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.util.ArrayList;
import java.util.List;

public abstract class DataControl
extends Searchable
implements Cloneable {
    protected Controller controller = Controller.getInstance();
    protected boolean justCreated;

    protected DataControl() {
    }

    public abstract Object getContent();

    public abstract int[] getAddableElements();

    public boolean canAddElements() {
        int[] nArray = this.getAddableElements();
        boolean bl = false;
        for (int n : nArray) {
            bl = bl || this.canAddElement(n);
        }
        return bl;
    }

    public abstract boolean canAddElement(int var1);

    public abstract boolean canBeDeleted();

    public abstract boolean canBeDuplicated();

    public abstract boolean canBeMoved();

    public abstract boolean canBeRenamed();

    public abstract boolean addElement(int var1, String var2);

    public String getDefaultId(int n) {
        return "id";
    }

    public abstract boolean deleteElement(DataControl var1, boolean var2);

    public boolean duplicateElement(DataControl dataControl) {
        return false;
    }

    public abstract boolean moveElementUp(DataControl var1);

    public abstract boolean moveElementDown(DataControl var1);

    public abstract String renameElement(String var1);

    public abstract void updateVarFlagSummary(VarFlagSummary var1);

    public abstract boolean isValid(String var1, List<String> var2);

    public abstract int countAssetReferences(String var1);

    public abstract void getAssetReferences(List<String> var1, List<Integer> var2);

    public abstract void deleteAssetReferences(String var1);

    public abstract int countIdentifierReferences(String var1);

    public abstract void replaceIdentifierReferences(String var1, String var2);

    public abstract void deleteIdentifierReferences(String var1);

    public void setJustCreated(boolean bl) {
        this.justCreated = bl;
    }

    public boolean isJustCreated() {
        return this.justCreated;
    }

    @Override
    public List<Searchable> getPath(Searchable searchable) {
        if (searchable == this) {
            ArrayList<Searchable> arrayList = new ArrayList<Searchable>();
            arrayList.add(this);
            return arrayList;
        }
        return this.getPathToDataControl(searchable);
    }

    protected abstract List<Searchable> getPathToDataControl(Searchable var1);
}

