/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers;

import es.eucm.eadventure.common.data.chapter.conditions.Condition;
import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.common.data.chapter.conditions.VarCondition;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.general.conditions.AddConditionTool;
import es.eucm.eadventure.editor.control.tools.general.conditions.ClearConditionsTool;
import es.eucm.eadventure.editor.control.tools.general.conditions.DeleteConditionTool;
import es.eucm.eadventure.editor.control.tools.general.conditions.DuplicateConditionTool;
import es.eucm.eadventure.editor.control.tools.general.conditions.SetConditionTool;
import es.eucm.eadventure.editor.control.tools.general.conditions.SetEvalFunctionTool;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ConditionsController {
    public static final int VAR_CONDITION = 0;
    public static final int FLAG_CONDITION = 1;
    public static final int GLOBAL_STATE_CONDITION = 2;
    public static final String CONDITION_TYPE = "condition-type";
    public static final String CONDITION_TYPE_VAR = "var";
    public static final String CONDITION_TYPE_FLAG = "flag";
    public static final String CONDITION_TYPE_GS = "global-state";
    public static final String CONDITION_ID = "condition-id";
    public static final String CONDITION_VALUE = "condition-value";
    public static final String CONDITION_STATE = "condition-state";
    public static final int EVAL_FUNCTION_AND = 0;
    public static final int EVAL_FUNCTION_OR = 1;
    public static final int INDEX_NOT_USED = -1;
    public static String CONDITION_GROUP_TYPE = "condition-type";
    public static String CONDITION_RESTRICTIONS = "condition-restrictions";
    public static String CONDITION_OWNER = "condition-owner";
    public static String CONDITION_CUSTOM_MESSAGE = "condition-custom-message";
    public static final String[] STATE_VALUES = new String[]{"Active", "Inactive", ">", ">=", "<", "<=", "="};
    public static final String[] STATE_VALUES_FLAGS = new String[]{"Active", "Inactive"};
    public static final String[] STATE_VALUES_VARS = new String[]{">", ">=", "<", "<=", "="};
    private HashMap<String, ConditionContextProperty> context;
    private Conditions conditions;

    public static int getStateFromString(String string) {
        int n = -1;
        if (string.equals(STATE_VALUES[0])) {
            n = 0;
        } else if (string.equals(STATE_VALUES[1])) {
            n = 1;
        } else if (string.equals(STATE_VALUES[2])) {
            n = 2;
        } else if (string.equals(STATE_VALUES[3])) {
            n = 3;
        } else if (string.equals(STATE_VALUES[4])) {
            n = 6;
        } else if (string.equals(STATE_VALUES[5])) {
            n = 5;
        } else if (string.equals(STATE_VALUES[6])) {
            n = 4;
        }
        return n;
    }

    public static int getTypeFromString(String string) {
        int n = -1;
        if (string.equals(CONDITION_TYPE_FLAG)) {
            n = 1;
        }
        if (string.equals(CONDITION_TYPE_VAR)) {
            n = 0;
        }
        if (string.equals(CONDITION_TYPE_GS)) {
            n = 2;
        }
        return n;
    }

    public static void updateVarFlagSummary(VarFlagSummary varFlagSummary, Conditions conditions) {
        for (Object object : conditions.getSimpleConditions()) {
            if (object.getType() == 1) {
                varFlagSummary.addFlagReference(object.getId());
                continue;
            }
            if (object.getType() != 0) continue;
            varFlagSummary.addVarReference(object.getId());
        }
        for (int i = 0; i < conditions.getEitherConditionsBlockCount(); ++i) {
            for (Condition condition : conditions.getEitherConditions(i)) {
                if (condition.getType() == 1) {
                    varFlagSummary.addFlagReference(condition.getId());
                    continue;
                }
                if (condition.getType() != 0) continue;
                varFlagSummary.addVarReference(condition.getId());
            }
        }
    }

    public static HashMap<String, ConditionContextProperty> createContextFromOwner(int n, String string) {
        HashMap<String, ConditionContextProperty> hashMap = new HashMap<String, ConditionContextProperty>();
        ConditionOwner conditionOwner = new ConditionOwner(n, string);
        hashMap.put(CONDITION_OWNER, conditionOwner);
        if (TC.containsConditionsContextText((int)n, (int)1) && TC.containsConditionsContextText((int)n, (int)2)) {
            ConditionCustomMessage conditionCustomMessage = new ConditionCustomMessage(TC.getConditionsContextText((int)n, (int)1), TC.getConditionsContextText((int)n, (int)2));
            hashMap.put(CONDITION_CUSTOM_MESSAGE, conditionCustomMessage);
        }
        return hashMap;
    }

    public ConditionsController(Conditions conditions) {
        this(conditions, new HashMap<String, ConditionContextProperty>());
    }

    public ConditionsController(Conditions conditions, int n, String string) {
        this(conditions, ConditionsController.createContextFromOwner(n, string));
    }

    public ConditionsController(Conditions conditions, HashMap<String, ConditionContextProperty> hashMap) {
        ConditionOwner conditionOwner;
        this.conditions = conditions;
        this.context = hashMap;
        if (hashMap.containsKey(CONDITION_OWNER) && (conditionOwner = (ConditionOwner)hashMap.get(CONDITION_OWNER)).getOwnerType() == 54) {
            ConditionRestrictions conditionRestrictions = new ConditionRestrictions(new String[]{conditionOwner.getOwnerName()});
            this.context.put(CONDITION_RESTRICTIONS, conditionRestrictions);
        }
    }

    public int getBlocksCount() {
        return this.conditions.size();
    }

    public boolean isEmpty() {
        return this.conditions.isEmpty();
    }

    public int getConditionCount(int n) {
        if (n < 0 || n >= this.conditions.size()) {
            return -1;
        }
        return this.conditions.get(n).size();
    }

    public boolean deleteCondition(int n, int n2) {
        if (n < 0 || n >= this.conditions.size()) {
            return false;
        }
        if (n2 < 0 || n2 >= this.conditions.get(n).size()) {
            return false;
        }
        return Controller.getInstance().addTool(new DeleteConditionTool(this.conditions, n, n2));
    }

    public boolean duplicateCondition(int n, int n2) {
        if (n < 0 || n >= this.conditions.size()) {
            return false;
        }
        if (n2 < 0 || n2 >= this.conditions.get(n).size()) {
            return false;
        }
        return Controller.getInstance().addTool(new DuplicateConditionTool(this.conditions, n, n2));
    }

    public boolean setCondition(int n, int n2, HashMap<String, String> hashMap) {
        if (n < 0 || n >= this.conditions.size()) {
            return false;
        }
        if (n2 < 0 || n2 >= this.conditions.get(n).size()) {
            return false;
        }
        if (hashMap.get(CONDITION_TYPE) == null || hashMap.get(CONDITION_ID) == null || hashMap.get(CONDITION_STATE) == null) {
            return false;
        }
        if (hashMap.get(CONDITION_TYPE).equals(CONDITION_TYPE_VAR) && hashMap.get(CONDITION_VALUE) == null) {
            return false;
        }
        return Controller.getInstance().addTool(new SetConditionTool(this.conditions, n, n2, hashMap));
    }

    public void deleteIdentifierReferences(String string) {
        Iterator iterator = this.conditions.getConditionsList().iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                Condition condition = (Condition)iterator2.next();
                if (condition.getType() != 2 || !condition.getId().equals(string)) continue;
                iterator2.remove();
            }
            if (list.size() != 0) continue;
            iterator.remove();
        }
    }

    public void replaceIdentifierReferences(String string, String string2) {
        for (int i = 0; i < this.conditions.size(); ++i) {
            for (int j = 0; j < this.conditions.get(i).size(); ++j) {
                if (!((Condition)this.conditions.get(i).get(j)).getId().equals(string)) continue;
                ((Condition)this.conditions.get(i).get(j)).setId(string2);
            }
        }
    }

    public int countIdentifierReferences(String string) {
        int n = 0;
        for (String string2 : this.conditions.getGloblaStateIds()) {
            if (!string2.equals(string)) continue;
            ++n;
        }
        return n;
    }

    public HashMap<String, String> getCondition(int n, int n2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (n < 0 || n >= this.conditions.size()) {
            return null;
        }
        List list = this.conditions.get(n);
        if (n2 < 0 || n2 >= list.size()) {
            return null;
        }
        Condition condition = (Condition)list.get(n2);
        hashMap.put(CONDITION_ID, condition.getId());
        hashMap.put(CONDITION_STATE, Integer.toString(condition.getState()));
        if (condition.getType() == 1) {
            hashMap.put(CONDITION_TYPE, CONDITION_TYPE_FLAG);
            hashMap.put(CONDITION_VALUE, Integer.toString(condition.getState()));
        } else if (condition.getType() == 0) {
            hashMap.put(CONDITION_TYPE, CONDITION_TYPE_VAR);
            VarCondition varCondition = (VarCondition)condition;
            hashMap.put(CONDITION_VALUE, Integer.toString(varCondition.getValue()));
        } else if (condition.getType() == 2) {
            hashMap.put(CONDITION_TYPE, CONDITION_TYPE_GS);
            hashMap.put(CONDITION_VALUE, Integer.toString(condition.getState()));
        }
        return hashMap;
    }

    public boolean addCondition(int n, int n2, String string, String string2, String string3, String string4) {
        if (n < 0 || n > this.conditions.size()) {
            return false;
        }
        if (string == null || string2 == null || string3 == null) {
            return false;
        }
        if (string.equals(CONDITION_TYPE_VAR) && string4 == null) {
            return false;
        }
        return Controller.getInstance().addTool(new AddConditionTool(this.conditions, n, n2, string, string2, string3, string4));
    }

    public boolean setEvalFunction(int n, int n2, int n3) {
        if (n3 != 0 && n3 != 1) {
            return false;
        }
        if (n2 == -1 ? n < 0 || n >= this.conditions.size() - 1 : n2 >= 0 && (n < 0 || n >= this.conditions.size())) {
            return false;
        }
        return Controller.getInstance().addTool(new SetEvalFunctionTool(this.conditions, n, n2, n3));
    }

    public HashMap<String, ConditionContextProperty> getContext() {
        return this.context;
    }

    public static String getOperatorFromString(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (n) {
            case 2: {
                return STATE_VALUES[2];
            }
            case 3: {
                return STATE_VALUES[3];
            }
            case 6: {
                return STATE_VALUES[4];
            }
            case 5: {
                return STATE_VALUES[5];
            }
            case 4: {
                return STATE_VALUES[6];
            }
        }
        return STATE_VALUES[2];
    }

    public void clearConditions() {
        Controller.getInstance().addTool(new ClearConditionsTool(this.conditions));
    }

    public static class ConditionOwner
    extends ConditionContextProperty {
        private int ownerType;
        private String ownerName;
        private ConditionOwner parent;

        public ConditionOwner(int n, String string, ConditionOwner conditionOwner) {
            super(CONDITION_OWNER);
            this.ownerType = n;
            this.ownerName = string;
            this.parent = conditionOwner;
        }

        public ConditionOwner(int n, String string) {
            this(n, string, null);
        }

        public int getOwnerType() {
            return this.ownerType;
        }

        public String getOwnerName() {
            return this.ownerName;
        }

        public ConditionOwner getParent() {
            return this.parent;
        }
    }

    public static class ConditionCustomMessage
    extends ConditionContextProperty {
        public static final String ELEMENT_TYPE = "{#ELEMENT_TYPE$}";
        public static final String ELEMENT_ID = "{#ELEMENT_ID$}";
        private String sentence;
        private String sentenceNoConditions;

        public ConditionCustomMessage(String[] stringArray, String[] stringArray2) {
            super(CONDITION_CUSTOM_MESSAGE);
            this.sentence = "";
            for (String string : stringArray) {
                this.sentence = this.sentence + string + " ";
            }
            if (stringArray.length > 0) {
                this.sentence = this.sentence.substring(0, this.sentence.length() - 1);
            }
            this.sentenceNoConditions = "";
            for (String string : stringArray2) {
                this.sentenceNoConditions = this.sentenceNoConditions + string + " ";
            }
            if (stringArray2.length > 0) {
                this.sentenceNoConditions = this.sentenceNoConditions.substring(0, this.sentenceNoConditions.length() - 1);
            }
        }

        public ConditionCustomMessage(List<String> list, List<String> list2) {
            this(list.toArray(new String[0]), list2.toArray(new String[0]));
        }

        public ConditionCustomMessage(String string, String string2) {
            super(CONDITION_CUSTOM_MESSAGE);
            this.sentence = string;
            this.sentenceNoConditions = string2;
        }

        private String formatSentence(ConditionOwner conditionOwner, String string) {
            String string2 = new String(string);
            if (string.contains(ELEMENT_TYPE)) {
                string2 = string2.replace(ELEMENT_TYPE, "<i>" + TC.getElement((int)conditionOwner.getOwnerType()) + "</i>");
            }
            if (string.contains(ELEMENT_ID)) {
                string2 = string2.replace(ELEMENT_ID, "<b>\"" + conditionOwner.getOwnerName() + "\"</b>");
            }
            return string2;
        }

        public String getFormattedSentence(ConditionOwner conditionOwner) {
            return this.formatSentence(conditionOwner, this.sentence);
        }

        public String getNoConditionFormattedSentence(ConditionOwner conditionOwner) {
            return this.formatSentence(conditionOwner, this.sentenceNoConditions);
        }
    }

    public static class ConditionRestrictions
    extends ConditionContextProperty {
        private String[] forbiddenIds;

        public ConditionRestrictions(String[] stringArray) {
            super(CONDITION_RESTRICTIONS);
            this.forbiddenIds = stringArray;
        }

        public ConditionRestrictions(String string) {
            this(new String[]{string});
        }

        public String[] getForbiddenIds() {
            return this.forbiddenIds;
        }
    }

    public static abstract class ConditionContextProperty {
        private String type;

        public ConditionContextProperty(String string) {
            this.type = string;
        }

        public String getType() {
            return this.type;
        }
    }
}

