/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers;

import es.eucm.eadventure.editor.control.controllers.ToolManager;
import es.eucm.eadventure.editor.control.tools.Tool;
import java.util.Stack;

public class ChapterToolManager {
    private ToolManager globalToolManager = new ToolManager(true);
    private Stack<ToolManager> localToolManagers = new Stack();

    public void clear() {
        this.globalToolManager.clear();
        this.localToolManagers.clear();
    }

    public boolean addTool(Tool tool) {
        return this.addTool(true, tool);
    }

    public boolean addTool(boolean bl, Tool tool) {
        if (this.localToolManagers.isEmpty()) {
            boolean bl2 = this.globalToolManager.addTool(bl, tool);
            if (bl2) {
                System.out.println("[ToolManager] Global Tool Manager: Tool \"" + tool.getToolName() + "\" ADDED");
            } else {
                System.out.println("[ToolManager] Global Tool Manager: Tool \"" + tool.getToolName() + "\" NOT ADDED");
            }
            return bl2;
        }
        boolean bl3 = this.localToolManagers.peek().addTool(bl, tool);
        if (bl3) {
            System.out.println("[ToolManager] Local Tool Manager: Tool \"" + tool.getToolName() + "\" ADDED");
        } else {
            System.out.println("[ToolManager] Local Tool Manager: Tool \"" + tool.getToolName() + "\" NOT ADDED");
        }
        return bl3;
    }

    public void undoTool() {
        if (this.localToolManagers.isEmpty()) {
            this.globalToolManager.undoTool();
            System.out.println("[ToolManager] Global Tool Manager: Undo Performed");
        } else {
            this.localToolManagers.peek().undoTool();
            System.out.println("[ToolManager] Local Tool Manager: Undo Performed");
        }
    }

    public void redoTool() {
        if (this.localToolManagers.isEmpty()) {
            this.globalToolManager.redoTool();
            System.out.println("[ToolManager] Global Tool Manager: Redo Performed");
        } else {
            this.localToolManagers.peek().redoTool();
            System.out.println("[ToolManager] Local Tool Manager: Redo Performed");
        }
    }

    public void pushLocalToolManager() {
        this.localToolManagers.push(new ToolManager(false));
        System.out.println("[ToolManager] Local Tool Manager PUSHED: Total local tool managers = " + this.localToolManagers.size());
    }

    public void popLocalToolManager() {
        if (!this.localToolManagers.isEmpty()) {
            this.localToolManagers.pop();
            System.out.println("[ToolManager] Local Tool Manager POPED: Total local tool managers = " + this.localToolManagers.size());
        } else {
            System.out.println("[ToolManager] Local Tool Manager Could NOT be POPED: Total local tool managers = " + this.localToolManagers.size());
        }
    }

    public ToolManager getGlobalToolManager() {
        return this.globalToolManager;
    }
}

