/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers;

import es.eucm.eadventure.common.auxiliar.AssetsConstants;
import es.eucm.eadventure.common.auxiliar.AssetsImageDimensions;
import es.eucm.eadventure.common.auxiliar.File;
import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.auxiliar.SpecialAssetPaths;
import es.eucm.eadventure.common.auxiliar.zipurl.ZipURL;
import es.eucm.eadventure.common.data.animation.Animation;
import es.eucm.eadventure.common.data.animation.Frame;
import es.eucm.eadventure.common.data.animation.ImageLoaderFactory;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.common.loader.InputStreamCreator;
import es.eucm.eadventure.common.loader.Loader;
import es.eucm.eadventure.common.loader.incidences.Incidence;
import es.eucm.eadventure.editor.auxiliar.categoryfilters.AnimationFileFilter;
import es.eucm.eadventure.editor.auxiliar.categoryfilters.AudioFileFilter;
import es.eucm.eadventure.editor.auxiliar.categoryfilters.FormattedTextFileFilter;
import es.eucm.eadventure.editor.auxiliar.categoryfilters.ImageFileFilter;
import es.eucm.eadventure.editor.auxiliar.categoryfilters.VideoFileFilter;
import es.eucm.eadventure.editor.auxiliar.filefilters.JPGSlidesFileFilter;
import es.eucm.eadventure.editor.auxiliar.filefilters.MP3FileFilter;
import es.eucm.eadventure.editor.auxiliar.filefilters.PNGAnimationFileFilter;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.EditorImageLoader;
import es.eucm.eadventure.editor.gui.assetchooser.AnimationChooser;
import es.eucm.eadventure.editor.gui.assetchooser.AssetChooser;
import es.eucm.eadventure.editor.gui.assetchooser.AudioChooser;
import es.eucm.eadventure.editor.gui.assetchooser.BackgroundChooser;
import es.eucm.eadventure.editor.gui.assetchooser.ButtonChooser;
import es.eucm.eadventure.editor.gui.assetchooser.CursorChooser;
import es.eucm.eadventure.editor.gui.assetchooser.FormatedTextChooser;
import es.eucm.eadventure.editor.gui.assetchooser.IconChooser;
import es.eucm.eadventure.editor.gui.assetchooser.ImageChooser;
import es.eucm.eadventure.editor.gui.assetchooser.VideoChooser;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.media.MediaLocator;

public class AssetsController
implements SpecialAssetPaths,
AssetsConstants,
AssetsImageDimensions {
    public static final int FILTER_NONE = 0;
    public static final int FILTER_JPG = 1;
    public static final int FILTER_PNG = 2;
    public static final int FILTER_MP3 = 3;
    private static final String CATEGORY_BACKGROUND_FOLDER = "assets/background";
    public static final String CATEGORY_ANIMATION_FOLDER = "assets/animation";
    private static final String CATEGORY_IMAGE_FOLDER = "assets/image";
    private static final String CATEGORY_ICON_FOLDER = "assets/icon";
    private static final String CATEGORY_AUDIO_PATH = "assets/audio";
    private static final String CATEGORY_VIDEO_PATH = "assets/video";
    private static final String CATEGORY_CURSOR_PATH = "gui/cursors";
    private static final String CATEGORY_STYLED_TEXT_PATH = "assets/styledtext";
    private static final String CATEGORY_BUTTON_PATH = "gui/buttons";
    private static final String CATEGORY_ARROW_BOOK_PATH = "assets/arrows";
    public static final String CATEGORY_SPECIAL_ASSETS = "assets/special";
    private static HashMap<String, File> tempFiles = new HashMap();

    private AssetsController() {
    }

    public static void resetCache() {
        tempFiles = new HashMap();
    }

    public static String[] categoryFolders() {
        String[] stringArray = new String[12];
        for (int i = 0; i < 12; ++i) {
            stringArray[i] = AssetsController.getCategoryFolder(i);
        }
        return stringArray;
    }

    public static void createFolderStructure() {
        File file;
        File file2;
        File file3;
        File file4;
        File file5 = new File(Controller.getInstance().getProjectFolder());
        String[] stringArray = AssetsController.categoryFolders();
        for (int i = 0; i < stringArray.length; ++i) {
            file4 = new File(file5, stringArray[i]);
            file4.create();
        }
        File file6 = new File("descriptor.dtd");
        if (file6.exists()) {
            if (!file6.copyTo((java.io.File)new File(file5, "descriptor.dtd"))) {
                Controller.getInstance().showErrorDialog(TC.get((String)"Error.DTD.NotCopied.Title"), TC.get((String)"Error.DTD.NotCopied.Message", (String)"descriptor.dtd"));
            }
        } else {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.DTD.NotFound.Title"), TC.get((String)"Error.DTD.NotFound.Message", (String)"descriptor.dtd"));
        }
        if ((file4 = new File("eadventure.dtd")).exists()) {
            if (!file4.copyTo((java.io.File)new File(file5, "eadventure.dtd"))) {
                Controller.getInstance().showErrorDialog(TC.get((String)"Error.DTD.NotCopied.Title"), TC.get((String)"Error.DTD.NotCopied.Message", (String)"eadventure.dtd"));
            }
        } else {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.DTD.NotFound.Title"), TC.get((String)"Error.DTD.NotFound.Message", (String)"eadventure.dtd"));
        }
        if ((file3 = new File("assessment.dtd")).exists()) {
            if (!file3.copyTo((java.io.File)new File(file5, "assessment.dtd"))) {
                Controller.getInstance().showErrorDialog(TC.get((String)"Error.DTD.NotCopied.Title"), TC.get((String)"Error.DTD.NotCopied.Message", (String)"assessment.dtd"));
            }
        } else {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.DTD.NotFound.Title"), TC.get((String)"Error.DTD.NotFound.Message", (String)"assessment.dtd"));
        }
        if ((file2 = new File("adaptation.dtd")).exists()) {
            if (!file2.copyTo((java.io.File)new File(file5, "adaptation.dtd"))) {
                Controller.getInstance().showErrorDialog(TC.get((String)"Error.DTD.NotCopied.Title"), TC.get((String)"Error.DTD.NotCopied.Message", (String)"adaptation.dtd"));
            }
        } else {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.DTD.NotFound.Title"), TC.get((String)"Error.DTD.NotFound.Message", (String)"adaptation.dtd"));
        }
        if ((file = new File("animation.dtd")).exists()) {
            if (!file.copyTo((java.io.File)new File(file5, "animation.dtd"))) {
                Controller.getInstance().showErrorDialog(TC.get((String)"Error.DTD.NotCopied.Title"), TC.get((String)"Error.DTD.NotCopied.Message", (String)"animation.dtd"));
            }
        } else {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.DTD.NotFound.Title"), TC.get((String)"Error.DTD.NotFound.Message", (String)"animation.dtd"));
        }
    }

    public static String[] getAssetFilenames(int n) {
        return AssetsController.getAssetFilenames(n, 0);
    }

    public static String[] getAssetFilenames(int n, int n2) {
        String[] stringArray;
        block5: {
            stringArray = new String[]{};
            File file = new File(Controller.getInstance().getProjectFolder(), AssetsController.getCategoryFolder(n));
            File[] fileArray = file.listFiles((FileFilter)AssetsController.getAssetsFileFilter(n, n2));
            if (fileArray == null) break block5;
            if (n != 7) {
                stringArray = new String[fileArray.length];
                for (int i = 0; i < fileArray.length; ++i) {
                    stringArray[i] = fileArray[i].getName();
                }
            } else {
                int n3;
                ArrayList<File> arrayList = new ArrayList<File>();
                for (n3 = 0; n3 < fileArray.length; ++n3) {
                    if (fileArray[n3].isDirectory()) continue;
                    arrayList.add(fileArray[n3]);
                }
                stringArray = new String[arrayList.size()];
                for (n3 = 0; n3 < arrayList.size(); ++n3) {
                    stringArray[n3] = ((java.io.File)arrayList.get(n3)).getName();
                }
            }
        }
        return stringArray;
    }

    public static String[] getAssetsList(int n) {
        return AssetsController.getAssetsList(n, 0);
    }

    public static String[] getAssetsList(int n, int n2) {
        String[] stringArray;
        block5: {
            stringArray = new String[]{};
            File file = new File(Controller.getInstance().getProjectFolder(), AssetsController.getCategoryFolder(n));
            File[] fileArray = file.listFiles((FileFilter)AssetsController.getAssetsFileFilter(n, n2));
            if (fileArray == null) break block5;
            if (n != 7) {
                stringArray = new String[fileArray.length];
                for (int i = 0; i < fileArray.length; ++i) {
                    stringArray[i] = AssetsController.getCategoryFolder(n) + "/" + fileArray[i].getName();
                }
            } else {
                int n3;
                ArrayList<File> arrayList = new ArrayList<File>();
                for (n3 = 0; n3 < fileArray.length; ++n3) {
                    if (fileArray[n3].isDirectory()) continue;
                    arrayList.add(fileArray[n3]);
                }
                stringArray = new String[arrayList.size()];
                for (n3 = 0; n3 < arrayList.size(); ++n3) {
                    stringArray[n3] = AssetsController.getCategoryFolder(n) + "/" + ((java.io.File)arrayList.get(n3)).getName();
                }
            }
        }
        return stringArray;
    }

    public static InputStream getInputStream(String string) {
        FileInputStream fileInputStream = null;
        if (string == null) {
            return fileInputStream;
        }
        try {
            if (new File(string).exists()) {
                fileInputStream = new FileInputStream(string);
            } else if (new File(Controller.getInstance().getProjectFolder(), string).exists()) {
                fileInputStream = new FileInputStream(Controller.getInstance().getProjectFolder() + "/" + string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            ReportDialog.GenerateErrorReport((Exception)fileNotFoundException, (boolean)true, (String)"UNKNOWERROR");
        }
        return fileInputStream;
    }

    public static MediaLocator getVideo(String string) {
        String string2 = null;
        String[] stringArray = AssetsController.getAssetsList(5);
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            n = i;
        }
        if (n != -1) {
            string2 = new File(Controller.getInstance().getProjectFolder(), string).getAbsolutePath();
        }
        File file = new File(string2);
        try {
            return new MediaLocator(file.toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            ReportDialog.GenerateErrorReport((Exception)malformedURLException, (boolean)true, (String)"UNKNOWERROR");
            return null;
        }
    }

    public static URL getResourceAsURLFromZip(String string) {
        try {
            return ZipURL.createAssetURL((String)Controller.getInstance().getProjectFolder(), (String)string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static Image getImage(String string) {
        BufferedImage bufferedImage = null;
        try {
            InputStream inputStream = AssetsController.getInputStream(string);
            if (inputStream != null) {
                bufferedImage = ImageIO.read(inputStream);
                if (bufferedImage == null || ((Image)bufferedImage).getHeight(null) == -1 || ((Image)bufferedImage).getWidth(null) == -1) {
                    Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.ImageTypeNotSupported"));
                }
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            ReportDialog.GenerateErrorReport((Exception)iOException, (boolean)true, (String)"UNKNOWERROR");
        }
        catch (Exception exception) {
            ReportDialog.GenerateErrorReport((Exception)exception, (boolean)true, (String)"UNKNOWERROR");
        }
        return bufferedImage;
    }

    public static Image[] getAnimation(String string) {
        ArrayList<Image> arrayList = new ArrayList<Image>();
        String string2 = AssetsController.getExtension(string);
        string = AssetsController.removeSuffix(string);
        boolean bl = false;
        for (int i = 1; i < 100 && !bl; ++i) {
            Image image = AssetsController.getImage(string + String.format("_%02d.", i) + string2);
            if (image != null) {
                arrayList.add(image);
                continue;
            }
            bl = true;
        }
        return arrayList.toArray(new Image[0]);
    }

    public static boolean addAssets(int n) {
        boolean bl = false;
        String[] stringArray = Controller.getInstance().showMultipleSelectionLoadDialog((javax.swing.filechooser.FileFilter)AssetsController.getAssetsFileFilter(n, 0));
        if (stringArray != null) {
            bl = true;
            for (String string : stringArray) {
                bl &= AssetsController.addSingleAsset(n, string);
            }
        }
        return bl;
    }

    public static boolean addSingleAsset(int n, String string) {
        return AssetsController.addSingleAsset(n, string, true);
    }

    public static boolean addSingleAsset(int n, String string, boolean bl) {
        boolean bl2 = false;
        File file = new File(Controller.getInstance().getProjectFolder(), AssetsController.getCategoryFolder(n));
        if (AssetsController.checkAsset(string, n)) {
            if (n == 1 && !string.endsWith(".eaa")) {
                String string2 = AssetsController.getExtension(string);
                string = AssetsController.removeSuffix(string);
                boolean bl3 = false;
                for (int i = 1; i < 100 && !bl3; ++i) {
                    File file2 = new File(string + String.format("_%02d.", i) + string2);
                    if (file2.exists()) {
                        File file3 = new File(file, file2.getName());
                        if (!file2.getAbsolutePath().toLowerCase().equals(file3.getAbsolutePath().toLowerCase())) {
                            if (file2.isDirectory()) {
                                bl2 = file2.copyAllTo((java.io.File)file3);
                                continue;
                            }
                            bl2 = file2.copyTo((java.io.File)file3);
                            continue;
                        }
                        bl2 = false;
                        bl3 = true;
                        continue;
                    }
                    bl3 = true;
                }
            } else if (n == 1) {
                Animation animation = Loader.loadAnimation((InputStreamCreator)AssetsController.getInputStreamCreator(), (String)string, (ImageLoaderFactory)new EditorImageLoader());
                animation.setAbsolutePath(string);
                File file4 = new File(string);
                File file5 = file4.getName().contains("EmptyAnimation") ? new File(Controller.getInstance().getProjectFolder() + "/" + CATEGORY_SPECIAL_ASSETS + "/" + file4.getName()) : new File(file, file4.getName());
                if (!file4.getAbsolutePath().toLowerCase().equals(file5.getAbsolutePath().toLowerCase())) {
                    if (file5.exists() && !Controller.getInstance().showStrictConfirmDialog(TC.get((String)"Assets.AddAsset"), TC.get((String)"Assets.WarningAssetFound", (String)file4.getName()))) {
                        AssetsController.deleteAsset(string, false);
                    }
                    bl2 = file4.copyTo((java.io.File)file5);
                } else {
                    bl2 = true;
                }
                if (bl2) {
                    for (Frame frame : animation.getFrames()) {
                        String string3 = frame.getImageAbsolutePath();
                        file4 = new File(string3);
                        file5 = new File(file, file4.getName());
                        file4.copyTo((java.io.File)file5);
                        String string4 = frame.getSoundAbsolutePath();
                        if (string4 == null) continue;
                        file4 = new File(string4);
                        file5 = new File(file, file4.getName());
                        file4.copyTo((java.io.File)file5);
                    }
                }
            } else if (n == 7 && (string.endsWith(".html") || string.endsWith(".htm"))) {
                bl2 = AssetsController.addStyledText(string, file);
            } else {
                File file6 = new File(string);
                File file7 = new File(file, file6.getName());
                if (!file6.getAbsolutePath().toLowerCase().equals(file7.getAbsolutePath().toLowerCase())) {
                    if (bl && file7.exists() && !Controller.getInstance().showStrictConfirmDialog(TC.get((String)"Assets.AddAsset"), TC.get((String)"Assets.WarningAssetFound", (String)file6.getName()))) {
                        AssetsController.deleteAsset(string, false);
                    }
                    bl2 = file6.isDirectory() ? file6.copyAllTo((java.io.File)file7) : file6.copyTo((java.io.File)file7);
                } else {
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    private static boolean addStyledText(String string, File file) {
        boolean bl = true;
        try {
            File file2;
            Object object;
            String string2;
            File file3 = new File(string);
            File file4 = new File(file, file3.getName());
            BufferedReader bufferedReader = new BufferedReader(new FileReader((java.io.File)file3));
            String string3 = "";
            String string4 = null;
            while ((string4 = bufferedReader.readLine()) != null) {
                string3 = string3 + string4 + "\n";
            }
            bufferedReader.close();
            if (string3.indexOf("<link rel=\"stylesheet\"") != -1) {
                string2 = string3.substring(string3.indexOf("href=\"") + 6, string3.indexOf(34, string3.indexOf("href=\"") + 8));
                object = new File(file3.getParent(), string2);
                file2 = new File(file, string2);
                bl = object.copyTo((java.io.File)file2);
            }
            string2 = new String(string3);
            while (bl && string2.indexOf("src=\"") != -1) {
                string2 = string2.substring(string2.indexOf("src=\"") + 5, string2.length() - 1);
                object = string2.substring(0, string2.indexOf(34));
                file2 = new File(file3.getParent(), (String)object);
                File file5 = new File(file, (String)object);
                bl = file2.copyTo((java.io.File)file5);
            }
            bl = file3.copyTo((java.io.File)file4);
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = false;
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    public static boolean deleteAsset(String string) {
        boolean bl = AssetsController.deleteAsset(string, true);
        Controller controller = Controller.getInstance();
        if (bl) {
            if (string.startsWith(CATEGORY_ANIMATION_FOLDER)) {
                controller.deleteAssetReferences(AssetsController.removeSuffix(string));
            } else {
                controller.deleteAssetReferences(string);
            }
        }
        return bl;
    }

    public static boolean deleteAsset(String string, boolean bl) {
        boolean bl2 = false;
        String string2 = null;
        string2 = string.startsWith(CATEGORY_ANIMATION_FOLDER) ? String.valueOf(Controller.getInstance().countAssetReferences(AssetsController.removeSuffix(string))) : String.valueOf(Controller.getInstance().countAssetReferences(string));
        if (!bl || Controller.getInstance().showStrictConfirmDialog(TC.get((String)"Assets.DeleteAsset"), TC.get((String)"Assets.DeleteAssetWarning", (String[])new String[]{AssetsController.getFilename(string), string2}))) {
            if (string.startsWith(CATEGORY_ANIMATION_FOLDER)) {
                bl2 = true;
                String string3 = AssetsController.getExtension(string);
                string = AssetsController.removeSuffix(string);
                boolean bl3 = false;
                for (int i = 1; i < 100 && !bl3; ++i) {
                    File file = new File(Controller.getInstance().getProjectFolder(), string + String.format("_%02d.", i) + string3);
                    if (file.exists()) {
                        bl2 &= file.delete();
                        continue;
                    }
                    bl3 = true;
                }
            } else {
                bl2 = new File(Controller.getInstance().getProjectFolder(), string).delete();
            }
        }
        return bl2;
    }

    public static void copyAssets(String string, String string2) {
        File file;
        File file2 = new File(string + "/assets");
        if (file2.exists()) {
            file = new File(string2 + "/assets");
            if (file.exists()) {
                file.deleteAll();
            }
            file2.copyAllTo((java.io.File)file);
        }
        if ((file = new File(string + "/gui")).exists()) {
            File file3 = new File(string2 + "/gui");
            if (file3.exists()) {
                file3.deleteAll();
            }
            file.copyAllTo((java.io.File)file3);
        }
    }

    public static void addSpecialAssets() {
        String string = Controller.getInstance().getProjectFolder();
        File file = new File("img/assets/DefaultBook.jpg");
        if (file.exists()) {
            file.copyTo((java.io.File)new File(string, "assets/special/DefaultBook.jpg"));
        } else {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.SpecialAssetNotFound", (String)"img/assets/DefaultBook.jpg"));
        }
        file = new File("img/assets/DefaultLeftNormalArrow.png");
        if (file.exists()) {
            file.copyTo((java.io.File)new File(string, "assets/special/DefaultLeftNormalArrow.png"));
        } else {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.SpecialAssetNotFound", (String)"img/assets/DefaultLeftNormalArrow.png"));
        }
        file = new File("img/assets/DefaultLeftOverArrow.png");
        if (file.exists()) {
            file.copyTo((java.io.File)new File(string, "assets/special/DefaultLeftOverArrow.png"));
        } else {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.SpecialAssetNotFound", (String)"img/assets/DefaultLeftOverArrow.png"));
        }
        file = new File("img/assets/EmptyImage.png");
        if (file.exists()) {
            file.copyTo((java.io.File)new File(string, "assets/special/EmptyImage.png"));
        }
        if ((file = new File("img/assets/EmptyBackground.png")).exists()) {
            file.copyTo((java.io.File)new File(string, "assets/special/EmptyBackground.png"));
        } else {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.SpecialAssetNotFound", (String)"img/assets/EmptyImage.png"));
        }
        file = new File("img/assets/EmptyIcon.png");
        if (file.exists()) {
            file.copyTo((java.io.File)new File(string, "assets/special/EmptyIcon.png"));
        } else {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.SpecialAssetNotFound", (String)"img/assets/EmptyIcon.png"));
        }
        file = new File("img/assets/EmptyAnimation_01.png");
        if (file.exists()) {
            file.copyTo((java.io.File)new File(string, "assets/special/EmptyAnimation_01.png"));
        } else {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.SpecialAssetNotFound", (String)"img/assets/EmptyAnimation_01.png"));
        }
    }

    public static boolean isAssetSpecial(String string) {
        return string.equals("assets/special/EmptyImage.png") || string.equals("assets/special/EmptyIcon.png") || string.equals("assets/special/EmptyAnimation");
    }

    public static String getFilename(String string) {
        int n = Math.max(string.lastIndexOf(47) + 1, string.lastIndexOf(92) + 1);
        return string.substring(n, string.length());
    }

    public static String removeSuffix(String string) {
        if (string.toLowerCase().endsWith("_01.png")) {
            string = string.substring(0, string.length() - 7);
        } else if (string.toLowerCase().endsWith("_01.jpg")) {
            string = string.substring(0, string.length() - 7);
        }
        return string;
    }

    private static boolean checkAsset(String string, int n) {
        boolean bl = true;
        if (AssetsController.isImageWithRestrictedDimension(n)) {
            Controller controller = Controller.getInstance();
            String string2 = AssetsController.getFilename(string);
            Image image = AssetsController.getImage(string);
            int n2 = image.getWidth(null);
            int n3 = image.getHeight(null);
            String[] stringArray = new String[]{string2, String.valueOf(n2), String.valueOf(n3)};
            Dimension dimension = AssetsController.getRestrictedDimension(n);
            int n4 = (int)dimension.getWidth();
            int n5 = (int)dimension.getHeight();
            if (n == 3) {
                if (n2 != n4 || n3 != n5) {
                    controller.showErrorDialog(TC.get((String)"IconAssets.Title"), TC.get((String)"IconAssets.ErrorIconSize", (String[])stringArray));
                    bl = false;
                }
            } else if (n == 0) {
                if (n2 < n4 || n3 < n5) {
                    controller.showErrorDialog(TC.get((String)"BackgroundAssets.Title"), TC.get((String)"BackgroundAssets.ErrorBackgroundSize", (String[])stringArray));
                    bl = false;
                }
            } else if (n == 11 && (n2 > n4 || n3 > n5)) {
                controller.showErrorDialog(TC.get((String)"ArrowAssets.Title"), TC.get((String)"ArrowAssets.ErrorArrowSize", (String[])stringArray));
                bl = false;
            }
        }
        return bl;
    }

    private static boolean isImageWithRestrictedDimension(int n) {
        return n == 0 || n == 3 || n == 11;
    }

    private static Dimension getRestrictedDimension(int n) {
        int n2 = 0;
        int n3 = 0;
        switch (n) {
            case 0: {
                n2 = 800;
                n3 = 600;
                break;
            }
            case 3: {
                n2 = 80;
                n3 = 48;
                break;
            }
            case 11: {
                n2 = 300;
                n3 = 200;
            }
        }
        return new Dimension(n2, n3);
    }

    public static void checkAssetFilesConsistency(List<Incidence> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        Controller controller = Controller.getInstance();
        controller.getAssetReferences(arrayList, arrayList2);
        for (int i = 0; i < arrayList.size(); ++i) {
            boolean bl = true;
            String string = (String)arrayList.get(i);
            int n = (Integer)arrayList2.get(i);
            String string2 = "";
            boolean bl2 = true;
            File file = new File(controller.getProjectFolder(), string);
            if (n == 1) {
                file = new File(controller.getProjectFolder(), string + "_01.png");
                if (!file.exists()) {
                    file = new File(controller.getProjectFolder(), string + "_01.jpg");
                }
                if (!file.exists()) {
                    file = new File(controller.getProjectFolder(), string);
                }
            }
            boolean bl3 = bl = file.exists() && file.isFile() && file.length() > 0L;
            if (!bl) {
                string2 = TC.get((String)("Error.AssetNotFound" + n), (String)string);
            }
            if (bl && (n == 0 || n == 3)) {
                Image image = AssetsController.getImage(string);
                int n2 = image.getWidth(null);
                int n3 = image.getHeight(null);
                String[] stringArray = new String[]{string, String.valueOf(n2), String.valueOf(n3)};
                if (n == 0 && (n2 < 800 || n3 < 600)) {
                    string2 = TC.get((String)"BackgroundAssets.ErrorBackgroundSize", (String[])stringArray);
                    bl = false;
                    bl2 = false;
                } else if (n == 3 && (n2 != 80 || n3 != 48)) {
                    string2 = TC.get((String)"IconAssets.ErrorIconSize", (String[])stringArray);
                    bl = false;
                    bl2 = false;
                }
            }
            if (bl) continue;
            list.add(Incidence.createAssetIncidence((boolean)bl2, (int)n, (String)string2, (String)string, null));
        }
    }

    private static String getExtension(String string) {
        return string.substring(string.lastIndexOf(46) + 1, string.length());
    }

    public static String getCategoryAbsoluteFolder(int n) {
        return new File(Controller.getInstance().getProjectFolder(), AssetsController.getCategoryFolder(n)).getAbsolutePath();
    }

    public static String getCategoryFolder(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = CATEGORY_BACKGROUND_FOLDER;
                break;
            }
            case 1: 
            case 8: 
            case 10: {
                string = CATEGORY_ANIMATION_FOLDER;
                break;
            }
            case 2: {
                string = CATEGORY_IMAGE_FOLDER;
                break;
            }
            case 3: {
                string = CATEGORY_ICON_FOLDER;
                break;
            }
            case 4: {
                string = CATEGORY_AUDIO_PATH;
                break;
            }
            case 5: {
                string = CATEGORY_VIDEO_PATH;
                break;
            }
            case 6: {
                string = CATEGORY_CURSOR_PATH;
                break;
            }
            case 7: {
                string = CATEGORY_STYLED_TEXT_PATH;
                break;
            }
            case 9: {
                string = CATEGORY_BUTTON_PATH;
                break;
            }
            case 11: {
                string = CATEGORY_ARROW_BOOK_PATH;
            }
        }
        return string;
    }

    public static es.eucm.eadventure.common.auxiliar.FileFilter getAssetsFileFilter(int n, int n2) {
        es.eucm.eadventure.common.auxiliar.FileFilter fileFilter = null;
        switch (n) {
            case 0: {
                fileFilter = new ImageFileFilter();
                break;
            }
            case 1: {
                if (n2 == 0) {
                    fileFilter = new AnimationFileFilter();
                }
                if (n2 == 1) {
                    fileFilter = new JPGSlidesFileFilter();
                }
                if (n2 != 2) break;
                fileFilter = new PNGAnimationFileFilter();
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 11: {
                fileFilter = new ImageFileFilter();
                break;
            }
            case 4: {
                if (n2 == 0) {
                    fileFilter = new AudioFileFilter();
                }
                if (n2 != 3) break;
                fileFilter = new MP3FileFilter();
                break;
            }
            case 5: {
                fileFilter = new VideoFileFilter();
                break;
            }
            case 7: {
                fileFilter = new FormattedTextFileFilter();
            }
        }
        return fileFilter;
    }

    public static AssetChooser getAssetChooser(int n, int n2) {
        AssetChooser assetChooser = null;
        switch (n) {
            case 1: {
                assetChooser = new AnimationChooser(n2);
                break;
            }
            case 3: {
                assetChooser = new IconChooser(n2);
                break;
            }
            case 2: 
            case 11: {
                assetChooser = new ImageChooser(n2, n);
                break;
            }
            case 0: {
                assetChooser = new BackgroundChooser(n2);
                break;
            }
            case 4: {
                assetChooser = new AudioChooser(n2);
                break;
            }
            case 5: {
                assetChooser = new VideoChooser();
                break;
            }
            case 6: {
                assetChooser = new CursorChooser();
                break;
            }
            case 7: {
                assetChooser = new FormatedTextChooser();
                break;
            }
            case 9: {
                assetChooser = new ButtonChooser();
            }
        }
        return assetChooser;
    }

    public static String extractResource(String string) {
        String string2 = null;
        try {
            if (!tempFiles.containsKey(string)) {
                File file;
                String string3 = TempFileGenerator.generateTempFileAbsolutePath(AssetsController.getExtension(string));
                File file2 = new File(Controller.getInstance().getProjectFolder(), string);
                if (file2.copyTo((java.io.File)(file = new File(string3)))) {
                    tempFiles.put(string, file);
                    string2 = string3;
                } else {
                    string2 = null;
                }
            } else {
                string2 = tempFiles.get(string).getAbsolutePath();
            }
        }
        catch (Exception exception) {
            string2 = null;
        }
        return string2;
    }

    public static InputStreamCreator getInputStreamCreator() {
        return new InputStreamCreatorEditor();
    }

    public static InputStreamCreator getInputStreamCreator(String string) {
        return new InputStreamCreatorEditor(string);
    }

    public static class InputStreamCreatorEditor
    implements InputStreamCreator {
        private String absolutePath;

        public InputStreamCreatorEditor() {
            this.absolutePath = null;
        }

        public InputStreamCreatorEditor(String string) {
            this.absolutePath = string;
        }

        public InputStream buildInputStream(String string) {
            if (this.absolutePath == null) {
                if ((string.startsWith("/") || string.startsWith("\\")) && !string.startsWith("/User")) {
                    string = string.substring(1, string.length());
                }
                return AssetsController.getInputStream(string);
            }
            try {
                return new FileInputStream((java.io.File)new File(this.absolutePath, string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }

        public String[] listNames(String string) {
            if (this.absolutePath == null) {
                File file = new File(Controller.getInstance().getProjectFolder(), string);
                if (file.exists() && file.isDirectory()) {
                    return file.list();
                }
                return new String[0];
            }
            File file = new File(this.absolutePath, string);
            if (file.exists() && file.isDirectory()) {
                return file.list();
            }
            return new String[0];
        }

        public MediaLocator buildMediaLocator(String string) {
            return AssetsController.getVideo(string);
        }

        public URL buildURL(String string) {
            try {
                return new File(Controller.getInstance().getProjectFolder(), string).toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
    }

    public static class TempFileGenerator {
        private static Random random = new Random();
        private static int MAX_RANDOM = 100000;
        private static final String TEMP_FILE_NAME = "eadventure_";

        public TempFileGenerator() {
            random = new Random();
        }

        public static String generateTempFileAbsolutePath(String string) {
            return TempFileGenerator.generateTempFileAbsolutePath(TEMP_FILE_NAME, string);
        }

        public static String generateTempFileAbsolutePath(String string, String string2) {
            String string3 = null;
            string3 = System.getenv("TEMP") != null && !System.getenv("TEMP").equals("") ? System.getenv("TEMP") : (System.getenv("HOME") != null && !System.getenv("HOME").equals("") ? System.getenv("HOME") : (System.getenv("ROOT") != null && !System.getenv("ROOT").equals("") ? System.getenv("ROOT") : ""));
            String string4 = string + "." + string2;
            File file = new File(string3 + "/" + string4);
            while (file.exists()) {
                string4 = string + random.nextInt(MAX_RANDOM) + "." + string2;
                file = new File(string3 + "/" + string4);
            }
            return string3 + "/" + string4;
        }

        public static String generateTempFileOverwriteExisting(String string, String string2) {
            String string3 = null;
            string3 = System.getenv("TEMP") != null && !System.getenv("TEMP").equals("") ? System.getenv("TEMP") : (System.getenv("HOME") != null && !System.getenv("HOME").equals("") ? System.getenv("HOME") : (System.getenv("ROOT") != null && !System.getenv("ROOT").equals("") ? System.getenv("ROOT") : ""));
            String string4 = string + "." + string2;
            File file = new File(string3 + "/" + string4);
            if (file.exists()) {
                file.delete();
            }
            return string3 + "/" + string4;
        }
    }
}

