/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.controllers;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.Described;
import es.eucm.eadventure.common.data.Titled;
import es.eucm.eadventure.common.data.adventure.AdventureData;
import es.eucm.eadventure.common.data.adventure.CustomArrow;
import es.eucm.eadventure.common.data.adventure.CustomButton;
import es.eucm.eadventure.common.data.adventure.CustomCursor;
import es.eucm.eadventure.common.data.adventure.DescriptorData;
import es.eucm.eadventure.common.data.chapter.Chapter;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.metadata.ims.IMSDataControl;
import es.eucm.eadventure.editor.control.controllers.metadata.lom.LOMDataControl;
import es.eucm.eadventure.editor.control.controllers.metadata.lomes.LOMESDataControl;
import es.eucm.eadventure.editor.control.tools.general.assets.DeleteArrowTool;
import es.eucm.eadventure.editor.control.tools.general.assets.DeleteButtonTool;
import es.eucm.eadventure.editor.control.tools.general.assets.DeleteCursorTool;
import es.eucm.eadventure.editor.control.tools.general.assets.SelectArrowTool;
import es.eucm.eadventure.editor.control.tools.general.assets.SelectButtonTool;
import es.eucm.eadventure.editor.control.tools.general.assets.SelectCursorPathTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeDescriptionTool;
import es.eucm.eadventure.editor.control.tools.general.commontext.ChangeTitleTool;
import es.eucm.eadventure.editor.control.tools.generic.ChangeBooleanValueTool;
import es.eucm.eadventure.editor.control.tools.generic.ChangeIntegerValueTool;
import es.eucm.eadventure.editor.gui.editdialogs.GUIStylesDialog;
import java.util.List;

public class AdventureDataControl {
    private AdventureData adventureData = new AdventureData();
    private LOMDataControl lomController;
    private IMSDataControl imsController;
    private LOMESDataControl lomesController;

    public AdventureDataControl(AdventureData adventureData) {
        this();
        this.adventureData = adventureData;
    }

    public AdventureDataControl() {
        this.lomController = new LOMDataControl();
        this.imsController = new IMSDataControl();
        this.lomesController = new LOMESDataControl();
    }

    public AdventureDataControl(String string, String string2, String string3, int n) {
        this.adventureData.setTitle(string);
        this.adventureData.setDescription("");
        this.adventureData.setGUIType(Integer.valueOf(1));
        this.adventureData.setPlayerMode(Integer.valueOf(n));
        this.adventureData.addChapter(new Chapter(string2, string3));
        this.lomController = new LOMDataControl();
        this.imsController = new IMSDataControl();
        this.lomesController = new LOMESDataControl();
    }

    public AdventureDataControl(String string, String string2, String string3) {
        this(string, string2, string3, 1);
    }

    public AdventureDataControl(String string, String string2, List<Chapter> list) {
        this.adventureData.setTitle(string);
        this.adventureData.setDescription(string2);
        this.adventureData.setGUIType(Integer.valueOf(0));
        this.adventureData.setChapters(list);
        this.adventureData.setGraphicConfig(Integer.valueOf(0));
        this.adventureData.setPlayerMode(Integer.valueOf(1));
        this.lomController = new LOMDataControl();
        this.imsController = new IMSDataControl();
    }

    public boolean isCursorTypeAllowed(String string) {
        return this.isCursorTypeAllowed(DescriptorData.getCursorTypeIndex((String)string));
    }

    public boolean isCursorTypeAllowed(int n) {
        return DescriptorData.typeAllowed[this.adventureData.getGUIType()][n];
    }

    public String getTitle() {
        return this.adventureData.getTitle();
    }

    public String getDescription() {
        return this.adventureData.getDescription();
    }

    public Integer getGUIType() {
        return this.adventureData.getGUIType();
    }

    public List<Chapter> getChapters() {
        return this.adventureData.getChapters();
    }

    public void setTitle(String string) {
        ChangeTitleTool changeTitleTool = new ChangeTitleTool((Titled)this.adventureData, string);
        Controller.getInstance().addTool(changeTitleTool);
    }

    public void setDescription(String string) {
        ChangeDescriptionTool changeDescriptionTool = new ChangeDescriptionTool((Described)this.adventureData, string);
        Controller.getInstance().addTool(changeDescriptionTool);
    }

    public void showGUIStylesDialog() {
        new GUIStylesDialog(this.adventureData.getGUIType());
    }

    public int getPlayerMode() {
        return this.adventureData.getPlayerMode();
    }

    public void setPlayerMode(int n) {
        ChangeIntegerValueTool changeIntegerValueTool = new ChangeIntegerValueTool(this.adventureData, n, "getPlayerMode", "setPlayerMode");
        Controller.getInstance().addTool(changeIntegerValueTool);
    }

    public List<CustomCursor> getCursors() {
        return this.adventureData.getCursors();
    }

    public List<CustomButton> getButtons() {
        return this.adventureData.getButtons();
    }

    public List<CustomArrow> getArrows() {
        return this.adventureData.getArrows();
    }

    public String getCursorPath(String string) {
        for (CustomCursor customCursor : this.adventureData.getCursors()) {
            if (!customCursor.getType().equals(string)) continue;
            return customCursor.getPath();
        }
        return null;
    }

    public String getCursorPath(int n) {
        return this.getCursorPath(DescriptorData.getCursorTypeString((int)n));
    }

    public void deleteCursor(int n) {
        String string = DescriptorData.getCursorTypeString((int)n);
        int n2 = -1;
        for (int i = 0; i < this.adventureData.getCursors().size(); ++i) {
            if (!((CustomCursor)this.adventureData.getCursors().get(i)).getType().equals(string)) continue;
            n2 = i;
            break;
        }
        if (n2 >= 0) {
            Controller.getInstance().addTool(new DeleteCursorTool(this.adventureData, n2));
        }
    }

    public void editCursorPath(int n) {
        try {
            Controller.getInstance().addTool(new SelectCursorPathTool(this.adventureData, n));
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ReportDialog.GenerateErrorReport((Exception)cloneNotSupportedException, (boolean)false, (String)"Could not clone cursor-adventureData");
        }
    }

    public String getArrowPath(String string) {
        for (CustomArrow customArrow : this.adventureData.getArrows()) {
            if (!customArrow.getType().equals(string)) continue;
            return customArrow.getPath();
        }
        return null;
    }

    public void deleteArrow(String string) {
        int n = -1;
        for (int i = 0; i < this.adventureData.getArrows().size(); ++i) {
            if (!((CustomArrow)this.adventureData.getArrows().get(i)).getType().equals(string)) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            Controller.getInstance().addTool(new DeleteArrowTool(this.adventureData, n));
        }
    }

    public LOMDataControl getLomController() {
        return this.lomController;
    }

    public void setLomController(LOMDataControl lOMDataControl) {
        this.lomController = lOMDataControl;
    }

    public IMSDataControl getImsController() {
        return this.imsController;
    }

    public LOMESDataControl getLOMESController() {
        return this.lomesController;
    }

    public void setImsController(IMSDataControl iMSDataControl) {
        this.imsController = iMSDataControl;
    }

    public boolean isCommentaries() {
        return this.adventureData.isCommentaries();
    }

    public void setCommentaries(boolean bl) {
        ChangeBooleanValueTool changeBooleanValueTool = new ChangeBooleanValueTool(this.adventureData, bl, "isCommentaries", "setCommentaries");
        Controller.getInstance().addTool(changeBooleanValueTool);
    }

    public boolean isKeepShowing() {
        return this.adventureData.isKeepShowing();
    }

    public DescriptorData.DefaultClickAction getDefaultClickAction() {
        return this.adventureData.getDefaultClickAction();
    }

    public DescriptorData.Perspective getPerspective() {
        return this.adventureData.getPerspective();
    }

    public void setKeepShowing(boolean bl) {
        ChangeBooleanValueTool changeBooleanValueTool = new ChangeBooleanValueTool(this.adventureData, bl, "isKeepShowing", "setKeepShowing");
        Controller.getInstance().addTool(changeBooleanValueTool);
    }

    public int getGraphicConfig() {
        return this.adventureData.getGraphicConfig();
    }

    public void setGraphicConfig(int n) {
        ChangeIntegerValueTool changeIntegerValueTool = new ChangeIntegerValueTool(this.adventureData, n, "getGraphicConfig", "setGraphicConfig");
        Controller.getInstance().addTool(changeIntegerValueTool);
    }

    public AdventureData getAdventureData() {
        return this.adventureData;
    }

    public String getButtonPath(String string, String string2) {
        CustomButton customButton = new CustomButton(string, string2, null);
        for (CustomButton customButton2 : this.adventureData.getButtons()) {
            if (!customButton2.equals((Object)customButton)) continue;
            return customButton2.getPath();
        }
        return null;
    }

    public void deleteButton(String string, String string2) {
        Controller.getInstance().addTool(new DeleteButtonTool(this.adventureData, string, string2));
    }

    public void editButtonPath(String string, String string2) {
        try {
            Controller.getInstance().addTool(new SelectButtonTool(this.adventureData, string, string2));
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ReportDialog.GenerateErrorReport((Exception)cloneNotSupportedException, (boolean)false, (String)"Could not clone resources: buttons");
        }
    }

    public void editArrowPath(String string) {
        try {
            Controller.getInstance().addTool(new SelectArrowTool(this.adventureData, string));
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ReportDialog.GenerateErrorReport((Exception)cloneNotSupportedException, (boolean)false, (String)"Could not clone resources: arrows");
        }
    }

    public int getInventoryPosition() {
        return this.adventureData.getInventoryPosition();
    }

    public void setInventoryPosition(int n) {
        Controller.getInstance().addTool(new ChangeIntegerValueTool(this.adventureData, n, "getInventoryPosition", "setInventoryPosition"));
    }

    public int countAssetReferences(String string) {
        return this.adventureData.countAssetReferences(string);
    }

    public void getAssetReferences(List<String> list, List<Integer> list2) {
        this.adventureData.getAssetReferences(list, list2);
    }

    public void deleteAssetReferences(String string) {
        this.adventureData.deleteAssetReferences(string);
    }

    public void setGUIStyleDialog(int n) {
        ChangeIntegerValueTool changeIntegerValueTool = new ChangeIntegerValueTool(this.adventureData, n, "getGUIType", "setGUIType");
        Controller.getInstance().addTool(changeIntegerValueTool);
    }

    public void setDefaultClickAction(DescriptorData.DefaultClickAction defaultClickAction) {
        this.adventureData.setDeafultClickAction(defaultClickAction);
    }

    public void setPerspective(DescriptorData.Perspective perspective) {
        this.adventureData.setPerspective(perspective);
    }
}

