/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.config;

import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.config.ProjectConfigData;
import es.eucm.eadventure.editor.control.config.ProjectConfigDataConsumer;

public class SceneLinksConfigData
implements ProjectConfigDataConsumer {
    private static Controller controller = Controller.getInstance();

    private static String getXKey(String string) {
        int n = controller.getSelectedChapter();
        return "Chapter" + n + "." + string + ".X";
    }

    private static String getYKey(String string) {
        int n = controller.getSelectedChapter();
        return "Chapter" + n + "." + string + ".Y";
    }

    private static String getVisibleKey(String string) {
        int n = controller.getSelectedChapter();
        return "Chapter" + n + "." + string + ".Visible";
    }

    public static boolean isSceneConfig(String string) {
        String string2 = SceneLinksConfigData.getXKey(string);
        String string3 = SceneLinksConfigData.getYKey(string);
        String string4 = SceneLinksConfigData.getVisibleKey(string);
        return ProjectConfigData.existsKey(string2) && ProjectConfigData.existsKey(string3) && ProjectConfigData.existsKey(string4);
    }

    public static int getSceneX(String string) {
        int n = Integer.MIN_VALUE;
        if (SceneLinksConfigData.isSceneConfig(string)) {
            try {
                String string2 = SceneLinksConfigData.getXKey(string);
                n = Integer.parseInt(ProjectConfigData.getProperty(string2));
            }
            catch (Exception exception) {
                n = Integer.MIN_VALUE;
            }
        }
        return n;
    }

    public static int getSceneY(String string) {
        int n = Integer.MIN_VALUE;
        if (SceneLinksConfigData.isSceneConfig(string)) {
            try {
                String string2 = SceneLinksConfigData.getYKey(string);
                n = Integer.parseInt(ProjectConfigData.getProperty(string2));
            }
            catch (Exception exception) {
                n = Integer.MIN_VALUE;
            }
        }
        return n;
    }

    public static boolean getSceneVisible(String string) {
        boolean bl = true;
        if (SceneLinksConfigData.isSceneConfig(string)) {
            try {
                String string2 = SceneLinksConfigData.getVisibleKey(string);
                bl = !ProjectConfigData.getProperty(string2).equals("false");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    public static void setSceneX(String string, int n) {
        if (n != Integer.MIN_VALUE) {
            String string2 = SceneLinksConfigData.getXKey(string);
            String string3 = Integer.toString(n);
            ProjectConfigData.setProperty(string2, string3);
        }
    }

    public static void setSceneY(String string, int n) {
        if (n != Integer.MIN_VALUE) {
            String string2 = SceneLinksConfigData.getYKey(string);
            String string3 = Integer.toString(n);
            ProjectConfigData.setProperty(string2, string3);
        }
    }

    public static void setSceneVisible(String string, boolean bl) {
        String string2 = SceneLinksConfigData.getVisibleKey(string);
        String string3 = bl ? "true" : "false";
        ProjectConfigData.setProperty(string2, string3);
    }

    @Override
    public void updateData() {
    }
}

