/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.config;

import es.eucm.eadventure.common.auxiliar.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import java.util.Set;

public class SCORMConfigData {
    private static final String FILE_NAME_12 = "datamodel.xml";
    private static final String FILE_NAME_2004 = "datamodel2004.xml";
    public static final String[] ArrayNames = new String[]{"cmi.objectives", "cmi.interactions", "cmi.comments_from_lms", "cmi.comments_from_learner"};
    public static final String[] ArrayInArray = new String[]{"cmi.interactions.n.objetives.m.id", "cmi.interactions.n.correct_responses.m.pattern"};
    public static final int SCORM_OBJECTIVES = 0;
    public static final int SCORM_INTERACTIONS = 1;
    public static final int READ = 0;
    public static final int WRITE = 1;
    public static final int SCORM_V12 = 0;
    public static final int SCORM_2004 = 1;
    private static Properties properties2004;
    private static Properties properties12;

    public static void init() {
        properties2004 = new Properties();
        properties12 = new Properties();
        SCORMConfigData.loadFromXML();
    }

    public static void loadFromXML() {
        properties2004 = new Properties();
        try {
            File file = new File(FILE_NAME_12);
            File file2 = new File(FILE_NAME_2004);
            if (file.exists()) {
                properties12.loadFromXML(new FileInputStream(FILE_NAME_12));
            }
            if (file2.exists()) {
                properties2004.loadFromXML(new FileInputStream(FILE_NAME_2004));
            }
        }
        catch (InvalidPropertiesFormatException invalidPropertiesFormatException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean isArrayInsideArray(String string) {
        for (int i = 0; i < ArrayInArray.length; ++i) {
            if (!string.equals(ArrayInArray[i])) continue;
            return true;
        }
        return false;
    }

    public static String getProperty2004(String string) {
        if (properties2004.containsKey(string)) {
            return properties2004.getProperty(string);
        }
        return null;
    }

    public static boolean isArrayAttributeExtension(String string) {
        for (int i = 0; i < ArrayNames.length; ++i) {
            if (!string.startsWith(ArrayNames[i] + ".")) continue;
            return true;
        }
        return false;
    }

    public static boolean isArrayAttribute(String string) {
        for (int i = 0; i < ArrayNames.length; ++i) {
            if (!string.equals(ArrayNames[i])) continue;
            return true;
        }
        return false;
    }

    public static String getProperty12(String string) {
        if (properties12.containsKey(string)) {
            return properties12.getProperty(string);
        }
        return null;
    }

    public static boolean isPartOfTheModel12(String string) {
        return properties12.containsKey(string);
    }

    public static boolean isPartOfTheModel2004(String string) {
        return properties2004.containsKey(string);
    }

    public static ArrayList<String> getPartsOfModel2004(int n) {
        Set<String> set = properties2004.stringPropertyNames();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : set) {
            if (SCORMConfigData.isArrayAttributeExtension(string) || !SCORMConfigData.canBeAdded(n, string, 1)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static ArrayList<String> getPartsOfModel12(int n) {
        Set<String> set = properties12.stringPropertyNames();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : set) {
            if (SCORMConfigData.isArrayAttributeExtension(string) || !SCORMConfigData.canBeAdded(n, string, 0)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private static boolean canBeAdded(int n, String string, int n2) {
        int n3 = 0;
        if (n == 0) {
            n3 = 1;
        } else if (n == 1) {
            n3 = 3;
        }
        if (n2 == 0) {
            return SCORMConfigData.getProperty12(string).charAt(n3) == '1';
        }
        if (n2 == 1) {
            return SCORMConfigData.getProperty2004(string).charAt(n3) == '1';
        }
        return false;
    }

    public static ArrayList<String> getAttribute(String string, int n, int n2) {
        Set<String> set = null;
        if (n == 0) {
            set = properties12.stringPropertyNames();
        } else if (n == 1) {
            set = properties2004.stringPropertyNames();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : set) {
            if (!string2.startsWith(string) || SCORMConfigData.isArrayAttribute(string2) || !SCORMConfigData.canBeAdded(n2, string2, n)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }
}

