/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.config;

import es.eucm.eadventure.common.auxiliar.File;
import es.eucm.eadventure.editor.control.config.RecentFile;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;

public class RecentFiles {
    public static final int OPENED_TODAY = 0;
    public static final int OPENED_YESTERDAY = 1;
    public static final int OPENED_THIS_WEEK = 2;
    public static final int OPENED_THIS_MONTH = 3;
    public static final int MAX_FILES = 10;
    private RecentFile[] recentFiles;
    private int nFiles = 0;

    public RecentFiles(Properties properties) {
        if (properties.containsKey("RecentFiles")) {
            try {
                this.nFiles = Integer.parseInt(properties.getProperty("RecentFiles"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.recentFiles = new RecentFile[10];
        int n = this.nFiles;
        for (int i = 0; i < this.nFiles; ++i) {
            String string = "RecentFile." + i + ".FilePath";
            String string2 = properties.getProperty(string);
            File file = new File(string2);
            if (file.exists()) {
                String string3 = "RecentFile." + i + ".DateOpened";
                String string4 = properties.getProperty(string3);
                try {
                    RecentFile recentFile;
                    this.recentFiles[i] = recentFile = new RecentFile(string2, string4);
                }
                catch (ParseException parseException) {
                    this.recentFiles[i] = null;
                    --n;
                }
                continue;
            }
            this.recentFiles[i] = null;
            --n;
        }
        RecentFile[] recentFileArray = new RecentFile[10];
        int n2 = 0;
        for (int i = 0; i < this.nFiles; ++i) {
            if (this.recentFiles[i] == null) continue;
            recentFileArray[n2] = this.recentFiles[i];
            ++n2;
        }
        this.nFiles = n;
        this.recentFiles = recentFileArray;
        this.orderFilesByDate();
    }

    public void fillProperties(Properties properties) {
        int n = 0;
        for (RecentFile recentFile : this.recentFiles) {
            if (n >= this.nFiles) break;
            String string = "RecentFile." + n + ".FilePath";
            String string2 = recentFile.getAbsolutePath();
            properties.put(string, string2);
            String string3 = "RecentFile." + n + ".DateOpened";
            String string4 = recentFile.toString();
            properties.put(string3, string4);
            ++n;
        }
        String string = "RecentFiles";
        String string5 = Integer.toString(this.nFiles);
        properties.put(string, string5);
    }

    public String[][] getRecentFilesInfo(int n) {
        ArrayList<RecentFile> arrayList = new ArrayList<RecentFile>();
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, -n);
        calendar.set(11, 0);
        int n2 = 0;
        for (RecentFile recentFile : this.recentFiles) {
            if (n2 >= this.nFiles) break;
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(recentFile.getDate());
            if (calendar2.compareTo(calendar) <= 0) {
                arrayList.add(recentFile);
            }
            ++n2;
        }
        RecentFile[] recentFileArray = new String[arrayList.size()][3];
        for (int i = 0; i < arrayList.size(); ++i) {
            recentFileArray[i][0] = ((RecentFile)arrayList.get(i)).getAbsolutePath();
            recentFileArray[i][1] = DateFormat.getDateInstance().format(((RecentFile)arrayList.get(i)).getDate());
            recentFileArray[i][2] = DateFormat.getTimeInstance().format(((RecentFile)arrayList.get(i)).getDate());
        }
        return recentFileArray;
    }

    public String[][] getRecentFilesInfo(int n, int n2) {
        ArrayList<RecentFile> arrayList = new ArrayList<RecentFile>();
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, -n);
        calendar.set(11, 0);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.add(6, -n2);
        calendar2.set(11, 0);
        int n3 = 0;
        for (RecentFile recentFile : this.recentFiles) {
            if (n3 >= this.nFiles) break;
            Calendar calendar3 = Calendar.getInstance();
            calendar3.setTime(recentFile.getDate());
            if (calendar3.compareTo(calendar2) <= 0 && calendar3.compareTo(calendar) > 0) {
                arrayList.add(recentFile);
            }
            ++n3;
        }
        RecentFile[] recentFileArray = new String[arrayList.size()][3];
        for (int i = 0; i < arrayList.size(); ++i) {
            recentFileArray[i][0] = ((RecentFile)arrayList.get(i)).getAbsolutePath();
            recentFileArray[i][1] = DateFormat.getDateInstance().format(((RecentFile)arrayList.get(i)).getDate());
            recentFileArray[i][2] = DateFormat.getTimeInstance().format(((RecentFile)arrayList.get(i)).getDate());
        }
        return recentFileArray;
    }

    public void orderFilesByDate() {
        for (int i = 0; i < this.nFiles; ++i) {
            RecentFile recentFile = this.recentFiles[i];
            int n = i;
            for (int j = i + 1; j < this.nFiles; ++j) {
                if (!this.recentFiles[j].getDate().before(recentFile.getDate())) continue;
                recentFile = this.recentFiles[j];
                n = j;
            }
            this.recentFiles[n] = this.recentFiles[i];
            this.recentFiles[i] = recentFile;
        }
    }

    public void fileLoaded(String string) {
        boolean bl = false;
        for (int i = 0; i < this.nFiles; ++i) {
            RecentFile recentFile = this.recentFiles[i];
            if (!recentFile.getAbsolutePath().equals(string)) continue;
            recentFile.setDate(new Date());
            bl = true;
        }
        if (!bl) {
            RecentFile recentFile = new RecentFile(string);
            if (this.nFiles == this.recentFiles.length) {
                this.recentFiles[0] = recentFile;
            } else {
                this.recentFiles[this.nFiles] = recentFile;
                ++this.nFiles;
            }
        }
        this.orderFilesByDate();
    }

    public static void main(String[] stringArray) {
        Date date = DateFormat.getDateInstance().getCalendar().getTime();
        System.out.println(date);
        long l = date.getTime();
        long l2 = l - 0L;
        long l3 = l - 172800000L;
        Date date2 = new Date(l2);
        Date date3 = new Date(l3);
        System.out.println(date2);
        System.out.println(date3);
    }
}

