/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.config;

import es.eucm.eadventure.common.auxiliar.File;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.config.LOMConfigData;
import es.eucm.eadventure.editor.control.config.ProjectConfigDataConsumer;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;

public class ProjectConfigData {
    private static final String FILE_NAME = "project.xml";
    private static Properties properties;
    private static ArrayList<ProjectConfigDataConsumer> consumers;

    public static void init() {
        consumers = new ArrayList();
        properties = new Properties();
        ProjectConfigData.storeToXML();
    }

    public static void addConsumer(ProjectConfigDataConsumer projectConfigDataConsumer) {
        consumers.add(projectConfigDataConsumer);
    }

    public static void loadFromXML() {
        properties = new Properties();
        try {
            File file = new File(Controller.getInstance().getProjectFolder(), FILE_NAME);
            if (file.exists()) {
                properties.loadFromXML(new FileInputStream(Controller.getInstance().getProjectFolder() + "/" + FILE_NAME));
            } else {
                ProjectConfigData.storeToXML();
            }
        }
        catch (InvalidPropertiesFormatException invalidPropertiesFormatException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (ProjectConfigDataConsumer projectConfigDataConsumer : consumers) {
            projectConfigDataConsumer.updateData();
        }
        LOMConfigData.loadData();
    }

    public static void storeToXML() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(Controller.getInstance().getProjectFolder() + "/" + FILE_NAME);
            properties.storeToXML(fileOutputStream, "Project Configuration");
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getProperty(String string) {
        if (properties.containsKey(string)) {
            return properties.getProperty(string);
        }
        return null;
    }

    public static void setProperty(String string, String string2) {
        properties.setProperty(string, string2);
    }

    public static boolean existsKey(String string) {
        return properties.containsKey(string);
    }

    public static void registerConsumer(ProjectConfigDataConsumer projectConfigDataConsumer) {
        consumers.add(projectConfigDataConsumer);
    }

    static {
        consumers = new ArrayList();
    }
}

