/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.config;

import es.eucm.eadventure.common.data.chapter.conversation.GraphConversation;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.config.ProjectConfigData;
import es.eucm.eadventure.editor.control.config.ProjectConfigDataConsumer;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.conversation.ConversationDataControl;
import es.eucm.eadventure.editor.control.controllers.general.ChapterDataControl;
import java.awt.Point;

public class ConversationConfigData
implements ProjectConfigDataConsumer {
    private static Controller controller = Controller.getInstance();

    private static boolean checkParameters(String string, int n) {
        boolean bl = false;
        if (controller.getIdentifierSummary().isConversation(string)) {
            DataControl dataControl = null;
            for (ConversationDataControl conversationDataControl : controller.getSelectedChapterDataControl().getConversationsList().getConversations()) {
                if (!conversationDataControl.getId().equals(string) || conversationDataControl.getType() != 33) continue;
                dataControl = conversationDataControl;
                break;
            }
            if (dataControl != null) {
                GraphConversation graphConversation = (GraphConversation)dataControl.getContent();
                if (n >= 0 && n < graphConversation.getAllNodes().size()) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    private static String getXKey(String string, int n) {
        int n2 = controller.getSelectedChapter();
        return "Chapter" + n2 + "." + string + "." + n + ".X";
    }

    private static String getYKey(String string, int n) {
        int n2 = controller.getSelectedChapter();
        return "Chapter" + n2 + "." + string + "." + n + ".Y";
    }

    public static boolean isNodeConfig(String string, int n) {
        boolean bl = false;
        if (ConversationConfigData.checkParameters(string, n)) {
            String string2 = ConversationConfigData.getXKey(string, n);
            String string3 = ConversationConfigData.getYKey(string, n);
            if (ProjectConfigData.existsKey(string2) && ProjectConfigData.existsKey(string3)) {
                bl = true;
            }
        }
        return bl;
    }

    public static int getNodeX(String string, int n) {
        int n2 = Integer.MIN_VALUE;
        if (ConversationConfigData.isNodeConfig(string, n)) {
            try {
                String string2 = ConversationConfigData.getXKey(string, n);
                n2 = Integer.parseInt(ProjectConfigData.getProperty(string2));
            }
            catch (Exception exception) {
                n2 = Integer.MIN_VALUE;
            }
        }
        return n2;
    }

    public static int getNodeY(String string, int n) {
        int n2 = Integer.MIN_VALUE;
        if (ConversationConfigData.isNodeConfig(string, n)) {
            try {
                String string2 = ConversationConfigData.getYKey(string, n);
                n2 = Integer.parseInt(ProjectConfigData.getProperty(string2));
            }
            catch (Exception exception) {
                n2 = Integer.MIN_VALUE;
            }
        }
        return n2;
    }

    public static Point getNodePos(String string, int n) {
        Point point = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
        if (ConversationConfigData.isNodeConfig(string, n)) {
            point = new Point(ConversationConfigData.getNodeX(string, n), ConversationConfigData.getNodeY(string, n));
        }
        return point;
    }

    public static void setNodeX(String string, int n, int n2) {
        if (n2 != Integer.MIN_VALUE) {
            String string2 = ConversationConfigData.getXKey(string, n);
            String string3 = Integer.toString(n2);
            ProjectConfigData.setProperty(string2, string3);
        }
    }

    public static void setNodeY(String string, int n, int n2) {
        if (n2 != Integer.MIN_VALUE) {
            String string2 = ConversationConfigData.getYKey(string, n);
            String string3 = Integer.toString(n2);
            ProjectConfigData.setProperty(string2, string3);
        }
    }

    public static void setNodePos(String string, int n, Point point) {
        ConversationConfigData.setNodeX(string, n, point.x);
        ConversationConfigData.setNodeY(string, n, point.y);
    }

    public static boolean isConversationConfig(String string) {
        boolean bl = false;
        Controller controller = Controller.getInstance();
        ChapterDataControl chapterDataControl = controller.getSelectedChapterDataControl();
        for (ConversationDataControl conversationDataControl : chapterDataControl.getConversationsList().getConversations()) {
            if (!conversationDataControl.getId().equals(string) || conversationDataControl.getType() != 33) continue;
            bl = true;
            GraphConversation graphConversation = (GraphConversation)conversationDataControl.getContent();
            for (int i = 0; i < graphConversation.getAllNodes().size(); ++i) {
                bl &= ConversationConfigData.isNodeConfig(string, i);
            }
        }
        return bl;
    }

    @Override
    public void updateData() {
    }
}

