/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.config;

import es.eucm.eadventure.common.auxiliar.ReleaseFolders;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.config.RecentFiles;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;

public class ConfigData {
    private boolean showStartDialog;
    private RecentFiles recentFiles;
    private static ConfigData instance;
    private String configFile;
    private String languageFile;
    private String aboutFile;
    private String loadingImage;
    private boolean showItemReferences;
    private boolean showAtrezzoReferences;
    private boolean showNPCReferences;
    private String exportsPath;
    private String reportsPath;
    private String projectsPath;
    private int effectSelectorTab;

    public static boolean showNPCReferences() {
        return ConfigData.instance.showNPCReferences;
    }

    public static boolean showItemReferences() {
        return ConfigData.instance.showItemReferences;
    }

    public static boolean showAtrezzoReferences() {
        return ConfigData.instance.showAtrezzoReferences;
    }

    public static String getLanguangeFile() {
        return ConfigData.instance.languageFile;
    }

    public static String getAboutFile() {
        return ConfigData.instance.aboutFile;
    }

    public static String getLoadingImage() {
        return ConfigData.instance.loadingImage;
    }

    public static boolean showStartDialog() {
        return ConfigData.instance.showStartDialog;
    }

    public static void setShowNPCReferences(boolean bl) {
        ConfigData.instance.showNPCReferences = bl;
    }

    public static void setShowItemReferences(boolean bl) {
        ConfigData.instance.showItemReferences = bl;
    }

    public static void setShowAtrezzoReferences(boolean bl) {
        ConfigData.instance.showAtrezzoReferences = bl;
    }

    public static void setLanguangeFile(String string, String string2, String string3) {
        ConfigData.instance.languageFile = string;
        ConfigData.instance.aboutFile = string2;
        ConfigData.instance.loadingImage = string3;
    }

    public static void setAboutFile(String string) {
        ConfigData.instance.aboutFile = string;
    }

    public static void setLoadingImage(String string) {
        ConfigData.instance.loadingImage = string;
    }

    public static void setShowStartDialog(boolean bl) {
        ConfigData.instance.showStartDialog = bl;
    }

    public static void loadFromXML(String string) {
        instance = new ConfigData(string);
    }

    public static void storeToXML() {
        Properties properties = new Properties();
        properties.setProperty("ShowItemReferences", String.valueOf(ConfigData.instance.showItemReferences));
        properties.setProperty("ShowNPCReferences", String.valueOf(ConfigData.instance.showNPCReferences));
        properties.setProperty("ShowAtrezzoReferences", String.valueOf(ConfigData.instance.showAtrezzoReferences));
        properties.setProperty("ShowStartDialog", String.valueOf(ConfigData.instance.showStartDialog));
        properties.setProperty("LanguageFile", ConfigData.instance.languageFile);
        properties.setProperty("AboutFile", ConfigData.instance.aboutFile);
        properties.setProperty("LoadingImage", ConfigData.instance.loadingImage);
        if (ConfigData.instance.exportsPath != null) {
            properties.setProperty("ExportsDirectory", ConfigData.instance.exportsPath);
        }
        if (ConfigData.instance.reportsPath != null) {
            properties.setProperty("ReportsDirectory", ConfigData.instance.reportsPath);
        }
        if (ConfigData.instance.projectsPath != null) {
            properties.setProperty("ProjectsDirectory", ConfigData.instance.projectsPath);
        }
        if (ConfigData.instance.projectsPath != null) {
            properties.setProperty("EffectSelectorTab", Integer.toString(ConfigData.instance.effectSelectorTab));
        }
        ConfigData.instance.recentFiles.fillProperties(properties);
        try {
            properties.storeToXML(new FileOutputStream(ConfigData.instance.configFile), "<e-Adventure> editor configuration");
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private ConfigData(String string) {
        this.configFile = string;
        Properties properties = new Properties();
        try {
            properties.loadFromXML(new FileInputStream(string));
            this.languageFile = properties.getProperty("LanguageFile");
            this.aboutFile = properties.getProperty("AboutFile");
            this.loadingImage = properties.getProperty("LoadingImage");
            this.showItemReferences = Boolean.parseBoolean(properties.getProperty("ShowItemReferences"));
            this.showNPCReferences = Boolean.parseBoolean(properties.getProperty("ShowNPCReferences"));
            this.showStartDialog = Boolean.parseBoolean(properties.getProperty("ShowStartDialog"));
            this.exportsPath = properties.getProperty("ExportsDirectory");
            if (this.exportsPath != null) {
                ReleaseFolders.setExportsPath((String)this.exportsPath);
            }
            this.reportsPath = properties.getProperty("ReportsDirectory");
            if (this.reportsPath != null) {
                ReleaseFolders.setReportsPath((String)this.reportsPath);
            }
            this.projectsPath = properties.getProperty("ProjectsDirectory");
            if (this.projectsPath != null) {
                ReleaseFolders.setProjectsPath((String)this.projectsPath);
            }
            try {
                this.effectSelectorTab = Integer.parseInt(properties.getProperty("EffectSelectorTab"));
            }
            catch (Exception exception) {
                this.effectSelectorTab = 0;
            }
            this.recentFiles = new RecentFiles(properties);
        }
        catch (InvalidPropertiesFormatException invalidPropertiesFormatException) {
            this.checkConsistency();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.checkConsistency();
        }
        catch (IOException iOException) {
            this.checkConsistency();
        }
        catch (Exception exception) {
            this.checkConsistency();
        }
    }

    private void checkConsistency() {
        if (this.languageFile == null) {
            this.languageFile = ReleaseFolders.getLanguageFilePath((String)"en_EN");
        }
        if (this.aboutFile == null) {
            this.aboutFile = "i18n/editor/" + ReleaseFolders.getDefaultAboutFilePath();
        }
        if (this.loadingImage == null) {
            this.loadingImage = "img/loading/" + Controller.getInstance().getDefaultLanguage() + "/Editor2D-Loading.png";
        }
        if (this.exportsPath == null) {
            // empty if block
        }
        if (this.projectsPath == null) {
            // empty if block
        }
        if (this.reportsPath == null) {
            // empty if block
        }
        if (this.recentFiles == null) {
            this.recentFiles = new RecentFiles(new Properties());
        }
    }

    public static void fileLoaded(String string) {
        ConfigData.instance.recentFiles.fileLoaded(string);
    }

    public static String[][] getRecentFilesInfo(int n) {
        return ConfigData.instance.recentFiles.getRecentFilesInfo(n);
    }

    public static String[][] getRecentFilesInfo(int n, int n2) {
        return ConfigData.instance.recentFiles.getRecentFilesInfo(n, n2);
    }

    public static int getEffectSelectorTab() {
        return ConfigData.instance.effectSelectorTab;
    }

    public static void setEffectSelectorTab(int n) {
        ConfigData.instance.effectSelectorTab = n;
    }
}

