/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control;

import es.eucm.eadventure.common.auxiliar.ReleaseFolders;
import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.adventure.AdventureData;
import es.eucm.eadventure.common.data.adventure.DescriptorData;
import es.eucm.eadventure.common.data.animation.Animation;
import es.eucm.eadventure.common.data.animation.Frame;
import es.eucm.eadventure.common.data.animation.ImageLoaderFactory;
import es.eucm.eadventure.common.data.chapter.Chapter;
import es.eucm.eadventure.common.data.chapter.Trajectory;
import es.eucm.eadventure.common.data.chapter.elements.NPC;
import es.eucm.eadventure.common.data.chapter.elements.Player;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.common.loader.InputStreamCreator;
import es.eucm.eadventure.common.loader.Loader;
import es.eucm.eadventure.common.loader.incidences.Incidence;
import es.eucm.eadventure.editor.auxiliar.filefilters.EADFileFilter;
import es.eucm.eadventure.editor.auxiliar.filefilters.FolderFileFilter;
import es.eucm.eadventure.editor.auxiliar.filefilters.JARFileFilter;
import es.eucm.eadventure.editor.auxiliar.filefilters.XMLFileFilter;
import es.eucm.eadventure.editor.control.AutoSave;
import es.eucm.eadventure.editor.control.config.ConfigData;
import es.eucm.eadventure.editor.control.config.ProjectConfigData;
import es.eucm.eadventure.editor.control.config.SCORMConfigData;
import es.eucm.eadventure.editor.control.controllers.AdventureDataControl;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.control.controllers.DataControlWithResources;
import es.eucm.eadventure.editor.control.controllers.EditorImageLoader;
import es.eucm.eadventure.editor.control.controllers.VarFlagsController;
import es.eucm.eadventure.editor.control.controllers.adaptation.AdaptationProfilesDataControl;
import es.eucm.eadventure.editor.control.controllers.assessment.AssessmentProfilesDataControl;
import es.eucm.eadventure.editor.control.controllers.atrezzo.AtrezzoDataControl;
import es.eucm.eadventure.editor.control.controllers.character.NPCDataControl;
import es.eucm.eadventure.editor.control.controllers.general.AdvancedFeaturesDataControl;
import es.eucm.eadventure.editor.control.controllers.general.ChapterDataControl;
import es.eucm.eadventure.editor.control.controllers.general.ChapterListDataControl;
import es.eucm.eadventure.editor.control.controllers.general.ResourcesDataControl;
import es.eucm.eadventure.editor.control.controllers.item.ItemDataControl;
import es.eucm.eadventure.editor.control.controllers.metadata.lom.LOMDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.SceneDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;
import es.eucm.eadventure.editor.control.tools.general.SwapPlayerModeTool;
import es.eucm.eadventure.editor.control.tools.general.chapters.AddChapterTool;
import es.eucm.eadventure.editor.control.tools.general.chapters.DeleteChapterTool;
import es.eucm.eadventure.editor.control.tools.general.chapters.ImportChapterTool;
import es.eucm.eadventure.editor.control.tools.general.chapters.MoveChapterTool;
import es.eucm.eadventure.editor.control.writer.AnimationWriter;
import es.eucm.eadventure.editor.control.writer.Writer;
import es.eucm.eadventure.editor.data.support.IdentifierSummary;
import es.eucm.eadventure.editor.data.support.VarFlagSummary;
import es.eucm.eadventure.editor.gui.LoadingScreen;
import es.eucm.eadventure.editor.gui.MainWindow;
import es.eucm.eadventure.editor.gui.displaydialogs.InvalidReportDialog;
import es.eucm.eadventure.editor.gui.editdialogs.AdventureDataDialog;
import es.eucm.eadventure.editor.gui.editdialogs.ExportToLOMDialog;
import es.eucm.eadventure.editor.gui.editdialogs.GraphicConfigDialog;
import es.eucm.eadventure.editor.gui.editdialogs.SearchDialog;
import es.eucm.eadventure.editor.gui.editdialogs.VarsFlagsDialog;
import es.eucm.eadventure.editor.gui.editdialogs.customizeguidialog.CustomizeGUIDialog;
import es.eucm.eadventure.editor.gui.metadatadialog.ims.IMSDialog;
import es.eucm.eadventure.editor.gui.metadatadialog.lomdialog.LOMDialog;
import es.eucm.eadventure.editor.gui.metadatadialog.lomes.LOMESDialog;
import es.eucm.eadventure.editor.gui.startdialog.FrameForInitialDialogs;
import es.eucm.eadventure.engine.EAdventureDebug;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;

public class Controller {
    public static final int CHAPTER = 0;
    public static final int SCENES_LIST = 1;
    public static final int SCENE = 2;
    public static final int EXITS_LIST = 3;
    public static final int EXIT = 4;
    public static final int ITEM_REFERENCES_LIST = 5;
    public static final int ITEM_REFERENCE = 6;
    public static final int NPC_REFERENCES_LIST = 7;
    public static final int NPC_REFERENCE = 8;
    public static final int CUTSCENES_LIST = 9;
    public static final int CUTSCENE_SLIDES = 10;
    public static final int CUTSCENE = 910;
    public static final int CUTSCENE_VIDEO = 37;
    public static final int BOOKS_LIST = 11;
    public static final int BOOK = 12;
    public static final int BOOK_PARAGRAPHS_LIST = 13;
    public static final int BOOK_TITLE_PARAGRAPH = 14;
    public static final int BOOK_TEXT_PARAGRAPH = 15;
    public static final int BOOK_BULLET_PARAGRAPH = 16;
    public static final int BOOK_IMAGE_PARAGRAPH = 17;
    public static final int ITEMS_LIST = 18;
    public static final int ITEM = 19;
    public static final int ACTIONS_LIST = 20;
    public static final int ACTION_EXAMINE = 21;
    public static final int ACTION_GRAB = 22;
    public static final int ACTION_USE = 23;
    public static final int ACTION_CUSTOM = 230;
    public static final int ACTION_TALK_TO = 231;
    public static final int ACTION_USE_WITH = 24;
    public static final int ACTION_GIVE_TO = 25;
    public static final int ACTION_DRAG_TO = 251;
    public static final int ACTION_CUSTOM_INTERACT = 250;
    public static final int PLAYER = 26;
    public static final int NPCS_LIST = 27;
    public static final int NPC = 28;
    public static final int CONVERSATION_REFERENCES_LIST = 29;
    public static final int CONVERSATION_REFERENCE = 30;
    public static final int CONVERSATIONS_LIST = 31;
    public static final int CONVERSATION_TREE = 32;
    public static final int CONVERSATION_GRAPH = 33;
    public static final int CONVERSATION_DIALOGUE_LINE = 330;
    public static final int CONVERSATION_OPTION_LINE = 331;
    public static final int RESOURCES = 34;
    public static final int NEXT_SCENE = 35;
    public static final int END_SCENE = 36;
    public static final int ASSESSMENT_RULE = 38;
    public static final int ADAPTATION_RULE = 39;
    public static final int ASSESSMENT_PROFILE = 40;
    public static final int ADAPTATION_PROFILE = 41;
    public static final int STYLED_BOOK = 42;
    public static final int BOOK_PAGE = 43;
    public static final int TIMER = 44;
    public static final int TIMERS_LIST = 45;
    public static final int ADVANCED_FEATURES = 46;
    public static final int ASSESSSMENT_PROFILES = 47;
    public static final int ADAPTATION_PROFILES = 48;
    public static final int TIMED_ASSESSMENT_RULE = 49;
    public static final int ACTIVE_AREAS_LIST = 50;
    public static final int ACTIVE_AREA = 51;
    public static final int BARRIERS_LIST = 52;
    public static final int BARRIER = 53;
    public static final int GLOBAL_STATE = 54;
    public static final int GLOBAL_STATE_LIST = 55;
    public static final int MACRO = 56;
    public static final int MACRO_LIST = 57;
    public static final int ATREZZO = 58;
    public static final int ATREZZO_LIST = 59;
    public static final int ATREZZO_REFERENCE = 60;
    public static final int ATREZZO_REFERENCES_LIST = 61;
    public static final int NODE = 62;
    public static final int SIDE = 63;
    public static final int TRAJECTORY = 64;
    public static final int ANIMATION = 65;
    public static final int EFFECT = 66;
    public static final int FILE_ADVENTURE_1STPERSON_PLAYER = 0;
    public static final int FILE_ADVENTURE_3RDPERSON_PLAYER = 1;
    public static final int FILE_ASSESSMENT = 2;
    public static final int FILE_ADAPTATION = 3;
    public static final int SCORM12 = 0;
    public static final int SCORM2004 = 1;
    public static final int AGREGA = 2;
    private static Controller controllerInstance = null;
    private MainWindow mainWindow;
    private String currentZipFile;
    private String currentZipPath;
    private String currentZipName;
    private AdventureDataControl adventureDataControl;
    private boolean dataModified;
    private String languageFile;
    private LoadingScreen loadingScreen;
    private String lastDialogDirectory;
    private ChapterListDataControl chaptersController = new ChapterListDataControl();
    private AutoSave autoSave;
    private Timer autoSaveTimer;
    private boolean isLomEs = false;
    private static final Runnable gc = new Runnable(){

        @Override
        public void run() {
            System.gc();
        }
    };

    private Controller() {
    }

    private String getCurrentExportSaveFolder() {
        return ReleaseFolders.exportsFolder().getAbsolutePath();
    }

    public String getCurrentLoadFolder() {
        return ReleaseFolders.projectsFolder().getAbsolutePath();
    }

    public void setLastDirectory(String string) {
        this.lastDialogDirectory = string;
    }

    public String getLastDirectory() {
        if (this.lastDialogDirectory != null) {
            return this.lastDialogDirectory;
        }
        return ReleaseFolders.projectsFolder().getAbsolutePath();
    }

    public static Controller getInstance() {
        if (controllerInstance == null) {
            controllerInstance = new Controller();
        }
        return controllerInstance;
    }

    public int playerMode() {
        return this.adventureDataControl.getPlayerMode();
    }

    public void init(String string) {
        es.eucm.eadventure.common.auxiliar.File file;
        es.eucm.eadventure.common.auxiliar.File file2;
        ConfigData.loadFromXML(ReleaseFolders.configFileEditorRelativePath());
        ProjectConfigData.init();
        SCORMConfigData.init();
        es.eucm.eadventure.common.auxiliar.File file3 = ReleaseFolders.projectsFolder();
        if (!file3.exists()) {
            file3.mkdirs();
        }
        if (!(file2 = ReleaseFolders.webTempFolder()).exists()) {
            file3.mkdirs();
        }
        if (!(file = ReleaseFolders.exportsFolder()).exists()) {
            file.mkdirs();
        }
        this.loadingScreen = new LoadingScreen("PRUEBA", this.getLoadingImage(), null);
        this.languageFile = "es_ES";
        this.setLanguage(ReleaseFolders.getLanguageFromPath((String)ConfigData.getLanguangeFile()), false);
        this.chaptersController = new ChapterListDataControl();
        this.currentZipFile = null;
        this.currentZipPath = null;
        this.currentZipName = null;
        this.dataModified = false;
        this.mainWindow = new MainWindow();
        this.mainWindow.setVisible(false);
        FrameForInitialDialogs frameForInitialDialogs = new FrameForInitialDialogs(true);
        if (string != null) {
            es.eucm.eadventure.common.auxiliar.File file4 = new es.eucm.eadventure.common.auxiliar.File(string);
            if (file4.exists()) {
                if (file4.getAbsolutePath().toLowerCase().endsWith(".eap")) {
                    String string2 = file4.getPath();
                    this.loadFile(string2.substring(0, string2.length() - 4), true);
                } else if (file4.isDirectory() && file4.exists()) {
                    this.loadFile(file4.getAbsolutePath(), true);
                }
            }
        } else if (ConfigData.showStartDialog()) {
            int n = frameForInitialDialogs.showStartDialog();
            if (n == 4) {
                this.newFile(frameForInitialDialogs.getFileType());
            } else if (n == 0) {
                File file5 = frameForInitialDialogs.getSelectedFile();
                if (file5.getAbsolutePath().toLowerCase().endsWith(".eap")) {
                    String string3 = file5.getPath();
                    this.loadFile(string3.substring(0, string3.length() - 4), true);
                } else if (file5.isDirectory() && file5.exists()) {
                    this.loadFile(frameForInitialDialogs.getSelectedFile().getAbsolutePath(), true);
                } else {
                    this.importGame(file5.getAbsolutePath());
                }
            } else if (n == 5) {
                this.loadFile(frameForInitialDialogs.getRecentFile().getAbsolutePath(), true);
            } else if (n == 1) {
                this.exit();
            }
            frameForInitialDialogs.remove();
        }
        if (this.currentZipFile == null) {
            this.mainWindow.reloadData();
        }
        this.mainWindow.setResizable(true);
        this.mainWindow.setVisible(true);
    }

    public void startAutoSave(int n) {
        this.stopAutoSave();
        if (ProjectConfigData.existsKey("autosave") && ProjectConfigData.getProperty("autosave").equals("yes") || !ProjectConfigData.existsKey("autosave")) {
            // empty if block
        }
        if (!ProjectConfigData.existsKey("autosave")) {
            ProjectConfigData.setProperty("autosave", "yes");
        }
    }

    public void stopAutoSave() {
        if (this.autoSaveTimer != null) {
            this.autoSaveTimer.cancel();
            this.autoSave.stop();
            this.autoSaveTimer = null;
        }
        this.autoSave = null;
    }

    public String getProjectFolder() {
        return this.currentZipFile;
    }

    public es.eucm.eadventure.common.auxiliar.File getProjectFolderFile() {
        return new es.eucm.eadventure.common.auxiliar.File(this.currentZipFile);
    }

    public String getFileName() {
        String string = this.currentZipName != null ? this.currentZipName : "http://e-adventure.e-ucm.es";
        return string;
    }

    public String getFilePath() {
        return this.currentZipPath;
    }

    public String[] getChapterTitles() {
        return this.chaptersController.getChapterTitles();
    }

    public int getSelectedChapter() {
        return this.chaptersController.getSelectedChapter();
    }

    public ChapterDataControl getSelectedChapterDataControl() {
        return this.chaptersController.getSelectedChapterDataControl();
    }

    public IdentifierSummary getIdentifierSummary() {
        return this.chaptersController.getIdentifierSummary();
    }

    public VarFlagSummary getVarFlagSummary() {
        return this.chaptersController.getVarFlagSummary();
    }

    public ChapterListDataControl getCharapterList() {
        return this.chaptersController;
    }

    public boolean isDataModified() {
        return this.dataModified;
    }

    public void dataModified() {
        if (!this.dataModified) {
            this.dataModified = true;
            this.mainWindow.updateTitle();
        }
    }

    public boolean isPlayTransparent() {
        if (this.adventureDataControl == null) {
            return false;
        }
        return this.adventureDataControl.getPlayerMode() == 0;
    }

    public void swapPlayerMode(boolean bl) {
        this.addTool(new SwapPlayerModeTool(bl, this.adventureDataControl, this.chaptersController));
    }

    public boolean newFile(int n) {
        boolean bl = false;
        if (n == 0 || n == 1) {
            bl = this.newAdventureFile(n);
        } else if (n == 2 || n == 3) {
            // empty if block
        }
        if (bl) {
            AssetsController.resetCache();
        }
        return bl;
    }

    public boolean newFile() {
        boolean bl = true;
        if (this.dataModified) {
            int n = this.mainWindow.showConfirmDialog(TC.get((String)"Operation.NewFileTitle"), TC.get((String)"Operation.NewFileMessage"));
            if (n == 0) {
                bl = this.saveFile(false);
            } else if (n == 1) {
                bl = true;
                this.dataModified = false;
                this.mainWindow.updateTitle();
            } else if (n == 2) {
                bl = false;
            }
        }
        if (bl) {
            this.stopAutoSave();
            ConfigData.storeToXML();
            ProjectConfigData.storeToXML();
            ConfigData.loadFromXML(ReleaseFolders.configFileEditorRelativePath());
            ProjectConfigData.init();
            FrameForInitialDialogs frameForInitialDialogs = new FrameForInitialDialogs(0);
            this.mainWindow.setVisible(false);
            int n = frameForInitialDialogs.showStartDialog();
            if (n == 4) {
                this.newFile(frameForInitialDialogs.getFileType());
            } else if (n == 0) {
                File file = frameForInitialDialogs.getSelectedFile();
                if (file.getAbsolutePath().toLowerCase().endsWith(".eap")) {
                    String string = file.getPath();
                    this.loadFile(string.substring(0, string.length() - 4), true);
                } else if (file.isDirectory() && file.exists()) {
                    this.loadFile(frameForInitialDialogs.getSelectedFile().getAbsolutePath(), true);
                } else {
                    this.importGame(file.getAbsolutePath());
                }
            } else if (n == 5) {
                this.loadFile(frameForInitialDialogs.getRecentFile().getAbsolutePath(), true);
            } else if (n == 1) {
                this.exit();
            }
            frameForInitialDialogs.remove();
            if (this.currentZipFile == null) {
                this.mainWindow.reloadData();
            }
            this.mainWindow.setResizable(true);
            this.mainWindow.setEnabled(true);
            this.mainWindow.setVisible(true);
        }
        Controller.gc();
        return bl;
    }

    private boolean newAdventureFile(int n) {
        boolean bl = false;
        boolean bl2 = false;
        File file = null;
        File file2 = null;
        FrameForInitialDialogs frameForInitialDialogs = new FrameForInitialDialogs(false);
        int n2 = frameForInitialDialogs.showStartDialog();
        if (n2 == 6) {
            String string;
            File file3 = frameForInitialDialogs.getSelectedFile();
            file2 = file3;
            if (file2.getAbsolutePath().endsWith(".eap")) {
                string = file3.getAbsolutePath();
                file3 = new es.eucm.eadventure.common.auxiliar.File(string.substring(0, string.length() - 4));
            } else {
                file2 = new es.eucm.eadventure.common.auxiliar.File(file2.getAbsolutePath() + ".eap");
            }
            file = file3;
            if (this.isValidTargetProject(file3)) {
                if (FolderFileFilter.checkCharacters(file3.getName())) {
                    if (file3.exists()) {
                        if (file3.list().length > 0 && this.showStrictConfirmDialog(TC.get((String)"Operation.NewProject.FolderNotEmptyTitle"), TC.get((String)"Operation.NewProject.FolderNotEmptyMessage")) && !(string = new es.eucm.eadventure.common.auxiliar.File(file3.getAbsolutePath())).deleteAll()) {
                            this.showStrictConfirmDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.DeletingFolderContents"));
                        }
                        bl2 = true;
                    } else if (this.showStrictConfirmDialog(TC.get((String)"Operation.NewProject.FolderNotCreatedTitle"), TC.get((String)"Operation.NewProject.FolderNotCreatedMessage"))) {
                        string = new es.eucm.eadventure.common.auxiliar.File(file3.getAbsolutePath());
                        if (string.mkdirs()) {
                            bl2 = true;
                        } else {
                            this.showStrictConfirmDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.CreatingFolder"));
                        }
                    } else {
                        bl2 = false;
                    }
                } else {
                    this.showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.ProjectFolderName", (String)FolderFileFilter.getAllowedChars()));
                }
            } else {
                this.mainWindow.showErrorDialog(TC.get((String)"Operation.NewProject.ForbiddenParent.Title"), TC.get((String)"Operation.NewProject.ForbiddenParent.Message"));
                bl2 = false;
            }
        }
        frameForInitialDialogs.remove();
        if (bl2) {
            this.loadingScreen.setMessage(TC.get((String)"Operation.CreateProject"));
            this.loadingScreen.setVisible(true);
            this.currentZipFile = file.getAbsolutePath();
            this.currentZipPath = file.getParent();
            this.currentZipName = file.getName();
            int n3 = -1;
            if (n == 1) {
                n3 = 1;
            } else if (n == 0) {
                n3 = 0;
            }
            this.adventureDataControl = new AdventureDataControl(TC.get((String)"DefaultValue.AdventureTitle"), TC.get((String)"DefaultValue.ChapterTitle"), TC.get((String)"DefaultValue.SceneId"), n3);
            this.chaptersController = new ChapterListDataControl(this.adventureDataControl.getChapters());
            ProjectConfigData.init();
            SCORMConfigData.init();
            AssetsController.createFolderStructure();
            AssetsController.addSpecialAssets();
            boolean bl3 = this.chaptersController.isValid(null, null);
            if (Writer.writeData(this.currentZipFile, this.adventureDataControl, bl3)) {
                this.dataModified = false;
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    ReportDialog.GenerateErrorReport((Exception)interruptedException, (boolean)true, (String)"UNKNOWNERROR");
                }
                try {
                    if (file2 != null && !file2.exists()) {
                        file2.createNewFile();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.mainWindow.reloadData();
                bl = true;
            } else {
                bl = false;
            }
        }
        if (bl) {
            ConfigData.fileLoaded(this.currentZipFile);
            this.mainWindow.showInformationDialog(TC.get((String)"Operation.FileLoadedTitle"), TC.get((String)"Operation.FileLoadedMessage"));
        } else {
            this.mainWindow.showInformationDialog(TC.get((String)"Operation.FileNotLoadedTitle"), TC.get((String)"Operation.FileNotLoadedMessage"));
        }
        this.loadingScreen.setVisible(false);
        Controller.gc();
        return bl;
    }

    public void showLoadingScreen(String string) {
        this.loadingScreen.setMessage(string);
        this.loadingScreen.setVisible(true);
    }

    public void hideLoadingScreen() {
        this.loadingScreen.setVisible(false);
    }

    public boolean fixIncidences(List<Incidence> list) {
        boolean bl = false;
        List<Chapter> list2 = this.adventureDataControl.getChapters();
        block0: for (int i = 0; i < list.size(); ++i) {
            Incidence incidence = list.get(i);
            if (incidence.getImportance() == 3) {
                if (incidence.getException() != null) {
                    ReportDialog.GenerateErrorReport((Exception)incidence.getException(), (boolean)true, (String)TC.get((String)"GeneralText.LoadError"));
                }
                bl = true;
                break;
            }
            if (incidence.getImportance() == 2) {
                String string;
                String[] stringArray;
                String string2;
                if (incidence.getAffectedArea() != 2 || incidence.getType() != 0) continue;
                String string3 = TC.get((String)"ErrorSolving.Chapter.Title") + " - Error " + (i + 1) + "/" + list.size();
                int n = this.showOptionDialog(string3, string2 = TC.get((String)"ErrorSolving.Chapter.Message", (String[])new String[]{incidence.getMessage(), incidence.getAffectedResource()}), stringArray = new String[]{TC.get((String)"GeneralText.Delete"), TC.get((String)"GeneralText.Replace"), TC.get((String)"GeneralText.Abort"), TC.get((String)"GeneralText.ReportError")});
                if (n == 0) {
                    String string4 = incidence.getAffectedResource();
                    for (int j = 0; j < list2.size(); ++j) {
                        if (!list2.get(j).getChapterPath().equals(string4)) continue;
                        list2.remove(j);
                        if (list2.size() == 0) {
                            string = new Chapter(TC.get((String)"DefaultValue.ChapterTitle"), TC.get((String)"DefaultValue.SceneId"));
                            list2.add((Chapter)string);
                        }
                        this.chaptersController = new ChapterListDataControl(list2);
                        this.dataModified();
                        continue block0;
                    }
                    continue;
                }
                if (n == 1) {
                    boolean bl2 = false;
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setDialogTitle(TC.get((String)"GeneralText.Select"));
                    jFileChooser.setFileFilter((FileFilter)((Object)new XMLFileFilter()));
                    jFileChooser.setMultiSelectionEnabled(false);
                    if (jFileChooser.showOpenDialog(this.mainWindow) == 0) {
                        string = jFileChooser.getSelectedFile().getAbsolutePath();
                        ArrayList arrayList = new ArrayList();
                        Chapter chapter = Loader.loadChapterData((InputStreamCreator)AssetsController.getInputStreamCreator(), (String)string, list, (boolean)true);
                        if (chapter != null && arrayList.size() == 0) {
                            int n2 = -1;
                            for (int j = 0; n2 == -1 && j < list2.size(); ++j) {
                                if (!list2.get(j).getChapterPath().equals(incidence.getAffectedResource())) continue;
                                n2 = j;
                            }
                            if (n2 >= 0) {
                                list2.set(n2, chapter);
                                this.chaptersController = new ChapterListDataControl(list2);
                                es.eucm.eadventure.common.auxiliar.File file = new es.eucm.eadventure.common.auxiliar.File(this.getProjectFolder(), chapter.getChapterPath());
                                if (file.exists()) {
                                    file.delete();
                                }
                                es.eucm.eadventure.common.auxiliar.File file2 = new es.eucm.eadventure.common.auxiliar.File(string);
                                file2.copyTo((File)file);
                                bl2 = true;
                                this.dataModified();
                            }
                        }
                    }
                    if (bl2) continue;
                    this.mainWindow.showWarningDialog(TC.get((String)"ErrorSolving.Chapter.NotReplaced.Title"), TC.get((String)"ErrorSolving.Chapter.NotReplaced.Message"));
                    continue;
                }
                if (n == 3) {
                    if (incidence.getException() != null) {
                        ReportDialog.GenerateErrorReport((Exception)incidence.getException(), (boolean)true, (String)TC.get((String)"GeneralText.LoadError"));
                    }
                    bl = true;
                    continue;
                }
                bl = true;
                break;
            }
            if (incidence.getImportance() == 1) {
                if (incidence.getType() == 1) {
                    this.deleteAssetReferences(incidence.getAffectedResource());
                    this.mainWindow.showInformationDialog(TC.get((String)"ErrorSolving.Asset.Deleted.Title") + " - Error " + (i + 1) + "/" + list.size(), TC.get((String)"ErrorSolving.Asset.Deleted.Message", (String)incidence.getAffectedResource()));
                    if (incidence.getException() == null) continue;
                    ReportDialog.GenerateErrorReport((Exception)incidence.getException(), (boolean)true, (String)TC.get((String)"GeneralText.LoadError"));
                    continue;
                }
                if (incidence.getAffectedArea() == 0) {
                    this.mainWindow.showInformationDialog(TC.get((String)"ErrorSolving.AssessmentReferenced.Deleted.Title") + " - Error " + (i + 1) + "/" + list.size(), TC.get((String)"ErrorSolving.AssessmentReferenced.Deleted.Message", (String)incidence.getAffectedResource()));
                    for (int j = 0; j < list2.size(); ++j) {
                        if (!list2.get(j).getAssessmentName().equals(incidence.getAffectedResource())) continue;
                        list2.get(j).setAssessmentName("");
                        this.dataModified();
                    }
                    if (incidence.getException() == null) continue;
                    ReportDialog.GenerateErrorReport((Exception)incidence.getException(), (boolean)true, (String)TC.get((String)"GeneralText.LoadError"));
                    continue;
                }
                if (incidence.getAffectedArea() == 1) {
                    this.mainWindow.showInformationDialog(TC.get((String)"ErrorSolving.AdaptationReferenced.Deleted.Title") + " - Error " + (i + 1) + "/" + list.size(), TC.get((String)"ErrorSolving.AdaptationReferenced.Deleted.Message", (String)incidence.getAffectedResource()));
                    for (int j = 0; j < list2.size(); ++j) {
                        if (!list2.get(j).getAdaptationName().equals(incidence.getAffectedResource())) continue;
                        list2.get(j).setAdaptationName("");
                        this.dataModified();
                    }
                    if (incidence.getException() == null) continue;
                    ReportDialog.GenerateErrorReport((Exception)incidence.getException(), (boolean)true, (String)TC.get((String)"GeneralText.LoadError"));
                    continue;
                }
                bl = true;
                break;
            }
            if (incidence.getImportance() != 0) continue;
            if (incidence.getAffectedArea() == 1) {
                this.dataModified();
            }
            if (incidence.getAffectedArea() != 0) continue;
            this.dataModified();
        }
        return bl;
    }

    public boolean loadFile() {
        return this.loadFile(null, true);
    }

    public boolean replaceSelectedChapter(Chapter chapter) {
        this.chaptersController.replaceSelectedChapter(chapter);
        this.mainWindow.reloadData();
        return true;
    }

    public NPC getNPC(String string) {
        return this.getSelectedChapterDataControl().getNPCsList().getNPC(string);
    }

    private boolean loadFile(String string, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            boolean bl4 = true;
            if (this.dataModified) {
                int n = this.mainWindow.showConfirmDialog(TC.get((String)"Operation.LoadFileTitle"), TC.get((String)"Operation.LoadFileMessage"));
                if (n == 0) {
                    bl4 = this.saveFile(false);
                } else if (n == 1) {
                    bl4 = true;
                    this.dataModified = false;
                    this.mainWindow.updateTitle();
                } else if (n == 2) {
                    bl4 = false;
                }
            }
            if (bl4 && string == null) {
                this.stopAutoSave();
                ConfigData.loadFromXML(ReleaseFolders.configFileEditorRelativePath());
                ProjectConfigData.loadFromXML();
                FrameForInitialDialogs frameForInitialDialogs = new FrameForInitialDialogs(1);
                this.mainWindow.setVisible(false);
                int n = frameForInitialDialogs.showStartDialog();
                if (n == 4) {
                    this.newFile(frameForInitialDialogs.getFileType());
                } else if (n == 0) {
                    File file = frameForInitialDialogs.getSelectedFile();
                    String string2 = file.getAbsolutePath().toLowerCase();
                    if (string2.endsWith(".eap")) {
                        String string3 = file.getPath();
                        this.loadFile(string3.substring(0, string3.length() - 4), true);
                    } else if (file.isDirectory() && file.exists()) {
                        this.loadFile(frameForInitialDialogs.getSelectedFile().getAbsolutePath(), true);
                    } else {
                        this.importGame(file.getAbsolutePath());
                    }
                } else if (n == 5) {
                    this.loadFile(frameForInitialDialogs.getRecentFile().getAbsolutePath(), true);
                } else if (n == 1) {
                    this.exit();
                }
                frameForInitialDialogs.remove();
                this.mainWindow.setResizable(true);
                this.mainWindow.setEnabled(true);
                this.mainWindow.setVisible(true);
                return true;
            }
            if (string != null) {
                if (bl) {
                    this.loadingScreen.setMessage(TC.get((String)"Operation.LoadProject"));
                    this.loadingScreen.setVisible(true);
                    bl = true;
                }
                es.eucm.eadventure.common.auxiliar.File file = new es.eucm.eadventure.common.auxiliar.File(string);
                ArrayList<Incidence> arrayList = new ArrayList<Incidence>();
                AdventureData adventureData = Loader.loadAdventureData((InputStreamCreator)AssetsController.getInputStreamCreator(string), arrayList, (boolean)true);
                if (adventureData != null) {
                    boolean bl5;
                    this.currentZipFile = file.getAbsolutePath();
                    this.currentZipPath = file.getParent();
                    this.currentZipName = file.getName();
                    adventureData.setProjectName(this.currentZipName);
                    this.adventureDataControl = new AdventureDataControl(adventureData);
                    this.chaptersController = new ChapterListDataControl(this.adventureDataControl.getChapters());
                    AssetsController.checkAssetFilesConsistency(arrayList);
                    Incidence.sortIncidences(arrayList);
                    if (arrayList.size() > 0 && (bl5 = this.fixIncidences(arrayList))) {
                        this.mainWindow.showInformationDialog(TC.get((String)"Error.LoadAborted.Title"), TC.get((String)"Error.LoadAborted.Message"));
                        bl3 = true;
                    }
                    ProjectConfigData.loadFromXML();
                    AssetsController.createFolderStructure();
                    AssetsController.addSpecialAssets();
                    this.dataModified = false;
                    bl2 = true;
                    this.mainWindow.reloadData();
                }
            }
            if (bl2) {
                ConfigData.fileLoaded(this.currentZipFile);
                AssetsController.resetCache();
                ProjectConfigData.loadFromXML();
                this.startAutoSave(15);
                if (!bl3) {
                    this.mainWindow.showInformationDialog(TC.get((String)"Operation.FileLoadedTitle"), TC.get((String)"Operation.FileLoadedMessage"));
                } else {
                    this.mainWindow.showInformationDialog(TC.get((String)"Operation.FileLoadedWithErrorTitle"), TC.get((String)"Operation.FileLoadedWithErrorMessage"));
                }
            } else {
                this.mainWindow.showInformationDialog(TC.get((String)"Operation.FileNotLoadedTitle"), TC.get((String)"Operation.FileNotLoadedMessage"));
            }
            if (bl) {
                this.loadingScreen.setVisible(false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl2 = false;
            if (bl) {
                this.loadingScreen.setVisible(false);
            }
            this.mainWindow.showInformationDialog(TC.get((String)"Operation.FileNotLoadedTitle"), TC.get((String)"Operation.FileNotLoadedMessage"));
        }
        Controller.gc();
        return bl2;
    }

    public boolean saveFile(boolean bl) {
        boolean bl2 = false;
        try {
            es.eucm.eadventure.common.auxiliar.File file;
            es.eucm.eadventure.common.auxiliar.File file2;
            boolean bl3 = true;
            if (bl) {
                String string = null;
                string = this.mainWindow.showSaveDialog(this.getCurrentLoadFolder(), (FileFilter)((Object)new FolderFileFilter(false, false, null)));
                if (string != null) {
                    if (string.endsWith(".eap")) {
                        file2 = new es.eucm.eadventure.common.auxiliar.File(string);
                        file = new es.eucm.eadventure.common.auxiliar.File(string.substring(0, string.length() - 4));
                    } else {
                        file2 = new es.eucm.eadventure.common.auxiliar.File(string + ".eap");
                        file = new es.eucm.eadventure.common.auxiliar.File(string);
                    }
                    if (this.isValidTargetProject((File)file2)) {
                        if (FolderFileFilter.checkCharacters(file.getName())) {
                            if (!(this.currentZipFile != null && file.getAbsolutePath().toLowerCase().equals(this.currentZipFile.toLowerCase()) || (file2.exists() || file.exists()) && file.exists() && file.list().length != 0 && !this.mainWindow.showStrictConfirmDialog(TC.get((String)"Operation.SaveFileTitle"), TC.get((String)"Operation.NewProject.FolderNotEmptyMessage", (String)file.getName())))) {
                                if (!file2.exists()) {
                                    file2.create();
                                }
                                if (bl) {
                                    this.loadingScreen.setMessage(TC.get((String)"Operation.SaveProjectAs"));
                                    this.loadingScreen.setVisible(true);
                                    AssetsController.copyAssets(this.currentZipFile, file.getAbsolutePath());
                                }
                                this.currentZipFile = file.getAbsolutePath();
                                this.currentZipPath = file.getParent();
                                this.currentZipName = file.getName();
                                AssetsController.createFolderStructure();
                            } else {
                                bl3 = false;
                            }
                            if (!bl3 && this.currentZipFile != null && file.getAbsolutePath().toLowerCase().equals(this.currentZipFile.toLowerCase())) {
                                this.showErrorDialog(TC.get((String)"Operation.SaveProjectAs.TargetFolderInUse.Title"), TC.get((String)"Operation.SaveProjectAs.TargetFolderInUse.Message"));
                            }
                        } else {
                            this.showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.ProjectFolderName", (String)FolderFileFilter.getAllowedChars()));
                            bl3 = false;
                        }
                    } else {
                        this.mainWindow.showErrorDialog(TC.get((String)"Operation.NewProject.ForbiddenParent.Title"), TC.get((String)"Operation.NewProject.ForbiddenParent.Message"));
                        bl3 = false;
                    }
                } else {
                    bl3 = false;
                }
            } else {
                this.loadingScreen.setMessage(TC.get((String)"Operation.SaveProject"));
                this.loadingScreen.setVisible(true);
            }
            if (bl3) {
                ConfigData.storeToXML();
                ProjectConfigData.storeToXML();
                boolean bl4 = this.chaptersController.isValid(null, null);
                if (!bl4) {
                    this.mainWindow.showWarningDialog(TC.get((String)"Operation.AdventureConsistencyTitle"), TC.get((String)"Operation.AdventurInconsistentWarning"));
                }
                file = this.increaseVersionNumber(this.adventureDataControl.getAdventureData().getVersionNumber());
                this.adventureDataControl.getAdventureData().setVersionNumber((String)file);
                if (Writer.writeData(this.currentZipFile, this.adventureDataControl, bl4)) {
                    file2 = new es.eucm.eadventure.common.auxiliar.File(this.currentZipFile + ".eap");
                    if (!file2.exists()) {
                        file2.create();
                    }
                    this.dataModified = false;
                    this.mainWindow.updateTitle();
                    bl2 = true;
                }
            }
            if (bl2) {
                ConfigData.fileLoaded(this.currentZipFile);
                ProjectConfigData.storeToXML();
                AssetsController.resetCache();
                es.eucm.eadventure.common.auxiliar.File file3 = new es.eucm.eadventure.common.auxiliar.File(this.currentZipFile + es.eucm.eadventure.common.auxiliar.File.separator + "assessment");
                if (file3.exists()) {
                    file = file3.listFiles();
                    for (int i = 0; i < ((es.eucm.eadventure.common.auxiliar.File[])file).length; ++i) {
                        file[i].delete();
                    }
                    file3.delete();
                }
                if ((file = new es.eucm.eadventure.common.auxiliar.File(this.currentZipFile + es.eucm.eadventure.common.auxiliar.File.separator + "adaptation")).exists()) {
                    es.eucm.eadventure.common.auxiliar.File[] fileArray = file.listFiles();
                    for (int i = 0; i < fileArray.length; ++i) {
                        fileArray[i].delete();
                    }
                    file.delete();
                }
            }
        }
        catch (Exception exception) {
            bl2 = false;
            this.mainWindow.showInformationDialog(TC.get((String)"Operation.FileNotSavedTitle"), TC.get((String)"Operation.FileNotSavedMessage"));
        }
        Controller.gc();
        this.loadingScreen.setVisible(false);
        return bl2;
    }

    private String increaseVersionNumber(char[] cArray, int n) {
        if (cArray[n] != '9') {
            int n2 = n;
            cArray[n2] = (char)(cArray[n2] + '\u0001');
            return new String(cArray);
        }
        if (n == 0) {
            char[] cArray2 = new char[cArray.length + 1];
            cArray2[0] = 49;
            cArray2[1] = 48;
            for (int i = 2; i < cArray2.length; ++i) {
                cArray2[i] = cArray[i - 1];
            }
            return new String(cArray2);
        }
        cArray[n] = 48;
        return this.increaseVersionNumber(cArray, --n);
    }

    private String increaseVersionNumber(String string) {
        char[] cArray = string.toCharArray();
        return this.increaseVersionNumber(cArray, cArray.length - 1);
    }

    public void importGame() {
        this.importGame(null);
    }

    public void importGame(String string) {
        boolean bl = true;
        File file = null;
        try {
            if (this.dataModified) {
                int n = this.mainWindow.showConfirmDialog(TC.get((String)"Operation.SaveChangesTitle"), TC.get((String)"Operation.SaveChangesMessage"));
                if (n == 0) {
                    bl = this.saveFile(false);
                } else if (n == 1) {
                    bl = true;
                    this.dataModified = false;
                    this.mainWindow.updateTitle();
                } else if (n == 2) {
                    bl = false;
                }
            }
            if (bl) {
                if (string.endsWith(".zip")) {
                    this.mainWindow.showInformationDialog(TC.get((String)"Operation.ImportProject"), TC.get((String)"Operation.ImportLO.InfoMessage"));
                } else if (string.endsWith(".jar")) {
                    this.mainWindow.showInformationDialog(TC.get((String)"Operation.ImportProject"), TC.get((String)"Operation.ImportJAR.InfoMessage"));
                }
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileFilter((FileFilter)((Object)new EADFileFilter()));
                jFileChooser.setMultiSelectionEnabled(false);
                jFileChooser.setCurrentDirectory((File)new es.eucm.eadventure.common.auxiliar.File(this.getCurrentExportSaveFolder()));
                int n = 0;
                if (string == null) {
                    n = jFileChooser.showOpenDialog(this.mainWindow);
                }
                if (n == 0) {
                    File file2 = null;
                    file2 = string == null ? jFileChooser.getSelectedFile() : new es.eucm.eadventure.common.auxiliar.File(string);
                    if (!file2.exists()) {
                        this.mainWindow.showErrorDialog(TC.get((String)"Error.Import.FileNotFound.Title"), TC.get((String)"Error.Import.FileNotFound.Title", (String)file2.getName()));
                    } else {
                        boolean bl2 = false;
                        File file3 = null;
                        FrameForInitialDialogs frameForInitialDialogs = new FrameForInitialDialogs(false);
                        int n2 = frameForInitialDialogs.showStartDialog();
                        if (n2 == 6) {
                            String string2;
                            File file4;
                            file = file4 = frameForInitialDialogs.getSelectedFile();
                            if (file4.getAbsolutePath().endsWith(".eap")) {
                                string2 = file4.getAbsolutePath();
                                file4 = new File(string2.substring(0, string2.length() - 4));
                            } else {
                                file = new File(file4.getAbsolutePath() + ".eap");
                            }
                            file3 = file4;
                            if (this.isValidTargetProject(file4)) {
                                if (FolderFileFilter.checkCharacters(file4.getName())) {
                                    if (file4.exists()) {
                                        if (file4.list().length > 0) {
                                            if (this.showStrictConfirmDialog(TC.get((String)"Operation.NewProject.FolderNotEmptyTitle"), TC.get((String)"Operation.NewProject.FolderNotEmptyMessage"))) {
                                                string2 = new es.eucm.eadventure.common.auxiliar.File(file4.getAbsolutePath());
                                                if (string2.deleteAll()) {
                                                    bl2 = true;
                                                } else {
                                                    this.showStrictConfirmDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.DeletingFolderContents"));
                                                }
                                            }
                                        } else {
                                            bl2 = true;
                                        }
                                    } else {
                                        string2 = new es.eucm.eadventure.common.auxiliar.File(file4.getAbsolutePath());
                                        if (string2.mkdirs()) {
                                            bl2 = true;
                                        } else {
                                            this.showStrictConfirmDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.CreatingFolder"));
                                        }
                                    }
                                } else {
                                    this.showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.ProjectFolderName", (String)FolderFileFilter.getAllowedChars()));
                                }
                            } else {
                                this.mainWindow.showErrorDialog(TC.get((String)"Operation.NewProject.ForbiddenParent.Title"), TC.get((String)"Operation.NewProject.ForbiddenParent.Message"));
                                bl2 = false;
                            }
                        }
                        frameForInitialDialogs.remove();
                        if (bl2) {
                            this.loadingScreen.setMessage(TC.get((String)"Operation.ImportProject"));
                            this.loadingScreen.setVisible(true);
                            if (!file3.exists()) {
                                file3.mkdirs();
                            }
                            if (file != null && !file.exists()) {
                                file.createNewFile();
                            }
                            boolean bl3 = true;
                            if (string.endsWith(".ead")) {
                                es.eucm.eadventure.common.auxiliar.File.unzipDir((String)file2.getAbsolutePath(), (String)file3.getAbsolutePath());
                            } else if (string.endsWith(".zip")) {
                                if (!es.eucm.eadventure.common.auxiliar.File.importEadventureLO((String)file2.getAbsolutePath(), (String)file3.getAbsolutePath())) {
                                    this.loadingScreen.setVisible(false);
                                    this.mainWindow.showErrorDialog(TC.get((String)"Operation.FileNotLoadedTitle"), TC.get((String)"Operation.ImportLO.FileNotLoadedMessage"));
                                    bl3 = false;
                                }
                            } else if (string.endsWith(".jar") && !es.eucm.eadventure.common.auxiliar.File.importEadventureJar((String)file2.getAbsolutePath(), (String)file3.getAbsolutePath())) {
                                this.loadingScreen.setVisible(false);
                                this.mainWindow.showErrorDialog(TC.get((String)"Operation.FileNotLoadedTitle"), TC.get((String)"Operation.ImportJAR.FileNotLoaded"));
                                bl3 = false;
                            }
                            if (bl3) {
                                this.loadFile(file3.getAbsolutePath(), false);
                                this.loadingScreen.setVisible(false);
                            } else {
                                file.delete();
                                file3.delete();
                            }
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            this.loadingScreen.setVisible(false);
            this.mainWindow.showErrorDialog(TC.get((String)"Operation.FileNotLoadedTitle"), TC.get((String)"Operation.FileNotLoadedMessage"));
        }
    }

    public boolean exportGame() {
        return this.exportGame(null);
    }

    public boolean exportGame(String string) {
        boolean bl = true;
        boolean bl2 = false;
        try {
            if (this.dataModified) {
                int n = this.mainWindow.showConfirmDialog(TC.get((String)"Operation.SaveChangesTitle"), TC.get((String)"Operation.SaveChangesMessage"));
                if (n == 0) {
                    bl = this.saveFile(false);
                } else if (n == 1) {
                    bl = true;
                } else if (n == 2) {
                    bl = false;
                }
            }
            if (bl) {
                String string2 = string;
                if (string2 == null) {
                    string2 = this.mainWindow.showSaveDialog(this.getCurrentExportSaveFolder(), (FileFilter)((Object)new EADFileFilter()));
                }
                if (string2 != null) {
                    if (!string2.toLowerCase().endsWith(".ead")) {
                        string2 = string2 + ".ead";
                    }
                    es.eucm.eadventure.common.auxiliar.File file = new es.eucm.eadventure.common.auxiliar.File(string2);
                    if (string != null || this.isValidTargetFile((File)file)) {
                        if (!file.exists() || string != null || this.mainWindow.showStrictConfirmDialog(TC.get((String)"Operation.SaveFileTitle"), TC.get((String)"Operation.OverwriteExistingFile", (String)file.getName()))) {
                            file.delete();
                            if (string == null) {
                                this.loadingScreen.setMessage(TC.get((String)"Operation.ExportProject.AsEAD"));
                                this.loadingScreen.setVisible(true);
                            }
                            if (Writer.export(this.getProjectFolder(), file.getAbsolutePath())) {
                                bl2 = true;
                                if (string == null) {
                                    this.mainWindow.showInformationDialog(TC.get((String)"Operation.ExportT.Success.Title"), TC.get((String)"Operation.ExportT.Success.Message"));
                                }
                            } else {
                                this.mainWindow.showInformationDialog(TC.get((String)"Operation.ExportT.NotSuccess.Title"), TC.get((String)"Operation.ExportT.NotSuccess.Message"));
                            }
                            if (string == null) {
                                this.loadingScreen.setVisible(false);
                            }
                        }
                    } else {
                        this.mainWindow.showErrorDialog(TC.get((String)"Operation.ExportT.TargetInProjectDir.Title"), TC.get((String)"Operation.ExportT.TargetInProjectDir.Message"));
                    }
                }
            }
        }
        catch (Exception exception) {
            this.loadingScreen.setVisible(false);
            this.mainWindow.showErrorDialog("Operation.FileNotSavedTitle", "Operation.FileNotSavedMessage");
            bl2 = false;
        }
        return bl2;
    }

    public boolean createBackup(String string) {
        boolean bl = false;
        if (string == null) {
            string = this.currentZipFile + ".tmp";
        }
        es.eucm.eadventure.common.auxiliar.File file = new es.eucm.eadventure.common.auxiliar.File(this.currentZipFile, "backup");
        try {
            String string2;
            boolean bl2 = this.chaptersController.isValid(null, null);
            file.create();
            if (Writer.writeData(this.currentZipFile + es.eucm.eadventure.common.auxiliar.File.separatorChar + "backup", this.adventureDataControl, bl2)) {
                bl = true;
            }
            if (bl && (string2 = string) != null) {
                es.eucm.eadventure.common.auxiliar.File file2 = new es.eucm.eadventure.common.auxiliar.File(string2);
                if (string != null || this.isValidTargetFile((File)file2)) {
                    if (!file2.exists() || string != null) {
                        file2.delete();
                        if (Writer.export(this.getProjectFolder(), file2.getAbsolutePath())) {
                            bl = true;
                        }
                    }
                } else {
                    bl = false;
                }
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (file.exists()) {
            file.deleteAll();
        }
        return bl;
    }

    public void exportStandaloneGame() {
        boolean bl = true;
        try {
            if (this.dataModified) {
                int n = this.mainWindow.showConfirmDialog(TC.get((String)"Operation.SaveChangesTitle"), TC.get((String)"Operation.SaveChangesMessage"));
                if (n == 0) {
                    bl = this.saveFile(false);
                } else if (n == 1) {
                    bl = true;
                } else if (n == 2) {
                    bl = false;
                }
            }
            if (bl) {
                String string = null;
                string = this.mainWindow.showSaveDialog(this.getCurrentExportSaveFolder(), (FileFilter)((Object)new JARFileFilter()));
                if (string != null) {
                    es.eucm.eadventure.common.auxiliar.File file;
                    if (!string.toLowerCase().endsWith(".jar")) {
                        string = string + ".jar";
                    }
                    if (this.isValidTargetFile((File)(file = new es.eucm.eadventure.common.auxiliar.File(string)))) {
                        if (!file.exists() || this.mainWindow.showStrictConfirmDialog(TC.get((String)"Operation.SaveFileTitle"), TC.get((String)"Operation.OverwriteExistingFile", (String)file.getName()))) {
                            file.delete();
                            this.loadingScreen.setMessage(TC.get((String)"Operation.ExportProject.AsJAR"));
                            this.loadingScreen.setVisible(true);
                            if (Writer.exportStandalone(this.getProjectFolder(), file.getAbsolutePath())) {
                                this.mainWindow.showInformationDialog(TC.get((String)"Operation.ExportT.Success.Title"), TC.get((String)"Operation.ExportT.Success.Message"));
                            } else {
                                this.mainWindow.showInformationDialog(TC.get((String)"Operation.ExportT.NotSuccess.Title"), TC.get((String)"Operation.ExportT.NotSuccess.Message"));
                            }
                            this.loadingScreen.setVisible(false);
                        }
                    } else {
                        this.mainWindow.showErrorDialog(TC.get((String)"Operation.ExportT.TargetInProjectDir.Title"), TC.get((String)"Operation.ExportT.TargetInProjectDir.Message"));
                    }
                }
            }
        }
        catch (Exception exception) {
            this.loadingScreen.setVisible(false);
            this.mainWindow.showErrorDialog(TC.get((String)"Operation.FileNotSavedTitle"), TC.get((String)"Operation.FileNotSavedMessage"));
        }
    }

    public void exportToLOM() {
        boolean bl = true;
        try {
            if (this.dataModified) {
                int n = this.mainWindow.showConfirmDialog(TC.get((String)"Operation.SaveChangesTitle"), TC.get((String)"Operation.SaveChangesMessage"));
                if (n == 0) {
                    bl = this.saveFile(false);
                } else if (n == 1) {
                    bl = true;
                } else if (n == 2) {
                    bl = false;
                }
            }
            if (bl) {
                ExportToLOMDialog exportToLOMDialog = new ExportToLOMDialog(TC.get((String)"Operation.ExportToLOM.DefaultValue"));
                String string = exportToLOMDialog.getLomName();
                String string2 = exportToLOMDialog.getAuthorName();
                String string3 = exportToLOMDialog.getOrganizationName();
                boolean bl2 = exportToLOMDialog.getWindowed();
                int n = exportToLOMDialog.getType();
                String string4 = exportToLOMDialog.getTestUserID();
                String string5 = exportToLOMDialog.getTestReturnURI();
                boolean bl3 = exportToLOMDialog.isValidated();
                if (n == 2 && !this.hasScormProfiles(0)) {
                    this.mainWindow.showErrorDialog(TC.get((String)"Operation.ExportSCORM12.BadProfiles.Title"), TC.get((String)"Operation.ExportSCORM12.BadProfiles.Message"));
                } else if (n == 3 && !this.hasScormProfiles(1)) {
                    this.mainWindow.showErrorDialog(TC.get((String)"Operation.ExportSCORM2004.BadProfiles.Title"), TC.get((String)"Operation.ExportSCORM2004.BadProfiles.Message"));
                } else if (n == 4 && !this.hasScormProfiles(2)) {
                    this.mainWindow.showErrorDialog(TC.get((String)"Operation.ExportSCORM2004AGREGA.BadProfiles.Title"), TC.get((String)"Operation.ExportSCORM2004AGREGA.BadProfiles.Message"));
                }
                if (bl3) {
                    if (string != null && !string.equals("") && !string.contains(" ")) {
                        if (string2 != null && string2.length() > 5 && string3 != null && string3.length() > 5) {
                            String string6 = null;
                            string6 = this.mainWindow.showSaveDialog(this.getCurrentExportSaveFolder(), new FileFilter(){

                                @Override
                                public boolean accept(File file) {
                                    return file.getAbsolutePath().toLowerCase().endsWith(".zip") || file.isDirectory();
                                }

                                @Override
                                public String getDescription() {
                                    return "Zip files (*.zip)";
                                }
                            });
                            if (string6 != null) {
                                es.eucm.eadventure.common.auxiliar.File file;
                                if (!string6.toLowerCase().endsWith(".zip")) {
                                    string6 = string6 + ".zip";
                                }
                                if (this.isValidTargetFile((File)(file = new es.eucm.eadventure.common.auxiliar.File(string6)))) {
                                    if (!file.exists() || this.mainWindow.showStrictConfirmDialog(TC.get((String)"Operation.SaveFileTitle"), TC.get((String)"Operation.OverwriteExistingFile", (String)file.getName()))) {
                                        try {
                                            if (file.exists()) {
                                                file.delete();
                                            }
                                            this.changeAllAnimationFormats();
                                            this.saveFile(false);
                                            this.loadingScreen.setMessage(TC.get((String)"Operation.ExportProject.AsLO"));
                                            this.loadingScreen.setVisible(true);
                                            this.updateLOMLanguage();
                                            if (n == 0 && Writer.exportAsLearningObject(string6, string, string2, string3, bl2, this.currentZipFile, this.adventureDataControl)) {
                                                this.mainWindow.showInformationDialog(TC.get((String)"Operation.ExportT.Success.Title"), TC.get((String)"Operation.ExportT.Success.Message"));
                                            } else if (n == 1 && Writer.exportAsWebCTObject(string6, string, string2, string3, bl2, this.currentZipFile, this.adventureDataControl)) {
                                                this.mainWindow.showInformationDialog(TC.get((String)"Operation.ExportT.Success.Title"), TC.get((String)"Operation.ExportT.Success.Message"));
                                            } else if (n == 2 && Writer.exportAsSCORM(string6, string, string2, string3, bl2, this.currentZipFile, this.adventureDataControl)) {
                                                this.mainWindow.showInformationDialog(TC.get((String)"Operation.ExportT.Success.Title"), TC.get((String)"Operation.ExportT.Success.Message"));
                                            } else if (n == 3 && Writer.exportAsSCORM2004(string6, string, string2, string3, bl2, this.currentZipFile, this.adventureDataControl)) {
                                                this.mainWindow.showInformationDialog(TC.get((String)"Operation.ExportT.Success.Title"), TC.get((String)"Operation.ExportT.Success.Message"));
                                            } else if (n == 4 && Writer.exportAsAGREGA(string6, string, string2, string3, bl2, this.currentZipFile, this.adventureDataControl)) {
                                                this.mainWindow.showInformationDialog(TC.get((String)"Operation.ExportT.Success.Title"), TC.get((String)"Operation.ExportT.Success.Message"));
                                            } else if (n == 5 && Writer.exportAsLAMSLearningObject(string6, string, string2, string3, bl2, this.currentZipFile, this.adventureDataControl)) {
                                                this.mainWindow.showInformationDialog(TC.get((String)"Operation.ExportT.Success.Title"), TC.get((String)"Operation.ExportT.Success.Message"));
                                            } else if (n == 6 && Writer.exportAsGAMETELLearningObject(string6, string, string2, string3, bl2, this.currentZipFile, string5, string4, this.adventureDataControl)) {
                                                this.mainWindow.showInformationDialog(TC.get((String)"Operation.ExportT.Success.Title"), TC.get((String)"Operation.ExportT.Success.Message"));
                                            } else {
                                                this.mainWindow.showInformationDialog(TC.get((String)"Operation.ExportT.NotSuccess.Title"), TC.get((String)"Operation.ExportT.NotSuccess.Message"));
                                            }
                                            this.loadingScreen.setVisible(false);
                                        }
                                        catch (Exception exception) {
                                            this.showErrorDialog(TC.get((String)"Operation.ExportToLOM.LONameNotValid.Title"), TC.get((String)"Operation.ExportToLOM.LONameNotValid.Title"));
                                            ReportDialog.GenerateErrorReport((Exception)exception, (boolean)true, (String)TC.get((String)"Operation.ExportToLOM.LONameNotValid.Title"));
                                            this.hideLoadingScreen();
                                        }
                                    }
                                } else {
                                    this.mainWindow.showErrorDialog(TC.get((String)"Operation.ExportT.TargetInProjectDir.Title"), TC.get((String)"Operation.ExportT.TargetInProjectDir.Message"));
                                    this.hideLoadingScreen();
                                }
                            }
                        } else {
                            this.showErrorDialog(TC.get((String)"Operation.ExportToLOM.AuthorNameOrganizationNotValid.Title"), TC.get((String)"Operation.ExportToLOM.AuthorNameOrganizationNotValid.Message"));
                        }
                    } else {
                        this.showErrorDialog(TC.get((String)"Operation.ExportToLOM.LONameNotValid.Title"), TC.get((String)"Operation.ExportToLOM.LONameNotValid.Message"));
                    }
                }
            }
        }
        catch (Exception exception) {
            this.loadingScreen.setVisible(false);
            this.mainWindow.showErrorDialog("Operation.FileNotSavedTitle", "Operation.FileNotSavedMessage");
        }
    }

    private boolean hasScormProfiles(int n) {
        if (n == 0) {
            return this.chaptersController.hasScorm12Profiles(this.adventureDataControl);
        }
        if (n == 1 || n == 2) {
            return this.chaptersController.hasScorm2004Profiles(this.adventureDataControl);
        }
        return false;
    }

    public void run() {
        this.stopAutoSave();
        if (this.checkAdventureConsistency(false)) {
            this.getSelectedChapterDataControl().getConversationsList().resetAllConversationNodes();
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    if (Controller.this.canBeRun()) {
                        Controller.this.mainWindow.setNormalRunAvailable(false);
                        Controller.this.chaptersController.updateVarsFlagsForRunning();
                        EAdventureDebug.normalRun((AdventureData)Controller.getInstance().adventureDataControl.getAdventureData(), (InputStreamCreator)AssetsController.getInputStreamCreator());
                        Controller.getInstance().startAutoSave(15);
                        Controller.this.mainWindow.setNormalRunAvailable(true);
                    }
                }
            }, 1000L);
        }
    }

    public void debugRun() {
        this.stopAutoSave();
        if (this.checkAdventureConsistency(false)) {
            this.getSelectedChapterDataControl().getConversationsList().resetAllConversationNodes();
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    if (Controller.this.canBeRun()) {
                        Controller.this.mainWindow.setNormalRunAvailable(false);
                        Controller.this.chaptersController.updateVarsFlagsForRunning();
                        EAdventureDebug.debug((AdventureData)Controller.getInstance().adventureDataControl.getAdventureData(), (InputStreamCreator)AssetsController.getInputStreamCreator());
                        Controller.getInstance().startAutoSave(15);
                        Controller.this.mainWindow.setNormalRunAvailable(true);
                    }
                }
            }, 1000L);
        }
    }

    private boolean canBeRun() {
        if (this.dataModified) {
            if (this.mainWindow.showStrictConfirmDialog(TC.get((String)"Run.CanBeRun.Title"), TC.get((String)"Run.CanBeRun.Text"))) {
                this.saveFile(false);
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isValidTargetFile(File file) {
        File[] fileArray = new File[]{ReleaseFolders.webFolder(), ReleaseFolders.webTempFolder(), this.getProjectFolderFile()};
        boolean bl = true;
        for (File file2 : fileArray) {
            if (!file.getAbsolutePath().toLowerCase().startsWith(file2.getAbsolutePath().toLowerCase())) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private boolean isValidTargetProject(File file) {
        File[] fileArray = new File[]{ReleaseFolders.webFolder(), ReleaseFolders.webTempFolder()};
        boolean bl = true;
        for (File file2 : fileArray) {
            if (!file.getAbsolutePath().toLowerCase().startsWith(file2.getAbsolutePath().toLowerCase())) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean askDeleteConditionsResourceBlock() {
        int n = this.mainWindow.showConfirmDialog(TC.get((String)"ResourceBlock.deleteOnlyOneBlock.title"), TC.get((String)"ResourceBlock.deleteOnlyOneBlock.message"));
        if (n == 0) {
            return true;
        }
        if (n == 1 || n == 2) {
            return false;
        }
        return false;
    }

    public void exit() {
        boolean bl = true;
        if (this.dataModified) {
            int n = this.mainWindow.showConfirmDialog(TC.get((String)"Operation.ExitTitle"), TC.get((String)"Operation.ExitMessage"));
            if (n == 0) {
                bl = this.saveFile(false);
            } else if (n == 1) {
                bl = true;
            } else if (n == 2) {
                bl = false;
            }
        }
        if (bl) {
            ConfigData.storeToXML();
            ProjectConfigData.storeToXML();
            System.exit(0);
        }
    }

    public boolean checkAdventureConsistency() {
        return this.checkAdventureConsistency(true);
    }

    public boolean checkAdventureConsistency(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = this.chaptersController.isValid(null, arrayList);
        if (bl2) {
            if (bl) {
                this.mainWindow.showInformationDialog(TC.get((String)"Operation.AdventureConsistencyTitle"), TC.get((String)"Operation.AdventureConsistentReport"));
            }
        } else {
            new InvalidReportDialog(arrayList, TC.get((String)"Operation.AdventureInconsistentReport"));
        }
        return bl2;
    }

    public void checkFileConsistency() {
    }

    public void showAdventureDataDialog() {
        new AdventureDataDialog();
    }

    public void showLOMDataDialog() {
        this.isLomEs = false;
        new LOMDialog(this.adventureDataControl.getLomController());
    }

    public void showLOMSCORMDataDialog() {
        this.isLomEs = false;
        new IMSDialog(this.adventureDataControl.getImsController());
    }

    public void showLOMESDataDialog() {
        this.isLomEs = true;
        new LOMESDialog(this.adventureDataControl.getLOMESController());
    }

    public void showGUIStylesDialog() {
        this.adventureDataControl.showGUIStylesDialog();
    }

    public void changeToolGUIStyleDialog(int n) {
        if (n != 1) {
            this.adventureDataControl.setGUIStyleDialog(n);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void deleteUnsuedAssets() {
        void var5_44;
        void var5_42;
        void var5_40;
        void var5_37;
        void var5_35;
        void var5_33;
        void var5_31;
        void var5_29;
        void var5_27;
        void var5_25;
        void var5_23;
        void var5_21;
        if (!this.showStrictConfirmDialog(TC.get((String)"DeleteUnusedAssets.Title"), TC.get((String)"DeleteUnusedAssets.Warning"))) {
            return;
        }
        int n2 = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = AssetsController.getAssetsList(2);
        int n = ((String[])object).length;
        boolean bl = false;
        while (var5_21 < n) {
            String string = object[var5_21];
            if (!arrayList.contains(string)) {
                arrayList.add(string);
            }
            ++var5_21;
        }
        object = AssetsController.getAssetsList(0);
        int string = ((String[])object).length;
        boolean bl2 = false;
        while (var5_23 < string) {
            String string2 = object[var5_23];
            if (!arrayList.contains(string2)) {
                arrayList.add(string2);
            }
            ++var5_23;
        }
        object = AssetsController.getAssetsList(5);
        string = ((String[])object).length;
        boolean bl3 = false;
        while (var5_25 < string) {
            String string3 = object[var5_25];
            if (!arrayList.contains(string3)) {
                arrayList.add(string3);
            }
            ++var5_25;
        }
        object = AssetsController.getAssetsList(4);
        int n3 = ((String[])object).length;
        boolean bl4 = false;
        while (var5_27 < n3) {
            String string4 = object[var5_27];
            if (!arrayList.contains(string4)) {
                arrayList.add(string4);
            }
            ++var5_27;
        }
        object = AssetsController.getAssetsList(6);
        int n4 = ((String[])object).length;
        boolean bl5 = false;
        while (var5_29 < n4) {
            String string5 = object[var5_29];
            if (!arrayList.contains(string5)) {
                arrayList.add(string5);
            }
            ++var5_29;
        }
        object = AssetsController.getAssetsList(9);
        int n5 = ((String[])object).length;
        boolean bl6 = false;
        while (var5_31 < n5) {
            String string6 = object[var5_31];
            if (!arrayList.contains(string6)) {
                arrayList.add(string6);
            }
            ++var5_31;
        }
        object = AssetsController.getAssetsList(3);
        int n6 = ((String[])object).length;
        boolean bl7 = false;
        while (var5_33 < n6) {
            String string7 = object[var5_33];
            if (!arrayList.contains(string7)) {
                arrayList.add(string7);
            }
            ++var5_33;
        }
        object = AssetsController.getAssetsList(7);
        int n7 = ((String[])object).length;
        boolean bl8 = false;
        while (var5_35 < n7) {
            String string8 = object[var5_35];
            if (!arrayList.contains(string8)) {
                arrayList.add(string8);
            }
            ++var5_35;
        }
        object = AssetsController.getAssetsList(11);
        int n8 = ((String[])object).length;
        boolean bl9 = false;
        while (var5_37 < n8) {
            String string9 = object[var5_37];
            if (!arrayList.contains(string9)) {
                arrayList.add(string9);
            }
            ++var5_37;
        }
        for (String string10 : arrayList) {
            int n9 = 0;
            n9 = this.countAssetReferences(string10);
            if (n9 != 0) continue;
            new es.eucm.eadventure.common.auxiliar.File(Controller.getInstance().getProjectFolder(), string10).delete();
            ++n2;
        }
        arrayList.clear();
        object = AssetsController.getAssetsList(10);
        int n10 = ((Object)object).length;
        boolean bl10 = false;
        while (var5_40 < n10) {
            Object object2 = object[var5_40];
            if (!arrayList.contains(object2)) {
                arrayList.add(object2);
            }
            ++var5_40;
        }
        object = AssetsController.getAssetsList(8);
        int n11 = ((Object)object).length;
        boolean bl11 = false;
        while (var5_42 < n11) {
            Object object3 = object[var5_42];
            if (!arrayList.contains(object3)) {
                arrayList.add(object3);
            }
            ++var5_42;
        }
        object = AssetsController.getAssetsList(1);
        int n12 = ((Object)object).length;
        boolean bl12 = false;
        while (var5_44 < n12) {
            Object object4 = object[var5_44];
            if (!arrayList.contains(object4)) {
                arrayList.add(object4);
            }
            ++var5_44;
        }
        int n32 = 0;
        while (n32 < arrayList.size()) {
            String string11 = (String)arrayList.get(n32);
            if (this.countAssetReferences(AssetsController.removeSuffix(string11)) != 0) {
                void var5_47;
                arrayList.remove(string11);
                if (string11.endsWith("eaa")) {
                    Animation animation = Loader.loadAnimation((InputStreamCreator)AssetsController.getInputStreamCreator(), (String)string11, (ImageLoaderFactory)new EditorImageLoader());
                    for (Frame frame : animation.getFrames()) {
                        int n13;
                        if (frame.getUri() != null && arrayList.contains(frame.getUri())) {
                            for (n13 = 0; n13 < arrayList.size(); ++n13) {
                                if (!((String)arrayList.get(n13)).equals(frame.getUri())) continue;
                                if (n13 < n32) {
                                    --n32;
                                }
                                arrayList.remove(n13);
                            }
                        }
                        if (frame.getSoundUri() == null || !arrayList.contains(frame.getSoundUri())) continue;
                        for (n13 = 0; n13 < arrayList.size(); ++n13) {
                            if (!((String)arrayList.get(n13)).equals(frame.getSoundUri())) continue;
                            if (n13 < n32) {
                                --n32;
                            }
                            arrayList.remove(n13);
                        }
                    }
                    continue;
                }
                boolean bl13 = false;
                while (var5_47 < arrayList.size()) {
                    if (((String)arrayList.get((int)var5_47)).startsWith(AssetsController.removeSuffix(string11))) {
                        if (var5_47 < n32) {
                            --n32;
                        }
                        arrayList.remove((int)var5_47);
                        continue;
                    }
                    ++var5_47;
                }
                continue;
            }
            ++n32;
        }
        for (String string12 : arrayList) {
            new es.eucm.eadventure.common.auxiliar.File(Controller.getInstance().getProjectFolder(), string12).delete();
            ++n2;
        }
        if (n2 != 0) {
            this.mainWindow.showInformationDialog(TC.get((String)"DeleteUnusedAssets.Title"), TC.get((String)"DeleteUnusedAssets.AssetsDeleted", (String[])new String[]{String.valueOf(n2)}));
        } else {
            this.mainWindow.showInformationDialog(TC.get((String)"DeleteUnusedAssets.Title"), TC.get((String)"DeleteUnusedAssets.NoUnsuedAssetsFound"));
        }
    }

    public File selectXMLChapterFile() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter((FileFilter)((Object)new XMLFileFilter()));
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setCurrentDirectory((File)new es.eucm.eadventure.common.auxiliar.File(this.getCurrentLoadFolder()));
        int n = jFileChooser.showOpenDialog(this.mainWindow);
        if (n == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    public void showEditFlagDialog() {
        new VarsFlagsDialog(new VarFlagsController(this.getVarFlagSummary()));
    }

    public void setSelectedChapter(int n) {
        this.chaptersController.setSelectedChapterInternal(n);
        this.mainWindow.reloadData();
    }

    public void updateVarFlagSummary() {
        this.chaptersController.updateVarFlagSummary();
    }

    public void addChapter() {
        this.addTool(new AddChapterTool(this.chaptersController));
    }

    public void importChapter() {
        try {
            this.addTool(new ImportChapterTool(this.chaptersController));
        }
        catch (Exception exception) {
            exception.getStackTrace();
            this.loadingScreen.setVisible(false);
            this.showInformationDialog(TC.get((String)"ImportChapter.UnknowProblems.Title"), TC.get((String)"ImportChapter.UnknowProblems.Message"));
        }
    }

    public void deleteChapter() {
        this.addTool(new DeleteChapterTool(this.chaptersController));
    }

    public void moveChapterUp() {
        this.addTool(new MoveChapterTool(0, this.chaptersController));
    }

    public void moveChapterDown() {
        this.addTool(new MoveChapterTool(1, this.chaptersController));
    }

    public String getAdventureTitle() {
        return this.adventureDataControl.getTitle();
    }

    public String getAdventureDescription() {
        return this.adventureDataControl.getDescription();
    }

    public LOMDataControl getLOMDataControl() {
        return this.adventureDataControl.getLomController();
    }

    public void setAdventureTitle(String string) {
        if (!string.equals(this.adventureDataControl.getTitle())) {
            this.adventureDataControl.setTitle(string);
        }
    }

    public void setAdventureDescription(String string) {
        if (!string.equals(this.adventureDataControl.getDescription())) {
            this.adventureDataControl.setDescription(string);
        }
    }

    public boolean isElementIdValid(String string) {
        return this.isElementIdValid(string, true);
    }

    public boolean isElementIdValid(String string, boolean bl) {
        boolean bl2 = false;
        if (!string.contains(" ") && !string.contains("'")) {
            if (!this.getIdentifierSummary().existsId(string)) {
                if (!string.equals("Player") && !string.equals(TC.get((String)"ConversationLine.PlayerName"))) {
                    if (Character.isLetter(string.charAt(0))) {
                        bl2 = this.isCharacterValid(string);
                        if (!bl2) {
                            this.mainWindow.showErrorDialog(TC.get((String)"Operation.IdErrorTitle"), TC.get((String)"Operation.IdErrorCharacter"));
                        }
                    } else if (bl) {
                        this.mainWindow.showErrorDialog(TC.get((String)"Operation.IdErrorTitle"), TC.get((String)"Operation.IdErrorFirstCharacter"));
                    }
                } else if (bl) {
                    this.mainWindow.showErrorDialog(TC.get((String)"Operation.IdErrorTitle"), TC.get((String)"Operation.IdErrorReservedIdentifier", (String)string));
                }
            } else if (bl) {
                this.mainWindow.showErrorDialog(TC.get((String)"Operation.IdErrorTitle"), TC.get((String)"Operation.IdErrorAlreadyUsed"));
            }
        } else if (bl) {
            this.mainWindow.showErrorDialog(TC.get((String)"Operation.IdErrorTitle"), TC.get((String)"Operation.IdErrorBlankSpaces"));
        }
        return bl2;
    }

    public boolean isCharacterValid(String string) {
        boolean bl = true;
        for (int i = 1; i < string.length() && bl; ++i) {
            Character c = Character.valueOf(string.charAt(i));
            if (c.charValue() != '&' && c.charValue() != '\"' && c.charValue() != '\'' && c.charValue() != '<' && c.charValue() != '>') continue;
            bl = false;
        }
        return bl;
    }

    public boolean isPropertyIdValid(String string) {
        boolean bl = false;
        if (!string.contains(" ")) {
            if (Character.isLetter(string.charAt(0))) {
                bl = true;
            } else {
                this.mainWindow.showErrorDialog(TC.get((String)"Operation.IdErrorTitle"), TC.get((String)"Operation.IdErrorFirstCharacter"));
            }
        } else {
            this.mainWindow.showErrorDialog(TC.get((String)"Operation.IdErrorTitle"), TC.get((String)"Operation.IdErrorBlankSpaces"));
        }
        return bl;
    }

    public String getSceneImagePath(String string) {
        String string2 = null;
        for (SceneDataControl sceneDataControl : this.getSelectedChapterDataControl().getScenesList().getScenes()) {
            if (!string.equals(sceneDataControl.getId())) continue;
            string2 = sceneDataControl.getPreviewBackground();
        }
        return string2;
    }

    public Trajectory getSceneTrajectory(String string) {
        Trajectory trajectory = null;
        for (SceneDataControl sceneDataControl : this.getSelectedChapterDataControl().getScenesList().getScenes()) {
            if (!string.equals(sceneDataControl.getId()) || !sceneDataControl.getTrajectory().hasTrajectory()) continue;
            trajectory = (Trajectory)sceneDataControl.getTrajectory().getContent();
        }
        return trajectory;
    }

    public String getPlayerImagePath() {
        if (this.getSelectedChapterDataControl() != null) {
            return this.getSelectedChapterDataControl().getPlayer().getPreviewImage();
        }
        return null;
    }

    public Player getPlayer() {
        return (Player)this.getSelectedChapterDataControl().getPlayer().getContent();
    }

    public void changePlayerNecessaryResources(boolean bl) {
        for (ResourcesDataControl resourcesDataControl : this.getSelectedChapterDataControl().getPlayer().getResources()) {
            for (int i = 0; i < resourcesDataControl.getAssetsInformation().length; ++i) {
                if (resourcesDataControl.getAssetsInformation()[i].name.equals("standleft")) {
                    resourcesDataControl.getAssetsInformation()[i].assetNecessary = bl;
                    int n = i;
                    continue;
                }
                if (!resourcesDataControl.getAssetsInformation()[i].name.equals("standright")) continue;
                resourcesDataControl.getAssetsInformation()[i].assetNecessary = bl;
                int n = i;
            }
        }
    }

    public String getElementImagePath(String string) {
        String string2 = null;
        for (ItemDataControl dataControlWithResources : this.getSelectedChapterDataControl().getItemsList().getItems()) {
            if (!string.equals(dataControlWithResources.getId())) continue;
            string2 = dataControlWithResources.getPreviewImage();
        }
        for (NPCDataControl nPCDataControl : this.getSelectedChapterDataControl().getNPCsList().getNPCs()) {
            if (!string.equals(nPCDataControl.getId())) continue;
            string2 = nPCDataControl.getPreviewImage();
        }
        for (AtrezzoDataControl atrezzoDataControl : this.getSelectedChapterDataControl().getAtrezzoList().getAtrezzoList()) {
            if (!string.equals(atrezzoDataControl.getId())) continue;
            string2 = atrezzoDataControl.getPreviewImage();
        }
        return string2;
    }

    public int countAssetReferences(String string) {
        return this.adventureDataControl.countAssetReferences(string) + this.chaptersController.countAssetReferences(string);
    }

    public void getAssetReferences(List<String> list, List<Integer> list2) {
        this.adventureDataControl.getAssetReferences(list, list2);
        this.chaptersController.getAssetReferences(list, list2);
    }

    public void deleteAssetReferences(String string) {
        this.adventureDataControl.deleteAssetReferences(string);
        this.chaptersController.deleteAssetReferences(string);
    }

    public int countIdentifierReferences(String string) {
        return this.getSelectedChapterDataControl().countIdentifierReferences(string);
    }

    public void deleteIdentifierReferences(String string) {
        this.chaptersController.deleteIdentifierReferences(string);
    }

    public void replaceIdentifierReferences(String string, String string2) {
        this.getSelectedChapterDataControl().replaceIdentifierReferences(string, string2);
    }

    public void updateChapterMenu() {
        this.mainWindow.updateChapterMenu();
    }

    public void updateStructure() {
        this.mainWindow.updateStructure();
    }

    public void reloadPanel() {
        this.mainWindow.reloadPanel();
    }

    public void updatePanel() {
        this.mainWindow.updatePanel();
    }

    public void reloadData() {
        this.mainWindow.reloadData();
    }

    public Window peekWindow() {
        return this.mainWindow.peekWindow();
    }

    public void pushWindow(Window window) {
        this.mainWindow.pushWindow(window);
    }

    public void popWindow() {
        this.mainWindow.popWindow();
    }

    public void showInformationDialog(String string, String string2) {
        this.mainWindow.showInformationDialog(string, string2);
    }

    public String[] showMultipleSelectionLoadDialog(FileFilter fileFilter) {
        return this.mainWindow.showMultipleSelectionLoadDialog(this.currentZipPath, fileFilter);
    }

    public boolean showStrictConfirmDialog(String string, String string2) {
        return this.mainWindow.showStrictConfirmDialog(string, string2);
    }

    public int showOptionDialog(String string, String string2, String[] stringArray) {
        return this.mainWindow.showOptionDialog(string, string2, stringArray);
    }

    public String showInputDialog(String string, String string2, String string3) {
        return this.mainWindow.showInputDialog(string, string2, string3);
    }

    public String showInputDialog(String string, String string2) {
        return this.mainWindow.showInputDialog(string, string2);
    }

    public String showInputDialog(String string, String string2, Object[] objectArray) {
        return this.mainWindow.showInputDialog(string, string2, objectArray);
    }

    public void showErrorDialog(String string, String string2) {
        this.mainWindow.showErrorDialog(string, string2);
    }

    public void showCustomizeGUIDialog() {
        new CustomizeGUIDialog(this.adventureDataControl);
    }

    public boolean isFolderLoaded() {
        return this.chaptersController.isAnyChapterSelected();
    }

    public String getEditorMinVersion() {
        return "1.3";
    }

    public String getEditorVersion() {
        return "1.3";
    }

    public void updateLOMLanguage() {
        this.adventureDataControl.getLomController().updateLanguage();
    }

    public void updateIMSLanguage() {
        this.adventureDataControl.getImsController().updateLanguage();
    }

    public void showAboutDialog() {
        try {
            JComponent jComponent;
            JDialog jDialog = new JDialog(Controller.getInstance().peekWindow(), TC.get((String)"About"), Dialog.ModalityType.TOOLKIT_MODAL);
            jDialog.getContentPane().setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            es.eucm.eadventure.common.auxiliar.File file = new es.eucm.eadventure.common.auxiliar.File(ConfigData.getAboutFile());
            if (file.exists()) {
                jComponent = new JEditorPane();
                ((JEditorPane)jComponent).setPage(file.toURI().toURL());
                ((JTextComponent)jComponent).setEditable(false);
                jPanel.add((Component)jComponent, "Center");
            }
            jComponent = new JPanel();
            jComponent.setLayout(new BorderLayout());
            JButton jButton = new JButton(TC.get((String)"About.CheckNewVersion"));
            jComponent.add((Component)jButton, "Center");
            final JLabel jLabel = new JLabel("");
            jComponent.add((Component)jLabel, "South");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BufferedInputStream bufferedInputStream = null;
                    try {
                        bufferedInputStream = new BufferedInputStream(new URL("http://e-adventure.e-ucm.es/files/version").openStream());
                        byte[] byArray = new byte[1024];
                        int n = 0;
                        String string = null;
                        while ((n = bufferedInputStream.read(byArray, 0, 1024)) >= 0) {
                            string = new String(byArray, 0, n);
                        }
                        string = string.substring(0, string.length() - 1);
                        System.out.println(Controller.this.getCurrentVersion().split("-")[0] + " " + string);
                        if (Controller.this.getCurrentVersion().split("-")[0].equals(string)) {
                            jLabel.setText(TC.get((String)"About.LatestRelease"));
                        } else {
                            jLabel.setText(TC.get((String)"About.NewReleaseAvailable"));
                        }
                        jLabel.updateUI();
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException) {
                        jLabel.setText(TC.get((String)"About.LatestRelease"));
                        jLabel.updateUI();
                    }
                }
            });
            jPanel.add((Component)jComponent, "North");
            jDialog.getContentPane().add((Component)jPanel, "Center");
            jDialog.setSize(275, 560);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            jDialog.setLocation((dimension.width - jDialog.getWidth()) / 2, (dimension.height - jDialog.getHeight()) / 2);
            jDialog.setVisible(true);
        }
        catch (IOException iOException) {
            ReportDialog.GenerateErrorReport((Exception)iOException, (boolean)true, (String)"UNKNOWERROR");
        }
    }

    private String getCurrentVersion() {
        es.eucm.eadventure.common.auxiliar.File file = new es.eucm.eadventure.common.auxiliar.File("RELEASE");
        String string = null;
        if (file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream((File)file);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                int n = -1;
                while ((n = bufferedInputStream.read()) != -1) {
                    if (string == null) {
                        string = "" + (char)n;
                        continue;
                    }
                    string = string + (char)n;
                }
                if (string != null) {
                    return string;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "NOVERSION";
    }

    public AssessmentProfilesDataControl getAssessmentController() {
        return this.chaptersController.getSelectedChapterDataControl().getAssessmentProfilesDataControl();
    }

    public AdaptationProfilesDataControl getAdaptationController() {
        return this.chaptersController.getSelectedChapterDataControl().getAdaptationProfilesDataControl();
    }

    public boolean isCommentaries() {
        return this.adventureDataControl.isCommentaries();
    }

    public void setCommentaries(boolean bl) {
        this.adventureDataControl.setCommentaries(bl);
    }

    public boolean isKeepShowing() {
        return this.adventureDataControl.isKeepShowing();
    }

    public void setKeepShowing(boolean bl) {
        this.adventureDataControl.setKeepShowing(bl);
    }

    public String getLanguage() {
        return this.languageFile;
    }

    public String getDefaultLanguage() {
        return "en_EN";
    }

    public void setLanguage(String string) {
        this.setLanguage(string, true);
    }

    public void setLanguage(String string, boolean bl) {
        String string2;
        es.eucm.eadventure.common.auxiliar.File file;
        String string3 = "img/loading/" + string + "/Editor2D-Loading.png";
        es.eucm.eadventure.common.auxiliar.File file2 = new es.eucm.eadventure.common.auxiliar.File(string3);
        if (!file2.exists()) {
            string3 = "img/loading/" + this.getDefaultLanguage() + "/Editor2D-Loading.png";
        }
        if (!(file = new es.eucm.eadventure.common.auxiliar.File(string2 = "i18n/editor/" + ReleaseFolders.getAboutFilePath((String)string))).exists()) {
            string2 = "i18n/editor/" + ReleaseFolders.getDefaultAboutFilePath();
        }
        ConfigData.setLanguangeFile(ReleaseFolders.getLanguageFilePath((String)string), string2, string3);
        this.languageFile = string;
        TC.loadStrings((String)ReleaseFolders.getLanguageFilePath4Editor((boolean)true, (String)this.languageFile));
        TC.appendStrings((String)ReleaseFolders.getLanguageFilePath4Editor((boolean)false, (String)this.languageFile));
        this.loadingScreen.setImage(this.getLoadingImage());
        if (bl) {
            this.mainWindow.reloadData();
        }
    }

    public String getLoadingImage() {
        return ConfigData.getLoadingImage();
    }

    public void showGraphicConfigDialog() {
        new GraphicConfigDialog(this.adventureDataControl.getGraphicConfig());
    }

    public void changeToolGraphicConfig(int n) {
        if (n != -1 && this.adventureDataControl.getGraphicConfig() != n) {
            this.adventureDataControl.setGraphicConfig(n);
        }
    }

    public boolean addTool(Tool tool) {
        boolean bl = this.chaptersController.addTool(tool);
        return bl;
    }

    public void undoTool() {
        this.chaptersController.undoTool();
    }

    public void redoTool() {
        this.chaptersController.redoTool();
    }

    public void pushLocalToolManager() {
        this.chaptersController.pushLocalToolManager();
    }

    public void popLocalToolManager() {
        this.chaptersController.popLocalToolManager();
    }

    public void search() {
        new SearchDialog();
    }

    public boolean getAutoSaveEnabled() {
        if (ProjectConfigData.existsKey("autosave")) {
            String string = ProjectConfigData.getProperty("autosave");
            return string.equals("yes");
        }
        return true;
    }

    public void setAutoSaveEnabled(boolean bl) {
        if (bl != this.getAutoSaveEnabled()) {
            ProjectConfigData.setProperty("autosave", bl ? "yes" : "no");
            this.startAutoSave(15);
        }
    }

    public boolean isLomEs() {
        return this.isLomEs;
    }

    public int getGUIConfigConfiguration() {
        return this.adventureDataControl.getGraphicConfig();
    }

    public String getDefaultExitCursorPath() {
        String string = this.adventureDataControl.getCursorPath("exit");
        if (string != null && string.length() > 0) {
            return string;
        }
        return "gui/cursors/exit.png";
    }

    public AdvancedFeaturesDataControl getAdvancedFeaturesController() {
        return this.chaptersController.getSelectedChapterDataControl().getAdvancedFeaturesController();
    }

    public static Color generateColor(int n) {
        int n2 = n * 180 % 256;
        int n3 = (n + 4) * 130 % 256;
        int n4 = (n + 2) * 155 % 256;
        if (n2 > 250 && n3 > 250 && n4 > 250) {
            n2 = 0;
            n3 = 0;
            n4 = 0;
        }
        return new Color(n2, n3, n4);
    }

    public static void gc() {
        new Thread(gc).start();
    }

    public static File createTempDirectory() throws IOException {
        File file = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!file.delete()) {
            throw new IOException("Could not delete temp file: " + file.getAbsolutePath());
        }
        if (!file.mkdir()) {
            throw new IOException("Could not create temp directory: " + file.getAbsolutePath());
        }
        return file;
    }

    public DescriptorData.DefaultClickAction getDefaultCursorAction() {
        return this.adventureDataControl.getDefaultClickAction();
    }

    public void setDefaultCursorAction(DescriptorData.DefaultClickAction defaultClickAction) {
        this.adventureDataControl.setDefaultClickAction(defaultClickAction);
    }

    public DescriptorData.Perspective getPerspective() {
        return this.adventureDataControl.getPerspective();
    }

    public void setPerspective(DescriptorData.Perspective perspective) {
        this.adventureDataControl.setPerspective(perspective);
    }

    public void changeAllAnimationFormats() {
        ArrayList<DataControlWithResources> arrayList = new ArrayList<DataControlWithResources>();
        arrayList.addAll(this.chaptersController.getSelectedChapterDataControl().getCutscenesList().getAllCutsceneDataControls());
        this.changeFormats(true, arrayList);
        arrayList.clear();
        arrayList.addAll(this.chaptersController.getSelectedChapterDataControl().getNPCsList().getAllNPCDataControls());
        arrayList.add(this.chaptersController.getSelectedChapterDataControl().getPlayer());
        this.changeFormats(false, arrayList);
        this.loadingScreen.setMessage(TC.get((String)"Operation.ExportProject.AsLO"));
        this.loadingScreen.setVisible(true);
    }

    private void changeFormats(boolean bl, List<DataControlWithResources> list) {
        es.eucm.eadventure.common.auxiliar.File file = new es.eucm.eadventure.common.auxiliar.File(Controller.getInstance().getProjectFolder());
        for (DataControlWithResources dataControlWithResources : list) {
            List<ResourcesDataControl> list2 = dataControlWithResources.getResources();
            for (ResourcesDataControl resourcesDataControl : list2) {
                for (int i = 0; i < resourcesDataControl.getAssetCount(); ++i) {
                    if (resourcesDataControl.getAssetCategory(i) != 1) continue;
                    String string = resourcesDataControl.getAssetPath(i);
                    if (string == null || string.equals("")) {
                        string = "assets/special/EmptyAnimation";
                    }
                    if (!string.toLowerCase().endsWith(".eaa")) {
                        String[] stringArray = string.split("/");
                        String string2 = stringArray[stringArray.length - 1];
                        es.eucm.eadventure.common.auxiliar.File file2 = new es.eucm.eadventure.common.auxiliar.File(file, string + ".eaa");
                        if (!file2.exists()) {
                            Animation animation = new Animation(string2, (ImageLoaderFactory)new EditorImageLoader());
                            animation.setSlides(bl);
                            animation.setDocumentation(resourcesDataControl.getAssetDescription(i));
                            ResourcesDataControl.framesFromImages(animation, string, true);
                            AnimationWriter.writeAnimation(file2.getAbsolutePath(), animation);
                            resourcesDataControl.addAsset(resourcesDataControl.getAssetName(i), string + ".eaa");
                            continue;
                        }
                        resourcesDataControl.changeAssetPath(i, string + ".eaa");
                        continue;
                    }
                    resourcesDataControl.changeAssetPath(i, string);
                }
            }
        }
    }
}

