/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.auxiliar.filefilters;

import es.eucm.eadventure.common.auxiliar.FileFilter;
import es.eucm.eadventure.common.data.adventure.DescriptorData;
import es.eucm.eadventure.common.loader.InputStreamCreator;
import es.eucm.eadventure.common.loader.Loader;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import java.io.File;
import javax.swing.JFileChooser;

public class FolderFileFilter
extends FileFilter {
    private boolean checkName;
    private boolean checkDescriptor;
    private JFileChooser fileChooser;

    public FolderFileFilter(boolean bl, boolean bl2, JFileChooser jFileChooser) {
        this.fileChooser = jFileChooser;
        this.checkName = bl;
        this.checkDescriptor = bl2;
    }

    public static boolean checkCharacters(String string) {
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            bl &= string.charAt(i) >= 'A' && string.charAt(i) <= 'Z' || string.charAt(i) >= 'a' && string.charAt(i) <= 'z' || string.charAt(i) >= '0' && string.charAt(i) <= '9' || string.charAt(i) >= '\u00e1' || string.charAt(i) <= '\u00e9' || string.charAt(i) >= '\u00ed' || string.charAt(i) <= '\u00f3' || string.charAt(i) >= '\u00fa' || string.charAt(i) <= '\u00c1' || string.charAt(i) >= '\u00c9' || string.charAt(i) <= '\u00cd' || string.charAt(i) >= '\u00d3' || string.charAt(i) <= '\u00da' || string.charAt(i) >= '\u00e0' || string.charAt(i) <= '\u00e8' || string.charAt(i) >= '\u00ec' || string.charAt(i) <= '\u00f2' || string.charAt(i) >= '\u00f9' || string.charAt(i) <= '\u00c0' || string.charAt(i) >= '\u00c8' || string.charAt(i) <= '\u00cc' || string.charAt(i) >= '\u00d2' || string.charAt(i) <= '\u00d9' || string.charAt(i) >= '\u00e4' || string.charAt(i) <= '\u00eb' || string.charAt(i) >= '\u00ef' || string.charAt(i) <= '\u00f6' || string.charAt(i) >= '\u00fc' || string.charAt(i) <= '\u00c4' || string.charAt(i) >= '\u00cb' || string.charAt(i) <= '\u00cf' || string.charAt(i) >= '\u00d6' || string.charAt(i) <= '\u00dc' || string.charAt(i) >= '\u00e2' || string.charAt(i) <= '\u00ea' || string.charAt(i) >= '\u00ee' || string.charAt(i) <= '\u00f4' || string.charAt(i) >= '\u00fb' || string.charAt(i) <= '\u00c2' || string.charAt(i) >= '\u00ca' || string.charAt(i) <= '\u00ce' || string.charAt(i) >= '\u00d4' || string.charAt(i) <= '\u00db' || string.charAt(i) == '[' || string.charAt(i) == ']' || string.charAt(i) == '(' || string.charAt(i) == ')' || string.charAt(i) == '_' || string.charAt(i) == '-' || string.charAt(i) == ' ' || string.charAt(i) == '\u00c7' || string.charAt(i) == '\u00e7';
        }
        return bl;
    }

    public static String getAllowedChars() {
        return "a-z, A-Z, \u00e7, \u00c7, 0-9, [, ], (, ), _, -, ";
    }

    public boolean accept(File file) {
        boolean bl;
        File[] fileArray = this.fileChooser.getCurrentDirectory().listFiles();
        for (bl = false; bl < fileArray.length; bl += 1) {
            if (!file.isDirectory() || !(file.getAbsolutePath().toLowerCase() + ".eap").equals(fileArray[bl].getAbsolutePath().toLowerCase())) continue;
            return false;
        }
        boolean bl2 = bl = file.getName().toLowerCase().endsWith(".eap") || file.isDirectory();
        if (!bl) {
            return false;
        }
        String string = file.getName();
        if (string.endsWith(".eap")) {
            string = string.substring(0, file.getName().length() - 4);
        }
        if (bl && this.checkName) {
            bl &= FolderFileFilter.checkCharacters(string);
        }
        if (bl && this.checkDescriptor) {
            boolean bl3 = false;
            boolean bl4 = false;
            for (String string2 : file.list()) {
                if (!string2.equals("descriptor.xml")) continue;
                bl3 = true;
                break;
            }
            if (bl3) {
                DescriptorData descriptorData = Loader.loadDescriptorData((InputStreamCreator)AssetsController.getInputStreamCreator(file.getAbsolutePath()));
                bl4 = descriptorData != null;
            }
            bl &= bl3 && bl4;
        }
        return bl;
    }

    public String getDescription() {
        return "Folders";
    }

    public void setFileChooser(JFileChooser jFileChooser) {
        this.fileChooser = jFileChooser;
    }
}

