/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.engine.multimedia;

import es.eucm.eadventure.engine.multimedia.Sound;
import es.eucm.eadventure.engine.resourcehandler.ResourceHandler;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundMp3
extends Sound {
    private AudioFormat decodedFormat;
    private AudioInputStream audioInputStream;
    private SourceDataLine line;
    private String filename;

    public SoundMp3(String string, boolean bl) {
        super(bl);
        this.filename = string;
    }

    @Override
    public void playOnce() {
        block9: {
            try {
                InputStream inputStream = ResourceHandler.getInstance().getResourceAsStreamFromZip(this.filename);
                AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(inputStream);
                AudioFormat audioFormat = audioInputStream.getFormat();
                this.decodedFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), 16, audioFormat.getChannels(), audioFormat.getChannels() * 2, audioFormat.getSampleRate(), false);
                this.audioInputStream = AudioSystem.getAudioInputStream(this.decodedFormat, audioInputStream);
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.decodedFormat);
                this.line = (SourceDataLine)AudioSystem.getLine(info);
                this.line.open(this.decodedFormat);
                if (this.line != null) {
                    try {
                        int n;
                        this.line.open(this.decodedFormat);
                        byte[] byArray = new byte[4096];
                        this.line.start();
                        while (!this.stop && (n = this.audioInputStream.read(byArray, 0, byArray.length)) != -1) {
                            this.line.write(byArray, 0, n);
                        }
                        break block9;
                    }
                    catch (IOException iOException) {
                        this.stopPlaying();
                        System.out.println("WARNING - could not open \"" + this.filename + "\" - sound will be disabled");
                        break block9;
                    }
                    catch (LineUnavailableException lineUnavailableException) {
                        this.stopPlaying();
                        System.out.println("WARNING - audio device is unavailable to play \"" + this.filename + "\" - sound will be disabled");
                        break block9;
                    }
                }
                this.stopPlaying();
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                this.finalize();
                System.out.println("WARNING - \"" + this.filename + "\" is a no supported MP3 file - sound will be disabled");
            }
            catch (IOException iOException) {
                this.finalize();
                System.out.println("WARNING - could not open \"" + this.filename + "\" - sound will be disabled");
            }
            catch (LineUnavailableException lineUnavailableException) {
                this.finalize();
                System.out.println("WARNING - audio device is unavailable to play \"" + this.filename + "\" - sound will be disabled");
            }
        }
    }

    @Override
    public synchronized void stopPlaying() {
        super.stopPlaying();
        if (this.line != null) {
            this.line.drain();
            this.line.stop();
            this.line.close();
        }
        if (this.audioInputStream != null) {
            try {
                this.audioInputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("WARNING - could not close \"" + this.filename + "\" - sound will be disabled");
                iOException.printStackTrace();
            }
        }
    }

    @Override
    public synchronized void finalize() {
        this.line = null;
        this.audioInputStream = null;
    }
}

